# Vend20\SearchApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**search()**](SearchApi.md#search) | **GET** /search | Search for resources


## `search()`

```php
search($type, $order_by, $order_direction, $page_size, $offset, $_id, $__id, $deleted, $status, $invoice_number, $customer_id, $user_id, $outlet_id, $date_from, $date_to, $sku, $_sku, $supplier_id, $_supplier_id, $brand_id, $_brand_id, $tag_id, $_tag_id, $product_type_id, $_product_type_id, $variant_parent_id, $_variant_parent_id, $customer_code, $email, $first_name, $last_name, $company_name, $mobile, $phone): \Vend20\Model\SearchResponse
```

Search for resources

This endpoint allows integrators to search all of the most commonly used resources, **sales**, **products** and **customers**. Each type allowing search by a number of different parameters. ### Supported resource types and attributes - **Sales**   - date_from   - date_to   - status   - invoice_number   - customer_id   - user_id   - outlet_id - **Products**   - sku   - supplier_id   - brand_id   - tag_id   - product_type_id   - variant_parent_id - **Customers**   - customer_code   - first_name   - last_name   - company_name   - mobile   - phone   - email ### Sorting and pagination Unlike other endpoints in the API 2.0, search results from this endpoint can be sorted by any of the attributes above. Because of that, the default [pagination](https://docs.vendhq.com/v0.9/reference#section-api-2-0) mechanism is not appropriate for this endpoint. Instead, this endpoint uses `offset` and `page_size` attributes to handle search results spanning multiple pages.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\SearchApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$type = 'type_example'; // string | The entity type to search for.
$order_by = 'order_by_example'; // string | The attribute used to sort items returned in the response.
$order_direction = 'order_direction_example'; // string | Sorting direction.
$page_size = 56; // int | The maximum number of objects to be included in the response, currently limited to 1000. Specifying more than 1000 will result in 1000 objects being returned.
$offset = 56; // int | The number of objects to be \"skipped\" for the response. Used for pagination.
$_id = '_id_example'; // string | The `id` of the object to be included in the response.
$__id = '__id_example'; // string | The `id` of the object to be excluded from the response.
$deleted = True; // bool | Indicated whether deleted objects should be included in the response.
$status = array('status_example'); // string[] | **SALES** Status of the sale to find. Can be used multiple times to search for objects with different values of this parameter.
$invoice_number = 'invoice_number_example'; // string | **SALES** Invoice number of the sale.
$customer_id = 'customer_id_example'; // string | **SALES** The `ID` of the customer associated with the sales.
$user_id = 'user_id_example'; // string | **SALES** The `ID` of the user associated with the sales.
$outlet_id = 'outlet_id_example'; // string | **SALES** The `ID` of the outlet associated with the sales.
$date_from = 'date_from_example'; // string | **SALES** Lower limit for the sale date as UTC timestamp. Format: `2016-08-08T12:00:00Z`.
$date_to = 'date_to_example'; // string | **SALES** Upper limit for the sale date as UTC timestamp. Format: `2016-08-08T12:00:00Z`.
$sku = array('sku_example'); // string[] | **PRODUCTS** The SKU of products to include in the search. Can be used multiple times to search for objects with different values of this parameter.
$_sku = array('_sku_example'); // string[] | **PRODUCTS** The SKU of products to exclude from the search. Can be used multiple times to search for objects with different values of this parameter.
$supplier_id = array('supplier_id_example'); // string[] | **PRODUCTS** The ID of the supplier associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter.
$_supplier_id = array('_supplier_id_example'); // string[] | **PRODUCTS** The ID of the supplier associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter.
$brand_id = array('brand_id_example'); // string[] | **PRODUCTS** The ID of the brand associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter.
$_brand_id = array('_brand_id_example'); // string[] | **PRODUCTS** The ID of the brand associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter.
$tag_id = array('tag_id_example'); // string[] | **PRODUCTS** The ID of the tag associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter.
$_tag_id = array('_tag_id_example'); // string[] | **PRODUCTS** The ID of the brand associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter.
$product_type_id = array('product_type_id_example'); // string[] | **PRODUCTS** The ID of the product type associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter.
$_product_type_id = array('_product_type_id_example'); // string[] | **PRODUCTS** The ID of the product type associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter.
$variant_parent_id = array('variant_parent_id_example'); // string[] | **PRODUCTS** The ID of the variant parent product associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter.
$_variant_parent_id = array('_variant_parent_id_example'); // string[] | **PRODUCTS** The ID of the variant parent product associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter.
$customer_code = 'customer_code_example'; // string | **CUSTOMERS** The `customer_code` associated with the customer to find.
$email = 'email_example'; // string | **CUSTOMERS** The `email` address associated with the customer to find.
$first_name = 'first_name_example'; // string | **CUSTOMERS** The `first_name` for the customers to find.
$last_name = 'last_name_example'; // string | **CUSTOMERS** The `last_name` for the customers to find.
$company_name = 'company_name_example'; // string | **CUSTOMERS** The `company_name` for the customers to find.
$mobile = 'mobile_example'; // string | **CUSTOMERS** The `mobile number` for the customers to find.
$phone = 'phone_example'; // string | **CUSTOMERS** The `phone number` for the customers to find.

try {
    $result = $apiInstance->search($type, $order_by, $order_direction, $page_size, $offset, $_id, $__id, $deleted, $status, $invoice_number, $customer_id, $user_id, $outlet_id, $date_from, $date_to, $sku, $_sku, $supplier_id, $_supplier_id, $brand_id, $_brand_id, $tag_id, $_tag_id, $product_type_id, $_product_type_id, $variant_parent_id, $_variant_parent_id, $customer_code, $email, $first_name, $last_name, $company_name, $mobile, $phone);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling SearchApi->search: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| The entity type to search for. |
 **order_by** | **string**| The attribute used to sort items returned in the response. | [optional]
 **order_direction** | **string**| Sorting direction. | [optional]
 **page_size** | **int**| The maximum number of objects to be included in the response, currently limited to 1000. Specifying more than 1000 will result in 1000 objects being returned. | [optional]
 **offset** | **int**| The number of objects to be \&quot;skipped\&quot; for the response. Used for pagination. | [optional]
 **_id** | **string**| The &#x60;id&#x60; of the object to be included in the response. | [optional]
 **__id** | **string**| The &#x60;id&#x60; of the object to be excluded from the response. | [optional]
 **deleted** | **bool**| Indicated whether deleted objects should be included in the response. | [optional]
 **status** | [**string[]**](../Model/string.md)| **SALES** Status of the sale to find. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **invoice_number** | **string**| **SALES** Invoice number of the sale. | [optional]
 **customer_id** | **string**| **SALES** The &#x60;ID&#x60; of the customer associated with the sales. | [optional]
 **user_id** | **string**| **SALES** The &#x60;ID&#x60; of the user associated with the sales. | [optional]
 **outlet_id** | **string**| **SALES** The &#x60;ID&#x60; of the outlet associated with the sales. | [optional]
 **date_from** | **string**| **SALES** Lower limit for the sale date as UTC timestamp. Format: &#x60;2016-08-08T12:00:00Z&#x60;. | [optional]
 **date_to** | **string**| **SALES** Upper limit for the sale date as UTC timestamp. Format: &#x60;2016-08-08T12:00:00Z&#x60;. | [optional]
 **sku** | [**string[]**](../Model/string.md)| **PRODUCTS** The SKU of products to include in the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **_sku** | [**string[]**](../Model/string.md)| **PRODUCTS** The SKU of products to exclude from the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **supplier_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the supplier associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **_supplier_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the supplier associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **brand_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the brand associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **_brand_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the brand associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **tag_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the tag associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **_tag_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the brand associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **product_type_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the product type associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **_product_type_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the product type associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **variant_parent_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the variant parent product associated with the product to include in the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **_variant_parent_id** | [**string[]**](../Model/string.md)| **PRODUCTS** The ID of the variant parent product associated with the product to exclude from the search. Can be used multiple times to search for objects with different values of this parameter. | [optional]
 **customer_code** | **string**| **CUSTOMERS** The &#x60;customer_code&#x60; associated with the customer to find. | [optional]
 **email** | **string**| **CUSTOMERS** The &#x60;email&#x60; address associated with the customer to find. | [optional]
 **first_name** | **string**| **CUSTOMERS** The &#x60;first_name&#x60; for the customers to find. | [optional]
 **last_name** | **string**| **CUSTOMERS** The &#x60;last_name&#x60; for the customers to find. | [optional]
 **company_name** | **string**| **CUSTOMERS** The &#x60;company_name&#x60; for the customers to find. | [optional]
 **mobile** | **string**| **CUSTOMERS** The &#x60;mobile number&#x60; for the customers to find. | [optional]
 **phone** | **string**| **CUSTOMERS** The &#x60;phone number&#x60; for the customers to find. | [optional]

### Return type

[**\Vend20\Model\SearchResponse**](../Model/SearchResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
