# Vend20\RegistersApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**closeRegister()**](RegistersApi.md#closeRegister) | **PUT** /registers/{register_id}/actions/close | Close a single register
[**getRegisterByID()**](RegistersApi.md#getRegisterByID) | **GET** /registers/{register_id} | Get a single register
[**listRegisters()**](RegistersApi.md#listRegisters) | **GET** /registers | List registers
[**openRegister()**](RegistersApi.md#openRegister) | **PUT** /registers/{register_id}/actions/open | Open a single register
[**registerPaymentsSummary()**](RegistersApi.md#registerPaymentsSummary) | **GET** /registers/{register_id}/payments_summary | Get all the payments data associated with a single register.


## `closeRegister()`

```php
closeRegister($register_id, $register_close_request): \Vend20\Model\RegisterResponse
```

Close a single register

Closes a single register with the requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\RegistersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$register_id = 'register_id_example'; // string | Valid register ID.
$register_close_request = new \Vend20\Model\RegisterCloseRequest(); // \Vend20\Model\RegisterCloseRequest

try {
    $result = $apiInstance->closeRegister($register_id, $register_close_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegistersApi->closeRegister: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **register_id** | **string**| Valid register ID. |
 **register_close_request** | [**\Vend20\Model\RegisterCloseRequest**](../Model/RegisterCloseRequest.md)|  |

### Return type

[**\Vend20\Model\RegisterResponse**](../Model/RegisterResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRegisterByID()`

```php
getRegisterByID($register_id): \Vend20\Model\RegisterResponse
```

Get a single register

Returns a single register with the requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\RegistersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$register_id = 'register_id_example'; // string | Valid register ID.

try {
    $result = $apiInstance->getRegisterByID($register_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegistersApi->getRegisterByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **register_id** | **string**| Valid register ID. |

### Return type

[**\Vend20\Model\RegisterResponse**](../Model/RegisterResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listRegisters()`

```php
listRegisters($after, $before, $deleted, $page_size): \Vend20\Model\RegisterCollection
```

List registers

Returns a paginated list of registers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\RegistersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$deleted = True; // bool | Indicates whether deleted items should be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.

try {
    $result = $apiInstance->listRegisters($after, $before, $deleted, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegistersApi->listRegisters: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **deleted** | **bool**| Indicates whether deleted items should be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]

### Return type

[**\Vend20\Model\RegisterCollection**](../Model/RegisterCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `openRegister()`

```php
openRegister($register_id, $register_open_request): \Vend20\Model\RegisterResponse
```

Open a single register

Opens a single register with the requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\RegistersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$register_id = 'register_id_example'; // string | Valid register ID.
$register_open_request = new \Vend20\Model\RegisterOpenRequest(); // \Vend20\Model\RegisterOpenRequest

try {
    $result = $apiInstance->openRegister($register_id, $register_open_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegistersApi->openRegister: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **register_id** | **string**| Valid register ID. |
 **register_open_request** | [**\Vend20\Model\RegisterOpenRequest**](../Model/RegisterOpenRequest.md)|  |

### Return type

[**\Vend20\Model\RegisterResponse**](../Model/RegisterResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `registerPaymentsSummary()`

```php
registerPaymentsSummary($register_id): \Vend20\Model\RegisterPaymentsSummaryResponse
```

Get all the payments data associated with a single register.

Returns a payload containing payment totals for all payments types defined in the account for a single register.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\RegistersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$register_id = 'register_id_example'; // string | Valid register ID.

try {
    $result = $apiInstance->registerPaymentsSummary($register_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegistersApi->registerPaymentsSummary: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **register_id** | **string**| Valid register ID. |

### Return type

[**\Vend20\Model\RegisterPaymentsSummaryResponse**](../Model/RegisterPaymentsSummaryResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
