# Vend20\PromotionsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**applyDiscount()**](PromotionsApi.md#applyDiscount) | **POST** /discount | Apply discounts to a sale object
[**createPromotion()**](PromotionsApi.md#createPromotion) | **POST** /promotions | Create a promotion
[**deletePromoCodesBulk()**](PromotionsApi.md#deletePromoCodesBulk) | **DELETE** /promocode/bulk | Delete promo codes
[**getActivePromoCodesBulk()**](PromotionsApi.md#getActivePromoCodesBulk) | **POST** /promocode/bulk/active | Get the active status of promo codes
[**getPromotionByID()**](PromotionsApi.md#getPromotionByID) | **GET** /promotions/{promotion_id} | Get a promotion by ID
[**getPromotionProducts()**](PromotionsApi.md#getPromotionProducts) | **GET** /promotions/{promotion_id}/products | Get products for a promotion
[**getPromotionPromoCodes()**](PromotionsApi.md#getPromotionPromoCodes) | **GET** /promotions/{promotion_id}/promocodes | Get the promo codes for a promotion
[**listPromotions()**](PromotionsApi.md#listPromotions) | **GET** /promotions | List promotions
[**updatePromotion()**](PromotionsApi.md#updatePromotion) | **PUT** /promotions/{promotion_id} | Update a promotion


## `applyDiscount()`

```php
applyDiscount($discount_param): \Vend20\Model\DiscountResponse
```

Apply discounts to a sale object

This will find the best possible promotion to a sale, apply it and return the sale and the discount.   * Despite its `POST` method, this endpoint does not modify any server-side state.  * It is the caller's responsibility to pass along the full details of the sale, including all customer information and product information (product type, tags, etc.).

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$discount_param = new \Vend20\Model\DiscountParam(); // \Vend20\Model\DiscountParam

try {
    $result = $apiInstance->applyDiscount($discount_param);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->applyDiscount: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **discount_param** | [**\Vend20\Model\DiscountParam**](../Model/DiscountParam.md)|  |

### Return type

[**\Vend20\Model\DiscountResponse**](../Model/DiscountResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createPromotion()`

```php
createPromotion($promotion): \Vend20\Model\Promotion
```

Create a promotion

This endpoint creates a new promotion.  It responds with the newly-created promotion, including the promotion's ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$promotion = new \Vend20\Model\Promotion(); // \Vend20\Model\Promotion

try {
    $result = $apiInstance->createPromotion($promotion);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->createPromotion: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promotion** | [**\Vend20\Model\Promotion**](../Model/Promotion.md)|  |

### Return type

[**\Vend20\Model\Promotion**](../Model/Promotion.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deletePromoCodesBulk()`

```php
deletePromoCodesBulk($request_body): \Vend20\Model\PromotionDeletePromoCodesResponse
```

Delete promo codes

Delete promo codes, by promocode IDs

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request_body = array('request_body_example'); // string[]

try {
    $result = $apiInstance->deletePromoCodesBulk($request_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->deletePromoCodesBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request_body** | [**string[]**](../Model/string.md)|  |

### Return type

[**\Vend20\Model\PromotionDeletePromoCodesResponse**](../Model/PromotionDeletePromoCodesResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getActivePromoCodesBulk()`

```php
getActivePromoCodesBulk($request_body): \Vend20\Model\PromotionActivePromoCodesResponse
```

Get the active status of promo codes

Get promo codes, with their associated promotions.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request_body = array('request_body_example'); // string[]

try {
    $result = $apiInstance->getActivePromoCodesBulk($request_body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->getActivePromoCodesBulk: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request_body** | [**string[]**](../Model/string.md)|  |

### Return type

[**\Vend20\Model\PromotionActivePromoCodesResponse**](../Model/PromotionActivePromoCodesResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPromotionByID()`

```php
getPromotionByID($promotion_id): \Vend20\Model\Promotion
```

Get a promotion by ID

This will retrieve a single promotion using the given ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$promotion_id = 'promotion_id_example'; // string

try {
    $result = $apiInstance->getPromotionByID($promotion_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->getPromotionByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promotion_id** | **string**|  |

### Return type

[**\Vend20\Model\Promotion**](../Model/Promotion.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPromotionProducts()`

```php
getPromotionProducts($promotion_id): \Vend20\Model\Promotion
```

Get products for a promotion

Get a list of products applicable for this promotion, and their discount price.  It takes in `page_size`, `offset` and `name` (use for searching product by product name) as query parameters.  The endpoint returns:  * a list of products with discount for the condition product set, and  * another list for the action product sets.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$promotion_id = 'promotion_id_example'; // string

try {
    $result = $apiInstance->getPromotionProducts($promotion_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->getPromotionProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promotion_id** | **string**|  |

### Return type

[**\Vend20\Model\Promotion**](../Model/Promotion.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPromotionPromoCodes()`

```php
getPromotionPromoCodes($promotion_id): \Vend20\Model\PromotionPromoCodesResponse
```

Get the promo codes for a promotion

Get the promo codes associated with this promotion.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$promotion_id = 'promotion_id_example'; // string

try {
    $result = $apiInstance->getPromotionPromoCodes($promotion_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->getPromotionPromoCodes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promotion_id** | **string**|  |

### Return type

[**\Vend20\Model\PromotionPromoCodesResponse**](../Model/PromotionPromoCodesResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listPromotions()`

```php
listPromotions($end_time_to, $end_time_from, $page_size): \Vend20\Model\PromotionCollection
```

List promotions

This endpoint lists all promotions for a retailer.  There are optional query parameters that allow filtering promotions. They can't be combined:   * `end_time_from` - only show promotions that have end_time after or equal to this time  * `end_time_to` - only show promotions that have end_time before this time  For example. the time format for end_time_from and end_time_to are: `2047-06-21T13:00:00`

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$end_time_to = 'end_time_to_example'; // string | Upper limit for the promotion end date as UTC timestamp. Format: `2020-08-08T12:00:00Z`.
$end_time_from = 'end_time_from_example'; // string | Lower limit for the promotion end date as UTC timestamp. Format: `2020-08-08T12:00:00Z`.
$page_size = 56; // int | The maximum number of items to be returned in the response.

try {
    $result = $apiInstance->listPromotions($end_time_to, $end_time_from, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->listPromotions: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **end_time_to** | **string**| Upper limit for the promotion end date as UTC timestamp. Format: &#x60;2020-08-08T12:00:00Z&#x60;. | [optional]
 **end_time_from** | **string**| Lower limit for the promotion end date as UTC timestamp. Format: &#x60;2020-08-08T12:00:00Z&#x60;. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]

### Return type

[**\Vend20\Model\PromotionCollection**](../Model/PromotionCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updatePromotion()`

```php
updatePromotion($promotion_id, $promotion): \Vend20\Model\Promotion
```

Update a promotion

This endpoint updates an existing promotion by ID.   * All of a promotion's fields except its id may be updated.  * There are no partial updates.  * All fields must be specified in the update.  * The response contains the updated promotion object.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PromotionsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$promotion_id = 'promotion_id_example'; // string
$promotion = new \Vend20\Model\Promotion(); // \Vend20\Model\Promotion

try {
    $result = $apiInstance->updatePromotion($promotion_id, $promotion);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PromotionsApi->updatePromotion: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **promotion_id** | **string**|  |
 **promotion** | [**\Vend20\Model\Promotion**](../Model/Promotion.md)|  |

### Return type

[**\Vend20\Model\Promotion**](../Model/Promotion.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
