# Vend20\ProductImagesApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteProductImageByID()**](ProductImagesApi.md#deleteProductImageByID) | **DELETE** /product_images/{product_image_id} | Delete a product_image
[**getProductImageDataByID()**](ProductImagesApi.md#getProductImageDataByID) | **GET** /product_images/{product_image_id} | Get a single product_image data
[**setImagePosition()**](ProductImagesApi.md#setImagePosition) | **PUT** /product_images/{product_image_id} | Set image position


## `deleteProductImageByID()`

```php
deleteProductImageByID($product_image_id)
```

Delete a product_image

Deletes the product_image with the requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ProductImagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_image_id = 'product_image_id_example'; // string

try {
    $apiInstance->deleteProductImageByID($product_image_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductImagesApi->deleteProductImageByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_image_id** | **string**|  |

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductImageDataByID()`

```php
getProductImageDataByID($product_image_id): \Vend20\Model\ImageResponse
```

Get a single product_image data

Returns the metadata for a single product image with a given ID. This method is useful for checking the status of an image after it was uploaded.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ProductImagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_image_id = 'product_image_id_example'; // string | Valid product ID.

try {
    $result = $apiInstance->getProductImageDataByID($product_image_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductImagesApi->getProductImageDataByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_image_id** | **string**| Valid product ID. |

### Return type

[**\Vend20\Model\ImageResponse**](../Model/ImageResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `setImagePosition()`

```php
setImagePosition($product_image_id, $image_position): \Vend20\Model\ImageResponse
```

Set image position

Allows for changing the image position in the list

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ProductImagesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_image_id = 'product_image_id_example'; // string
$image_position = new \Vend20\Model\ImagePosition(); // \Vend20\Model\ImagePosition

try {
    $result = $apiInstance->setImagePosition($product_image_id, $image_position);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductImagesApi->setImagePosition: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_image_id** | **string**|  |
 **image_position** | [**\Vend20\Model\ImagePosition**](../Model/ImagePosition.md)|  |

### Return type

[**\Vend20\Model\ImageResponse**](../Model/ImageResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
