# Vend20\ProductCategoryApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createUpdateProductCategory()**](ProductCategoryApi.md#createUpdateProductCategory) | **POST** /product_categories/bulk | Create and update a product category hierarchy
[**deleteProductCategories()**](ProductCategoryApi.md#deleteProductCategories) | **DELETE** /product_categories/bulk | Delete a list of product categories
[**getProductCategories()**](ProductCategoryApi.md#getProductCategories) | **GET** /product_categories | List product categories


## `createUpdateProductCategory()`

```php
createUpdateProductCategory($product_category_request): \Vend20\Model\ProductCategoryResponse
```

Create and update a product category hierarchy

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ProductCategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_category_request = new \Vend20\Model\ProductCategoryRequest(); // \Vend20\Model\ProductCategoryRequest

try {
    $result = $apiInstance->createUpdateProductCategory($product_category_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductCategoryApi->createUpdateProductCategory: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_category_request** | [**\Vend20\Model\ProductCategoryRequest**](../Model/ProductCategoryRequest.md)|  | [optional]

### Return type

[**\Vend20\Model\ProductCategoryResponse**](../Model/ProductCategoryResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductCategories()`

```php
deleteProductCategories($product_category_delete_request)
```

Delete a list of product categories

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ProductCategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_category_delete_request = new \Vend20\Model\ProductCategoryDeleteRequest(); // \Vend20\Model\ProductCategoryDeleteRequest

try {
    $apiInstance->deleteProductCategories($product_category_delete_request);
} catch (Exception $e) {
    echo 'Exception when calling ProductCategoryApi->deleteProductCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_category_delete_request** | [**\Vend20\Model\ProductCategoryDeleteRequest**](../Model/ProductCategoryDeleteRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductCategories()`

```php
getProductCategories($after, $page_size, $parent, $include): \Vend20\Model\ProductCategoryResponse
```

List product categories

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ProductCategoryApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.
$parent = 'parent_example'; // string
$include = 'include_example'; // string

try {
    $result = $apiInstance->getProductCategories($after, $page_size, $parent, $include);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductCategoryApi->getProductCategories: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]
 **parent** | **string**|  | [optional]
 **include** | **string**|  | [optional]

### Return type

[**\Vend20\Model\ProductCategoryResponse**](../Model/ProductCategoryResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
