# Vend20\PriceBooksApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**addPriceBookProducts()**](PriceBooksApi.md#addPriceBookProducts) | **POST** /price_books/{price_book_id}/products | Add the products to a Price Book
[**createPriceBook()**](PriceBooksApi.md#createPriceBook) | **POST** /price_books | Create a single Price Book
[**deletePriceBook()**](PriceBooksApi.md#deletePriceBook) | **DELETE** /price_books/{price_book_id} | Delete a Price Book
[**deletePriceBookProducts()**](PriceBooksApi.md#deletePriceBookProducts) | **DELETE** /price_books/{price_book_id}/products | Delete some entries for a Price Book
[**getPriceBookProductsForPriceBook()**](PriceBooksApi.md#getPriceBookProductsForPriceBook) | **GET** /price_books/{price_book_id}/products | List Price Book Products per Price Book
[**getPriceBookbyID()**](PriceBooksApi.md#getPriceBookbyID) | **GET** /price_books/{price_book_id} | Get a single Price Book
[**listPriceBookProducts()**](PriceBooksApi.md#listPriceBookProducts) | **GET** /price_book_products | List Price Book products
[**listPriceBooks()**](PriceBooksApi.md#listPriceBooks) | **GET** /price_books | List Price Books
[**updatePriceBook()**](PriceBooksApi.md#updatePriceBook) | **POST** /price_books/{price_book_id} | Update a single Price Book
[**updatePriceBookProducts()**](PriceBooksApi.md#updatePriceBookProducts) | **PATCH** /price_books/{price_book_id}/products | Update the products in a Price Book


## `addPriceBookProducts()`

```php
addPriceBookProducts($price_book_id, $price_book_product_collection): \Vend20\Model\PriceBookProductCollection
```

Add the products to a Price Book

Create Price Book Products.  > **Note**: When adding a product the retail price is the tax exclusive price of the product if your store is tax exclusive, and tax inclusive if your store is tax inclusive.  The returned value is always tax exclusive.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_book_id = 'price_book_id_example'; // string
$price_book_product_collection = new \Vend20\Model\PriceBookProductCollection(); // \Vend20\Model\PriceBookProductCollection | The request body may not contain more than 100 Price Book Products.

try {
    $result = $apiInstance->addPriceBookProducts($price_book_id, $price_book_product_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->addPriceBookProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_book_id** | **string**|  |
 **price_book_product_collection** | [**\Vend20\Model\PriceBookProductCollection**](../Model/PriceBookProductCollection.md)| The request body may not contain more than 100 Price Book Products. |

### Return type

[**\Vend20\Model\PriceBookProductCollection**](../Model/PriceBookProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createPriceBook()`

```php
createPriceBook($price_book): \Vend20\Model\PriceBookResponse
```

Create a single Price Book

Create a Price Book

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_book = new \Vend20\Model\PriceBook(); // \Vend20\Model\PriceBook

try {
    $result = $apiInstance->createPriceBook($price_book);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->createPriceBook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_book** | [**\Vend20\Model\PriceBook**](../Model/PriceBook.md)|  |

### Return type

[**\Vend20\Model\PriceBookResponse**](../Model/PriceBookResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deletePriceBook()`

```php
deletePriceBook($price_book_id): \Vend20\Model\PriceBookResponse
```

Delete a Price Book

Delete a Price Book by ID  **Note**: The products associated with this price book will be automatically deleted when you delete the price book.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_book_id = 'price_book_id_example'; // string | Valid Price Book ID.

try {
    $result = $apiInstance->deletePriceBook($price_book_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->deletePriceBook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_book_id** | **string**| Valid Price Book ID. |

### Return type

[**\Vend20\Model\PriceBookResponse**](../Model/PriceBookResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deletePriceBookProducts()`

```php
deletePriceBookProducts($price_book_id, $price_book_product_id_collection): \Vend20\Model\PriceBookProductCollection
```

Delete some entries for a Price Book

Delete Price Book Product entries

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_book_id = 'price_book_id_example'; // string
$price_book_product_id_collection = new \Vend20\Model\PriceBookProductIdCollection(); // \Vend20\Model\PriceBookProductIdCollection | You may not delete more than 100 Price Book Products at a time.

try {
    $result = $apiInstance->deletePriceBookProducts($price_book_id, $price_book_product_id_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->deletePriceBookProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_book_id** | **string**|  |
 **price_book_product_id_collection** | [**\Vend20\Model\PriceBookProductIdCollection**](../Model/PriceBookProductIdCollection.md)| You may not delete more than 100 Price Book Products at a time. |

### Return type

[**\Vend20\Model\PriceBookProductCollection**](../Model/PriceBookProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPriceBookProductsForPriceBook()`

```php
getPriceBookProductsForPriceBook($price_book_id): \Vend20\Model\PriceBookProductCollection
```

List Price Book Products per Price Book

Returns a list of Price Book Products for a given Price Book.  > **Note**: The returned retail price is the tax exclusive price of the product.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_book_id = 'price_book_id_example'; // string

try {
    $result = $apiInstance->getPriceBookProductsForPriceBook($price_book_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->getPriceBookProductsForPriceBook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_book_id** | **string**|  |

### Return type

[**\Vend20\Model\PriceBookProductCollection**](../Model/PriceBookProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getPriceBookbyID()`

```php
getPriceBookbyID($price_book_id): \Vend20\Model\PriceBookResponse
```

Get a single Price Book

Returns a single Price Book with a requested ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_book_id = 'price_book_id_example'; // string | Valid Price Book ID.

try {
    $result = $apiInstance->getPriceBookbyID($price_book_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->getPriceBookbyID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_book_id** | **string**| Valid Price Book ID. |

### Return type

[**\Vend20\Model\PriceBookResponse**](../Model/PriceBookResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listPriceBookProducts()`

```php
listPriceBookProducts($after, $before, $page_size): \Vend20\Model\PriceBookProductCollection
```

List Price Book products

Returns a paginated list of Price Book products.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.

try {
    $result = $apiInstance->listPriceBookProducts($after, $before, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->listPriceBookProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]

### Return type

[**\Vend20\Model\PriceBookProductCollection**](../Model/PriceBookProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listPriceBooks()`

```php
listPriceBooks($after, $before, $page_size): \Vend20\Model\PriceBookCollection
```

List Price Books

Returns a paginated list of Price Books.  **Note**: In general you should avoid using Price Books unless the retailers' price books are already defined by an external system. The promotions API is the recommended way of providing custom pricing as it is rule based and more powerful, which reduces the amount of manual changes required compared to Price Books.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.

try {
    $result = $apiInstance->listPriceBooks($after, $before, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->listPriceBooks: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]

### Return type

[**\Vend20\Model\PriceBookCollection**](../Model/PriceBookCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updatePriceBook()`

```php
updatePriceBook($price_book_id, $price_book): \Vend20\Model\PriceBookResponse
```

Update a single Price Book

Update a Price Book by ID

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_book_id = 'price_book_id_example'; // string | Valid Price Book ID.
$price_book = new \Vend20\Model\PriceBook(); // \Vend20\Model\PriceBook

try {
    $result = $apiInstance->updatePriceBook($price_book_id, $price_book);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->updatePriceBook: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_book_id** | **string**| Valid Price Book ID. |
 **price_book** | [**\Vend20\Model\PriceBook**](../Model/PriceBook.md)|  |

### Return type

[**\Vend20\Model\PriceBookResponse**](../Model/PriceBookResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updatePriceBookProducts()`

```php
updatePriceBookProducts($price_book_id, $price_book_product_collection): \Vend20\Model\PriceBookProductCollection
```

Update the products in a Price Book

Update Price Book Products.  > **Note**: When adding a product the retail price is the tax exclusive price of the product if your store is tax exclusive, and tax inclusive if your store is tax inclusive. The returned value is always tax exclusive.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\PriceBooksApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$price_book_id = 'price_book_id_example'; // string
$price_book_product_collection = new \Vend20\Model\PriceBookProductCollection(); // \Vend20\Model\PriceBookProductCollection | The request body may not contain more than 100 Price Book Products.

try {
    $result = $apiInstance->updatePriceBookProducts($price_book_id, $price_book_product_collection);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling PriceBooksApi->updatePriceBookProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **price_book_id** | **string**|  |
 **price_book_product_collection** | [**\Vend20\Model\PriceBookProductCollection**](../Model/PriceBookProductCollection.md)| The request body may not contain more than 100 Price Book Products. |

### Return type

[**\Vend20\Model\PriceBookProductCollection**](../Model/PriceBookProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
