# Vend20\OutletsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getOutletByID()**](OutletsApi.md#getOutletByID) | **GET** /outlets/{outlet_id} | Get a single outlet
[**listOutlets()**](OutletsApi.md#listOutlets) | **GET** /outlets | List outlets


## `getOutletByID()`

```php
getOutletByID($outlet_id): \Vend20\Model\OutletResponse
```

Get a single outlet

Returns a single outlet with the requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\OutletsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$outlet_id = 'outlet_id_example'; // string | Valid Outlet ID.

try {
    $result = $apiInstance->getOutletByID($outlet_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutletsApi->getOutletByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outlet_id** | **string**| Valid Outlet ID. |

### Return type

[**\Vend20\Model\OutletResponse**](../Model/OutletResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listOutlets()`

```php
listOutlets($after, $before, $page_size, $deleted): \Vend20\Model\OutletCollection
```

List outlets

Returns a collection of outlets.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\OutletsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.
$deleted = True; // bool | Indicates whether deleted items should be included in the response.

try {
    $result = $apiInstance->listOutlets($after, $before, $page_size, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutletsApi->listOutlets: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]
 **deleted** | **bool**| Indicates whether deleted items should be included in the response. | [optional]

### Return type

[**\Vend20\Model\OutletCollection**](../Model/OutletCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
