# Vend20\OutletProductTaxesApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**listOutletProductTaxes()**](OutletProductTaxesApi.md#listOutletProductTaxes) | **GET** /outlet_taxes | List outlet product taxes


## `listOutletProductTaxes()`

```php
listOutletProductTaxes($outlet_id, $after, $before, $page_size, $deleted): \Vend20\Model\OutletTaxCollection
```

List outlet product taxes

Returns a paginated list of outlet-product-tax records.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\OutletProductTaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$outlet_id = 'outlet_id_example'; // string | The ID of the outlet for which the results should be returned.
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.
$deleted = True; // bool | Indicates whether deleted items should be included in the response.

try {
    $result = $apiInstance->listOutletProductTaxes($outlet_id, $after, $before, $page_size, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutletProductTaxesApi->listOutletProductTaxes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outlet_id** | **string**| The ID of the outlet for which the results should be returned. | [optional]
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]
 **deleted** | **bool**| Indicates whether deleted items should be included in the response. | [optional]

### Return type

[**\Vend20\Model\OutletTaxCollection**](../Model/OutletTaxCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
