# Vend20\FulfillmentApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**fulfillSale()**](FulfillmentApi.md#fulfillSale) | **POST** /sales/{sale_id}/fulfill | Fulfil a sale
[**getFulfillmentsBySaleID()**](FulfillmentApi.md#getFulfillmentsBySaleID) | **GET** /sales/{sale_id}/fulfillments | List Sale Fulfillments
[**getfulfillments()**](FulfillmentApi.md#getfulfillments) | **GET** /fulfillments | Get Fulfillments Summary


## `fulfillSale()`

```php
fulfillSale($sale_id, $fulfill_sale_request): \Vend20\Model\FulfillmentResponse
```

Fulfil a sale

Fulfil an unfulfilled sale.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\FulfillmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 'sale_id_example'; // string | Valid sale ID.
$fulfill_sale_request = new \Vend20\Model\FulfillSaleRequest(); // \Vend20\Model\FulfillSaleRequest

try {
    $result = $apiInstance->fulfillSale($sale_id, $fulfill_sale_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfillmentApi->fulfillSale: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sale_id** | **string**| Valid sale ID. |
 **fulfill_sale_request** | [**\Vend20\Model\FulfillSaleRequest**](../Model/FulfillSaleRequest.md)|  |

### Return type

[**\Vend20\Model\FulfillmentResponse**](../Model/FulfillmentResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getFulfillmentsBySaleID()`

```php
getFulfillmentsBySaleID($sale_id): \Vend20\Model\FulfillmentsResponse
```

List Sale Fulfillments

Returns a list of sales for a given sale.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\FulfillmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 'sale_id_example'; // string | Valid sale ID.

try {
    $result = $apiInstance->getFulfillmentsBySaleID($sale_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfillmentApi->getFulfillmentsBySaleID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sale_id** | **string**| Valid sale ID. |

### Return type

[**\Vend20\Model\FulfillmentsResponse**](../Model/FulfillmentsResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getfulfillments()`

```php
getfulfillments($outlet_id, $sale_id, $fulfillment_type, $fulfillment_state, $page_number, $page_size): \Vend20\Model\FulfilmentSummaryResponse
```

Get Fulfillments Summary

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\FulfillmentApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$outlet_id = array('outlet_id_example'); // string[] | Filter by outlet IDs (can be specified multiple times, e.g. ?outlet_id=1234&outlet_id=5678)
$sale_id = array('sale_id_example'); // string[] | Filter by sale IDs (can be specified multiple times, e.g. ?sale_id=1234&sale_id=5678)
$fulfillment_type = array('fulfillment_type_example'); // string[] | Filter by fulfillment types (can be specified multiple times, e.g. ?fulfillment_type=PICKUP&fulfillment_type=DISPATCH)
$fulfillment_state = array('fulfillment_state_example'); // string[] | Filter by fulfillment states (can be specified multiple times, e.g. ?fulfillment_state=OPEN&fulfillment_state=STARTED)
$page_number = 56; // int | Page number for pagination (1-based)
$page_size = 56; // int | The maximum number of items to be returned in the response.

try {
    $result = $apiInstance->getfulfillments($outlet_id, $sale_id, $fulfillment_type, $fulfillment_state, $page_number, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling FulfillmentApi->getfulfillments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **outlet_id** | [**string[]**](../Model/string.md)| Filter by outlet IDs (can be specified multiple times, e.g. ?outlet_id&#x3D;1234&amp;outlet_id&#x3D;5678) | [optional]
 **sale_id** | [**string[]**](../Model/string.md)| Filter by sale IDs (can be specified multiple times, e.g. ?sale_id&#x3D;1234&amp;sale_id&#x3D;5678) | [optional]
 **fulfillment_type** | [**string[]**](../Model/string.md)| Filter by fulfillment types (can be specified multiple times, e.g. ?fulfillment_type&#x3D;PICKUP&amp;fulfillment_type&#x3D;DISPATCH) | [optional]
 **fulfillment_state** | [**string[]**](../Model/string.md)| Filter by fulfillment states (can be specified multiple times, e.g. ?fulfillment_state&#x3D;OPEN&amp;fulfillment_state&#x3D;STARTED) | [optional]
 **page_number** | **int**| Page number for pagination (1-based) | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]

### Return type

[**\Vend20\Model\FulfilmentSummaryResponse**](../Model/FulfilmentSummaryResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
