# Vend20\CustomersApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createCustomer()**](CustomersApi.md#createCustomer) | **POST** /customers | Create a new customer
[**deleteCustomerByID()**](CustomersApi.md#deleteCustomerByID) | **DELETE** /customers/{customer_id} | Delete a customer
[**getCustomerByID()**](CustomersApi.md#getCustomerByID) | **GET** /customers/{customer_id} | Get a single customer
[**listCustomers()**](CustomersApi.md#listCustomers) | **GET** /customers | List customers
[**updateCustomerByID()**](CustomersApi.md#updateCustomerByID) | **PUT** /customers/{customer_id} | Update a customer


## `createCustomer()`

```php
createCustomer($customer_base): \Vend20\Model\CustomerResponse
```

Create a new customer

Creates a new customer.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_base = new \Vend20\Model\CustomerBase(); // \Vend20\Model\CustomerBase

try {
    $result = $apiInstance->createCustomer($customer_base);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->createCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_base** | [**\Vend20\Model\CustomerBase**](../Model/CustomerBase.md)|  |

### Return type

[**\Vend20\Model\CustomerResponse**](../Model/CustomerResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCustomerByID()`

```php
deleteCustomerByID($customer_id)
```

Delete a customer

Deletes the customer with the requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 'customer_id_example'; // string | Valid customer ID.

try {
    $apiInstance->deleteCustomerByID($customer_id);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->deleteCustomerByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **string**| Valid customer ID. |

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerByID()`

```php
getCustomerByID($customer_id): \Vend20\Model\CustomerResponse
```

Get a single customer

Returns a single customer with a requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 'customer_id_example'; // string | Valid customer ID.

try {
    $result = $apiInstance->getCustomerByID($customer_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->getCustomerByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **string**| Valid customer ID. |

### Return type

[**\Vend20\Model\CustomerResponse**](../Model/CustomerResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listCustomers()`

```php
listCustomers($after, $before, $page_size, $deleted): \Vend20\Model\CustomerCollection
```

List customers

Returns a paginated list of customers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.
$deleted = True; // bool | Indicates whether deleted items should be included in the response.

try {
    $result = $apiInstance->listCustomers($after, $before, $page_size, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->listCustomers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]
 **deleted** | **bool**| Indicates whether deleted items should be included in the response. | [optional]

### Return type

[**\Vend20\Model\CustomerCollection**](../Model/CustomerCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCustomerByID()`

```php
updateCustomerByID($customer_id, $customer_base): \Vend20\Model\CustomerResponse
```

Update a customer

Updates the customer with the requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_id = 'customer_id_example'; // string | Valid customer ID.
$customer_base = new \Vend20\Model\CustomerBase(); // \Vend20\Model\CustomerBase

try {
    $result = $apiInstance->updateCustomerByID($customer_id, $customer_base);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->updateCustomerByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_id** | **string**| Valid customer ID. |
 **customer_base** | [**\Vend20\Model\CustomerBase**](../Model/CustomerBase.md)|  |

### Return type

[**\Vend20\Model\CustomerResponse**](../Model/CustomerResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
