# Vend20\CustomerGroupsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**addCustomersToCustomerGroup()**](CustomerGroupsApi.md#addCustomersToCustomerGroup) | **POST** /customer_groups/{customer_group_id}/customers | AddCustomersToCustomerGroup
[**createCustomerGroup()**](CustomerGroupsApi.md#createCustomerGroup) | **POST** /customer_groups | Create a new Customer Group
[**deleteCustomerGroup()**](CustomerGroupsApi.md#deleteCustomerGroup) | **DELETE** /customer_groups/{customer_group_id} | Delete the given Customer Group
[**deleteCustomersFromCustomerGroup()**](CustomerGroupsApi.md#deleteCustomersFromCustomerGroup) | **DELETE** /customer_groups/{customer_group_id}/customers | Delete Customers from Customer Group
[**getCustomerGroupById()**](CustomerGroupsApi.md#getCustomerGroupById) | **GET** /customer_groups/{customer_group_id} | Return the given Customer Group
[**getCustomerGroupCustomers()**](CustomerGroupsApi.md#getCustomerGroupCustomers) | **GET** /customer_groups/{customer_group_id}/customers | Get Customers for Customer Group
[**listCustomerGroups()**](CustomerGroupsApi.md#listCustomerGroups) | **GET** /customer_groups | List customer groups
[**updateCustomerGroup()**](CustomerGroupsApi.md#updateCustomerGroup) | **PUT** /customer_groups/{customer_group_id} | Update the given Customer Group


## `addCustomersToCustomerGroup()`

```php
addCustomersToCustomerGroup($customer_group_id, $add_customers_to_customer_group_request): bool
```

AddCustomersToCustomerGroup

Associates one or more Customers with the given Customer Group

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 'customer_group_id_example'; // string | The Customer Group id
$add_customers_to_customer_group_request = new \Vend20\Model\AddCustomersToCustomerGroupRequest(); // \Vend20\Model\AddCustomersToCustomerGroupRequest

try {
    $result = $apiInstance->addCustomersToCustomerGroup($customer_group_id, $add_customers_to_customer_group_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->addCustomersToCustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_group_id** | **string**| The Customer Group id |
 **add_customers_to_customer_group_request** | [**\Vend20\Model\AddCustomersToCustomerGroupRequest**](../Model/AddCustomersToCustomerGroupRequest.md)|  |

### Return type

**bool**

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createCustomerGroup()`

```php
createCustomerGroup($customer_group): \Vend20\Model\CustomerGroupResponse
```

Create a new Customer Group

Create a new Customer Group

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group = new \Vend20\Model\CustomerGroup(); // \Vend20\Model\CustomerGroup

try {
    $result = $apiInstance->createCustomerGroup($customer_group);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->createCustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_group** | [**\Vend20\Model\CustomerGroup**](../Model/CustomerGroup.md)|  |

### Return type

[**\Vend20\Model\CustomerGroupResponse**](../Model/CustomerGroupResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCustomerGroup()`

```php
deleteCustomerGroup($customer_group_id): bool
```

Delete the given Customer Group

Delete the given Customer Group

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 'customer_group_id_example'; // string | The Customer Group id

try {
    $result = $apiInstance->deleteCustomerGroup($customer_group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->deleteCustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_group_id** | **string**| The Customer Group id |

### Return type

**bool**

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteCustomersFromCustomerGroup()`

```php
deleteCustomersFromCustomerGroup($customer_group_id, $delete_customers_from_customer_group_request)
```

Delete Customers from Customer Group

Deletes the given Customers from the Customer Group.  **Note**: Only the link is deleted, the Customers are not.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 'customer_group_id_example'; // string | The Customer Group id
$delete_customers_from_customer_group_request = new \Vend20\Model\DeleteCustomersFromCustomerGroupRequest(); // \Vend20\Model\DeleteCustomersFromCustomerGroupRequest

try {
    $apiInstance->deleteCustomersFromCustomerGroup($customer_group_id, $delete_customers_from_customer_group_request);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->deleteCustomersFromCustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_group_id** | **string**| The Customer Group id |
 **delete_customers_from_customer_group_request** | [**\Vend20\Model\DeleteCustomersFromCustomerGroupRequest**](../Model/DeleteCustomersFromCustomerGroupRequest.md)|  |

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerGroupById()`

```php
getCustomerGroupById($customer_group_id): \Vend20\Model\CustomerGroupResponse
```

Return the given Customer Group

Return the given Customer Group

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 'customer_group_id_example'; // string | The Customer Group id

try {
    $result = $apiInstance->getCustomerGroupById($customer_group_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->getCustomerGroupById: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_group_id** | **string**| The Customer Group id |

### Return type

[**\Vend20\Model\CustomerGroupResponse**](../Model/CustomerGroupResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getCustomerGroupCustomers()`

```php
getCustomerGroupCustomers($customer_group_id, $after, $before, $page_size): \Vend20\Model\CustomerCollection
```

Get Customers for Customer Group

Returns a list of Customers for the given Customer Group

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 'customer_group_id_example'; // string | The Customer Group id
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.

try {
    $result = $apiInstance->getCustomerGroupCustomers($customer_group_id, $after, $before, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->getCustomerGroupCustomers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_group_id** | **string**| The Customer Group id |
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]

### Return type

[**\Vend20\Model\CustomerCollection**](../Model/CustomerCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listCustomerGroups()`

```php
listCustomerGroups($after, $before, $page_size, $deleted): \Vend20\Model\CustomerGroupCollection
```

List customer groups

Return a list of Customer Groups

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.
$deleted = True; // bool | Indicates whether deleted items should be included in the response.

try {
    $result = $apiInstance->listCustomerGroups($after, $before, $page_size, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->listCustomerGroups: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]
 **deleted** | **bool**| Indicates whether deleted items should be included in the response. | [optional]

### Return type

[**\Vend20\Model\CustomerGroupCollection**](../Model/CustomerGroupCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateCustomerGroup()`

```php
updateCustomerGroup($customer_group_id, $customer_group): \Vend20\Model\CustomerGroupResponse
```

Update the given Customer Group

Update the given Customer Group

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\CustomerGroupsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$customer_group_id = 'customer_group_id_example'; // string | The Customer Group id
$customer_group = new \Vend20\Model\CustomerGroup(); // \Vend20\Model\CustomerGroup

try {
    $result = $apiInstance->updateCustomerGroup($customer_group_id, $customer_group);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomerGroupsApi->updateCustomerGroup: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **customer_group_id** | **string**| The Customer Group id |
 **customer_group** | [**\Vend20\Model\CustomerGroup**](../Model/CustomerGroup.md)|  |

### Return type

[**\Vend20\Model\CustomerGroupResponse**](../Model/CustomerGroupResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
