# Vend20\ConsignmentsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createConsignment()**](ConsignmentsApi.md#createConsignment) | **POST** /consignments | Create an consignment
[**deleteConsignmentByID()**](ConsignmentsApi.md#deleteConsignmentByID) | **DELETE** /consignments/{consignment_id} | Delete a consignment
[**getConsignmentByID()**](ConsignmentsApi.md#getConsignmentByID) | **GET** /consignments/{consignment_id} | Get a single consignment
[**listConsignmentTotals()**](ConsignmentsApi.md#listConsignmentTotals) | **GET** /consignments/{consignment_id}/totals | Get consignment totals
[**listConsignments()**](ConsignmentsApi.md#listConsignments) | **GET** /consignments | List consignments
[**updateConsignmentByID()**](ConsignmentsApi.md#updateConsignmentByID) | **PUT** /consignments/{consignment_id} | Update a consignment


## `createConsignment()`

```php
createConsignment($consignment_request): \Vend20\Model\ConsignmentResponse
```

Create an consignment

Creates a new consignment.  The consignment type can be `SUPPLIER`, `OUTLET`, `STOCKTAKE` or `RETURN`. The workflows for these are:  - `SUPPLIER` workflow: `OPEN` -> `SENT` -> `DISPATCHED` -> `RECEIVED` (can be `CANCELLED` at any time after `OPEN`) - `OUTLET` workflow: `OPEN` -> `SENT` -> `RECEIVED` (can be `CANCELLED` at any time after `OPEN`) - `RETURN` workflow: `OPEN` -> `SENT` or `CANCELLED` - `STOCKTAKE` workflow: `STOCKTAKE` or `STOCKTAKE_SCHEDULED` -> `STOCKTAKE_IN_PROGRESS` -> `STOCKTAKE_IN_PROGRESS_PROCESSED` -> `STOCKTAKE_COMPLETE` (can be `CANCELLED` or `CLOSED` at any time)

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_request = new \Vend20\Model\ConsignmentRequest(); // \Vend20\Model\ConsignmentRequest

try {
    $result = $apiInstance->createConsignment($consignment_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->createConsignment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_request** | [**\Vend20\Model\ConsignmentRequest**](../Model/ConsignmentRequest.md)|  |

### Return type

[**\Vend20\Model\ConsignmentResponse**](../Model/ConsignmentResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteConsignmentByID()`

```php
deleteConsignmentByID($consignment_id)
```

Delete a consignment

Deletes the consignment with the given ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The consignment id to use.

try {
    $apiInstance->deleteConsignmentByID($consignment_id);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->deleteConsignmentByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The consignment id to use. |

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getConsignmentByID()`

```php
getConsignmentByID($consignment_id): \Vend20\Model\ConsignmentResponse
```

Get a single consignment

Returns a single consignment with the requested ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The consignment id to use.

try {
    $result = $apiInstance->getConsignmentByID($consignment_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->getConsignmentByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The consignment id to use. |

### Return type

[**\Vend20\Model\ConsignmentResponse**](../Model/ConsignmentResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listConsignmentTotals()`

```php
listConsignmentTotals($consignment_id): \Vend20\Model\ConsignmentTotalsResponse
```

Get consignment totals

This end point allows you to get the count and cost for a consignment. It can be used for type `SUPPLIER`, `OUTLET` or `RETURN` (not `STOCKTAKE`). The status of the consignment does not matter but the status will determine which values makes sense. If the consignment is `OPEN` or `SENT` the received count and cost should both be zero. For completely received consignments received cost should equal the sent cost and the received count should equal the sent count. For partially received consignments we would expect the received cost value to be less than sent cost value, and the received count to be less than the sent count.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The consignment id

try {
    $result = $apiInstance->listConsignmentTotals($consignment_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->listConsignmentTotals: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The consignment id |

### Return type

[**\Vend20\Model\ConsignmentTotalsResponse**](../Model/ConsignmentTotalsResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listConsignments()`

```php
listConsignments($type, $status, $outlet_id, $after, $before, $page_size): \Vend20\Model\Consignment[]
```

List consignments

Return a paginated list of consignments.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$type = 'type_example'; // string
$status = 'status_example'; // string
$outlet_id = 'outlet_id_example'; // string
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.

try {
    $result = $apiInstance->listConsignments($type, $status, $outlet_id, $after, $before, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->listConsignments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**|  | [optional]
 **status** | **string**|  | [optional]
 **outlet_id** | **string**|  | [optional]
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]

### Return type

[**\Vend20\Model\Consignment[]**](../Model/Consignment.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateConsignmentByID()`

```php
updateConsignmentByID($consignment_id, $consignment_request): \Vend20\Model\ConsignmentResponse
```

Update a consignment

Updates the given consignment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The consignment id to use.
$consignment_request = new \Vend20\Model\ConsignmentRequest(); // \Vend20\Model\ConsignmentRequest

try {
    $result = $apiInstance->updateConsignmentByID($consignment_id, $consignment_request);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->updateConsignmentByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The consignment id to use. |
 **consignment_request** | [**\Vend20\Model\ConsignmentRequest**](../Model/ConsignmentRequest.md)|  |

### Return type

[**\Vend20\Model\ConsignmentResponse**](../Model/ConsignmentResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
