# Vend20\ConsignmentProductsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createConsignmentProduct()**](ConsignmentProductsApi.md#createConsignmentProduct) | **POST** /consignments/{consignment_id}/products | Add a product to a consignment
[**createOrUpdateConsignmentProducts()**](ConsignmentProductsApi.md#createOrUpdateConsignmentProducts) | **POST** /consignments/{consignment_id}/bulk | Bulk update consignment products
[**deleteProductFromConsignment()**](ConsignmentProductsApi.md#deleteProductFromConsignment) | **DELETE** /consignments/{consignment_id}/products/{product_id} | Delete an item from a consignment
[**listProductsByConsignmentID()**](ConsignmentProductsApi.md#listProductsByConsignmentID) | **GET** /consignments/{consignment_id}/products | List all products for a specific consignment
[**updateProductInConsignment()**](ConsignmentProductsApi.md#updateProductInConsignment) | **PUT** /consignments/{consignment_id}/products/{product_id} | Update a product in a consignment


## `createConsignmentProduct()`

```php
createConsignmentProduct($consignment_id, $consignment_product): \Vend20\Model\InventoryCountItemResponse
```

Add a product to a consignment

Add a product to the given consignment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The consignment id to add a product to.
$consignment_product = new \Vend20\Model\ConsignmentProduct(); // \Vend20\Model\ConsignmentProduct

try {
    $result = $apiInstance->createConsignmentProduct($consignment_id, $consignment_product);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->createConsignmentProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The consignment id to add a product to. |
 **consignment_product** | [**\Vend20\Model\ConsignmentProduct**](../Model/ConsignmentProduct.md)|  | [optional]

### Return type

[**\Vend20\Model\InventoryCountItemResponse**](../Model/InventoryCountItemResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `createOrUpdateConsignmentProducts()`

```php
createOrUpdateConsignmentProducts($consignment_id, $consignment_product)
```

Bulk update consignment products

Add or update the products in a consignment in bulk.  **Note**: If you are using the bulk end point then both count and received are required fields.  **Note**: If you add or update more than 500 products at a time you may find that your connection to the server has timed out, so we don't recommend you do that.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The id of the consignment
$consignment_product = array(new \Vend20\Model\ConsignmentProduct()); // \Vend20\Model\ConsignmentProduct[]

try {
    $apiInstance->createOrUpdateConsignmentProducts($consignment_id, $consignment_product);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->createOrUpdateConsignmentProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The id of the consignment |
 **consignment_product** | [**\Vend20\Model\ConsignmentProduct[]**](../Model/ConsignmentProduct.md)|  |

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProductFromConsignment()`

```php
deleteProductFromConsignment($consignment_id, $product_id)
```

Delete an item from a consignment

Removes the specific product from the consignment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The consignment id to be updated.
$product_id = 'product_id_example'; // string | The product id of the product to be added to the consignment.

try {
    $apiInstance->deleteProductFromConsignment($consignment_id, $product_id);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->deleteProductFromConsignment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The consignment id to be updated. |
 **product_id** | **string**| The product id of the product to be added to the consignment. |

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listProductsByConsignmentID()`

```php
listProductsByConsignmentID($consignment_id, $after, $before, $page_size): \Vend20\Model\ConsignmentProductCollection
```

List all products for a specific consignment

Returns a collection of consignment products associated with the specified consignment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The consignment id to add a product to.
$after = 56; // int | The lower limit for the version numbers to be included in the response.
$before = 56; // int | The upper limit for the version numbers to be included in the response.
$page_size = 56; // int | The maximum number of items to be returned in the response.

try {
    $result = $apiInstance->listProductsByConsignmentID($consignment_id, $after, $before, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->listProductsByConsignmentID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The consignment id to add a product to. |
 **after** | **int**| The lower limit for the version numbers to be included in the response. | [optional]
 **before** | **int**| The upper limit for the version numbers to be included in the response. | [optional]
 **page_size** | **int**| The maximum number of items to be returned in the response. | [optional]

### Return type

[**\Vend20\Model\ConsignmentProductCollection**](../Model/ConsignmentProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateProductInConsignment()`

```php
updateProductInConsignment($consignment_id, $product_id, $consignment_product): \Vend20\Model\ConsignmentProductResponse
```

Update a product in a consignment

Updates the specific product within the consignment.  **Notes**:  - If the type is SUPPLIER or OUTLET then:   * If the type is OUTLET and there is a cost the cost will be update.   * If the status is SENT or DISPATCHED and received is not null the received quantity will be updated.   * If the status is OPEN or SENT and count is not null then the count quantity will be updated. - If the type is RETURN and the status is OPEN or SENT and count is not null then the count quantity will be updated. - If the type is STOCKTAKE and the status is STATUS\\_STOCKTAKE\\_IN\\_PROGRESS or STATUS\\_STOCKTAKE\\_IN\\_PROCESS\\_PROCESSED and received is not null then the received quantity will be updated.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The consignment id to be updated.
$product_id = 'product_id_example'; // string | The product id of the product to be added to the consignment.
$consignment_product = new \Vend20\Model\ConsignmentProduct(); // \Vend20\Model\ConsignmentProduct

try {
    $result = $apiInstance->updateProductInConsignment($consignment_id, $product_id, $consignment_product);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->updateProductInConsignment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The consignment id to be updated. |
 **product_id** | **string**| The product id of the product to be added to the consignment. |
 **consignment_product** | [**\Vend20\Model\ConsignmentProduct**](../Model/ConsignmentProduct.md)|  | [optional]

### Return type

[**\Vend20\Model\ConsignmentProductResponse**](../Model/ConsignmentProductResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
