# Vend20\ChannelRequestLogApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api/2.0.

Method | HTTP request | Description
------------- | ------------- | -------------
[**getSingleRequest()**](ChannelRequestLogApi.md#getSingleRequest) | **GET** /channel_requests/{request_log_id} | Get a single request log
[**getSingleRequestText()**](ChannelRequestLogApi.md#getSingleRequestText) | **GET** /channel_requests/{request_log_id}.txt | Get a single request log as text
[**listChannels()**](ChannelRequestLogApi.md#listChannels) | **GET** /channels | List channel records
[**listRequests()**](ChannelRequestLogApi.md#listRequests) | **GET** /channel_requests | List request records


## `getSingleRequest()`

```php
getSingleRequest($request_log_id): \Vend20\Model\RequestSingleResponse
```

Get a single request log

Returns a single request log entry with a specific ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ChannelRequestLogApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request_log_id = 'request_log_id_example'; // string

try {
    $result = $apiInstance->getSingleRequest($request_log_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ChannelRequestLogApi->getSingleRequest: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request_log_id** | **string**|  |

### Return type

[**\Vend20\Model\RequestSingleResponse**](../Model/RequestSingleResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getSingleRequestText()`

```php
getSingleRequestText($request_log_id): string
```

Get a single request log as text

Returns a text representation of a single request log entry with a specific ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ChannelRequestLogApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$request_log_id = 'request_log_id_example'; // string

try {
    $result = $apiInstance->getSingleRequestText($request_log_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ChannelRequestLogApi->getSingleRequestText: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **request_log_id** | **string**|  |

### Return type

**string**

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `text/plain`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listChannels()`

```php
listChannels(): \Vend20\Model\ChannelCollectionResponse
```

List channel records

Returns a list of configured channels.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ChannelRequestLogApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->listChannels();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ChannelRequestLogApi->listChannels: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Vend20\Model\ChannelCollectionResponse**](../Model/ChannelCollectionResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listRequests()`

```php
listRequests($status_code, $request_method, $occurred_before, $occurred_after, $status_code_before, $status_code_after, $channel_id): \Vend20\Model\RequestCollectionResponse
```

List request records

Returns a list of request log records.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\ChannelRequestLogApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$status_code = 'status_code_example'; // string | Limit the requests to 1 or more status codes.
$request_method = 'request_method_example'; // string | Limit the requests to 1 or more request methods.
$occurred_before = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Limit requests to before this RFC3339 date.
$occurred_after = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | Limit requests to after this RFC3339 date.
$status_code_before = 'status_code_before_example'; // string | Limit requests to those with status codes less than this value.
$status_code_after = 'status_code_after_example'; // string | Limit requests to those with status codes greater than this value.
$channel_id = 'channel_id_example'; // string | If provided, request logs will be limited to the supplied channel id. If no id is provided, only requests logged with no channel id will be returned. Requests with no channel id indicate requests made during the setup process.

try {
    $result = $apiInstance->listRequests($status_code, $request_method, $occurred_before, $occurred_after, $status_code_before, $status_code_after, $channel_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ChannelRequestLogApi->listRequests: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **status_code** | **string**| Limit the requests to 1 or more status codes. | [optional]
 **request_method** | **string**| Limit the requests to 1 or more request methods. | [optional]
 **occurred_before** | **\DateTime**| Limit requests to before this RFC3339 date. | [optional]
 **occurred_after** | **\DateTime**| Limit requests to after this RFC3339 date. | [optional]
 **status_code_before** | **string**| Limit requests to those with status codes less than this value. | [optional]
 **status_code_after** | **string**| Limit requests to those with status codes greater than this value. | [optional]
 **channel_id** | **string**| If provided, request logs will be limited to the supplied channel id. If no id is provided, only requests logged with no channel id will be returned. Requests with no channel id indicate requests made during the setup process. | [optional]

### Return type

[**\Vend20\Model\RequestCollectionResponse**](../Model/RequestCollectionResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
