# OpenAPIClient-php

Early release of version 2.0 of the Vend API.

For more information, please visit [https://developers.vendhq.com](https://developers.vendhq.com).

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/vend2.0.git"
    }
  ],
  "require": {
    "talisman/vend2.0": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: personal_token
$config = Vend20\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend20\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend20\Api\BrandsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$brand_base = new \Vend20\Model\BrandBase(); // \Vend20\Model\BrandBase

try {
    $apiInstance->createBrand($brand_base);
} catch (Exception $e) {
    echo 'Exception when calling BrandsApi->createBrand: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://domain_prefix.retail.lightspeed.app/api/2.0*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*BrandsApi* | [**createBrand**](docs/Api/BrandsApi.md#createbrand) | **POST** /brands | Create brand
*BrandsApi* | [**getBrandByID**](docs/Api/BrandsApi.md#getbrandbyid) | **GET** /brands/{brand_id} | Get a single brand
*BrandsApi* | [**listBrands**](docs/Api/BrandsApi.md#listbrands) | **GET** /brands | List brands
*ChannelRequestLogApi* | [**getSingleRequest**](docs/Api/ChannelRequestLogApi.md#getsinglerequest) | **GET** /channel_requests/{request_log_id} | Get a single request log
*ChannelRequestLogApi* | [**getSingleRequestText**](docs/Api/ChannelRequestLogApi.md#getsinglerequesttext) | **GET** /channel_requests/{request_log_id}.txt | Get a single request log as text
*ChannelRequestLogApi* | [**listChannels**](docs/Api/ChannelRequestLogApi.md#listchannels) | **GET** /channels | List channel records
*ChannelRequestLogApi* | [**listRequests**](docs/Api/ChannelRequestLogApi.md#listrequests) | **GET** /channel_requests | List request records
*ConsignmentProductsApi* | [**createConsignmentProduct**](docs/Api/ConsignmentProductsApi.md#createconsignmentproduct) | **POST** /consignments/{consignment_id}/products | Add a product to a consignment
*ConsignmentProductsApi* | [**createOrUpdateConsignmentProducts**](docs/Api/ConsignmentProductsApi.md#createorupdateconsignmentproducts) | **POST** /consignments/{consignment_id}/bulk | Bulk update consignment products
*ConsignmentProductsApi* | [**deleteProductFromConsignment**](docs/Api/ConsignmentProductsApi.md#deleteproductfromconsignment) | **DELETE** /consignments/{consignment_id}/products/{product_id} | Delete an item from a consignment
*ConsignmentProductsApi* | [**listProductsByConsignmentID**](docs/Api/ConsignmentProductsApi.md#listproductsbyconsignmentid) | **GET** /consignments/{consignment_id}/products | List all products for a specific consignment
*ConsignmentProductsApi* | [**updateProductInConsignment**](docs/Api/ConsignmentProductsApi.md#updateproductinconsignment) | **PUT** /consignments/{consignment_id}/products/{product_id} | Update a product in a consignment
*ConsignmentsApi* | [**createConsignment**](docs/Api/ConsignmentsApi.md#createconsignment) | **POST** /consignments | Create an consignment
*ConsignmentsApi* | [**deleteConsignmentByID**](docs/Api/ConsignmentsApi.md#deleteconsignmentbyid) | **DELETE** /consignments/{consignment_id} | Delete a consignment
*ConsignmentsApi* | [**getConsignmentByID**](docs/Api/ConsignmentsApi.md#getconsignmentbyid) | **GET** /consignments/{consignment_id} | Get a single consignment
*ConsignmentsApi* | [**listConsignmentTotals**](docs/Api/ConsignmentsApi.md#listconsignmenttotals) | **GET** /consignments/{consignment_id}/totals | Get consignment totals
*ConsignmentsApi* | [**listConsignments**](docs/Api/ConsignmentsApi.md#listconsignments) | **GET** /consignments | List consignments
*ConsignmentsApi* | [**updateConsignmentByID**](docs/Api/ConsignmentsApi.md#updateconsignmentbyid) | **PUT** /consignments/{consignment_id} | Update a consignment
*CustomerGroupsApi* | [**addCustomersToCustomerGroup**](docs/Api/CustomerGroupsApi.md#addcustomerstocustomergroup) | **POST** /customer_groups/{customer_group_id}/customers | AddCustomersToCustomerGroup
*CustomerGroupsApi* | [**createCustomerGroup**](docs/Api/CustomerGroupsApi.md#createcustomergroup) | **POST** /customer_groups | Create a new Customer Group
*CustomerGroupsApi* | [**deleteCustomerGroup**](docs/Api/CustomerGroupsApi.md#deletecustomergroup) | **DELETE** /customer_groups/{customer_group_id} | Delete the given Customer Group
*CustomerGroupsApi* | [**deleteCustomersFromCustomerGroup**](docs/Api/CustomerGroupsApi.md#deletecustomersfromcustomergroup) | **DELETE** /customer_groups/{customer_group_id}/customers | Delete Customers from Customer Group
*CustomerGroupsApi* | [**getCustomerGroupById**](docs/Api/CustomerGroupsApi.md#getcustomergroupbyid) | **GET** /customer_groups/{customer_group_id} | Return the given Customer Group
*CustomerGroupsApi* | [**getCustomerGroupCustomers**](docs/Api/CustomerGroupsApi.md#getcustomergroupcustomers) | **GET** /customer_groups/{customer_group_id}/customers | Get Customers for Customer Group
*CustomerGroupsApi* | [**listCustomerGroups**](docs/Api/CustomerGroupsApi.md#listcustomergroups) | **GET** /customer_groups | List customer groups
*CustomerGroupsApi* | [**updateCustomerGroup**](docs/Api/CustomerGroupsApi.md#updatecustomergroup) | **PUT** /customer_groups/{customer_group_id} | Update the given Customer Group
*CustomersApi* | [**createCustomer**](docs/Api/CustomersApi.md#createcustomer) | **POST** /customers | Create a new customer
*CustomersApi* | [**deleteCustomerByID**](docs/Api/CustomersApi.md#deletecustomerbyid) | **DELETE** /customers/{customer_id} | Delete a customer
*CustomersApi* | [**getCustomerByID**](docs/Api/CustomersApi.md#getcustomerbyid) | **GET** /customers/{customer_id} | Get a single customer
*CustomersApi* | [**listCustomers**](docs/Api/CustomersApi.md#listcustomers) | **GET** /customers | List customers
*CustomersApi* | [**updateCustomerByID**](docs/Api/CustomersApi.md#updatecustomerbyid) | **PUT** /customers/{customer_id} | Update a customer
*FulfillmentApi* | [**fulfillSale**](docs/Api/FulfillmentApi.md#fulfillsale) | **POST** /sales/{sale_id}/fulfill | Fulfil a sale
*FulfillmentApi* | [**getFulfillmentsBySaleID**](docs/Api/FulfillmentApi.md#getfulfillmentsbysaleid) | **GET** /sales/{sale_id}/fulfillments | List Sale Fulfillments
*FulfillmentApi* | [**getfulfillments**](docs/Api/FulfillmentApi.md#getfulfillments) | **GET** /fulfillments | Get Fulfillments Summary
*InventoryApi* | [**listInventoryLevels**](docs/Api/InventoryApi.md#listinventorylevels) | **GET** /inventory_levels | List inventory levels
*InventoryApi* | [**listInventoryRecords**](docs/Api/InventoryApi.md#listinventoryrecords) | **GET** /inventory | List inventory records
*OutletProductTaxesApi* | [**listOutletProductTaxes**](docs/Api/OutletProductTaxesApi.md#listoutletproducttaxes) | **GET** /outlet_taxes | List outlet product taxes
*OutletsApi* | [**getOutletByID**](docs/Api/OutletsApi.md#getoutletbyid) | **GET** /outlets/{outlet_id} | Get a single outlet
*OutletsApi* | [**listOutlets**](docs/Api/OutletsApi.md#listoutlets) | **GET** /outlets | List outlets
*PaymentTypesApi* | [**listPaymentTypes**](docs/Api/PaymentTypesApi.md#listpaymenttypes) | **GET** /payment_types | List payment types
*PriceBooksApi* | [**addPriceBookProducts**](docs/Api/PriceBooksApi.md#addpricebookproducts) | **POST** /price_books/{price_book_id}/products | Add the products to a Price Book
*PriceBooksApi* | [**createPriceBook**](docs/Api/PriceBooksApi.md#createpricebook) | **POST** /price_books | Create a single Price Book
*PriceBooksApi* | [**deletePriceBook**](docs/Api/PriceBooksApi.md#deletepricebook) | **DELETE** /price_books/{price_book_id} | Delete a Price Book
*PriceBooksApi* | [**deletePriceBookProducts**](docs/Api/PriceBooksApi.md#deletepricebookproducts) | **DELETE** /price_books/{price_book_id}/products | Delete some entries for a Price Book
*PriceBooksApi* | [**getPriceBookProductsForPriceBook**](docs/Api/PriceBooksApi.md#getpricebookproductsforpricebook) | **GET** /price_books/{price_book_id}/products | List Price Book Products per Price Book
*PriceBooksApi* | [**getPriceBookbyID**](docs/Api/PriceBooksApi.md#getpricebookbyid) | **GET** /price_books/{price_book_id} | Get a single Price Book
*PriceBooksApi* | [**listPriceBookProducts**](docs/Api/PriceBooksApi.md#listpricebookproducts) | **GET** /price_book_products | List Price Book products
*PriceBooksApi* | [**listPriceBooks**](docs/Api/PriceBooksApi.md#listpricebooks) | **GET** /price_books | List Price Books
*PriceBooksApi* | [**updatePriceBook**](docs/Api/PriceBooksApi.md#updatepricebook) | **POST** /price_books/{price_book_id} | Update a single Price Book
*PriceBooksApi* | [**updatePriceBookProducts**](docs/Api/PriceBooksApi.md#updatepricebookproducts) | **PATCH** /price_books/{price_book_id}/products | Update the products in a Price Book
*ProductCategoryApi* | [**createUpdateProductCategory**](docs/Api/ProductCategoryApi.md#createupdateproductcategory) | **POST** /product_categories/bulk | Create and update a product category hierarchy
*ProductCategoryApi* | [**deleteProductCategories**](docs/Api/ProductCategoryApi.md#deleteproductcategories) | **DELETE** /product_categories/bulk | Delete a list of product categories
*ProductCategoryApi* | [**getProductCategories**](docs/Api/ProductCategoryApi.md#getproductcategories) | **GET** /product_categories | List product categories
*ProductImagesApi* | [**deleteProductImageByID**](docs/Api/ProductImagesApi.md#deleteproductimagebyid) | **DELETE** /product_images/{product_image_id} | Delete a product_image
*ProductImagesApi* | [**getProductImageDataByID**](docs/Api/ProductImagesApi.md#getproductimagedatabyid) | **GET** /product_images/{product_image_id} | Get a single product_image data
*ProductImagesApi* | [**setImagePosition**](docs/Api/ProductImagesApi.md#setimageposition) | **PUT** /product_images/{product_image_id} | Set image position
*ProductTypesApi* | [**getProductTypeByID**](docs/Api/ProductTypesApi.md#getproducttypebyid) | **GET** /product_types/{product_type_id} | Get a single product type
*ProductTypesApi* | [**listProductTypes**](docs/Api/ProductTypesApi.md#listproducttypes) | **GET** /product_types | List product types
*ProductsApi* | [**createProduct**](docs/Api/ProductsApi.md#createproduct) | **POST** /products | Create product
*ProductsApi* | [**deleteProduct**](docs/Api/ProductsApi.md#deleteproduct) | **DELETE** /products/{product_id} | 
*ProductsApi* | [**deleteProductAll**](docs/Api/ProductsApi.md#deleteproductall) | **DELETE** /products/{product_id}/all | 
*ProductsApi* | [**getInventoryByProductID**](docs/Api/ProductsApi.md#getinventorybyproductid) | **GET** /products/{product_id}/inventory | Get inventory data for a single product
*ProductsApi* | [**getPriceBooksForProduct**](docs/Api/ProductsApi.md#getpricebooksforproduct) | **GET** /products/{product_id}/price_book_products | Get a list of Price Books the given product is in
*ProductsApi* | [**getProductByID**](docs/Api/ProductsApi.md#getproductbyid) | **GET** /products/{product_id} | Get a single product
*ProductsApi* | [**listProducts**](docs/Api/ProductsApi.md#listproducts) | **GET** /products | List products
*ProductsApi* | [**uploadImage**](docs/Api/ProductsApi.md#uploadimage) | **POST** /products/{product_id}/actions/image_upload | Upload an image
*PromotionsApi* | [**applyDiscount**](docs/Api/PromotionsApi.md#applydiscount) | **POST** /discount | Apply discounts to a sale object
*PromotionsApi* | [**createPromotion**](docs/Api/PromotionsApi.md#createpromotion) | **POST** /promotions | Create a promotion
*PromotionsApi* | [**deletePromoCodesBulk**](docs/Api/PromotionsApi.md#deletepromocodesbulk) | **DELETE** /promocode/bulk | Delete promo codes
*PromotionsApi* | [**getActivePromoCodesBulk**](docs/Api/PromotionsApi.md#getactivepromocodesbulk) | **POST** /promocode/bulk/active | Get the active status of promo codes
*PromotionsApi* | [**getPromotionByID**](docs/Api/PromotionsApi.md#getpromotionbyid) | **GET** /promotions/{promotion_id} | Get a promotion by ID
*PromotionsApi* | [**getPromotionProducts**](docs/Api/PromotionsApi.md#getpromotionproducts) | **GET** /promotions/{promotion_id}/products | Get products for a promotion
*PromotionsApi* | [**getPromotionPromoCodes**](docs/Api/PromotionsApi.md#getpromotionpromocodes) | **GET** /promotions/{promotion_id}/promocodes | Get the promo codes for a promotion
*PromotionsApi* | [**listPromotions**](docs/Api/PromotionsApi.md#listpromotions) | **GET** /promotions | List promotions
*PromotionsApi* | [**updatePromotion**](docs/Api/PromotionsApi.md#updatepromotion) | **PUT** /promotions/{promotion_id} | Update a promotion
*RegistersApi* | [**closeRegister**](docs/Api/RegistersApi.md#closeregister) | **PUT** /registers/{register_id}/actions/close | Close a single register
*RegistersApi* | [**getRegisterByID**](docs/Api/RegistersApi.md#getregisterbyid) | **GET** /registers/{register_id} | Get a single register
*RegistersApi* | [**listRegisters**](docs/Api/RegistersApi.md#listregisters) | **GET** /registers | List registers
*RegistersApi* | [**openRegister**](docs/Api/RegistersApi.md#openregister) | **PUT** /registers/{register_id}/actions/open | Open a single register
*RegistersApi* | [**registerPaymentsSummary**](docs/Api/RegistersApi.md#registerpaymentssummary) | **GET** /registers/{register_id}/payments_summary | Get all the payments data associated with a single register.
*RetailersApi* | [**getRetailer**](docs/Api/RetailersApi.md#getretailer) | **GET** /retailer | Get information about this retailer
*SalesApi* | [**getSaleByID**](docs/Api/SalesApi.md#getsalebyid) | **GET** /sales/{sale_id} | Get a single sale
*SalesApi* | [**initReturnSale**](docs/Api/SalesApi.md#initreturnsale) | **PUT** /sales/{sale_id}/actions/return | Return a sale
*SalesApi* | [**listSales**](docs/Api/SalesApi.md#listsales) | **GET** /sales | List Sales
*SearchApi* | [**search**](docs/Api/SearchApi.md#search) | **GET** /search | Search for resources
*SuppliersApi* | [**createSuppliers**](docs/Api/SuppliersApi.md#createsuppliers) | **POST** /suppliers | 
*SuppliersApi* | [**deleteSuppliersSupplierId**](docs/Api/SuppliersApi.md#deletesupplierssupplierid) | **DELETE** /suppliers/{supplier_id} | 
*SuppliersApi* | [**getSupplierByID**](docs/Api/SuppliersApi.md#getsupplierbyid) | **GET** /suppliers/{supplier_id} | Get a single supplier
*SuppliersApi* | [**listSuppliers**](docs/Api/SuppliersApi.md#listsuppliers) | **GET** /suppliers | List suppliers
*SuppliersApi* | [**updateSupplier**](docs/Api/SuppliersApi.md#updatesupplier) | **PUT** /suppliers/{supplier_id} | 
*TagsApi* | [**createTag**](docs/Api/TagsApi.md#createtag) | **POST** /tags | 
*TagsApi* | [**deleteTagsTagId**](docs/Api/TagsApi.md#deletetagstagid) | **DELETE** /tags/{tag_id} | 
*TagsApi* | [**getTagByID**](docs/Api/TagsApi.md#gettagbyid) | **GET** /tags/{tag_id} | Get a single tag
*TagsApi* | [**listTags**](docs/Api/TagsApi.md#listtags) | **GET** /tags | List tags
*TagsApi* | [**updateTag**](docs/Api/TagsApi.md#updatetag) | **PUT** /tags/{tag_id} | 
*TaxesApi* | [**listTaxes**](docs/Api/TaxesApi.md#listtaxes) | **GET** /taxes | List taxes
*UsersApi* | [**getUserByID**](docs/Api/UsersApi.md#getuserbyid) | **GET** /users/{user_id} | Get a single user
*UsersApi* | [**listUsers**](docs/Api/UsersApi.md#listusers) | **GET** /users | List users
*VariantApi* | [**createVariantAttribute**](docs/Api/VariantApi.md#createvariantattribute) | **POST** /variant_attributes | 
*VariantApi* | [**deleteVariantAttributesAttributeId**](docs/Api/VariantApi.md#deletevariantattributesattributeid) | **DELETE** /variant_attributes/{attribute-id} | 
*VariantApi* | [**getVariantAttribute**](docs/Api/VariantApi.md#getvariantattribute) | **GET** /variant_attributes/{attribute-id} | Retrieve a single Variant Attribute
*VariantApi* | [**getVariantAttributes**](docs/Api/VariantApi.md#getvariantattributes) | **GET** /variant_attributes | Retrieve all Variant Attributes
*VariantApi* | [**updateVariantAttribute**](docs/Api/VariantApi.md#updatevariantattribute) | **PUT** /variant_attributes/{attribute-id} | 
*WebhooksApi* | [**createWebhook**](docs/Api/WebhooksApi.md#createwebhook) | **POST** /webhooks | Create a Webhook
*WebhooksApi* | [**deleteWebhook**](docs/Api/WebhooksApi.md#deletewebhook) | **DELETE** /webhooks/{id} | 
*WebhooksApi* | [**getWebhook**](docs/Api/WebhooksApi.md#getwebhook) | **GET** /webhooks/{id} | Get a Webhook
*WebhooksApi* | [**getWebhooks**](docs/Api/WebhooksApi.md#getwebhooks) | **GET** /webhooks | List Webhooks
*WebhooksApi* | [**updateWebhook**](docs/Api/WebhooksApi.md#updatewebhook) | **PUT** /webhooks/{id} | 

## Models

- [Action](docs/Model/Action.md)
- [AddCustomersToCustomerGroupRequest](docs/Model/AddCustomersToCustomerGroupRequest.md)
- [Adjustment](docs/Model/Adjustment.md)
- [AllOutletTax](docs/Model/AllOutletTax.md)
- [Attribute](docs/Model/Attribute.md)
- [Brand](docs/Model/Brand.md)
- [BrandBase](docs/Model/BrandBase.md)
- [BrandCollection](docs/Model/BrandCollection.md)
- [BrandResponse](docs/Model/BrandResponse.md)
- [BrandSample](docs/Model/BrandSample.md)
- [Category](docs/Model/Category.md)
- [CategoryPath](docs/Model/CategoryPath.md)
- [Channel](docs/Model/Channel.md)
- [ChannelCollectionResponse](docs/Model/ChannelCollectionResponse.md)
- [Condition](docs/Model/Condition.md)
- [Consignment](docs/Model/Consignment.md)
- [ConsignmentProduct](docs/Model/ConsignmentProduct.md)
- [ConsignmentProductCollection](docs/Model/ConsignmentProductCollection.md)
- [ConsignmentProductResponse](docs/Model/ConsignmentProductResponse.md)
- [ConsignmentRequest](docs/Model/ConsignmentRequest.md)
- [ConsignmentResponse](docs/Model/ConsignmentResponse.md)
- [ConsignmentTotalsResponse](docs/Model/ConsignmentTotalsResponse.md)
- [ConsignmentTotalsResponseDataInner](docs/Model/ConsignmentTotalsResponseDataInner.md)
- [Contact](docs/Model/Contact.md)
- [CreateProduct200Response](docs/Model/CreateProduct200Response.md)
- [CreateSuppliers200Response](docs/Model/CreateSuppliers200Response.md)
- [CreateVariantAttribute200Response](docs/Model/CreateVariantAttribute200Response.md)
- [Customer](docs/Model/Customer.md)
- [CustomerBase](docs/Model/CustomerBase.md)
- [CustomerCollection](docs/Model/CustomerCollection.md)
- [CustomerGroup](docs/Model/CustomerGroup.md)
- [CustomerGroupCollection](docs/Model/CustomerGroupCollection.md)
- [CustomerGroupResponse](docs/Model/CustomerGroupResponse.md)
- [CustomerResponse](docs/Model/CustomerResponse.md)
- [DeleteCustomersFromCustomerGroupRequest](docs/Model/DeleteCustomersFromCustomerGroupRequest.md)
- [DiscountCustomerParam](docs/Model/DiscountCustomerParam.md)
- [DiscountLineItem](docs/Model/DiscountLineItem.md)
- [DiscountParam](docs/Model/DiscountParam.md)
- [DiscountResponse](docs/Model/DiscountResponse.md)
- [DiscountResponseParam](docs/Model/DiscountResponseParam.md)
- [DiscountSaleParam](docs/Model/DiscountSaleParam.md)
- [Filter](docs/Model/Filter.md)
- [FulfillSaleRequest](docs/Model/FulfillSaleRequest.md)
- [Fulfillment](docs/Model/Fulfillment.md)
- [FulfillmentLineItem](docs/Model/FulfillmentLineItem.md)
- [FulfillmentResponse](docs/Model/FulfillmentResponse.md)
- [FulfillmentsResponse](docs/Model/FulfillmentsResponse.md)
- [FulfilmentSummary](docs/Model/FulfilmentSummary.md)
- [FulfilmentSummaryLineItem](docs/Model/FulfilmentSummaryLineItem.md)
- [FulfilmentSummaryResponse](docs/Model/FulfilmentSummaryResponse.md)
- [GetVariantAttributes200Response](docs/Model/GetVariantAttributes200Response.md)
- [Id](docs/Model/Id.md)
- [Image](docs/Model/Image.md)
- [ImagePosition](docs/Model/ImagePosition.md)
- [ImageResponse](docs/Model/ImageResponse.md)
- [ImageSample](docs/Model/ImageSample.md)
- [Inventory](docs/Model/Inventory.md)
- [InventoryCollection](docs/Model/InventoryCollection.md)
- [InventoryCountItem](docs/Model/InventoryCountItem.md)
- [InventoryCountItemResponse](docs/Model/InventoryCountItemResponse.md)
- [InventoryLevel](docs/Model/InventoryLevel.md)
- [InventoryLevelLevels](docs/Model/InventoryLevelLevels.md)
- [InventoryLevelsCollection](docs/Model/InventoryLevelsCollection.md)
- [LineItem](docs/Model/LineItem.md)
- [LineItemTaxComponent](docs/Model/LineItemTaxComponent.md)
- [Outlet](docs/Model/Outlet.md)
- [OutletCollection](docs/Model/OutletCollection.md)
- [OutletResponse](docs/Model/OutletResponse.md)
- [OutletTax](docs/Model/OutletTax.md)
- [OutletTaxCollection](docs/Model/OutletTaxCollection.md)
- [PageInfo](docs/Model/PageInfo.md)
- [Payment](docs/Model/Payment.md)
- [PaymentType](docs/Model/PaymentType.md)
- [PaymentTypeCollection](docs/Model/PaymentTypeCollection.md)
- [PaymentTypeConfig](docs/Model/PaymentTypeConfig.md)
- [PriceBook](docs/Model/PriceBook.md)
- [PriceBookCollection](docs/Model/PriceBookCollection.md)
- [PriceBookProduct](docs/Model/PriceBookProduct.md)
- [PriceBookProductCollection](docs/Model/PriceBookProductCollection.md)
- [PriceBookProductIdCollection](docs/Model/PriceBookProductIdCollection.md)
- [PriceBookProductIdCollectionData](docs/Model/PriceBookProductIdCollectionData.md)
- [PriceBookResponse](docs/Model/PriceBookResponse.md)
- [Product](docs/Model/Product.md)
- [ProductBase](docs/Model/ProductBase.md)
- [ProductCategoryDeleteRequest](docs/Model/ProductCategoryDeleteRequest.md)
- [ProductCategoryRequest](docs/Model/ProductCategoryRequest.md)
- [ProductCategoryResponse](docs/Model/ProductCategoryResponse.md)
- [ProductCategoryResponseData](docs/Model/ProductCategoryResponseData.md)
- [ProductCategoryResponseDataData](docs/Model/ProductCategoryResponseDataData.md)
- [ProductCategoryResponsePageInfo](docs/Model/ProductCategoryResponsePageInfo.md)
- [ProductCode](docs/Model/ProductCode.md)
- [ProductCollection](docs/Model/ProductCollection.md)
- [ProductImage](docs/Model/ProductImage.md)
- [ProductInventory](docs/Model/ProductInventory.md)
- [ProductResponse](docs/Model/ProductResponse.md)
- [ProductSupplier](docs/Model/ProductSupplier.md)
- [ProductType](docs/Model/ProductType.md)
- [ProductTypeCollection](docs/Model/ProductTypeCollection.md)
- [ProductTypeResponse](docs/Model/ProductTypeResponse.md)
- [ProductTypeSample](docs/Model/ProductTypeSample.md)
- [ProductVariant](docs/Model/ProductVariant.md)
- [PromoCode](docs/Model/PromoCode.md)
- [PromoCodeValidation](docs/Model/PromoCodeValidation.md)
- [Promotion](docs/Model/Promotion.md)
- [PromotionActivePromoCodesResponse](docs/Model/PromotionActivePromoCodesResponse.md)
- [PromotionCollection](docs/Model/PromotionCollection.md)
- [PromotionDeletePromoCodesResponse](docs/Model/PromotionDeletePromoCodesResponse.md)
- [PromotionDescription](docs/Model/PromotionDescription.md)
- [PromotionPromoCodesResponse](docs/Model/PromotionPromoCodesResponse.md)
- [RateRule](docs/Model/RateRule.md)
- [Register](docs/Model/Register.md)
- [RegisterClosePaymentType](docs/Model/RegisterClosePaymentType.md)
- [RegisterCloseRequest](docs/Model/RegisterCloseRequest.md)
- [RegisterCollection](docs/Model/RegisterCollection.md)
- [RegisterOpenRequest](docs/Model/RegisterOpenRequest.md)
- [RegisterPaymentSummaryPaymentType](docs/Model/RegisterPaymentSummaryPaymentType.md)
- [RegisterPaymentsSummary](docs/Model/RegisterPaymentsSummary.md)
- [RegisterPaymentsSummaryResponse](docs/Model/RegisterPaymentsSummaryResponse.md)
- [RegisterResponse](docs/Model/RegisterResponse.md)
- [RequestCollectionResponse](docs/Model/RequestCollectionResponse.md)
- [RequestLog](docs/Model/RequestLog.md)
- [RequestSingleResponse](docs/Model/RequestSingleResponse.md)
- [Retailer](docs/Model/Retailer.md)
- [RetailerCurrency](docs/Model/RetailerCurrency.md)
- [RetailerGiftCards](docs/Model/RetailerGiftCards.md)
- [RetailerLoyalty](docs/Model/RetailerLoyalty.md)
- [RetailerResponse](docs/Model/RetailerResponse.md)
- [RetailerSkuSequence](docs/Model/RetailerSkuSequence.md)
- [Sale](docs/Model/Sale.md)
- [SaleCollection](docs/Model/SaleCollection.md)
- [SaleResponse](docs/Model/SaleResponse.md)
- [SaleTax](docs/Model/SaleTax.md)
- [SearchResponse](docs/Model/SearchResponse.md)
- [SearchResponseOneOf](docs/Model/SearchResponseOneOf.md)
- [Supplier](docs/Model/Supplier.md)
- [SupplierCollection](docs/Model/SupplierCollection.md)
- [SupplierRequest](docs/Model/SupplierRequest.md)
- [SupplierResponse](docs/Model/SupplierResponse.md)
- [Tag](docs/Model/Tag.md)
- [TagCollection](docs/Model/TagCollection.md)
- [TagResponse](docs/Model/TagResponse.md)
- [Tax](docs/Model/Tax.md)
- [TaxCollection](docs/Model/TaxCollection.md)
- [TaxRate](docs/Model/TaxRate.md)
- [User](docs/Model/User.md)
- [UserCollection](docs/Model/UserCollection.md)
- [UserImages](docs/Model/UserImages.md)
- [UserResponse](docs/Model/UserResponse.md)
- [VariantAttribute](docs/Model/VariantAttribute.md)
- [VariantDefinition](docs/Model/VariantDefinition.md)
- [VariantOption](docs/Model/VariantOption.md)
- [Version](docs/Model/Version.md)
- [Webhook](docs/Model/Webhook.md)
- [WebhookResponse](docs/Model/WebhookResponse.md)
- [WebhooksResponse](docs/Model/WebhooksResponse.md)

## Authorization

### personal_token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

api@vendhq.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `2.0`
    - Package version: `2.0`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
