<?php
/**
 * RegisterSaleUpdateBase
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * RegisterSaleUpdateBase Class Doc Comment
 *
 * @category Class
 * @description Editable attributes of the sale
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class RegisterSaleUpdateBase implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RegisterSaleUpdateBase';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'source_id' => 'string',
        'register_id' => 'string',
        'customer_id' => 'string',
        'user_id' => 'string',
        'sale_date' => 'string',
        'note' => 'string',
        'status' => 'string',
        'short_code' => 'string',
        'invoice_number' => 'string',
        'accounts_transaction_id' => 'string',
        'register_sale_products' => '\Vend09\Model\RegisterSaleProductUpdateBase[]',
        'register_sale_payments' => '\Vend09\Model\RegisterSalePaymentUpdateBase[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'source_id' => null,
        'register_id' => 'uuid',
        'customer_id' => 'uuid',
        'user_id' => 'uuid',
        'sale_date' => null,
        'note' => null,
        'status' => null,
        'short_code' => null,
        'invoice_number' => null,
        'accounts_transaction_id' => null,
        'register_sale_products' => null,
        'register_sale_payments' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'source_id' => 'source_id',
        'register_id' => 'register_id',
        'customer_id' => 'customer_id',
        'user_id' => 'user_id',
        'sale_date' => 'sale_date',
        'note' => 'note',
        'status' => 'status',
        'short_code' => 'short_code',
        'invoice_number' => 'invoice_number',
        'accounts_transaction_id' => 'accounts_transaction_id',
        'register_sale_products' => 'register_sale_products',
        'register_sale_payments' => 'register_sale_payments'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'source_id' => 'setSourceId',
        'register_id' => 'setRegisterId',
        'customer_id' => 'setCustomerId',
        'user_id' => 'setUserId',
        'sale_date' => 'setSaleDate',
        'note' => 'setNote',
        'status' => 'setStatus',
        'short_code' => 'setShortCode',
        'invoice_number' => 'setInvoiceNumber',
        'accounts_transaction_id' => 'setAccountsTransactionId',
        'register_sale_products' => 'setRegisterSaleProducts',
        'register_sale_payments' => 'setRegisterSalePayments'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'source_id' => 'getSourceId',
        'register_id' => 'getRegisterId',
        'customer_id' => 'getCustomerId',
        'user_id' => 'getUserId',
        'sale_date' => 'getSaleDate',
        'note' => 'getNote',
        'status' => 'getStatus',
        'short_code' => 'getShortCode',
        'invoice_number' => 'getInvoiceNumber',
        'accounts_transaction_id' => 'getAccountsTransactionId',
        'register_sale_products' => 'getRegisterSaleProducts',
        'register_sale_payments' => 'getRegisterSalePayments'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['register_id'] = $data['register_id'] ?? null;
        $this->container['customer_id'] = $data['customer_id'] ?? null;
        $this->container['user_id'] = $data['user_id'] ?? null;
        $this->container['sale_date'] = $data['sale_date'] ?? null;
        $this->container['note'] = $data['note'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['short_code'] = $data['short_code'] ?? null;
        $this->container['invoice_number'] = $data['invoice_number'] ?? null;
        $this->container['accounts_transaction_id'] = $data['accounts_transaction_id'] ?? null;
        $this->container['register_sale_products'] = $data['register_sale_products'] ?? null;
        $this->container['register_sale_payments'] = $data['register_sale_payments'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['user_id'] === null) {
            $invalidProperties[] = "'user_id' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id The ID of the sale on the client side or another system where the sale was originally created.
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return string|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param string|null $register_id The ID of the register where the sale was created.
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id The ID of the customer associated with this sale.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return string
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param string $user_id The ID of the user (cashier) who created the sale.
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets sale_date
     *
     * @return string|null
     */
    public function getSaleDate()
    {
        return $this->container['sale_date'];
    }

    /**
     * Sets sale_date
     *
     * @param string|null $sale_date The date of the sale. If not provided will be added as the time the sale reached the server.
     *
     * @return self
     */
    public function setSaleDate($sale_date)
    {
        $this->container['sale_date'] = $sale_date;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note A note on the sale entered by the cashier.
     *
     * @return self
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status Status of the sale. One of: `SAVED`, `CLOSED`, `ONACCOUNT`, `LAYBY`, `ONACCOUNT_CLOSED`, `LAYBY_CLOSED`, `VOIDED`.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets short_code
     *
     * @return string|null
     */
    public function getShortCode()
    {
        return $this->container['short_code'];
    }

    /**
     * Sets short_code
     *
     * @param string|null $short_code Short, unique code to be printed on the receipt for loyalty tracking purposes.
     *
     * @return self
     */
    public function setShortCode($short_code)
    {
        $this->container['short_code'] = $short_code;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number The invoice number for the sale. If left null it will be populated by Vend with the next available invoice number.
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets accounts_transaction_id
     *
     * @return string|null
     */
    public function getAccountsTransactionId()
    {
        return $this->container['accounts_transaction_id'];
    }

    /**
     * Sets accounts_transaction_id
     *
     * @param string|null $accounts_transaction_id Xero invoice reference ID. Only editable for `ONACCOUNT` sales.
     *
     * @return self
     */
    public function setAccountsTransactionId($accounts_transaction_id)
    {
        $this->container['accounts_transaction_id'] = $accounts_transaction_id;

        return $this;
    }

    /**
     * Gets register_sale_products
     *
     * @return \Vend09\Model\RegisterSaleProductUpdateBase[]|null
     */
    public function getRegisterSaleProducts()
    {
        return $this->container['register_sale_products'];
    }

    /**
     * Sets register_sale_products
     *
     * @param \Vend09\Model\RegisterSaleProductUpdateBase[]|null $register_sale_products Line items.
     *
     * @return self
     */
    public function setRegisterSaleProducts($register_sale_products)
    {
        $this->container['register_sale_products'] = $register_sale_products;

        return $this;
    }

    /**
     * Gets register_sale_payments
     *
     * @return \Vend09\Model\RegisterSalePaymentUpdateBase[]|null
     */
    public function getRegisterSalePayments()
    {
        return $this->container['register_sale_payments'];
    }

    /**
     * Sets register_sale_payments
     *
     * @param \Vend09\Model\RegisterSalePaymentUpdateBase[]|null $register_sale_payments Payments.
     *
     * @return self
     */
    public function setRegisterSalePayments($register_sale_payments)
    {
        $this->container['register_sale_payments'] = $register_sale_payments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


