<?php
/**
 * RegisterSaleProduct
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * RegisterSaleProduct Class Doc Comment
 *
 * @category Class
 * @description Register sale product object
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class RegisterSaleProduct implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RegisterSaleProduct';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'handle' => 'string',
        'sku' => 'string',
        'name' => 'string',
        'tax_name' => 'string',
        'tax_rate' => 'double',
        'tax_total' => 'double',
        'price_total' => 'double',
        'product_id' => 'string',
        'register_id' => 'string',
        'sequence' => 'int',
        'quantity' => 'double',
        'price' => 'double',
        'cost' => 'double',
        'price_set' => 'int',
        'discount' => 'int',
        'loyalty_value' => 'double',
        'tax' => 'double',
        'tax_id' => 'string',
        'status' => 'string',
        'attributes' => '\Vend09\Model\RegisterSaleProductAttribute[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'handle' => null,
        'sku' => null,
        'name' => null,
        'tax_name' => null,
        'tax_rate' => 'double',
        'tax_total' => 'double',
        'price_total' => 'double',
        'product_id' => 'uuid',
        'register_id' => 'uuid',
        'sequence' => 'int32',
        'quantity' => 'double',
        'price' => 'double',
        'cost' => 'double',
        'price_set' => 'int32',
        'discount' => 'int32',
        'loyalty_value' => 'double',
        'tax' => 'double',
        'tax_id' => 'uuid',
        'status' => null,
        'attributes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'handle' => 'handle',
        'sku' => 'sku',
        'name' => 'name',
        'tax_name' => 'tax_name',
        'tax_rate' => 'tax_rate',
        'tax_total' => 'tax_total',
        'price_total' => 'price_total',
        'product_id' => 'product_id',
        'register_id' => 'register_id',
        'sequence' => 'sequence',
        'quantity' => 'quantity',
        'price' => 'price',
        'cost' => 'cost',
        'price_set' => 'price_set',
        'discount' => 'discount',
        'loyalty_value' => 'loyalty_value',
        'tax' => 'tax',
        'tax_id' => 'tax_id',
        'status' => 'status',
        'attributes' => 'attributes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'handle' => 'setHandle',
        'sku' => 'setSku',
        'name' => 'setName',
        'tax_name' => 'setTaxName',
        'tax_rate' => 'setTaxRate',
        'tax_total' => 'setTaxTotal',
        'price_total' => 'setPriceTotal',
        'product_id' => 'setProductId',
        'register_id' => 'setRegisterId',
        'sequence' => 'setSequence',
        'quantity' => 'setQuantity',
        'price' => 'setPrice',
        'cost' => 'setCost',
        'price_set' => 'setPriceSet',
        'discount' => 'setDiscount',
        'loyalty_value' => 'setLoyaltyValue',
        'tax' => 'setTax',
        'tax_id' => 'setTaxId',
        'status' => 'setStatus',
        'attributes' => 'setAttributes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'handle' => 'getHandle',
        'sku' => 'getSku',
        'name' => 'getName',
        'tax_name' => 'getTaxName',
        'tax_rate' => 'getTaxRate',
        'tax_total' => 'getTaxTotal',
        'price_total' => 'getPriceTotal',
        'product_id' => 'getProductId',
        'register_id' => 'getRegisterId',
        'sequence' => 'getSequence',
        'quantity' => 'getQuantity',
        'price' => 'getPrice',
        'cost' => 'getCost',
        'price_set' => 'getPriceSet',
        'discount' => 'getDiscount',
        'loyalty_value' => 'getLoyaltyValue',
        'tax' => 'getTax',
        'tax_id' => 'getTaxId',
        'status' => 'getStatus',
        'attributes' => 'getAttributes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['handle'] = $data['handle'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['tax_name'] = $data['tax_name'] ?? null;
        $this->container['tax_rate'] = $data['tax_rate'] ?? null;
        $this->container['tax_total'] = $data['tax_total'] ?? null;
        $this->container['price_total'] = $data['price_total'] ?? null;
        $this->container['product_id'] = $data['product_id'] ?? null;
        $this->container['register_id'] = $data['register_id'] ?? null;
        $this->container['sequence'] = $data['sequence'] ?? null;
        $this->container['quantity'] = $data['quantity'] ?? null;
        $this->container['price'] = $data['price'] ?? null;
        $this->container['cost'] = $data['cost'] ?? null;
        $this->container['price_set'] = $data['price_set'] ?? 0;
        $this->container['discount'] = $data['discount'] ?? null;
        $this->container['loyalty_value'] = $data['loyalty_value'] ?? null;
        $this->container['tax'] = $data['tax'] ?? null;
        $this->container['tax_id'] = $data['tax_id'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['attributes'] = $data['attributes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets handle
     *
     * @return string|null
     */
    public function getHandle()
    {
        return $this->container['handle'];
    }

    /**
     * Sets handle
     *
     * @param string|null $handle The handle of the product associated with this line item.
     *
     * @return self
     */
    public function setHandle($handle)
    {
        $this->container['handle'] = $handle;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string|null
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string|null $sku The SKU of the product associated with this line item.
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name of the product associated with this line item.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets tax_name
     *
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->container['tax_name'];
    }

    /**
     * Sets tax_name
     *
     * @param string|null $tax_name The name of the tax associated with this line item.
     *
     * @return self
     */
    public function setTaxName($tax_name)
    {
        $this->container['tax_name'] = $tax_name;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return double|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param double|null $tax_rate The rate of the tax associated with this line item.
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return double|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param double|null $tax_total Total tax for this line item. (`tax * quantity`).
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets price_total
     *
     * @return double|null
     */
    public function getPriceTotal()
    {
        return $this->container['price_total'];
    }

    /**
     * Sets price_total
     *
     * @param double|null $price_total Total price for this line item. (`price * quantity`).
     *
     * @return self
     */
    public function setPriceTotal($price_total)
    {
        $this->container['price_total'] = $price_total;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return string|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param string|null $product_id The ID of the product associated with this line item.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return string|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param string|null $register_id The ID of the register which was used to add this line item to the sale.
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets sequence
     *
     * @return int|null
     */
    public function getSequence()
    {
        return $this->container['sequence'];
    }

    /**
     * Sets sequence
     *
     * @param int|null $sequence Order number of the line item.
     *
     * @return self
     */
    public function setSequence($sequence)
    {
        $this->container['sequence'] = $sequence;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return double|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param double|null $quantity Quantity of products for the line item.
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets price
     *
     * @return double|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param double|null $price Unit price of the line item.
     *
     * @return self
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return double|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param double|null $cost Unit cost of the line item
     *
     * @return self
     */
    public function setCost($cost)
    {
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets price_set
     *
     * @return int|null
     */
    public function getPriceSet()
    {
        return $this->container['price_set'];
    }

    /**
     * Sets price_set
     *
     * @param int|null $price_set Indicated whether the price was \"fixed\". If set to `\"1\"` it prevents recalculation of the total price based on the price from the database. One of `\"0\"` or `\"1\"`.
     *
     * @return self
     */
    public function setPriceSet($price_set)
    {
        $this->container['price_set'] = $price_set;

        return $this;
    }

    /**
     * Gets discount
     *
     * @return int|null
     */
    public function getDiscount()
    {
        return $this->container['discount'];
    }

    /**
     * Sets discount
     *
     * @param int|null $discount Discount value of the line item.
     *
     * @return self
     */
    public function setDiscount($discount)
    {
        $this->container['discount'] = $discount;

        return $this;
    }

    /**
     * Gets loyalty_value
     *
     * @return double|null
     */
    public function getLoyaltyValue()
    {
        return $this->container['loyalty_value'];
    }

    /**
     * Sets loyalty_value
     *
     * @param double|null $loyalty_value The value of loyalty that will be incurred by the customer for this line item.
     *
     * @return self
     */
    public function setLoyaltyValue($loyalty_value)
    {
        $this->container['loyalty_value'] = $loyalty_value;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return double|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param double|null $tax The unit tax value associated with this line item.
     *
     * @return self
     */
    public function setTax($tax)
    {
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id The ID of the tax associated with this line item.
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        $this->container['tax_id'] = $tax_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status If defined as `CONFIRMED` for pending sales, the line item will be added as **read-only**.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets attributes
     *
     * @return \Vend09\Model\RegisterSaleProductAttribute[]|null
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     *
     * @param \Vend09\Model\RegisterSaleProductAttribute[]|null $attributes Additional line item attributes.
     *
     * @return self
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


