<?php
/**
 * RegisterSale
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * RegisterSale Class Doc Comment
 *
 * @category Class
 * @description Register sale object
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class RegisterSale implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'RegisterSale';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'source' => 'string',
        'customer_name' => 'string',
        'customer' => '\Vend09\Model\Customer',
        'user_name' => 'string',
        'created_at' => 'string',
        'updated_at' => 'string',
        'total_price' => 'double',
        'total_cost' => 'double',
        'total_tax' => 'double',
        'tax_name' => 'string',
        'return_for' => 'string',
        'source_id' => 'string',
        'register_id' => 'string',
        'customer_id' => 'string',
        'user_id' => 'string',
        'sale_date' => 'string',
        'note' => 'string',
        'status' => 'string',
        'short_code' => 'string',
        'invoice_number' => 'string',
        'accounts_transaction_id' => 'string',
        'register_sale_products' => '\Vend09\Model\RegisterSaleProduct[]',
        'register_sale_payments' => '\Vend09\Model\RegisterSalePayment[]',
        'totals' => '\Vend09\Model\RegisterSaleTotals',
        'taxes' => '\Vend09\Model\RegisterSaleTax[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'source' => null,
        'customer_name' => null,
        'customer' => null,
        'user_name' => null,
        'created_at' => null,
        'updated_at' => null,
        'total_price' => 'double',
        'total_cost' => 'double',
        'total_tax' => 'double',
        'tax_name' => null,
        'return_for' => null,
        'source_id' => null,
        'register_id' => 'uuid',
        'customer_id' => 'uuid',
        'user_id' => 'uuid',
        'sale_date' => null,
        'note' => null,
        'status' => null,
        'short_code' => null,
        'invoice_number' => null,
        'accounts_transaction_id' => null,
        'register_sale_products' => null,
        'register_sale_payments' => null,
        'totals' => null,
        'taxes' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'source' => 'source',
        'customer_name' => 'customer_name',
        'customer' => 'customer',
        'user_name' => 'user_name',
        'created_at' => 'created_at',
        'updated_at' => 'updated_at',
        'total_price' => 'total_price',
        'total_cost' => 'total_cost',
        'total_tax' => 'total_tax',
        'tax_name' => 'tax_name',
        'return_for' => 'return_for',
        'source_id' => 'source_id',
        'register_id' => 'register_id',
        'customer_id' => 'customer_id',
        'user_id' => 'user_id',
        'sale_date' => 'sale_date',
        'note' => 'note',
        'status' => 'status',
        'short_code' => 'short_code',
        'invoice_number' => 'invoice_number',
        'accounts_transaction_id' => 'accounts_transaction_id',
        'register_sale_products' => 'register_sale_products',
        'register_sale_payments' => 'register_sale_payments',
        'totals' => 'totals',
        'taxes' => 'taxes'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'source' => 'setSource',
        'customer_name' => 'setCustomerName',
        'customer' => 'setCustomer',
        'user_name' => 'setUserName',
        'created_at' => 'setCreatedAt',
        'updated_at' => 'setUpdatedAt',
        'total_price' => 'setTotalPrice',
        'total_cost' => 'setTotalCost',
        'total_tax' => 'setTotalTax',
        'tax_name' => 'setTaxName',
        'return_for' => 'setReturnFor',
        'source_id' => 'setSourceId',
        'register_id' => 'setRegisterId',
        'customer_id' => 'setCustomerId',
        'user_id' => 'setUserId',
        'sale_date' => 'setSaleDate',
        'note' => 'setNote',
        'status' => 'setStatus',
        'short_code' => 'setShortCode',
        'invoice_number' => 'setInvoiceNumber',
        'accounts_transaction_id' => 'setAccountsTransactionId',
        'register_sale_products' => 'setRegisterSaleProducts',
        'register_sale_payments' => 'setRegisterSalePayments',
        'totals' => 'setTotals',
        'taxes' => 'setTaxes'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'source' => 'getSource',
        'customer_name' => 'getCustomerName',
        'customer' => 'getCustomer',
        'user_name' => 'getUserName',
        'created_at' => 'getCreatedAt',
        'updated_at' => 'getUpdatedAt',
        'total_price' => 'getTotalPrice',
        'total_cost' => 'getTotalCost',
        'total_tax' => 'getTotalTax',
        'tax_name' => 'getTaxName',
        'return_for' => 'getReturnFor',
        'source_id' => 'getSourceId',
        'register_id' => 'getRegisterId',
        'customer_id' => 'getCustomerId',
        'user_id' => 'getUserId',
        'sale_date' => 'getSaleDate',
        'note' => 'getNote',
        'status' => 'getStatus',
        'short_code' => 'getShortCode',
        'invoice_number' => 'getInvoiceNumber',
        'accounts_transaction_id' => 'getAccountsTransactionId',
        'register_sale_products' => 'getRegisterSaleProducts',
        'register_sale_payments' => 'getRegisterSalePayments',
        'totals' => 'getTotals',
        'taxes' => 'getTaxes'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['source'] = $data['source'] ?? null;
        $this->container['customer_name'] = $data['customer_name'] ?? null;
        $this->container['customer'] = $data['customer'] ?? null;
        $this->container['user_name'] = $data['user_name'] ?? null;
        $this->container['created_at'] = $data['created_at'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['total_price'] = $data['total_price'] ?? null;
        $this->container['total_cost'] = $data['total_cost'] ?? null;
        $this->container['total_tax'] = $data['total_tax'] ?? null;
        $this->container['tax_name'] = $data['tax_name'] ?? null;
        $this->container['return_for'] = $data['return_for'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['register_id'] = $data['register_id'] ?? null;
        $this->container['customer_id'] = $data['customer_id'] ?? null;
        $this->container['user_id'] = $data['user_id'] ?? null;
        $this->container['sale_date'] = $data['sale_date'] ?? null;
        $this->container['note'] = $data['note'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['short_code'] = $data['short_code'] ?? null;
        $this->container['invoice_number'] = $data['invoice_number'] ?? null;
        $this->container['accounts_transaction_id'] = $data['accounts_transaction_id'] ?? null;
        $this->container['register_sale_products'] = $data['register_sale_products'] ?? null;
        $this->container['register_sale_payments'] = $data['register_sale_payments'] ?? null;
        $this->container['totals'] = $data['totals'] ?? null;
        $this->container['taxes'] = $data['taxes'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets source
     *
     * @return string|null
     */
    public function getSource()
    {
        return $this->container['source'];
    }

    /**
     * Sets source
     *
     * @param string|null $source **internal** One of `USER` and `SHOPIFY`.
     *
     * @return self
     */
    public function setSource($source)
    {
        $this->container['source'] = $source;

        return $this;
    }

    /**
     * Gets customer_name
     *
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->container['customer_name'];
    }

    /**
     * Sets customer_name
     *
     * @param string|null $customer_name The name of the customer associated with the sale.
     *
     * @return self
     */
    public function setCustomerName($customer_name)
    {
        $this->container['customer_name'] = $customer_name;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \Vend09\Model\Customer|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \Vend09\Model\Customer|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets user_name
     *
     * @return string|null
     */
    public function getUserName()
    {
        return $this->container['user_name'];
    }

    /**
     * Sets user_name
     *
     * @param string|null $user_name The username of the user who created the sale.
     *
     * @return self
     */
    public function setUserName($user_name)
    {
        $this->container['user_name'] = $user_name;

        return $this;
    }

    /**
     * Gets created_at
     *
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->container['created_at'];
    }

    /**
     * Sets created_at
     *
     * @param string|null $created_at The date and time when the sale was created (on the server).
     *
     * @return self
     */
    public function setCreatedAt($created_at)
    {
        $this->container['created_at'] = $created_at;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at The date and time of the last update.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets total_price
     *
     * @return double|null
     */
    public function getTotalPrice()
    {
        return $this->container['total_price'];
    }

    /**
     * Sets total_price
     *
     * @param double|null $total_price Total price of the sale.
     *
     * @return self
     */
    public function setTotalPrice($total_price)
    {
        $this->container['total_price'] = $total_price;

        return $this;
    }

    /**
     * Gets total_cost
     *
     * @return double|null
     */
    public function getTotalCost()
    {
        return $this->container['total_cost'];
    }

    /**
     * Sets total_cost
     *
     * @param double|null $total_cost Total cost of the sale.
     *
     * @return self
     */
    public function setTotalCost($total_cost)
    {
        $this->container['total_cost'] = $total_cost;

        return $this;
    }

    /**
     * Gets total_tax
     *
     * @return double|null
     */
    public function getTotalTax()
    {
        return $this->container['total_tax'];
    }

    /**
     * Sets total_tax
     *
     * @param double|null $total_tax Total tax of the sale.
     *
     * @return self
     */
    public function setTotalTax($total_tax)
    {
        $this->container['total_tax'] = $total_tax;

        return $this;
    }

    /**
     * Gets tax_name
     *
     * @return string|null
     */
    public function getTaxName()
    {
        return $this->container['tax_name'];
    }

    /**
     * Sets tax_name
     *
     * @param string|null $tax_name Tax tax associated with the sale.
     *
     * @return self
     */
    public function setTaxName($tax_name)
    {
        $this->container['tax_name'] = $tax_name;

        return $this;
    }

    /**
     * Gets return_for
     *
     * @return string|null
     */
    public function getReturnFor()
    {
        return $this->container['return_for'];
    }

    /**
     * Sets return_for
     *
     * @param string|null $return_for The ID of another sale if this sale was created as a return.
     *
     * @return self
     */
    public function setReturnFor($return_for)
    {
        $this->container['return_for'] = $return_for;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id The ID of the sale on the client side or another system where the sale was originally created.
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets register_id
     *
     * @return string|null
     */
    public function getRegisterId()
    {
        return $this->container['register_id'];
    }

    /**
     * Sets register_id
     *
     * @param string|null $register_id The ID of the register where the sale was created.
     *
     * @return self
     */
    public function setRegisterId($register_id)
    {
        $this->container['register_id'] = $register_id;

        return $this;
    }

    /**
     * Gets customer_id
     *
     * @return string|null
     */
    public function getCustomerId()
    {
        return $this->container['customer_id'];
    }

    /**
     * Sets customer_id
     *
     * @param string|null $customer_id The ID of the customer associated with this sale.
     *
     * @return self
     */
    public function setCustomerId($customer_id)
    {
        $this->container['customer_id'] = $customer_id;

        return $this;
    }

    /**
     * Gets user_id
     *
     * @return string|null
     */
    public function getUserId()
    {
        return $this->container['user_id'];
    }

    /**
     * Sets user_id
     *
     * @param string|null $user_id The ID of the user (cashier) who created the sale.
     *
     * @return self
     */
    public function setUserId($user_id)
    {
        $this->container['user_id'] = $user_id;

        return $this;
    }

    /**
     * Gets sale_date
     *
     * @return string|null
     */
    public function getSaleDate()
    {
        return $this->container['sale_date'];
    }

    /**
     * Sets sale_date
     *
     * @param string|null $sale_date The date of the sale. If not provided will be added as the time the sale reached the server.
     *
     * @return self
     */
    public function setSaleDate($sale_date)
    {
        $this->container['sale_date'] = $sale_date;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note A note on the sale entered by the cashier.
     *
     * @return self
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string|null
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string|null $status Status of the sale. One of: `SAVED`, `CLOSED`, `ONACCOUNT`, `LAYBY`, `ONACCOUNT_CLOSED`, `LAYBY_CLOSED`, `VOIDED`.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets short_code
     *
     * @return string|null
     */
    public function getShortCode()
    {
        return $this->container['short_code'];
    }

    /**
     * Sets short_code
     *
     * @param string|null $short_code Short, unique code to be printed on the receipt for loyalty tracking purposes.
     *
     * @return self
     */
    public function setShortCode($short_code)
    {
        $this->container['short_code'] = $short_code;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number The invoice number for the sale. If left null it will be populated by Vend with the next available invoice number.
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets accounts_transaction_id
     *
     * @return string|null
     */
    public function getAccountsTransactionId()
    {
        return $this->container['accounts_transaction_id'];
    }

    /**
     * Sets accounts_transaction_id
     *
     * @param string|null $accounts_transaction_id Xero invoice reference ID. Only editable for `ONACCOUNT` sales.
     *
     * @return self
     */
    public function setAccountsTransactionId($accounts_transaction_id)
    {
        $this->container['accounts_transaction_id'] = $accounts_transaction_id;

        return $this;
    }

    /**
     * Gets register_sale_products
     *
     * @return \Vend09\Model\RegisterSaleProduct[]|null
     */
    public function getRegisterSaleProducts()
    {
        return $this->container['register_sale_products'];
    }

    /**
     * Sets register_sale_products
     *
     * @param \Vend09\Model\RegisterSaleProduct[]|null $register_sale_products Line items.
     *
     * @return self
     */
    public function setRegisterSaleProducts($register_sale_products)
    {
        $this->container['register_sale_products'] = $register_sale_products;

        return $this;
    }

    /**
     * Gets register_sale_payments
     *
     * @return \Vend09\Model\RegisterSalePayment[]|null
     */
    public function getRegisterSalePayments()
    {
        return $this->container['register_sale_payments'];
    }

    /**
     * Sets register_sale_payments
     *
     * @param \Vend09\Model\RegisterSalePayment[]|null $register_sale_payments Payments.
     *
     * @return self
     */
    public function setRegisterSalePayments($register_sale_payments)
    {
        $this->container['register_sale_payments'] = $register_sale_payments;

        return $this;
    }

    /**
     * Gets totals
     *
     * @return \Vend09\Model\RegisterSaleTotals|null
     */
    public function getTotals()
    {
        return $this->container['totals'];
    }

    /**
     * Sets totals
     *
     * @param \Vend09\Model\RegisterSaleTotals|null $totals totals
     *
     * @return self
     */
    public function setTotals($totals)
    {
        $this->container['totals'] = $totals;

        return $this;
    }

    /**
     * Gets taxes
     *
     * @return \Vend09\Model\RegisterSaleTax[]|null
     */
    public function getTaxes()
    {
        return $this->container['taxes'];
    }

    /**
     * Sets taxes
     *
     * @param \Vend09\Model\RegisterSaleTax[]|null $taxes Tax components for the sale.
     *
     * @return self
     */
    public function setTaxes($taxes)
    {
        $this->container['taxes'] = $taxes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


