<?php
/**
 * Register
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * Register Class Doc Comment
 *
 * @category Class
 * @description Register object
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Register implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Register';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'outlet_id' => 'string',
        'button_layout_id' => 'string',
        'print_receipt' => 'string',
        'email_receipt' => 'string',
        'ask_for_note_on_save' => 'string',
        'print_note_on_receipt' => 'string',
        'ask_for_user_on_sale' => 'string',
        'show_discounts_on_receipt' => 'string',
        'receipt_header' => 'string',
        'receipt_barcoded' => 'string',
        'receipt_footer' => 'string',
        'receipt_style_class' => 'string',
        'invoice_prefix' => 'string',
        'invoice_suffix' => 'string',
        'invoice_sequence' => 'int',
        'register_open_count_sequence' => 'string',
        'register_open_sequence_id' => 'string',
        'register_open_time' => 'string',
        'register_close_time' => 'string',
        'cash_managed_payment_type_id' => 'string',
        'is_quick_keys_enabled' => 'bool',
        'quick_key_template_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'name' => null,
        'outlet_id' => 'uuid',
        'button_layout_id' => 'uuid',
        'print_receipt' => null,
        'email_receipt' => null,
        'ask_for_note_on_save' => null,
        'print_note_on_receipt' => null,
        'ask_for_user_on_sale' => null,
        'show_discounts_on_receipt' => null,
        'receipt_header' => null,
        'receipt_barcoded' => null,
        'receipt_footer' => null,
        'receipt_style_class' => null,
        'invoice_prefix' => null,
        'invoice_suffix' => null,
        'invoice_sequence' => 'int32',
        'register_open_count_sequence' => null,
        'register_open_sequence_id' => 'uuid',
        'register_open_time' => null,
        'register_close_time' => null,
        'cash_managed_payment_type_id' => 'uuid',
        'is_quick_keys_enabled' => null,
        'quick_key_template_id' => 'uuid'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'outlet_id' => 'outlet_id',
        'button_layout_id' => 'button_layout_id',
        'print_receipt' => 'print_receipt',
        'email_receipt' => 'email_receipt',
        'ask_for_note_on_save' => 'ask_for_note_on_save',
        'print_note_on_receipt' => 'print_note_on_receipt',
        'ask_for_user_on_sale' => 'ask_for_user_on_sale',
        'show_discounts_on_receipt' => 'show_discounts_on_receipt',
        'receipt_header' => 'receipt_header',
        'receipt_barcoded' => 'receipt_barcoded',
        'receipt_footer' => 'receipt_footer',
        'receipt_style_class' => 'receipt_style_class',
        'invoice_prefix' => 'invoice_prefix',
        'invoice_suffix' => 'invoice_suffix',
        'invoice_sequence' => 'invoice_sequence',
        'register_open_count_sequence' => 'register_open_count_sequence',
        'register_open_sequence_id' => 'register_open_sequence_id',
        'register_open_time' => 'register_open_time',
        'register_close_time' => 'register_close_time',
        'cash_managed_payment_type_id' => 'cash_managed_payment_type_id',
        'is_quick_keys_enabled' => 'is_quick_keys_enabled',
        'quick_key_template_id' => 'quick_key_template_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'outlet_id' => 'setOutletId',
        'button_layout_id' => 'setButtonLayoutId',
        'print_receipt' => 'setPrintReceipt',
        'email_receipt' => 'setEmailReceipt',
        'ask_for_note_on_save' => 'setAskForNoteOnSave',
        'print_note_on_receipt' => 'setPrintNoteOnReceipt',
        'ask_for_user_on_sale' => 'setAskForUserOnSale',
        'show_discounts_on_receipt' => 'setShowDiscountsOnReceipt',
        'receipt_header' => 'setReceiptHeader',
        'receipt_barcoded' => 'setReceiptBarcoded',
        'receipt_footer' => 'setReceiptFooter',
        'receipt_style_class' => 'setReceiptStyleClass',
        'invoice_prefix' => 'setInvoicePrefix',
        'invoice_suffix' => 'setInvoiceSuffix',
        'invoice_sequence' => 'setInvoiceSequence',
        'register_open_count_sequence' => 'setRegisterOpenCountSequence',
        'register_open_sequence_id' => 'setRegisterOpenSequenceId',
        'register_open_time' => 'setRegisterOpenTime',
        'register_close_time' => 'setRegisterCloseTime',
        'cash_managed_payment_type_id' => 'setCashManagedPaymentTypeId',
        'is_quick_keys_enabled' => 'setIsQuickKeysEnabled',
        'quick_key_template_id' => 'setQuickKeyTemplateId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'outlet_id' => 'getOutletId',
        'button_layout_id' => 'getButtonLayoutId',
        'print_receipt' => 'getPrintReceipt',
        'email_receipt' => 'getEmailReceipt',
        'ask_for_note_on_save' => 'getAskForNoteOnSave',
        'print_note_on_receipt' => 'getPrintNoteOnReceipt',
        'ask_for_user_on_sale' => 'getAskForUserOnSale',
        'show_discounts_on_receipt' => 'getShowDiscountsOnReceipt',
        'receipt_header' => 'getReceiptHeader',
        'receipt_barcoded' => 'getReceiptBarcoded',
        'receipt_footer' => 'getReceiptFooter',
        'receipt_style_class' => 'getReceiptStyleClass',
        'invoice_prefix' => 'getInvoicePrefix',
        'invoice_suffix' => 'getInvoiceSuffix',
        'invoice_sequence' => 'getInvoiceSequence',
        'register_open_count_sequence' => 'getRegisterOpenCountSequence',
        'register_open_sequence_id' => 'getRegisterOpenSequenceId',
        'register_open_time' => 'getRegisterOpenTime',
        'register_close_time' => 'getRegisterCloseTime',
        'cash_managed_payment_type_id' => 'getCashManagedPaymentTypeId',
        'is_quick_keys_enabled' => 'getIsQuickKeysEnabled',
        'quick_key_template_id' => 'getQuickKeyTemplateId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['button_layout_id'] = $data['button_layout_id'] ?? null;
        $this->container['print_receipt'] = $data['print_receipt'] ?? null;
        $this->container['email_receipt'] = $data['email_receipt'] ?? null;
        $this->container['ask_for_note_on_save'] = $data['ask_for_note_on_save'] ?? null;
        $this->container['print_note_on_receipt'] = $data['print_note_on_receipt'] ?? null;
        $this->container['ask_for_user_on_sale'] = $data['ask_for_user_on_sale'] ?? null;
        $this->container['show_discounts_on_receipt'] = $data['show_discounts_on_receipt'] ?? null;
        $this->container['receipt_header'] = $data['receipt_header'] ?? null;
        $this->container['receipt_barcoded'] = $data['receipt_barcoded'] ?? null;
        $this->container['receipt_footer'] = $data['receipt_footer'] ?? null;
        $this->container['receipt_style_class'] = $data['receipt_style_class'] ?? null;
        $this->container['invoice_prefix'] = $data['invoice_prefix'] ?? null;
        $this->container['invoice_suffix'] = $data['invoice_suffix'] ?? null;
        $this->container['invoice_sequence'] = $data['invoice_sequence'] ?? null;
        $this->container['register_open_count_sequence'] = $data['register_open_count_sequence'] ?? null;
        $this->container['register_open_sequence_id'] = $data['register_open_sequence_id'] ?? null;
        $this->container['register_open_time'] = $data['register_open_time'] ?? null;
        $this->container['register_close_time'] = $data['register_close_time'] ?? null;
        $this->container['cash_managed_payment_type_id'] = $data['cash_managed_payment_type_id'] ?? null;
        $this->container['is_quick_keys_enabled'] = $data['is_quick_keys_enabled'] ?? null;
        $this->container['quick_key_template_id'] = $data['quick_key_template_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name The name of the register.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets outlet_id
     *
     * @return string|null
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string|null $outlet_id The ID of the outlet the register is associated with.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets button_layout_id
     *
     * @return string|null
     */
    public function getButtonLayoutId()
    {
        return $this->container['button_layout_id'];
    }

    /**
     * Sets button_layout_id
     *
     * @param string|null $button_layout_id **internal** The ID of the button layout associated with this register.
     *
     * @return self
     */
    public function setButtonLayoutId($button_layout_id)
    {
        $this->container['button_layout_id'] = $button_layout_id;

        return $this;
    }

    /**
     * Gets print_receipt
     *
     * @return string|null
     */
    public function getPrintReceipt()
    {
        return $this->container['print_receipt'];
    }

    /**
     * Sets print_receipt
     *
     * @param string|null $print_receipt Indicates whether the receipt will be printed after the sale is completed. `\"0\"` or `\"1\"`.
     *
     * @return self
     */
    public function setPrintReceipt($print_receipt)
    {
        $this->container['print_receipt'] = $print_receipt;

        return $this;
    }

    /**
     * Gets email_receipt
     *
     * @return string|null
     */
    public function getEmailReceipt()
    {
        return $this->container['email_receipt'];
    }

    /**
     * Sets email_receipt
     *
     * @param string|null $email_receipt Indicated whether the receipt should be emailed after the sale is completed.  `\"0\"` or `\"1\"`.
     *
     * @return self
     */
    public function setEmailReceipt($email_receipt)
    {
        $this->container['email_receipt'] = $email_receipt;

        return $this;
    }

    /**
     * Gets ask_for_note_on_save
     *
     * @return string|null
     */
    public function getAskForNoteOnSave()
    {
        return $this->container['ask_for_note_on_save'];
    }

    /**
     * Sets ask_for_note_on_save
     *
     * @param string|null $ask_for_note_on_save Indicates whether the user will be asked to enter a note when saving a sale.  `\"0\"` or `\"1\"`.
     *
     * @return self
     */
    public function setAskForNoteOnSave($ask_for_note_on_save)
    {
        $this->container['ask_for_note_on_save'] = $ask_for_note_on_save;

        return $this;
    }

    /**
     * Gets print_note_on_receipt
     *
     * @return string|null
     */
    public function getPrintNoteOnReceipt()
    {
        return $this->container['print_note_on_receipt'];
    }

    /**
     * Sets print_note_on_receipt
     *
     * @param string|null $print_note_on_receipt Indicates whether the sale note should be printed on the receipt.  `\"0\"` or `\"1\"`.
     *
     * @return self
     */
    public function setPrintNoteOnReceipt($print_note_on_receipt)
    {
        $this->container['print_note_on_receipt'] = $print_note_on_receipt;

        return $this;
    }

    /**
     * Gets ask_for_user_on_sale
     *
     * @return string|null
     */
    public function getAskForUserOnSale()
    {
        return $this->container['ask_for_user_on_sale'];
    }

    /**
     * Sets ask_for_user_on_sale
     *
     * @param string|null $ask_for_user_on_sale Indicated whether the user prompt should appear after the sale. `\"0\"` or `\"1\"`.
     *
     * @return self
     */
    public function setAskForUserOnSale($ask_for_user_on_sale)
    {
        $this->container['ask_for_user_on_sale'] = $ask_for_user_on_sale;

        return $this;
    }

    /**
     * Gets show_discounts_on_receipt
     *
     * @return string|null
     */
    public function getShowDiscountsOnReceipt()
    {
        return $this->container['show_discounts_on_receipt'];
    }

    /**
     * Sets show_discounts_on_receipt
     *
     * @param string|null $show_discounts_on_receipt Indicates whether discounts values should appear on the receipt. `\"0\"` or `\"1\"`.
     *
     * @return self
     */
    public function setShowDiscountsOnReceipt($show_discounts_on_receipt)
    {
        $this->container['show_discounts_on_receipt'] = $show_discounts_on_receipt;

        return $this;
    }

    /**
     * Gets receipt_header
     *
     * @return string|null
     */
    public function getReceiptHeader()
    {
        return $this->container['receipt_header'];
    }

    /**
     * Sets receipt_header
     *
     * @param string|null $receipt_header Content of the receipt header. May contain HTML.
     *
     * @return self
     */
    public function setReceiptHeader($receipt_header)
    {
        $this->container['receipt_header'] = $receipt_header;

        return $this;
    }

    /**
     * Gets receipt_barcoded
     *
     * @return string|null
     */
    public function getReceiptBarcoded()
    {
        return $this->container['receipt_barcoded'];
    }

    /**
     * Sets receipt_barcoded
     *
     * @param string|null $receipt_barcoded Indicates whether the barcode should be printed on the receipt. `\"0\"` or `\"1\"`.
     *
     * @return self
     */
    public function setReceiptBarcoded($receipt_barcoded)
    {
        $this->container['receipt_barcoded'] = $receipt_barcoded;

        return $this;
    }

    /**
     * Gets receipt_footer
     *
     * @return string|null
     */
    public function getReceiptFooter()
    {
        return $this->container['receipt_footer'];
    }

    /**
     * Sets receipt_footer
     *
     * @param string|null $receipt_footer Content of the receipt footer. May contain HTML.
     *
     * @return self
     */
    public function setReceiptFooter($receipt_footer)
    {
        $this->container['receipt_footer'] = $receipt_footer;

        return $this;
    }

    /**
     * Gets receipt_style_class
     *
     * @return string|null
     */
    public function getReceiptStyleClass()
    {
        return $this->container['receipt_style_class'];
    }

    /**
     * Sets receipt_style_class
     *
     * @param string|null $receipt_style_class **internal**
     *
     * @return self
     */
    public function setReceiptStyleClass($receipt_style_class)
    {
        $this->container['receipt_style_class'] = $receipt_style_class;

        return $this;
    }

    /**
     * Gets invoice_prefix
     *
     * @return string|null
     */
    public function getInvoicePrefix()
    {
        return $this->container['invoice_prefix'];
    }

    /**
     * Sets invoice_prefix
     *
     * @param string|null $invoice_prefix Text to be used as prefix of the invoice number.
     *
     * @return self
     */
    public function setInvoicePrefix($invoice_prefix)
    {
        $this->container['invoice_prefix'] = $invoice_prefix;

        return $this;
    }

    /**
     * Gets invoice_suffix
     *
     * @return string|null
     */
    public function getInvoiceSuffix()
    {
        return $this->container['invoice_suffix'];
    }

    /**
     * Sets invoice_suffix
     *
     * @param string|null $invoice_suffix Text to be used as suffix of the invoice number.
     *
     * @return self
     */
    public function setInvoiceSuffix($invoice_suffix)
    {
        $this->container['invoice_suffix'] = $invoice_suffix;

        return $this;
    }

    /**
     * Gets invoice_sequence
     *
     * @return int|null
     */
    public function getInvoiceSequence()
    {
        return $this->container['invoice_sequence'];
    }

    /**
     * Sets invoice_sequence
     *
     * @param int|null $invoice_sequence The numeric part of the last created invoice number.
     *
     * @return self
     */
    public function setInvoiceSequence($invoice_sequence)
    {
        $this->container['invoice_sequence'] = $invoice_sequence;

        return $this;
    }

    /**
     * Gets register_open_count_sequence
     *
     * @return string|null
     */
    public function getRegisterOpenCountSequence()
    {
        return $this->container['register_open_count_sequence'];
    }

    /**
     * Sets register_open_count_sequence
     *
     * @param string|null $register_open_count_sequence **internal** The number of the current register closure.
     *
     * @return self
     */
    public function setRegisterOpenCountSequence($register_open_count_sequence)
    {
        $this->container['register_open_count_sequence'] = $register_open_count_sequence;

        return $this;
    }

    /**
     * Gets register_open_sequence_id
     *
     * @return string|null
     */
    public function getRegisterOpenSequenceId()
    {
        return $this->container['register_open_sequence_id'];
    }

    /**
     * Sets register_open_sequence_id
     *
     * @param string|null $register_open_sequence_id **internal** The ID of the current register closure.
     *
     * @return self
     */
    public function setRegisterOpenSequenceId($register_open_sequence_id)
    {
        $this->container['register_open_sequence_id'] = $register_open_sequence_id;

        return $this;
    }

    /**
     * Gets register_open_time
     *
     * @return string|null
     */
    public function getRegisterOpenTime()
    {
        return $this->container['register_open_time'];
    }

    /**
     * Sets register_open_time
     *
     * @param string|null $register_open_time The time when the register was opened.
     *
     * @return self
     */
    public function setRegisterOpenTime($register_open_time)
    {
        $this->container['register_open_time'] = $register_open_time;

        return $this;
    }

    /**
     * Gets register_close_time
     *
     * @return string|null
     */
    public function getRegisterCloseTime()
    {
        return $this->container['register_close_time'];
    }

    /**
     * Sets register_close_time
     *
     * @param string|null $register_close_time Time time when the register was closed. May be blank if the register is currently open.
     *
     * @return self
     */
    public function setRegisterCloseTime($register_close_time)
    {
        $this->container['register_close_time'] = $register_close_time;

        return $this;
    }

    /**
     * Gets cash_managed_payment_type_id
     *
     * @return string|null
     */
    public function getCashManagedPaymentTypeId()
    {
        return $this->container['cash_managed_payment_type_id'];
    }

    /**
     * Sets cash_managed_payment_type_id
     *
     * @param string|null $cash_managed_payment_type_id **internal** The ID of the payment type used for cash management functionality.
     *
     * @return self
     */
    public function setCashManagedPaymentTypeId($cash_managed_payment_type_id)
    {
        $this->container['cash_managed_payment_type_id'] = $cash_managed_payment_type_id;

        return $this;
    }

    /**
     * Gets is_quick_keys_enabled
     *
     * @return bool|null
     */
    public function getIsQuickKeysEnabled()
    {
        return $this->container['is_quick_keys_enabled'];
    }

    /**
     * Sets is_quick_keys_enabled
     *
     * @param bool|null $is_quick_keys_enabled **internal** Indicated whether the register is using quick keys.
     *
     * @return self
     */
    public function setIsQuickKeysEnabled($is_quick_keys_enabled)
    {
        $this->container['is_quick_keys_enabled'] = $is_quick_keys_enabled;

        return $this;
    }

    /**
     * Gets quick_key_template_id
     *
     * @return string|null
     */
    public function getQuickKeyTemplateId()
    {
        return $this->container['quick_key_template_id'];
    }

    /**
     * Sets quick_key_template_id
     *
     * @param string|null $quick_key_template_id **internal** The ID of the quick keys template the register is using.
     *
     * @return self
     */
    public function setQuickKeyTemplateId($quick_key_template_id)
    {
        $this->container['quick_key_template_id'] = $quick_key_template_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


