<?php
/**
 * ProductUpdateBase
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * ProductUpdateBase Class Doc Comment
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class ProductUpdateBase implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'ProductUpdateBase';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'source_id' => 'string',
        'source_variant_id' => 'string',
        'handle' => 'string',
        'type' => 'string',
        'variant_option_one_name' => 'string',
        'variant_option_one_value' => 'string',
        'variant_option_two_name' => 'string',
        'variant_option_two_value' => 'string',
        'variant_option_three_name' => 'string',
        'variant_option_three_value' => 'string',
        'active' => 'string',
        'name' => 'string',
        'description' => 'string',
        'sku' => 'string',
        'tags' => 'string',
        'brand_id' => 'string',
        'brand_name' => 'string',
        'supplier_name' => 'string',
        'supplier_code' => 'string',
        'supply_price' => 'double',
        'account_code_purchase' => 'string',
        'account_code' => 'string',
        'track_inventory' => 'bool',
        'button_order' => 'int',
        'inventory' => '\Vend09\Model\InventoryRecord[]',
        'retail_price' => 'double',
        'tax_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'source_id' => null,
        'source_variant_id' => null,
        'handle' => null,
        'type' => null,
        'variant_option_one_name' => null,
        'variant_option_one_value' => null,
        'variant_option_two_name' => null,
        'variant_option_two_value' => null,
        'variant_option_three_name' => null,
        'variant_option_three_value' => null,
        'active' => null,
        'name' => null,
        'description' => null,
        'sku' => null,
        'tags' => null,
        'brand_id' => 'uuid',
        'brand_name' => null,
        'supplier_name' => null,
        'supplier_code' => null,
        'supply_price' => 'double',
        'account_code_purchase' => null,
        'account_code' => null,
        'track_inventory' => null,
        'button_order' => 'int32',
        'inventory' => null,
        'retail_price' => 'double',
        'tax_id' => 'uuid'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'source_id' => 'source_id',
        'source_variant_id' => 'source_variant_id',
        'handle' => 'handle',
        'type' => 'type',
        'variant_option_one_name' => 'variant_option_one_name',
        'variant_option_one_value' => 'variant_option_one_value',
        'variant_option_two_name' => 'variant_option_two_name',
        'variant_option_two_value' => 'variant_option_two_value',
        'variant_option_three_name' => 'variant_option_three_name',
        'variant_option_three_value' => 'variant_option_three_value',
        'active' => 'active',
        'name' => 'name',
        'description' => 'description',
        'sku' => 'sku',
        'tags' => 'tags',
        'brand_id' => 'brand_id',
        'brand_name' => 'brand_name',
        'supplier_name' => 'supplier_name',
        'supplier_code' => 'supplier_code',
        'supply_price' => 'supply_price',
        'account_code_purchase' => 'account_code_purchase',
        'account_code' => 'account_code',
        'track_inventory' => 'track_inventory',
        'button_order' => 'button_order',
        'inventory' => 'inventory',
        'retail_price' => 'retail_price',
        'tax_id' => 'tax_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'source_id' => 'setSourceId',
        'source_variant_id' => 'setSourceVariantId',
        'handle' => 'setHandle',
        'type' => 'setType',
        'variant_option_one_name' => 'setVariantOptionOneName',
        'variant_option_one_value' => 'setVariantOptionOneValue',
        'variant_option_two_name' => 'setVariantOptionTwoName',
        'variant_option_two_value' => 'setVariantOptionTwoValue',
        'variant_option_three_name' => 'setVariantOptionThreeName',
        'variant_option_three_value' => 'setVariantOptionThreeValue',
        'active' => 'setActive',
        'name' => 'setName',
        'description' => 'setDescription',
        'sku' => 'setSku',
        'tags' => 'setTags',
        'brand_id' => 'setBrandId',
        'brand_name' => 'setBrandName',
        'supplier_name' => 'setSupplierName',
        'supplier_code' => 'setSupplierCode',
        'supply_price' => 'setSupplyPrice',
        'account_code_purchase' => 'setAccountCodePurchase',
        'account_code' => 'setAccountCode',
        'track_inventory' => 'setTrackInventory',
        'button_order' => 'setButtonOrder',
        'inventory' => 'setInventory',
        'retail_price' => 'setRetailPrice',
        'tax_id' => 'setTaxId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'source_id' => 'getSourceId',
        'source_variant_id' => 'getSourceVariantId',
        'handle' => 'getHandle',
        'type' => 'getType',
        'variant_option_one_name' => 'getVariantOptionOneName',
        'variant_option_one_value' => 'getVariantOptionOneValue',
        'variant_option_two_name' => 'getVariantOptionTwoName',
        'variant_option_two_value' => 'getVariantOptionTwoValue',
        'variant_option_three_name' => 'getVariantOptionThreeName',
        'variant_option_three_value' => 'getVariantOptionThreeValue',
        'active' => 'getActive',
        'name' => 'getName',
        'description' => 'getDescription',
        'sku' => 'getSku',
        'tags' => 'getTags',
        'brand_id' => 'getBrandId',
        'brand_name' => 'getBrandName',
        'supplier_name' => 'getSupplierName',
        'supplier_code' => 'getSupplierCode',
        'supply_price' => 'getSupplyPrice',
        'account_code_purchase' => 'getAccountCodePurchase',
        'account_code' => 'getAccountCode',
        'track_inventory' => 'getTrackInventory',
        'button_order' => 'getButtonOrder',
        'inventory' => 'getInventory',
        'retail_price' => 'getRetailPrice',
        'tax_id' => 'getTaxId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }

    public const ACTIVE__0 = '0';
    public const ACTIVE__1 = '1';

    /**
     * Gets allowable values of the enum
     *
     * @return string[]
     */
    public function getActiveAllowableValues()
    {
        return [
            self::ACTIVE__0,
            self::ACTIVE__1,
        ];
    }

    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['source_id'] = $data['source_id'] ?? null;
        $this->container['source_variant_id'] = $data['source_variant_id'] ?? null;
        $this->container['handle'] = $data['handle'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['variant_option_one_name'] = $data['variant_option_one_name'] ?? null;
        $this->container['variant_option_one_value'] = $data['variant_option_one_value'] ?? null;
        $this->container['variant_option_two_name'] = $data['variant_option_two_name'] ?? null;
        $this->container['variant_option_two_value'] = $data['variant_option_two_value'] ?? null;
        $this->container['variant_option_three_name'] = $data['variant_option_three_name'] ?? null;
        $this->container['variant_option_three_value'] = $data['variant_option_three_value'] ?? null;
        $this->container['active'] = $data['active'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['description'] = $data['description'] ?? null;
        $this->container['sku'] = $data['sku'] ?? null;
        $this->container['tags'] = $data['tags'] ?? null;
        $this->container['brand_id'] = $data['brand_id'] ?? null;
        $this->container['brand_name'] = $data['brand_name'] ?? null;
        $this->container['supplier_name'] = $data['supplier_name'] ?? null;
        $this->container['supplier_code'] = $data['supplier_code'] ?? null;
        $this->container['supply_price'] = $data['supply_price'] ?? null;
        $this->container['account_code_purchase'] = $data['account_code_purchase'] ?? null;
        $this->container['account_code'] = $data['account_code'] ?? null;
        $this->container['track_inventory'] = $data['track_inventory'] ?? null;
        $this->container['button_order'] = $data['button_order'] ?? null;
        $this->container['inventory'] = $data['inventory'] ?? null;
        $this->container['retail_price'] = $data['retail_price'] ?? null;
        $this->container['tax_id'] = $data['tax_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['handle'] === null) {
            $invalidProperties[] = "'handle' can't be null";
        }
        $allowedValues = $this->getActiveAllowableValues();
        if (!is_null($this->container['active']) && !in_array($this->container['active'], $allowedValues, true)) {
            $invalidProperties[] = sprintf(
                "invalid value '%s' for 'active', must be one of '%s'",
                $this->container['active'],
                implode("', '", $allowedValues)
            );
        }

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['sku'] === null) {
            $invalidProperties[] = "'sku' can't be null";
        }
        if ($this->container['retail_price'] === null) {
            $invalidProperties[] = "'retail_price' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Existing product ID. If included in the POST request it will cause an update instead of a creating a new object.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id The ID that can be used to reference a product in another system.
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets source_variant_id
     *
     * @return string|null
     */
    public function getSourceVariantId()
    {
        return $this->container['source_variant_id'];
    }

    /**
     * Sets source_variant_id
     *
     * @param string|null $source_variant_id Reference ID to an external object. Value will be returned as `variant_source_id`.
     *
     * @return self
     */
    public function setSourceVariantId($source_variant_id)
    {
        $this->container['source_variant_id'] = $source_variant_id;

        return $this;
    }

    /**
     * Gets handle
     *
     * @return string
     */
    public function getHandle()
    {
        return $this->container['handle'];
    }

    /**
     * Sets handle
     *
     * @param string $handle The handle of the product. Creating a new product with a handle identical to one of an existing product will cause creating a variant.
     *
     * @return self
     */
    public function setHandle($handle)
    {
        $this->container['handle'] = $handle;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type The name of the product type associated with the product.
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets variant_option_one_name
     *
     * @return string|null
     */
    public function getVariantOptionOneName()
    {
        return $this->container['variant_option_one_name'];
    }

    /**
     * Sets variant_option_one_name
     *
     * @param string|null $variant_option_one_name The name of the variant option 1.
     *
     * @return self
     */
    public function setVariantOptionOneName($variant_option_one_name)
    {
        $this->container['variant_option_one_name'] = $variant_option_one_name;

        return $this;
    }

    /**
     * Gets variant_option_one_value
     *
     * @return string|null
     */
    public function getVariantOptionOneValue()
    {
        return $this->container['variant_option_one_value'];
    }

    /**
     * Sets variant_option_one_value
     *
     * @param string|null $variant_option_one_value The value of the variant option 1.
     *
     * @return self
     */
    public function setVariantOptionOneValue($variant_option_one_value)
    {
        $this->container['variant_option_one_value'] = $variant_option_one_value;

        return $this;
    }

    /**
     * Gets variant_option_two_name
     *
     * @return string|null
     */
    public function getVariantOptionTwoName()
    {
        return $this->container['variant_option_two_name'];
    }

    /**
     * Sets variant_option_two_name
     *
     * @param string|null $variant_option_two_name The name of the variant option 2.
     *
     * @return self
     */
    public function setVariantOptionTwoName($variant_option_two_name)
    {
        $this->container['variant_option_two_name'] = $variant_option_two_name;

        return $this;
    }

    /**
     * Gets variant_option_two_value
     *
     * @return string|null
     */
    public function getVariantOptionTwoValue()
    {
        return $this->container['variant_option_two_value'];
    }

    /**
     * Sets variant_option_two_value
     *
     * @param string|null $variant_option_two_value The value of the variant option 2.
     *
     * @return self
     */
    public function setVariantOptionTwoValue($variant_option_two_value)
    {
        $this->container['variant_option_two_value'] = $variant_option_two_value;

        return $this;
    }

    /**
     * Gets variant_option_three_name
     *
     * @return string|null
     */
    public function getVariantOptionThreeName()
    {
        return $this->container['variant_option_three_name'];
    }

    /**
     * Sets variant_option_three_name
     *
     * @param string|null $variant_option_three_name The name of the variant option 3.
     *
     * @return self
     */
    public function setVariantOptionThreeName($variant_option_three_name)
    {
        $this->container['variant_option_three_name'] = $variant_option_three_name;

        return $this;
    }

    /**
     * Gets variant_option_three_value
     *
     * @return string|null
     */
    public function getVariantOptionThreeValue()
    {
        return $this->container['variant_option_three_value'];
    }

    /**
     * Sets variant_option_three_value
     *
     * @param string|null $variant_option_three_value The value of the variant option 3.
     *
     * @return self
     */
    public function setVariantOptionThreeValue($variant_option_three_value)
    {
        $this->container['variant_option_three_value'] = $variant_option_three_value;

        return $this;
    }

    /**
     * Gets active
     *
     * @return string|null
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     *
     * @param string|null $active Indicates whether the product is currently active. **NOTE:** Currently has to be submitted as __\"0\"__ or __\"1\"__. Will be returned as __boolean__ value of `true` or `false`.
     *
     * @return self
     */
    public function setActive($active)
    {
        $allowedValues = $this->getActiveAllowableValues();
        if (!is_null($active) && !in_array($active, $allowedValues, true)) {
            throw new \InvalidArgumentException(
                sprintf(
                    "Invalid value '%s' for 'active', must be one of '%s'",
                    $active,
                    implode("', '", $allowedValues)
                )
            );
        }
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name of the product. Should be posted without any variant related suffixes.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     *
     * @return string|null
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     *
     * @param string|null $description The description of the product. May include HTML.
     *
     * @return self
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets sku
     *
     * @return string
     */
    public function getSku()
    {
        return $this->container['sku'];
    }

    /**
     * Sets sku
     *
     * @param string $sku The SKU of the product. Should be unique for new products.
     *
     * @return self
     */
    public function setSku($sku)
    {
        $this->container['sku'] = $sku;

        return $this;
    }

    /**
     * Gets tags
     *
     * @return string|null
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     *
     * @param string|null $tags A comma separated list of tags associated with the product.
     *
     * @return self
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets brand_id
     *
     * @return string|null
     */
    public function getBrandId()
    {
        return $this->container['brand_id'];
    }

    /**
     * Sets brand_id
     *
     * @param string|null $brand_id The ID of the brand associated with the product.
     *
     * @return self
     */
    public function setBrandId($brand_id)
    {
        $this->container['brand_id'] = $brand_id;

        return $this;
    }

    /**
     * Gets brand_name
     *
     * @return string|null
     */
    public function getBrandName()
    {
        return $this->container['brand_name'];
    }

    /**
     * Sets brand_name
     *
     * @param string|null $brand_name The name of the brand associated with the product.
     *
     * @return self
     */
    public function setBrandName($brand_name)
    {
        $this->container['brand_name'] = $brand_name;

        return $this;
    }

    /**
     * Gets supplier_name
     *
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->container['supplier_name'];
    }

    /**
     * Sets supplier_name
     *
     * @param string|null $supplier_name Product supplier's name.
     *
     * @return self
     */
    public function setSupplierName($supplier_name)
    {
        $this->container['supplier_name'] = $supplier_name;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code The code of the supplier for the product.
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets supply_price
     *
     * @return double|null
     */
    public function getSupplyPrice()
    {
        return $this->container['supply_price'];
    }

    /**
     * Sets supply_price
     *
     * @param double|null $supply_price The default cost of supply for the product.
     *
     * @return self
     */
    public function setSupplyPrice($supply_price)
    {
        $this->container['supply_price'] = $supply_price;

        return $this;
    }

    /**
     * Gets account_code_purchase
     *
     * @return string|null
     */
    public function getAccountCodePurchase()
    {
        return $this->container['account_code_purchase'];
    }

    /**
     * Sets account_code_purchase
     *
     * @param string|null $account_code_purchase Code used to associate purchase (cost) of the product with a specific account.
     *
     * @return self
     */
    public function setAccountCodePurchase($account_code_purchase)
    {
        $this->container['account_code_purchase'] = $account_code_purchase;

        return $this;
    }

    /**
     * Gets account_code
     *
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->container['account_code'];
    }

    /**
     * Sets account_code
     *
     * @param string|null $account_code Code used to associate sales of the product with a specific account. Value will be returned as `account_code_sales`.
     *
     * @return self
     */
    public function setAccountCode($account_code)
    {
        $this->container['account_code'] = $account_code;

        return $this;
    }

    /**
     * Gets track_inventory
     *
     * @return bool|null
     */
    public function getTrackInventory()
    {
        return $this->container['track_inventory'];
    }

    /**
     * Sets track_inventory
     *
     * @param bool|null $track_inventory Indicated whether the system should track inventory count for this product.
     *
     * @return self
     */
    public function setTrackInventory($track_inventory)
    {
        $this->container['track_inventory'] = $track_inventory;

        return $this;
    }

    /**
     * Gets button_order
     *
     * @return int|null
     */
    public function getButtonOrder()
    {
        return $this->container['button_order'];
    }

    /**
     * Sets button_order
     *
     * @param int|null $button_order A number describing the position of a variant in the UI.
     *
     * @return self
     */
    public function setButtonOrder($button_order)
    {
        $this->container['button_order'] = $button_order;

        return $this;
    }

    /**
     * Gets inventory
     *
     * @return \Vend09\Model\InventoryRecord[]|null
     */
    public function getInventory()
    {
        return $this->container['inventory'];
    }

    /**
     * Sets inventory
     *
     * @param \Vend09\Model\InventoryRecord[]|null $inventory A list of inventory records associated with the product.
     *
     * @return self
     */
    public function setInventory($inventory)
    {
        $this->container['inventory'] = $inventory;

        return $this;
    }

    /**
     * Gets retail_price
     *
     * @return double
     */
    public function getRetailPrice()
    {
        return $this->container['retail_price'];
    }

    /**
     * Sets retail_price
     *
     * @param double $retail_price Retail price for the product. Tax inclusive or exclusive depending on the store settings.
     *
     * @return self
     */
    public function setRetailPrice($retail_price)
    {
        $this->container['retail_price'] = $retail_price;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id ID of the tax to be used as the default for this product (for inclusive stores).
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        $this->container['tax_id'] = $tax_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


