<?php
/**
 * PriceBookEntry
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * PriceBookEntry Class Doc Comment
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class PriceBookEntry implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'PriceBookEntry';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'product_id' => 'string',
        'price_book_id' => 'string',
        'price_book_name' => 'string',
        'type' => 'string',
        'outlet_name' => 'string',
        'outlet_id' => 'string',
        'customer_group_name' => 'string',
        'customer_group_id' => 'string',
        'price' => 'double',
        'loyalty_value' => 'double',
        'tax' => 'double',
        'tax_id' => 'string',
        'tax_rate' => 'double',
        'tax_name' => 'string',
        'min_units' => 'string',
        'max_units' => 'string',
        'valid_from' => 'string',
        'valid_to' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'product_id' => 'uuid',
        'price_book_id' => 'uuid',
        'price_book_name' => null,
        'type' => null,
        'outlet_name' => null,
        'outlet_id' => 'uuid',
        'customer_group_name' => null,
        'customer_group_id' => 'uuid',
        'price' => 'double',
        'loyalty_value' => 'double',
        'tax' => 'double',
        'tax_id' => 'uuid',
        'tax_rate' => 'double',
        'tax_name' => null,
        'min_units' => null,
        'max_units' => null,
        'valid_from' => null,
        'valid_to' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'product_id' => 'product_id',
        'price_book_id' => 'price_book_id',
        'price_book_name' => 'price_book_name',
        'type' => 'type',
        'outlet_name' => 'outlet_name',
        'outlet_id' => 'outlet_id',
        'customer_group_name' => 'customer_group_name',
        'customer_group_id' => 'customer_group_id',
        'price' => 'price',
        'loyalty_value' => 'loyalty_value',
        'tax' => 'tax',
        'tax_id' => 'tax_id',
        'tax_rate' => 'tax_rate',
        'tax_name' => 'tax_name',
        'min_units' => 'min_units',
        'max_units' => 'max_units',
        'valid_from' => 'valid_from',
        'valid_to' => 'valid_to'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'product_id' => 'setProductId',
        'price_book_id' => 'setPriceBookId',
        'price_book_name' => 'setPriceBookName',
        'type' => 'setType',
        'outlet_name' => 'setOutletName',
        'outlet_id' => 'setOutletId',
        'customer_group_name' => 'setCustomerGroupName',
        'customer_group_id' => 'setCustomerGroupId',
        'price' => 'setPrice',
        'loyalty_value' => 'setLoyaltyValue',
        'tax' => 'setTax',
        'tax_id' => 'setTaxId',
        'tax_rate' => 'setTaxRate',
        'tax_name' => 'setTaxName',
        'min_units' => 'setMinUnits',
        'max_units' => 'setMaxUnits',
        'valid_from' => 'setValidFrom',
        'valid_to' => 'setValidTo'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'product_id' => 'getProductId',
        'price_book_id' => 'getPriceBookId',
        'price_book_name' => 'getPriceBookName',
        'type' => 'getType',
        'outlet_name' => 'getOutletName',
        'outlet_id' => 'getOutletId',
        'customer_group_name' => 'getCustomerGroupName',
        'customer_group_id' => 'getCustomerGroupId',
        'price' => 'getPrice',
        'loyalty_value' => 'getLoyaltyValue',
        'tax' => 'getTax',
        'tax_id' => 'getTaxId',
        'tax_rate' => 'getTaxRate',
        'tax_name' => 'getTaxName',
        'min_units' => 'getMinUnits',
        'max_units' => 'getMaxUnits',
        'valid_from' => 'getValidFrom',
        'valid_to' => 'getValidTo'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['product_id'] = $data['product_id'] ?? null;
        $this->container['price_book_id'] = $data['price_book_id'] ?? null;
        $this->container['price_book_name'] = $data['price_book_name'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['outlet_name'] = $data['outlet_name'] ?? null;
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['customer_group_name'] = $data['customer_group_name'] ?? null;
        $this->container['customer_group_id'] = $data['customer_group_id'] ?? null;
        $this->container['price'] = $data['price'] ?? null;
        $this->container['loyalty_value'] = $data['loyalty_value'] ?? null;
        $this->container['tax'] = $data['tax'] ?? null;
        $this->container['tax_id'] = $data['tax_id'] ?? null;
        $this->container['tax_rate'] = $data['tax_rate'] ?? null;
        $this->container['tax_name'] = $data['tax_name'] ?? null;
        $this->container['min_units'] = $data['min_units'] ?? null;
        $this->container['max_units'] = $data['max_units'] ?? null;
        $this->container['valid_from'] = $data['valid_from'] ?? null;
        $this->container['valid_to'] = $data['valid_to'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['tax_name'] === null) {
            $invalidProperties[] = "'tax_name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object id.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets product_id
     *
     * @return string|null
     */
    public function getProductId()
    {
        return $this->container['product_id'];
    }

    /**
     * Sets product_id
     *
     * @param string|null $product_id ID of the product associated with this record.
     *
     * @return self
     */
    public function setProductId($product_id)
    {
        $this->container['product_id'] = $product_id;

        return $this;
    }

    /**
     * Gets price_book_id
     *
     * @return string|null
     */
    public function getPriceBookId()
    {
        return $this->container['price_book_id'];
    }

    /**
     * Sets price_book_id
     *
     * @param string|null $price_book_id ID of the price book associated with this record.
     *
     * @return self
     */
    public function setPriceBookId($price_book_id)
    {
        $this->container['price_book_id'] = $price_book_id;

        return $this;
    }

    /**
     * Gets price_book_name
     *
     * @return string|null
     */
    public function getPriceBookName()
    {
        return $this->container['price_book_name'];
    }

    /**
     * Sets price_book_name
     *
     * @param string|null $price_book_name The name of the price book associated with this record.
     *
     * @return self
     */
    public function setPriceBookName($price_book_name)
    {
        $this->container['price_book_name'] = $price_book_name;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string|null
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string|null $type Product type for which this price book record should be used.
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets outlet_name
     *
     * @return string|null
     */
    public function getOutletName()
    {
        return $this->container['outlet_name'];
    }

    /**
     * Sets outlet_name
     *
     * @param string|null $outlet_name The name of the outlet for which this price book record should be used.
     *
     * @return self
     */
    public function setOutletName($outlet_name)
    {
        $this->container['outlet_name'] = $outlet_name;

        return $this;
    }

    /**
     * Gets outlet_id
     *
     * @return string|null
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string|null $outlet_id ID of the outlet for which this price book record should be used.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets customer_group_name
     *
     * @return string|null
     */
    public function getCustomerGroupName()
    {
        return $this->container['customer_group_name'];
    }

    /**
     * Sets customer_group_name
     *
     * @param string|null $customer_group_name The name of the customer group associated with this record.
     *
     * @return self
     */
    public function setCustomerGroupName($customer_group_name)
    {
        $this->container['customer_group_name'] = $customer_group_name;

        return $this;
    }

    /**
     * Gets customer_group_id
     *
     * @return string|null
     */
    public function getCustomerGroupId()
    {
        return $this->container['customer_group_id'];
    }

    /**
     * Sets customer_group_id
     *
     * @param string|null $customer_group_id The ID of the customer group associated with this record.
     *
     * @return self
     */
    public function setCustomerGroupId($customer_group_id)
    {
        $this->container['customer_group_id'] = $customer_group_id;

        return $this;
    }

    /**
     * Gets price
     *
     * @return double|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param double|null $price Tax exclusive price of the product.
     *
     * @return self
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }

    /**
     * Gets loyalty_value
     *
     * @return double|null
     */
    public function getLoyaltyValue()
    {
        return $this->container['loyalty_value'];
    }

    /**
     * Sets loyalty_value
     *
     * @param double|null $loyalty_value loyalty_value
     *
     * @return self
     */
    public function setLoyaltyValue($loyalty_value)
    {
        $this->container['loyalty_value'] = $loyalty_value;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return double|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param double|null $tax The tax value.
     *
     * @return self
     */
    public function setTax($tax)
    {
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id The ID of the tax associated with this record.
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        $this->container['tax_id'] = $tax_id;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return double|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param double|null $tax_rate The tax rate.
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets tax_name
     *
     * @return string
     */
    public function getTaxName()
    {
        return $this->container['tax_name'];
    }

    /**
     * Sets tax_name
     *
     * @param string $tax_name The name of the tax associated with this record.
     *
     * @return self
     */
    public function setTaxName($tax_name)
    {
        $this->container['tax_name'] = $tax_name;

        return $this;
    }

    /**
     * Gets min_units
     *
     * @return string|null
     */
    public function getMinUnits()
    {
        return $this->container['min_units'];
    }

    /**
     * Sets min_units
     *
     * @param string|null $min_units Minimum product quantity for which this price book entry will be used.
     *
     * @return self
     */
    public function setMinUnits($min_units)
    {
        $this->container['min_units'] = $min_units;

        return $this;
    }

    /**
     * Gets max_units
     *
     * @return string|null
     */
    public function getMaxUnits()
    {
        return $this->container['max_units'];
    }

    /**
     * Sets max_units
     *
     * @param string|null $max_units Maximum product quantity for which this price book entry will be used.
     *
     * @return self
     */
    public function setMaxUnits($max_units)
    {
        $this->container['max_units'] = $max_units;

        return $this;
    }

    /**
     * Gets valid_from
     *
     * @return string|null
     */
    public function getValidFrom()
    {
        return $this->container['valid_from'];
    }

    /**
     * Sets valid_from
     *
     * @param string|null $valid_from The staring date from which this price book entry is in effect.
     *
     * @return self
     */
    public function setValidFrom($valid_from)
    {
        $this->container['valid_from'] = $valid_from;

        return $this;
    }

    /**
     * Gets valid_to
     *
     * @return string|null
     */
    public function getValidTo()
    {
        return $this->container['valid_to'];
    }

    /**
     * Sets valid_to
     *
     * @param string|null $valid_to The end date to which this price book entry is in effect.
     *
     * @return self
     */
    public function setValidTo($valid_to)
    {
        $this->container['valid_to'] = $valid_to;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


