<?php
/**
 * Outlet
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * Outlet Class Doc Comment
 *
 * @category Class
 * @description Outlet object
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Outlet implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Outlet';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'time_zone' => 'string',
        'tax_id' => 'string',
        'contact' => '\Vend09\Model\GenericContact',
        'email' => 'string',
        'physical_address1' => 'string',
        'physical_address2' => 'string',
        'physical_suburb' => 'string',
        'physical_city' => 'string',
        'physical_postcode' => 'string',
        'physical_state' => 'string',
        'physical_country_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'name' => null,
        'time_zone' => null,
        'tax_id' => 'uuid',
        'contact' => null,
        'email' => null,
        'physical_address1' => null,
        'physical_address2' => null,
        'physical_suburb' => null,
        'physical_city' => null,
        'physical_postcode' => null,
        'physical_state' => null,
        'physical_country_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'time_zone' => 'time_zone',
        'tax_id' => 'tax_id',
        'contact' => 'contact',
        'email' => 'email',
        'physical_address1' => 'physical_address1',
        'physical_address2' => 'physical_address2',
        'physical_suburb' => 'physical_suburb',
        'physical_city' => 'physical_city',
        'physical_postcode' => 'physical_postcode',
        'physical_state' => 'physical_state',
        'physical_country_id' => 'physical_country_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'time_zone' => 'setTimeZone',
        'tax_id' => 'setTaxId',
        'contact' => 'setContact',
        'email' => 'setEmail',
        'physical_address1' => 'setPhysicalAddress1',
        'physical_address2' => 'setPhysicalAddress2',
        'physical_suburb' => 'setPhysicalSuburb',
        'physical_city' => 'setPhysicalCity',
        'physical_postcode' => 'setPhysicalPostcode',
        'physical_state' => 'setPhysicalState',
        'physical_country_id' => 'setPhysicalCountryId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'time_zone' => 'getTimeZone',
        'tax_id' => 'getTaxId',
        'contact' => 'getContact',
        'email' => 'getEmail',
        'physical_address1' => 'getPhysicalAddress1',
        'physical_address2' => 'getPhysicalAddress2',
        'physical_suburb' => 'getPhysicalSuburb',
        'physical_city' => 'getPhysicalCity',
        'physical_postcode' => 'getPhysicalPostcode',
        'physical_state' => 'getPhysicalState',
        'physical_country_id' => 'getPhysicalCountryId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['time_zone'] = $data['time_zone'] ?? null;
        $this->container['tax_id'] = $data['tax_id'] ?? null;
        $this->container['contact'] = $data['contact'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['physical_address1'] = $data['physical_address1'] ?? null;
        $this->container['physical_address2'] = $data['physical_address2'] ?? null;
        $this->container['physical_suburb'] = $data['physical_suburb'] ?? null;
        $this->container['physical_city'] = $data['physical_city'] ?? null;
        $this->container['physical_postcode'] = $data['physical_postcode'] ?? null;
        $this->container['physical_state'] = $data['physical_state'] ?? null;
        $this->container['physical_country_id'] = $data['physical_country_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Outlet name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets time_zone
     *
     * @return string|null
     */
    public function getTimeZone()
    {
        return $this->container['time_zone'];
    }

    /**
     * Sets time_zone
     *
     * @param string|null $time_zone Outlet time-zone in **tz database** format like: `Pacific/Auckland`.
     *
     * @return self
     */
    public function setTimeZone($time_zone)
    {
        $this->container['time_zone'] = $time_zone;

        return $this;
    }

    /**
     * Gets tax_id
     *
     * @return string|null
     */
    public function getTaxId()
    {
        return $this->container['tax_id'];
    }

    /**
     * Sets tax_id
     *
     * @param string|null $tax_id The ID of the default tax for the outlet.
     *
     * @return self
     */
    public function setTaxId($tax_id)
    {
        $this->container['tax_id'] = $tax_id;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \Vend09\Model\GenericContact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \Vend09\Model\GenericContact|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email Email address.
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets physical_address1
     *
     * @return string|null
     */
    public function getPhysicalAddress1()
    {
        return $this->container['physical_address1'];
    }

    /**
     * Sets physical_address1
     *
     * @param string|null $physical_address1 Address, line 1 - physical.
     *
     * @return self
     */
    public function setPhysicalAddress1($physical_address1)
    {
        $this->container['physical_address1'] = $physical_address1;

        return $this;
    }

    /**
     * Gets physical_address2
     *
     * @return string|null
     */
    public function getPhysicalAddress2()
    {
        return $this->container['physical_address2'];
    }

    /**
     * Sets physical_address2
     *
     * @param string|null $physical_address2 Address, line 2 - physical.
     *
     * @return self
     */
    public function setPhysicalAddress2($physical_address2)
    {
        $this->container['physical_address2'] = $physical_address2;

        return $this;
    }

    /**
     * Gets physical_suburb
     *
     * @return string|null
     */
    public function getPhysicalSuburb()
    {
        return $this->container['physical_suburb'];
    }

    /**
     * Sets physical_suburb
     *
     * @param string|null $physical_suburb Suburb - physical.
     *
     * @return self
     */
    public function setPhysicalSuburb($physical_suburb)
    {
        $this->container['physical_suburb'] = $physical_suburb;

        return $this;
    }

    /**
     * Gets physical_city
     *
     * @return string|null
     */
    public function getPhysicalCity()
    {
        return $this->container['physical_city'];
    }

    /**
     * Sets physical_city
     *
     * @param string|null $physical_city City - physical.
     *
     * @return self
     */
    public function setPhysicalCity($physical_city)
    {
        $this->container['physical_city'] = $physical_city;

        return $this;
    }

    /**
     * Gets physical_postcode
     *
     * @return string|null
     */
    public function getPhysicalPostcode()
    {
        return $this->container['physical_postcode'];
    }

    /**
     * Sets physical_postcode
     *
     * @param string|null $physical_postcode Post code - physical.
     *
     * @return self
     */
    public function setPhysicalPostcode($physical_postcode)
    {
        $this->container['physical_postcode'] = $physical_postcode;

        return $this;
    }

    /**
     * Gets physical_state
     *
     * @return string|null
     */
    public function getPhysicalState()
    {
        return $this->container['physical_state'];
    }

    /**
     * Sets physical_state
     *
     * @param string|null $physical_state State - physical.
     *
     * @return self
     */
    public function setPhysicalState($physical_state)
    {
        $this->container['physical_state'] = $physical_state;

        return $this;
    }

    /**
     * Gets physical_country_id
     *
     * @return string|null
     */
    public function getPhysicalCountryId()
    {
        return $this->container['physical_country_id'];
    }

    /**
     * Sets physical_country_id
     *
     * @param string|null $physical_country_id Country code - physical.
     *
     * @return self
     */
    public function setPhysicalCountryId($physical_country_id)
    {
        $this->container['physical_country_id'] = $physical_country_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


