<?php
/**
 * InventoryRecord
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * InventoryRecord Class Doc Comment
 *
 * @category Class
 * @description 
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class InventoryRecord implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'InventoryRecord';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'outlet_id' => 'string',
        'outlet_name' => 'string',
        'count' => 'int',
        'reorder_point' => 'int',
        'restock_level' => 'int'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'outlet_id' => 'uuid',
        'outlet_name' => null,
        'count' => 'int32',
        'reorder_point' => 'int32',
        'restock_level' => 'int32'
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'outlet_id' => 'outlet_id',
        'outlet_name' => 'outlet_name',
        'count' => 'count',
        'reorder_point' => 'reorder_point',
        'restock_level' => 'restock_level'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'outlet_id' => 'setOutletId',
        'outlet_name' => 'setOutletName',
        'count' => 'setCount',
        'reorder_point' => 'setReorderPoint',
        'restock_level' => 'setRestockLevel'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'outlet_id' => 'getOutletId',
        'outlet_name' => 'getOutletName',
        'count' => 'getCount',
        'reorder_point' => 'getReorderPoint',
        'restock_level' => 'getRestockLevel'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['outlet_name'] = $data['outlet_name'] ?? null;
        $this->container['count'] = $data['count'] ?? null;
        $this->container['reorder_point'] = $data['reorder_point'] ?? null;
        $this->container['restock_level'] = $data['restock_level'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['outlet_id'] === null) {
            $invalidProperties[] = "'outlet_id' can't be null";
        }
        if ($this->container['count'] === null) {
            $invalidProperties[] = "'count' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets outlet_id
     *
     * @return string
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string $outlet_id The ID of an outlet associated with this inventory record.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets outlet_name
     *
     * @return string|null
     */
    public function getOutletName()
    {
        return $this->container['outlet_name'];
    }

    /**
     * Sets outlet_name
     *
     * @param string|null $outlet_name The name of the outlet.
     *
     * @return self
     */
    public function setOutletName($outlet_name)
    {
        $this->container['outlet_name'] = $outlet_name;

        return $this;
    }

    /**
     * Gets count
     *
     * @return int
     */
    public function getCount()
    {
        return $this->container['count'];
    }

    /**
     * Sets count
     *
     * @param int $count Current stock quantity of the product at the given outlet.
     *
     * @return self
     */
    public function setCount($count)
    {
        $this->container['count'] = $count;

        return $this;
    }

    /**
     * Gets reorder_point
     *
     * @return int|null
     */
    public function getReorderPoint()
    {
        return $this->container['reorder_point'];
    }

    /**
     * Sets reorder_point
     *
     * @param int|null $reorder_point Quantity below which the product should be included in the auto-filled stock orders.
     *
     * @return self
     */
    public function setReorderPoint($reorder_point)
    {
        $this->container['reorder_point'] = $reorder_point;

        return $this;
    }

    /**
     * Gets restock_level
     *
     * @return int|null
     */
    public function getRestockLevel()
    {
        return $this->container['restock_level'];
    }

    /**
     * Sets restock_level
     *
     * @param int|null $restock_level The default of the quantity for auto-filled stock orders
     *
     * @return self
     */
    public function setRestockLevel($restock_level)
    {
        $this->container['restock_level'] = $restock_level;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


