<?php
/**
 * Customer
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * Customer Class Doc Comment
 *
 * @category Class
 * @description Customer object
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Customer implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Customer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'name' => 'string',
        'customer_group_name' => 'string',
        'loyalty_balance' => 'string',
        'updated_at' => 'string',
        'deleted_at' => 'string',
        'balance' => 'string',
        'year_to_date' => 'string',
        'contact' => '\Vend09\Model\CustomerContact',
        'customer_code' => 'string',
        'customer_group_id' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'company_name' => 'string',
        'phone' => 'string',
        'mobile' => 'string',
        'fax' => 'string',
        'email' => 'string',
        'twitter' => 'string',
        'website' => 'string',
        'physical_address1' => 'string',
        'physical_address2' => 'string',
        'physical_suburb' => 'string',
        'physical_city' => 'string',
        'physical_postcode' => 'string',
        'physical_state' => 'string',
        'physical_country_id' => 'string',
        'postal_address1' => 'string',
        'postal_address2' => 'string',
        'postal_suburb' => 'string',
        'postal_city' => 'string',
        'postal_postcode' => 'string',
        'postal_state' => 'string',
        'postal_country_id' => 'string',
        'enable_loyalty' => 'int',
        'date_of_birth' => 'string',
        'sex' => 'string',
        'custom_field_1' => 'string',
        'custom_field_2' => 'string',
        'custom_field_3' => 'string',
        'custom_field_4' => 'string',
        'note' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => 'uuid',
        'name' => null,
        'customer_group_name' => null,
        'loyalty_balance' => null,
        'updated_at' => null,
        'deleted_at' => null,
        'balance' => null,
        'year_to_date' => null,
        'contact' => null,
        'customer_code' => null,
        'customer_group_id' => 'uuid',
        'first_name' => null,
        'last_name' => null,
        'company_name' => null,
        'phone' => null,
        'mobile' => null,
        'fax' => null,
        'email' => null,
        'twitter' => null,
        'website' => null,
        'physical_address1' => null,
        'physical_address2' => null,
        'physical_suburb' => null,
        'physical_city' => null,
        'physical_postcode' => null,
        'physical_state' => null,
        'physical_country_id' => null,
        'postal_address1' => null,
        'postal_address2' => null,
        'postal_suburb' => null,
        'postal_city' => null,
        'postal_postcode' => null,
        'postal_state' => null,
        'postal_country_id' => null,
        'enable_loyalty' => 'int32',
        'date_of_birth' => null,
        'sex' => null,
        'custom_field_1' => null,
        'custom_field_2' => null,
        'custom_field_3' => null,
        'custom_field_4' => null,
        'note' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'name' => 'name',
        'customer_group_name' => 'customer_group_name',
        'loyalty_balance' => 'loyalty_balance',
        'updated_at' => 'updated_at',
        'deleted_at' => 'deleted_at',
        'balance' => 'balance',
        'year_to_date' => 'year_to_date',
        'contact' => 'contact',
        'customer_code' => 'customer_code',
        'customer_group_id' => 'customer_group_id',
        'first_name' => 'first_name',
        'last_name' => 'last_name',
        'company_name' => 'company_name',
        'phone' => 'phone',
        'mobile' => 'mobile',
        'fax' => 'fax',
        'email' => 'email',
        'twitter' => 'twitter',
        'website' => 'website',
        'physical_address1' => 'physical_address1',
        'physical_address2' => 'physical_address2',
        'physical_suburb' => 'physical_suburb',
        'physical_city' => 'physical_city',
        'physical_postcode' => 'physical_postcode',
        'physical_state' => 'physical_state',
        'physical_country_id' => 'physical_country_id',
        'postal_address1' => 'postal_address1',
        'postal_address2' => 'postal_address2',
        'postal_suburb' => 'postal_suburb',
        'postal_city' => 'postal_city',
        'postal_postcode' => 'postal_postcode',
        'postal_state' => 'postal_state',
        'postal_country_id' => 'postal_country_id',
        'enable_loyalty' => 'enable_loyalty',
        'date_of_birth' => 'date_of_birth',
        'sex' => 'sex',
        'custom_field_1' => 'custom_field_1',
        'custom_field_2' => 'custom_field_2',
        'custom_field_3' => 'custom_field_3',
        'custom_field_4' => 'custom_field_4',
        'note' => 'note'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'name' => 'setName',
        'customer_group_name' => 'setCustomerGroupName',
        'loyalty_balance' => 'setLoyaltyBalance',
        'updated_at' => 'setUpdatedAt',
        'deleted_at' => 'setDeletedAt',
        'balance' => 'setBalance',
        'year_to_date' => 'setYearToDate',
        'contact' => 'setContact',
        'customer_code' => 'setCustomerCode',
        'customer_group_id' => 'setCustomerGroupId',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'company_name' => 'setCompanyName',
        'phone' => 'setPhone',
        'mobile' => 'setMobile',
        'fax' => 'setFax',
        'email' => 'setEmail',
        'twitter' => 'setTwitter',
        'website' => 'setWebsite',
        'physical_address1' => 'setPhysicalAddress1',
        'physical_address2' => 'setPhysicalAddress2',
        'physical_suburb' => 'setPhysicalSuburb',
        'physical_city' => 'setPhysicalCity',
        'physical_postcode' => 'setPhysicalPostcode',
        'physical_state' => 'setPhysicalState',
        'physical_country_id' => 'setPhysicalCountryId',
        'postal_address1' => 'setPostalAddress1',
        'postal_address2' => 'setPostalAddress2',
        'postal_suburb' => 'setPostalSuburb',
        'postal_city' => 'setPostalCity',
        'postal_postcode' => 'setPostalPostcode',
        'postal_state' => 'setPostalState',
        'postal_country_id' => 'setPostalCountryId',
        'enable_loyalty' => 'setEnableLoyalty',
        'date_of_birth' => 'setDateOfBirth',
        'sex' => 'setSex',
        'custom_field_1' => 'setCustomField1',
        'custom_field_2' => 'setCustomField2',
        'custom_field_3' => 'setCustomField3',
        'custom_field_4' => 'setCustomField4',
        'note' => 'setNote'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'name' => 'getName',
        'customer_group_name' => 'getCustomerGroupName',
        'loyalty_balance' => 'getLoyaltyBalance',
        'updated_at' => 'getUpdatedAt',
        'deleted_at' => 'getDeletedAt',
        'balance' => 'getBalance',
        'year_to_date' => 'getYearToDate',
        'contact' => 'getContact',
        'customer_code' => 'getCustomerCode',
        'customer_group_id' => 'getCustomerGroupId',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'company_name' => 'getCompanyName',
        'phone' => 'getPhone',
        'mobile' => 'getMobile',
        'fax' => 'getFax',
        'email' => 'getEmail',
        'twitter' => 'getTwitter',
        'website' => 'getWebsite',
        'physical_address1' => 'getPhysicalAddress1',
        'physical_address2' => 'getPhysicalAddress2',
        'physical_suburb' => 'getPhysicalSuburb',
        'physical_city' => 'getPhysicalCity',
        'physical_postcode' => 'getPhysicalPostcode',
        'physical_state' => 'getPhysicalState',
        'physical_country_id' => 'getPhysicalCountryId',
        'postal_address1' => 'getPostalAddress1',
        'postal_address2' => 'getPostalAddress2',
        'postal_suburb' => 'getPostalSuburb',
        'postal_city' => 'getPostalCity',
        'postal_postcode' => 'getPostalPostcode',
        'postal_state' => 'getPostalState',
        'postal_country_id' => 'getPostalCountryId',
        'enable_loyalty' => 'getEnableLoyalty',
        'date_of_birth' => 'getDateOfBirth',
        'sex' => 'getSex',
        'custom_field_1' => 'getCustomField1',
        'custom_field_2' => 'getCustomField2',
        'custom_field_3' => 'getCustomField3',
        'custom_field_4' => 'getCustomField4',
        'note' => 'getNote'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['customer_group_name'] = $data['customer_group_name'] ?? null;
        $this->container['loyalty_balance'] = $data['loyalty_balance'] ?? null;
        $this->container['updated_at'] = $data['updated_at'] ?? null;
        $this->container['deleted_at'] = $data['deleted_at'] ?? null;
        $this->container['balance'] = $data['balance'] ?? null;
        $this->container['year_to_date'] = $data['year_to_date'] ?? null;
        $this->container['contact'] = $data['contact'] ?? null;
        $this->container['customer_code'] = $data['customer_code'] ?? null;
        $this->container['customer_group_id'] = $data['customer_group_id'] ?? null;
        $this->container['first_name'] = $data['first_name'] ?? null;
        $this->container['last_name'] = $data['last_name'] ?? null;
        $this->container['company_name'] = $data['company_name'] ?? null;
        $this->container['phone'] = $data['phone'] ?? null;
        $this->container['mobile'] = $data['mobile'] ?? null;
        $this->container['fax'] = $data['fax'] ?? null;
        $this->container['email'] = $data['email'] ?? null;
        $this->container['twitter'] = $data['twitter'] ?? null;
        $this->container['website'] = $data['website'] ?? null;
        $this->container['physical_address1'] = $data['physical_address1'] ?? null;
        $this->container['physical_address2'] = $data['physical_address2'] ?? null;
        $this->container['physical_suburb'] = $data['physical_suburb'] ?? null;
        $this->container['physical_city'] = $data['physical_city'] ?? null;
        $this->container['physical_postcode'] = $data['physical_postcode'] ?? null;
        $this->container['physical_state'] = $data['physical_state'] ?? null;
        $this->container['physical_country_id'] = $data['physical_country_id'] ?? null;
        $this->container['postal_address1'] = $data['postal_address1'] ?? null;
        $this->container['postal_address2'] = $data['postal_address2'] ?? null;
        $this->container['postal_suburb'] = $data['postal_suburb'] ?? null;
        $this->container['postal_city'] = $data['postal_city'] ?? null;
        $this->container['postal_postcode'] = $data['postal_postcode'] ?? null;
        $this->container['postal_state'] = $data['postal_state'] ?? null;
        $this->container['postal_country_id'] = $data['postal_country_id'] ?? null;
        $this->container['enable_loyalty'] = $data['enable_loyalty'] ?? null;
        $this->container['date_of_birth'] = $data['date_of_birth'] ?? null;
        $this->container['sex'] = $data['sex'] ?? null;
        $this->container['custom_field_1'] = $data['custom_field_1'] ?? null;
        $this->container['custom_field_2'] = $data['custom_field_2'] ?? null;
        $this->container['custom_field_3'] = $data['custom_field_3'] ?? null;
        $this->container['custom_field_4'] = $data['custom_field_4'] ?? null;
        $this->container['note'] = $data['note'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['first_name'] === null) {
            $invalidProperties[] = "'first_name' can't be null";
        }
        if ($this->container['last_name'] === null) {
            $invalidProperties[] = "'last_name' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID.
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string|null
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string|null $name Full customer name. Modified via first name and last name.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets customer_group_name
     *
     * @return string|null
     */
    public function getCustomerGroupName()
    {
        return $this->container['customer_group_name'];
    }

    /**
     * Sets customer_group_name
     *
     * @param string|null $customer_group_name The name of the customer group this customer is associated with.
     *
     * @return self
     */
    public function setCustomerGroupName($customer_group_name)
    {
        $this->container['customer_group_name'] = $customer_group_name;

        return $this;
    }

    /**
     * Gets loyalty_balance
     *
     * @return string|null
     */
    public function getLoyaltyBalance()
    {
        return $this->container['loyalty_balance'];
    }

    /**
     * Sets loyalty_balance
     *
     * @param string|null $loyalty_balance Customer's current loyalty balance.
     *
     * @return self
     */
    public function setLoyaltyBalance($loyalty_balance)
    {
        $this->container['loyalty_balance'] = $loyalty_balance;

        return $this;
    }

    /**
     * Gets updated_at
     *
     * @return string|null
     */
    public function getUpdatedAt()
    {
        return $this->container['updated_at'];
    }

    /**
     * Sets updated_at
     *
     * @param string|null $updated_at Last update timestamp.
     *
     * @return self
     */
    public function setUpdatedAt($updated_at)
    {
        $this->container['updated_at'] = $updated_at;

        return $this;
    }

    /**
     * Gets deleted_at
     *
     * @return string|null
     */
    public function getDeletedAt()
    {
        return $this->container['deleted_at'];
    }

    /**
     * Sets deleted_at
     *
     * @param string|null $deleted_at Deletion timestamp.
     *
     * @return self
     */
    public function setDeletedAt($deleted_at)
    {
        $this->container['deleted_at'] = $deleted_at;

        return $this;
    }

    /**
     * Gets balance
     *
     * @return string|null
     */
    public function getBalance()
    {
        return $this->container['balance'];
    }

    /**
     * Sets balance
     *
     * @param string|null $balance Customer's owing balance.
     *
     * @return self
     */
    public function setBalance($balance)
    {
        $this->container['balance'] = $balance;

        return $this;
    }

    /**
     * Gets year_to_date
     *
     * @return string|null
     */
    public function getYearToDate()
    {
        return $this->container['year_to_date'];
    }

    /**
     * Sets year_to_date
     *
     * @param string|null $year_to_date Customer's total spending this year.
     *
     * @return self
     */
    public function setYearToDate($year_to_date)
    {
        $this->container['year_to_date'] = $year_to_date;

        return $this;
    }

    /**
     * Gets contact
     *
     * @return \Vend09\Model\CustomerContact|null
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     *
     * @param \Vend09\Model\CustomerContact|null $contact contact
     *
     * @return self
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets customer_code
     *
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->container['customer_code'];
    }

    /**
     * Sets customer_code
     *
     * @param string|null $customer_code Short, unique customer code.
     *
     * @return self
     */
    public function setCustomerCode($customer_code)
    {
        $this->container['customer_code'] = $customer_code;

        return $this;
    }

    /**
     * Gets customer_group_id
     *
     * @return string|null
     */
    public function getCustomerGroupId()
    {
        return $this->container['customer_group_id'];
    }

    /**
     * Sets customer_group_id
     *
     * @param string|null $customer_group_id The ID of the customer group this customer is associated with.
     *
     * @return self
     */
    public function setCustomerGroupId($customer_group_id)
    {
        $this->container['customer_group_id'] = $customer_group_id;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string $first_name Customer's first name.
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string $last_name Customer's last name.
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets company_name
     *
     * @return string|null
     */
    public function getCompanyName()
    {
        return $this->container['company_name'];
    }

    /**
     * Sets company_name
     *
     * @param string|null $company_name Customer's company name.
     *
     * @return self
     */
    public function setCompanyName($company_name)
    {
        $this->container['company_name'] = $company_name;

        return $this;
    }

    /**
     * Gets phone
     *
     * @return string|null
     */
    public function getPhone()
    {
        return $this->container['phone'];
    }

    /**
     * Sets phone
     *
     * @param string|null $phone Customer's phone number.
     *
     * @return self
     */
    public function setPhone($phone)
    {
        $this->container['phone'] = $phone;

        return $this;
    }

    /**
     * Gets mobile
     *
     * @return string|null
     */
    public function getMobile()
    {
        return $this->container['mobile'];
    }

    /**
     * Sets mobile
     *
     * @param string|null $mobile Customer's mobile phone number.
     *
     * @return self
     */
    public function setMobile($mobile)
    {
        $this->container['mobile'] = $mobile;

        return $this;
    }

    /**
     * Gets fax
     *
     * @return string|null
     */
    public function getFax()
    {
        return $this->container['fax'];
    }

    /**
     * Sets fax
     *
     * @param string|null $fax Customer's fax number.
     *
     * @return self
     */
    public function setFax($fax)
    {
        $this->container['fax'] = $fax;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email Customer's email address.
     *
     * @return self
     */
    public function setEmail($email)
    {
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets twitter
     *
     * @return string|null
     */
    public function getTwitter()
    {
        return $this->container['twitter'];
    }

    /**
     * Sets twitter
     *
     * @param string|null $twitter Twitter handle.
     *
     * @return self
     */
    public function setTwitter($twitter)
    {
        $this->container['twitter'] = $twitter;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string|null $website Website URL.
     *
     * @return self
     */
    public function setWebsite($website)
    {
        $this->container['website'] = $website;

        return $this;
    }

    /**
     * Gets physical_address1
     *
     * @return string|null
     */
    public function getPhysicalAddress1()
    {
        return $this->container['physical_address1'];
    }

    /**
     * Sets physical_address1
     *
     * @param string|null $physical_address1 Address, line 1 - physical.
     *
     * @return self
     */
    public function setPhysicalAddress1($physical_address1)
    {
        $this->container['physical_address1'] = $physical_address1;

        return $this;
    }

    /**
     * Gets physical_address2
     *
     * @return string|null
     */
    public function getPhysicalAddress2()
    {
        return $this->container['physical_address2'];
    }

    /**
     * Sets physical_address2
     *
     * @param string|null $physical_address2 Address, line 2 - physical.
     *
     * @return self
     */
    public function setPhysicalAddress2($physical_address2)
    {
        $this->container['physical_address2'] = $physical_address2;

        return $this;
    }

    /**
     * Gets physical_suburb
     *
     * @return string|null
     */
    public function getPhysicalSuburb()
    {
        return $this->container['physical_suburb'];
    }

    /**
     * Sets physical_suburb
     *
     * @param string|null $physical_suburb Suburb - physical.
     *
     * @return self
     */
    public function setPhysicalSuburb($physical_suburb)
    {
        $this->container['physical_suburb'] = $physical_suburb;

        return $this;
    }

    /**
     * Gets physical_city
     *
     * @return string|null
     */
    public function getPhysicalCity()
    {
        return $this->container['physical_city'];
    }

    /**
     * Sets physical_city
     *
     * @param string|null $physical_city City - physical.
     *
     * @return self
     */
    public function setPhysicalCity($physical_city)
    {
        $this->container['physical_city'] = $physical_city;

        return $this;
    }

    /**
     * Gets physical_postcode
     *
     * @return string|null
     */
    public function getPhysicalPostcode()
    {
        return $this->container['physical_postcode'];
    }

    /**
     * Sets physical_postcode
     *
     * @param string|null $physical_postcode Post code - physical.
     *
     * @return self
     */
    public function setPhysicalPostcode($physical_postcode)
    {
        $this->container['physical_postcode'] = $physical_postcode;

        return $this;
    }

    /**
     * Gets physical_state
     *
     * @return string|null
     */
    public function getPhysicalState()
    {
        return $this->container['physical_state'];
    }

    /**
     * Sets physical_state
     *
     * @param string|null $physical_state State - physical.
     *
     * @return self
     */
    public function setPhysicalState($physical_state)
    {
        $this->container['physical_state'] = $physical_state;

        return $this;
    }

    /**
     * Gets physical_country_id
     *
     * @return string|null
     */
    public function getPhysicalCountryId()
    {
        return $this->container['physical_country_id'];
    }

    /**
     * Sets physical_country_id
     *
     * @param string|null $physical_country_id Country code - physical.
     *
     * @return self
     */
    public function setPhysicalCountryId($physical_country_id)
    {
        $this->container['physical_country_id'] = $physical_country_id;

        return $this;
    }

    /**
     * Gets postal_address1
     *
     * @return string|null
     */
    public function getPostalAddress1()
    {
        return $this->container['postal_address1'];
    }

    /**
     * Sets postal_address1
     *
     * @param string|null $postal_address1 Address, line 1 - postal.
     *
     * @return self
     */
    public function setPostalAddress1($postal_address1)
    {
        $this->container['postal_address1'] = $postal_address1;

        return $this;
    }

    /**
     * Gets postal_address2
     *
     * @return string|null
     */
    public function getPostalAddress2()
    {
        return $this->container['postal_address2'];
    }

    /**
     * Sets postal_address2
     *
     * @param string|null $postal_address2 Address, line 2 - postal.
     *
     * @return self
     */
    public function setPostalAddress2($postal_address2)
    {
        $this->container['postal_address2'] = $postal_address2;

        return $this;
    }

    /**
     * Gets postal_suburb
     *
     * @return string|null
     */
    public function getPostalSuburb()
    {
        return $this->container['postal_suburb'];
    }

    /**
     * Sets postal_suburb
     *
     * @param string|null $postal_suburb Suburb - postal.
     *
     * @return self
     */
    public function setPostalSuburb($postal_suburb)
    {
        $this->container['postal_suburb'] = $postal_suburb;

        return $this;
    }

    /**
     * Gets postal_city
     *
     * @return string|null
     */
    public function getPostalCity()
    {
        return $this->container['postal_city'];
    }

    /**
     * Sets postal_city
     *
     * @param string|null $postal_city City - postal.
     *
     * @return self
     */
    public function setPostalCity($postal_city)
    {
        $this->container['postal_city'] = $postal_city;

        return $this;
    }

    /**
     * Gets postal_postcode
     *
     * @return string|null
     */
    public function getPostalPostcode()
    {
        return $this->container['postal_postcode'];
    }

    /**
     * Sets postal_postcode
     *
     * @param string|null $postal_postcode Post code - postal.
     *
     * @return self
     */
    public function setPostalPostcode($postal_postcode)
    {
        $this->container['postal_postcode'] = $postal_postcode;

        return $this;
    }

    /**
     * Gets postal_state
     *
     * @return string|null
     */
    public function getPostalState()
    {
        return $this->container['postal_state'];
    }

    /**
     * Sets postal_state
     *
     * @param string|null $postal_state State - postal.
     *
     * @return self
     */
    public function setPostalState($postal_state)
    {
        $this->container['postal_state'] = $postal_state;

        return $this;
    }

    /**
     * Gets postal_country_id
     *
     * @return string|null
     */
    public function getPostalCountryId()
    {
        return $this->container['postal_country_id'];
    }

    /**
     * Sets postal_country_id
     *
     * @param string|null $postal_country_id Country code - postal.
     *
     * @return self
     */
    public function setPostalCountryId($postal_country_id)
    {
        $this->container['postal_country_id'] = $postal_country_id;

        return $this;
    }

    /**
     * Gets enable_loyalty
     *
     * @return int|null
     */
    public function getEnableLoyalty()
    {
        return $this->container['enable_loyalty'];
    }

    /**
     * Sets enable_loyalty
     *
     * @param int|null $enable_loyalty Indicates whether customer's purchases should incur loyalty. `0` or `1`.
     *
     * @return self
     */
    public function setEnableLoyalty($enable_loyalty)
    {
        $this->container['enable_loyalty'] = $enable_loyalty;

        return $this;
    }

    /**
     * Gets date_of_birth
     *
     * @return string|null
     */
    public function getDateOfBirth()
    {
        return $this->container['date_of_birth'];
    }

    /**
     * Sets date_of_birth
     *
     * @param string|null $date_of_birth Customer's date of birth.
     *
     * @return self
     */
    public function setDateOfBirth($date_of_birth)
    {
        $this->container['date_of_birth'] = $date_of_birth;

        return $this;
    }

    /**
     * Gets sex
     *
     * @return string|null
     */
    public function getSex()
    {
        return $this->container['sex'];
    }

    /**
     * Sets sex
     *
     * @param string|null $sex Customer's gender.
     *
     * @return self
     */
    public function setSex($sex)
    {
        $this->container['sex'] = $sex;

        return $this;
    }

    /**
     * Gets custom_field_1
     *
     * @return string|null
     */
    public function getCustomField1()
    {
        return $this->container['custom_field_1'];
    }

    /**
     * Sets custom_field_1
     *
     * @param string|null $custom_field_1 Custom field 1, able to store any data as a string.
     *
     * @return self
     */
    public function setCustomField1($custom_field_1)
    {
        $this->container['custom_field_1'] = $custom_field_1;

        return $this;
    }

    /**
     * Gets custom_field_2
     *
     * @return string|null
     */
    public function getCustomField2()
    {
        return $this->container['custom_field_2'];
    }

    /**
     * Sets custom_field_2
     *
     * @param string|null $custom_field_2 Custom field 2, able to store any data as a string.
     *
     * @return self
     */
    public function setCustomField2($custom_field_2)
    {
        $this->container['custom_field_2'] = $custom_field_2;

        return $this;
    }

    /**
     * Gets custom_field_3
     *
     * @return string|null
     */
    public function getCustomField3()
    {
        return $this->container['custom_field_3'];
    }

    /**
     * Sets custom_field_3
     *
     * @param string|null $custom_field_3 Custom field 3, able to store any data as a string.
     *
     * @return self
     */
    public function setCustomField3($custom_field_3)
    {
        $this->container['custom_field_3'] = $custom_field_3;

        return $this;
    }

    /**
     * Gets custom_field_4
     *
     * @return string|null
     */
    public function getCustomField4()
    {
        return $this->container['custom_field_4'];
    }

    /**
     * Sets custom_field_4
     *
     * @param string|null $custom_field_4 Custom field 4, able to store any data as a string.
     *
     * @return self
     */
    public function setCustomField4($custom_field_4)
    {
        $this->container['custom_field_4'] = $custom_field_4;

        return $this;
    }

    /**
     * Gets note
     *
     * @return string|null
     */
    public function getNote()
    {
        return $this->container['note'];
    }

    /**
     * Sets note
     *
     * @param string|null $note Customer related notes.
     *
     * @return self
     */
    public function setNote($note)
    {
        $this->container['note'] = $note;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


