<?php
/**
 * Consignment
 *
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Model;

use \ArrayAccess;
use \Vend09\ObjectSerializer;

/**
 * Consignment Class Doc Comment
 *
 * @category Class
 * @description Consignment object
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null
 */
class Consignment implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'Consignment';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'id' => 'string',
        'retailer_id' => 'string',
        'name' => 'string',
        'consignment_date' => 'string',
        'due_at' => 'string',
        'received_at' => 'string',
        'outlet_id' => 'string',
        'supplier_id' => 'string',
        'source_outlet_id' => 'string',
        'status' => 'string',
        'type' => 'string',
        'accounts_transaction_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'id' => null,
        'retailer_id' => null,
        'name' => null,
        'consignment_date' => null,
        'due_at' => null,
        'received_at' => null,
        'outlet_id' => 'uuid',
        'supplier_id' => 'uuid',
        'source_outlet_id' => 'uuid',
        'status' => null,
        'type' => null,
        'accounts_transaction_id' => null
    ];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'id' => 'id',
        'retailer_id' => 'retailer_id',
        'name' => 'name',
        'consignment_date' => 'consignment_date',
        'due_at' => 'due_at',
        'received_at' => 'received_at',
        'outlet_id' => 'outlet_id',
        'supplier_id' => 'supplier_id',
        'source_outlet_id' => 'source_outlet_id',
        'status' => 'status',
        'type' => 'type',
        'accounts_transaction_id' => 'accounts_transaction_id'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'id' => 'setId',
        'retailer_id' => 'setRetailerId',
        'name' => 'setName',
        'consignment_date' => 'setConsignmentDate',
        'due_at' => 'setDueAt',
        'received_at' => 'setReceivedAt',
        'outlet_id' => 'setOutletId',
        'supplier_id' => 'setSupplierId',
        'source_outlet_id' => 'setSourceOutletId',
        'status' => 'setStatus',
        'type' => 'setType',
        'accounts_transaction_id' => 'setAccountsTransactionId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'id' => 'getId',
        'retailer_id' => 'getRetailerId',
        'name' => 'getName',
        'consignment_date' => 'getConsignmentDate',
        'due_at' => 'getDueAt',
        'received_at' => 'getReceivedAt',
        'outlet_id' => 'getOutletId',
        'supplier_id' => 'getSupplierId',
        'source_outlet_id' => 'getSourceOutletId',
        'status' => 'getStatus',
        'type' => 'getType',
        'accounts_transaction_id' => 'getAccountsTransactionId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = $data['id'] ?? null;
        $this->container['retailer_id'] = $data['retailer_id'] ?? null;
        $this->container['name'] = $data['name'] ?? null;
        $this->container['consignment_date'] = $data['consignment_date'] ?? null;
        $this->container['due_at'] = $data['due_at'] ?? null;
        $this->container['received_at'] = $data['received_at'] ?? null;
        $this->container['outlet_id'] = $data['outlet_id'] ?? null;
        $this->container['supplier_id'] = $data['supplier_id'] ?? null;
        $this->container['source_outlet_id'] = $data['source_outlet_id'] ?? null;
        $this->container['status'] = $data['status'] ?? null;
        $this->container['type'] = $data['type'] ?? null;
        $this->container['accounts_transaction_id'] = $data['accounts_transaction_id'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if ($this->container['name'] === null) {
            $invalidProperties[] = "'name' can't be null";
        }
        if ($this->container['outlet_id'] === null) {
            $invalidProperties[] = "'outlet_id' can't be null";
        }
        if ($this->container['status'] === null) {
            $invalidProperties[] = "'status' can't be null";
        }
        if ($this->container['type'] === null) {
            $invalidProperties[] = "'type' can't be null";
        }
        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets id
     *
     * @return string|null
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     *
     * @param string|null $id Auto-generated object ID
     *
     * @return self
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets retailer_id
     *
     * @return string|null
     */
    public function getRetailerId()
    {
        return $this->container['retailer_id'];
    }

    /**
     * Sets retailer_id
     *
     * @param string|null $retailer_id The ID of the retailer associated with this consignment.
     *
     * @return self
     */
    public function setRetailerId($retailer_id)
    {
        $this->container['retailer_id'] = $retailer_id;

        return $this;
    }

    /**
     * Gets name
     *
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     *
     * @param string $name The name of the consignment.
     *
     * @return self
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets consignment_date
     *
     * @return string|null
     */
    public function getConsignmentDate()
    {
        return $this->container['consignment_date'];
    }

    /**
     * Sets consignment_date
     *
     * @param string|null $consignment_date The date when the consignment was created.
     *
     * @return self
     */
    public function setConsignmentDate($consignment_date)
    {
        $this->container['consignment_date'] = $consignment_date;

        return $this;
    }

    /**
     * Gets due_at
     *
     * @return string|null
     */
    public function getDueAt()
    {
        return $this->container['due_at'];
    }

    /**
     * Sets due_at
     *
     * @param string|null $due_at The due date for the consignment.
     *
     * @return self
     */
    public function setDueAt($due_at)
    {
        $this->container['due_at'] = $due_at;

        return $this;
    }

    /**
     * Gets received_at
     *
     * @return string|null
     */
    public function getReceivedAt()
    {
        return $this->container['received_at'];
    }

    /**
     * Sets received_at
     *
     * @param string|null $received_at The date when the consignment was received.
     *
     * @return self
     */
    public function setReceivedAt($received_at)
    {
        $this->container['received_at'] = $received_at;

        return $this;
    }

    /**
     * Gets outlet_id
     *
     * @return string
     */
    public function getOutletId()
    {
        return $this->container['outlet_id'];
    }

    /**
     * Sets outlet_id
     *
     * @param string $outlet_id The ID of the outlet to which the goods are coming.
     *
     * @return self
     */
    public function setOutletId($outlet_id)
    {
        $this->container['outlet_id'] = $outlet_id;

        return $this;
    }

    /**
     * Gets supplier_id
     *
     * @return string|null
     */
    public function getSupplierId()
    {
        return $this->container['supplier_id'];
    }

    /**
     * Sets supplier_id
     *
     * @param string|null $supplier_id The ID of the supplier associated with this consignment.
     *
     * @return self
     */
    public function setSupplierId($supplier_id)
    {
        $this->container['supplier_id'] = $supplier_id;

        return $this;
    }

    /**
     * Gets source_outlet_id
     *
     * @return string|null
     */
    public function getSourceOutletId()
    {
        return $this->container['source_outlet_id'];
    }

    /**
     * Sets source_outlet_id
     *
     * @param string|null $source_outlet_id The ID of the outlet from which the goods are coming. Only used for stock transfers.
     *
     * @return self
     */
    public function setSourceOutletId($source_outlet_id)
    {
        $this->container['source_outlet_id'] = $source_outlet_id;

        return $this;
    }

    /**
     * Gets status
     *
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     *
     * @param string $status Status of the consignment. One of: `OPEN`, `SENT`, `RECEIVED`, `CANCELLED`,  `STOCKTAKE`, `STOCKTAKE_COMPLETE`.
     *
     * @return self
     */
    public function setStatus($status)
    {
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets type
     *
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     *
     * @param string $type The type of the consignment. One of:  `SUPPLIER`, `OUTLET`, `STOCKTAKE`.
     *
     * @return self
     */
    public function setType($type)
    {
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets accounts_transaction_id
     *
     * @return string|null
     */
    public function getAccountsTransactionId()
    {
        return $this->container['accounts_transaction_id'];
    }

    /**
     * Sets accounts_transaction_id
     *
     * @param string|null $accounts_transaction_id The ID of a transaction in an external system associated with this consignment.
     *
     * @return self
     */
    public function setAccountsTransactionId($accounts_transaction_id)
    {
        $this->container['accounts_transaction_id'] = $accounts_transaction_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


