<?php
/**
 * RegisterSalesApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Vend09\ApiException;
use Vend09\Configuration;
use Vend09\HeaderSelector;
use Vend09\ObjectSerializer;

/**
 * RegisterSalesApi Class Doc Comment
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class RegisterSalesApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createUpdateRegisterSale
     *
     * Create or update a register sale
     *
     * @param  \Vend09\Model\RegisterSaleUpdateBase $register_sale New or updated register sale object. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend09\Model\RegisterSaleResponse
     */
    public function createUpdateRegisterSale($register_sale)
    {
        list($response) = $this->createUpdateRegisterSaleWithHttpInfo($register_sale);
        return $response;
    }

    /**
     * Operation createUpdateRegisterSaleWithHttpInfo
     *
     * Create or update a register sale
     *
     * @param  \Vend09\Model\RegisterSaleUpdateBase $register_sale New or updated register sale object. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend09\Model\RegisterSaleResponse, HTTP status code, HTTP response headers (array of strings)
     */
    public function createUpdateRegisterSaleWithHttpInfo($register_sale)
    {
        $request = $this->createUpdateRegisterSaleRequest($register_sale);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend09\Model\RegisterSaleResponse' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend09\Model\RegisterSaleResponse' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend09\Model\RegisterSaleResponse', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend09\Model\RegisterSaleResponse';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend09\Model\RegisterSaleResponse',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation createUpdateRegisterSaleAsync
     *
     * Create or update a register sale
     *
     * @param  \Vend09\Model\RegisterSaleUpdateBase $register_sale New or updated register sale object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUpdateRegisterSaleAsync($register_sale)
    {
        return $this->createUpdateRegisterSaleAsyncWithHttpInfo($register_sale)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createUpdateRegisterSaleAsyncWithHttpInfo
     *
     * Create or update a register sale
     *
     * @param  \Vend09\Model\RegisterSaleUpdateBase $register_sale New or updated register sale object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createUpdateRegisterSaleAsyncWithHttpInfo($register_sale)
    {
        $returnType = '\Vend09\Model\RegisterSaleResponse';
        $request = $this->createUpdateRegisterSaleRequest($register_sale);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createUpdateRegisterSale'
     *
     * @param  \Vend09\Model\RegisterSaleUpdateBase $register_sale New or updated register sale object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createUpdateRegisterSaleRequest($register_sale)
    {
        // verify the required parameter 'register_sale' is set
        if ($register_sale === null || (is_array($register_sale) && count($register_sale) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $register_sale when calling createUpdateRegisterSale'
            );
        }

        $resourcePath = '/register_sales';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($register_sale)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($register_sale));
            } else {
                $httpBody = $register_sale;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getRegisterSaleByID
     *
     * Get a single register sale by ID
     *
     * @param  string $sale_id An ID of an existing sale (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend09\Model\RegisterSaleCollection
     */
    public function getRegisterSaleByID($sale_id)
    {
        list($response) = $this->getRegisterSaleByIDWithHttpInfo($sale_id);
        return $response;
    }

    /**
     * Operation getRegisterSaleByIDWithHttpInfo
     *
     * Get a single register sale by ID
     *
     * @param  string $sale_id An ID of an existing sale (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend09\Model\RegisterSaleCollection, HTTP status code, HTTP response headers (array of strings)
     */
    public function getRegisterSaleByIDWithHttpInfo($sale_id)
    {
        $request = $this->getRegisterSaleByIDRequest($sale_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend09\Model\RegisterSaleCollection' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend09\Model\RegisterSaleCollection' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend09\Model\RegisterSaleCollection', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend09\Model\RegisterSaleCollection';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend09\Model\RegisterSaleCollection',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getRegisterSaleByIDAsync
     *
     * Get a single register sale by ID
     *
     * @param  string $sale_id An ID of an existing sale (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRegisterSaleByIDAsync($sale_id)
    {
        return $this->getRegisterSaleByIDAsyncWithHttpInfo($sale_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getRegisterSaleByIDAsyncWithHttpInfo
     *
     * Get a single register sale by ID
     *
     * @param  string $sale_id An ID of an existing sale (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getRegisterSaleByIDAsyncWithHttpInfo($sale_id)
    {
        $returnType = '\Vend09\Model\RegisterSaleCollection';
        $request = $this->getRegisterSaleByIDRequest($sale_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getRegisterSaleByID'
     *
     * @param  string $sale_id An ID of an existing sale (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getRegisterSaleByIDRequest($sale_id)
    {
        // verify the required parameter 'sale_id' is set
        if ($sale_id === null || (is_array($sale_id) && count($sale_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $sale_id when calling getRegisterSaleByID'
            );
        }

        $resourcePath = '/register_sales/{sale_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($sale_id !== null) {
            $resourcePath = str_replace(
                '{' . 'sale_id' . '}',
                ObjectSerializer::toPathValue($sale_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listRegisterSales
     *
     * List register sales
     *
     * @param  \DateTime $since If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. (optional)
     * @param  string $outlet_id If included, returns only register sales made for the given outlet, identified by ID. (optional)
     * @param  string $status If included, returns only register sales in the given state. The status[] parameter may be used more than once; returned sales will be in any of the specified states. (optional)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend09\Model\RegisterSaleCollection
     */
    public function listRegisterSales($since = null, $outlet_id = null, $status = null, $page = null, $page_size = null)
    {
        list($response) = $this->listRegisterSalesWithHttpInfo($since, $outlet_id, $status, $page, $page_size);
        return $response;
    }

    /**
     * Operation listRegisterSalesWithHttpInfo
     *
     * List register sales
     *
     * @param  \DateTime $since If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. (optional)
     * @param  string $outlet_id If included, returns only register sales made for the given outlet, identified by ID. (optional)
     * @param  string $status If included, returns only register sales in the given state. The status[] parameter may be used more than once; returned sales will be in any of the specified states. (optional)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend09\Model\RegisterSaleCollection, HTTP status code, HTTP response headers (array of strings)
     */
    public function listRegisterSalesWithHttpInfo($since = null, $outlet_id = null, $status = null, $page = null, $page_size = null)
    {
        $request = $this->listRegisterSalesRequest($since, $outlet_id, $status, $page, $page_size);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend09\Model\RegisterSaleCollection' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend09\Model\RegisterSaleCollection' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend09\Model\RegisterSaleCollection', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend09\Model\RegisterSaleCollection';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend09\Model\RegisterSaleCollection',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listRegisterSalesAsync
     *
     * List register sales
     *
     * @param  \DateTime $since If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. (optional)
     * @param  string $outlet_id If included, returns only register sales made for the given outlet, identified by ID. (optional)
     * @param  string $status If included, returns only register sales in the given state. The status[] parameter may be used more than once; returned sales will be in any of the specified states. (optional)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listRegisterSalesAsync($since = null, $outlet_id = null, $status = null, $page = null, $page_size = null)
    {
        return $this->listRegisterSalesAsyncWithHttpInfo($since, $outlet_id, $status, $page, $page_size)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listRegisterSalesAsyncWithHttpInfo
     *
     * List register sales
     *
     * @param  \DateTime $since If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. (optional)
     * @param  string $outlet_id If included, returns only register sales made for the given outlet, identified by ID. (optional)
     * @param  string $status If included, returns only register sales in the given state. The status[] parameter may be used more than once; returned sales will be in any of the specified states. (optional)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listRegisterSalesAsyncWithHttpInfo($since = null, $outlet_id = null, $status = null, $page = null, $page_size = null)
    {
        $returnType = '\Vend09\Model\RegisterSaleCollection';
        $request = $this->listRegisterSalesRequest($since, $outlet_id, $status, $page, $page_size);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listRegisterSales'
     *
     * @param  \DateTime $since If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. (optional)
     * @param  string $outlet_id If included, returns only register sales made for the given outlet, identified by ID. (optional)
     * @param  string $status If included, returns only register sales in the given state. The status[] parameter may be used more than once; returned sales will be in any of the specified states. (optional)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listRegisterSalesRequest($since = null, $outlet_id = null, $status = null, $page = null, $page_size = null)
    {

        $resourcePath = '/register_sales';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $since,
            'since', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $outlet_id,
            'outlet_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $status,
            'status[]', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
