<?php
/**
 * ConsignmentProductsApi
 * PHP version 7.4
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * API 0.9
 *
 * The current state of the original Vend API.
 *
 * The version of the OpenAPI document: 0.9
 * Contact: api@vendhq.com
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 6.0.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Vend09\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Vend09\ApiException;
use Vend09\Configuration;
use Vend09\HeaderSelector;
use Vend09\ObjectSerializer;

/**
 * ConsignmentProductsApi Class Doc Comment
 *
 * @category Class
 * @package  Vend09
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class ConsignmentProductsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ClientInterface $client = null,
        Configuration $config = null,
        HeaderSelector $selector = null,
        $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: new Configuration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation deleteConsignmentProduct
     *
     * Delete a consignment product
     *
     * @param  string $consignment_product_id The ID of the consignment product to be deleted. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return void
     */
    public function deleteConsignmentProduct($consignment_product_id)
    {
        $this->deleteConsignmentProductWithHttpInfo($consignment_product_id);
    }

    /**
     * Operation deleteConsignmentProductWithHttpInfo
     *
     * Delete a consignment product
     *
     * @param  string $consignment_product_id The ID of the consignment product to be deleted. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of null, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteConsignmentProductWithHttpInfo($consignment_product_id)
    {
        $request = $this->deleteConsignmentProductRequest($consignment_product_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return [null, $statusCode, $response->getHeaders()];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
            }
            throw $e;
        }
    }

    /**
     * Operation deleteConsignmentProductAsync
     *
     * Delete a consignment product
     *
     * @param  string $consignment_product_id The ID of the consignment product to be deleted. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteConsignmentProductAsync($consignment_product_id)
    {
        return $this->deleteConsignmentProductAsyncWithHttpInfo($consignment_product_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteConsignmentProductAsyncWithHttpInfo
     *
     * Delete a consignment product
     *
     * @param  string $consignment_product_id The ID of the consignment product to be deleted. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteConsignmentProductAsyncWithHttpInfo($consignment_product_id)
    {
        $returnType = '';
        $request = $this->deleteConsignmentProductRequest($consignment_product_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    return [null, $response->getStatusCode(), $response->getHeaders()];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteConsignmentProduct'
     *
     * @param  string $consignment_product_id The ID of the consignment product to be deleted. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteConsignmentProductRequest($consignment_product_id)
    {
        // verify the required parameter 'consignment_product_id' is set
        if ($consignment_product_id === null || (is_array($consignment_product_id) && count($consignment_product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_product_id when calling deleteConsignmentProduct'
            );
        }

        $resourcePath = '/consignment_product/{consignment_product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_product_id' . '}',
                ObjectSerializer::toPathValue($consignment_product_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                []
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                [],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getConsignmentProductByID
     *
     * Get a single consignment product by ID
     *
     * @param  string $consignment_product_id The ID of the consignment to get. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend09\Model\Consignment
     */
    public function getConsignmentProductByID($consignment_product_id)
    {
        list($response) = $this->getConsignmentProductByIDWithHttpInfo($consignment_product_id);
        return $response;
    }

    /**
     * Operation getConsignmentProductByIDWithHttpInfo
     *
     * Get a single consignment product by ID
     *
     * @param  string $consignment_product_id The ID of the consignment to get. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend09\Model\Consignment, HTTP status code, HTTP response headers (array of strings)
     */
    public function getConsignmentProductByIDWithHttpInfo($consignment_product_id)
    {
        $request = $this->getConsignmentProductByIDRequest($consignment_product_id);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend09\Model\Consignment' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend09\Model\Consignment' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend09\Model\Consignment', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend09\Model\Consignment';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend09\Model\Consignment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation getConsignmentProductByIDAsync
     *
     * Get a single consignment product by ID
     *
     * @param  string $consignment_product_id The ID of the consignment to get. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getConsignmentProductByIDAsync($consignment_product_id)
    {
        return $this->getConsignmentProductByIDAsyncWithHttpInfo($consignment_product_id)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getConsignmentProductByIDAsyncWithHttpInfo
     *
     * Get a single consignment product by ID
     *
     * @param  string $consignment_product_id The ID of the consignment to get. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getConsignmentProductByIDAsyncWithHttpInfo($consignment_product_id)
    {
        $returnType = '\Vend09\Model\Consignment';
        $request = $this->getConsignmentProductByIDRequest($consignment_product_id);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getConsignmentProductByID'
     *
     * @param  string $consignment_product_id The ID of the consignment to get. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getConsignmentProductByIDRequest($consignment_product_id)
    {
        // verify the required parameter 'consignment_product_id' is set
        if ($consignment_product_id === null || (is_array($consignment_product_id) && count($consignment_product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_product_id when calling getConsignmentProductByID'
            );
        }

        $resourcePath = '/consignment_product/{consignment_product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_product_id' . '}',
                ObjectSerializer::toPathValue($consignment_product_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation listConsignmentProducts
     *
     * List consignment products
     *
     * @param  string $consignment_id The ID of a consignment to filter the items for. Shouldn&#39;t be used together with the &#x60;product_id&#x60; parameter. (required)
     * @param  string $product_id The ID of a product to filter the items for. Shouldn&#39;t be used together with the &#x60;consignment_id&#x60; parameter. (required)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend09\Model\ConsignmentProductCollection
     */
    public function listConsignmentProducts($consignment_id, $product_id, $page = null, $page_size = null)
    {
        list($response) = $this->listConsignmentProductsWithHttpInfo($consignment_id, $product_id, $page, $page_size);
        return $response;
    }

    /**
     * Operation listConsignmentProductsWithHttpInfo
     *
     * List consignment products
     *
     * @param  string $consignment_id The ID of a consignment to filter the items for. Shouldn&#39;t be used together with the &#x60;product_id&#x60; parameter. (required)
     * @param  string $product_id The ID of a product to filter the items for. Shouldn&#39;t be used together with the &#x60;consignment_id&#x60; parameter. (required)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend09\Model\ConsignmentProductCollection, HTTP status code, HTTP response headers (array of strings)
     */
    public function listConsignmentProductsWithHttpInfo($consignment_id, $product_id, $page = null, $page_size = null)
    {
        $request = $this->listConsignmentProductsRequest($consignment_id, $product_id, $page, $page_size);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend09\Model\ConsignmentProductCollection' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend09\Model\ConsignmentProductCollection' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend09\Model\ConsignmentProductCollection', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend09\Model\ConsignmentProductCollection';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend09\Model\ConsignmentProductCollection',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation listConsignmentProductsAsync
     *
     * List consignment products
     *
     * @param  string $consignment_id The ID of a consignment to filter the items for. Shouldn&#39;t be used together with the &#x60;product_id&#x60; parameter. (required)
     * @param  string $product_id The ID of a product to filter the items for. Shouldn&#39;t be used together with the &#x60;consignment_id&#x60; parameter. (required)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listConsignmentProductsAsync($consignment_id, $product_id, $page = null, $page_size = null)
    {
        return $this->listConsignmentProductsAsyncWithHttpInfo($consignment_id, $product_id, $page, $page_size)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation listConsignmentProductsAsyncWithHttpInfo
     *
     * List consignment products
     *
     * @param  string $consignment_id The ID of a consignment to filter the items for. Shouldn&#39;t be used together with the &#x60;product_id&#x60; parameter. (required)
     * @param  string $product_id The ID of a product to filter the items for. Shouldn&#39;t be used together with the &#x60;consignment_id&#x60; parameter. (required)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function listConsignmentProductsAsyncWithHttpInfo($consignment_id, $product_id, $page = null, $page_size = null)
    {
        $returnType = '\Vend09\Model\ConsignmentProductCollection';
        $request = $this->listConsignmentProductsRequest($consignment_id, $product_id, $page, $page_size);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'listConsignmentProducts'
     *
     * @param  string $consignment_id The ID of a consignment to filter the items for. Shouldn&#39;t be used together with the &#x60;product_id&#x60; parameter. (required)
     * @param  string $product_id The ID of a product to filter the items for. Shouldn&#39;t be used together with the &#x60;consignment_id&#x60; parameter. (required)
     * @param  float $page The number of the page of results to be returned. (optional)
     * @param  float $page_size The size of the page of results to be returned. (optional)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function listConsignmentProductsRequest($consignment_id, $product_id, $page = null, $page_size = null)
    {
        // verify the required parameter 'consignment_id' is set
        if ($consignment_id === null || (is_array($consignment_id) && count($consignment_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_id when calling listConsignmentProducts'
            );
        }
        // verify the required parameter 'product_id' is set
        if ($product_id === null || (is_array($product_id) && count($product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $product_id when calling listConsignmentProducts'
            );
        }

        $resourcePath = '/consignment_product';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $consignment_id,
            'consignment_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $product_id,
            'product_id', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            true // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page,
            'page', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'page_size', // param base name
            'number', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                []
            );
        }

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation newConsignmentProduct
     *
     * Create a consignment product
     *
     * @param  \Vend09\Model\ConsignmentProductBase $body New consignment product object. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend09\Model\ConsignmentProduct
     */
    public function newConsignmentProduct($body)
    {
        list($response) = $this->newConsignmentProductWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation newConsignmentProductWithHttpInfo
     *
     * Create a consignment product
     *
     * @param  \Vend09\Model\ConsignmentProductBase $body New consignment product object. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend09\Model\ConsignmentProduct, HTTP status code, HTTP response headers (array of strings)
     */
    public function newConsignmentProductWithHttpInfo($body)
    {
        $request = $this->newConsignmentProductRequest($body);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend09\Model\ConsignmentProduct' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend09\Model\ConsignmentProduct' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend09\Model\ConsignmentProduct', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend09\Model\ConsignmentProduct';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend09\Model\ConsignmentProduct',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation newConsignmentProductAsync
     *
     * Create a consignment product
     *
     * @param  \Vend09\Model\ConsignmentProductBase $body New consignment product object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function newConsignmentProductAsync($body)
    {
        return $this->newConsignmentProductAsyncWithHttpInfo($body)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation newConsignmentProductAsyncWithHttpInfo
     *
     * Create a consignment product
     *
     * @param  \Vend09\Model\ConsignmentProductBase $body New consignment product object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function newConsignmentProductAsyncWithHttpInfo($body)
    {
        $returnType = '\Vend09\Model\ConsignmentProduct';
        $request = $this->newConsignmentProductRequest($body);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'newConsignmentProduct'
     *
     * @param  \Vend09\Model\ConsignmentProductBase $body New consignment product object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function newConsignmentProductRequest($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null || (is_array($body) && count($body) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $body when calling newConsignmentProduct'
            );
        }

        $resourcePath = '/consignment_product';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;





        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($body)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateConsignmentProduct
     *
     * Update a consignment product
     *
     * @param  string $consignment_product_id The ID of the consignment to be updated. (required)
     * @param  \Vend09\Model\ConsignmentProductBase $consignment A new or updated consignment object. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return \Vend09\Model\ConsignmentProduct
     */
    public function updateConsignmentProduct($consignment_product_id, $consignment)
    {
        list($response) = $this->updateConsignmentProductWithHttpInfo($consignment_product_id, $consignment);
        return $response;
    }

    /**
     * Operation updateConsignmentProductWithHttpInfo
     *
     * Update a consignment product
     *
     * @param  string $consignment_product_id The ID of the consignment to be updated. (required)
     * @param  \Vend09\Model\ConsignmentProductBase $consignment A new or updated consignment object. (required)
     *
     * @throws \Vend09\ApiException on non-2xx response
     * @throws \InvalidArgumentException
     * @return array of \Vend09\Model\ConsignmentProduct, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateConsignmentProductWithHttpInfo($consignment_product_id, $consignment)
    {
        $request = $this->updateConsignmentProductRequest($consignment_product_id, $consignment);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            switch($statusCode) {
                case 200:
                    if ('\Vend09\Model\ConsignmentProduct' === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ('\Vend09\Model\ConsignmentProduct' !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, '\Vend09\Model\ConsignmentProduct', []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
            }

            $returnType = '\Vend09\Model\ConsignmentProduct';
            if ($returnType === '\SplFileObject') {
                $content = $response->getBody(); //stream goes to serializer
            } else {
                $content = (string) $response->getBody();
                if ($returnType !== 'string') {
                    $content = json_decode($content);
                }
            }

            return [
                ObjectSerializer::deserialize($content, $returnType, []),
                $response->getStatusCode(),
                $response->getHeaders()
            ];

        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Vend09\Model\ConsignmentProduct',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    break;
            }
            throw $e;
        }
    }

    /**
     * Operation updateConsignmentProductAsync
     *
     * Update a consignment product
     *
     * @param  string $consignment_product_id The ID of the consignment to be updated. (required)
     * @param  \Vend09\Model\ConsignmentProductBase $consignment A new or updated consignment object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateConsignmentProductAsync($consignment_product_id, $consignment)
    {
        return $this->updateConsignmentProductAsyncWithHttpInfo($consignment_product_id, $consignment)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateConsignmentProductAsyncWithHttpInfo
     *
     * Update a consignment product
     *
     * @param  string $consignment_product_id The ID of the consignment to be updated. (required)
     * @param  \Vend09\Model\ConsignmentProductBase $consignment A new or updated consignment object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateConsignmentProductAsyncWithHttpInfo($consignment_product_id, $consignment)
    {
        $returnType = '\Vend09\Model\ConsignmentProduct';
        $request = $this->updateConsignmentProductRequest($consignment_product_id, $consignment);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateConsignmentProduct'
     *
     * @param  string $consignment_product_id The ID of the consignment to be updated. (required)
     * @param  \Vend09\Model\ConsignmentProductBase $consignment A new or updated consignment object. (required)
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateConsignmentProductRequest($consignment_product_id, $consignment)
    {
        // verify the required parameter 'consignment_product_id' is set
        if ($consignment_product_id === null || (is_array($consignment_product_id) && count($consignment_product_id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment_product_id when calling updateConsignmentProduct'
            );
        }
        // verify the required parameter 'consignment' is set
        if ($consignment === null || (is_array($consignment) && count($consignment) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $consignment when calling updateConsignmentProduct'
            );
        }

        $resourcePath = '/consignment_product/{consignment_product_id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($consignment_product_id !== null) {
            $resourcePath = str_replace(
                '{' . 'consignment_product_id' . '}',
                ObjectSerializer::toPathValue($consignment_product_id),
                $resourcePath
            );
        }


        if ($multipart) {
            $headers = $this->headerSelector->selectHeadersForMultipart(
                ['application/json']
            );
        } else {
            $headers = $this->headerSelector->selectHeaders(
                ['application/json'],
                ['application/json']
            );
        }

        // for model (json/xml)
        if (isset($consignment)) {
            if ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode(ObjectSerializer::sanitizeForSerialization($consignment));
            } else {
                $httpBody = $consignment;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif ($headers['Content-Type'] === 'application/json') {
                $httpBody = \GuzzleHttp\json_encode($formParams);

            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }

        // this endpoint requires API key authentication
        $apiKey = $this->config->getApiKeyWithPrefix('Authorization');
        if ($apiKey !== null) {
            $headers['Authorization'] = $apiKey;
        }

        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $this->config->getHost() . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }
}
