# # ProductUpdateBase

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | Existing product ID. If included in the POST request it will cause an update instead of a creating a new object. | [optional]
**source_id** | **string** | The ID that can be used to reference a product in another system. | [optional]
**source_variant_id** | **string** | Reference ID to an external object. Value will be returned as &#x60;variant_source_id&#x60;. | [optional]
**handle** | **string** | The handle of the product. Creating a new product with a handle identical to one of an existing product will cause creating a variant. |
**type** | **string** | The name of the product type associated with the product. | [optional]
**variant_option_one_name** | **string** | The name of the variant option 1. | [optional]
**variant_option_one_value** | **string** | The value of the variant option 1. | [optional]
**variant_option_two_name** | **string** | The name of the variant option 2. | [optional]
**variant_option_two_value** | **string** | The value of the variant option 2. | [optional]
**variant_option_three_name** | **string** | The name of the variant option 3. | [optional]
**variant_option_three_value** | **string** | The value of the variant option 3. | [optional]
**active** | **string** | Indicates whether the product is currently active. **NOTE:** Currently has to be submitted as __\&quot;0\&quot;__ or __\&quot;1\&quot;__. Will be returned as __boolean__ value of &#x60;true&#x60; or &#x60;false&#x60;. | [optional]
**name** | **string** | The name of the product. Should be posted without any variant related suffixes. |
**description** | **string** | The description of the product. May include HTML. | [optional]
**sku** | **string** | The SKU of the product. Should be unique for new products. |
**tags** | **string** | A comma separated list of tags associated with the product. | [optional]
**brand_id** | **string** | The ID of the brand associated with the product. | [optional]
**brand_name** | **string** | The name of the brand associated with the product. | [optional]
**supplier_name** | **string** | Product supplier&#39;s name. | [optional]
**supplier_code** | **string** | The code of the supplier for the product. | [optional]
**supply_price** | **double** | The default cost of supply for the product. | [optional]
**account_code_purchase** | **string** | Code used to associate purchase (cost) of the product with a specific account. | [optional]
**account_code** | **string** | Code used to associate sales of the product with a specific account. Value will be returned as &#x60;account_code_sales&#x60;. | [optional]
**track_inventory** | **bool** | Indicated whether the system should track inventory count for this product. | [optional]
**button_order** | **int** | A number describing the position of a variant in the UI. | [optional]
**inventory** | [**\Vend09\Model\InventoryRecord[]**](InventoryRecord.md) | A list of inventory records associated with the product. | [optional]
**retail_price** | **double** | Retail price for the product. Tax inclusive or exclusive depending on the store settings. |
**tax_id** | **string** | ID of the tax to be used as the default for this product (for inclusive stores). | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
