# # Product

## Properties

Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**has_variants** | **bool** | Indicated whether the product has variants. | [optional]
**variant_parent_id** | **string** | The ID of the parent product. Only available of variant children. | [optional]
**base_name** | **string** | The root of the product&#39;s name as defined by the user in the UI. Doesn&#39;t include any variant related suffixes. | [optional]
**image** | **string** | **DEPRECATED** URL of the product image. | [optional]
**image_large** | **string** | **DEPRECATED** URL of the large product image. | [optional]
**images** | [**\Vend09\Model\ProductImage[]**](ProductImage.md) | An array of product images. | [optional]
**composites** | [**\Vend09\Model\Component[]**](Component.md) | An array of component products associated with a composite product. | [optional]
**price_book_entries** | [**\Vend09\Model\PriceBookEntry[]**](PriceBookEntry.md) | An array of price book entries associated with the product. | [optional]
**price** | **double** | Tax exclusive default price of the product. | [optional]
**tax** | **double** | The name of the default tax for the product. | [optional]
**tax_rate** | **double** | The default tax rate for the product. | [optional]
**tax_name** | **string** | The name of the default tax for the product. | [optional]
**taxes** | [**\Vend09\Model\ProductTax[]**](ProductTax.md) | An array of product tax objects. | [optional]
**updated_at** | **string** | The time of the last update for the product. | [optional]
**deleted_at** | **string** | The time of the product deletion. | [optional]
**id** | **string** | Auto-generated object ID. | [optional]
**source_id** | **string** | The ID that can be used to reference a product in another system. | [optional]
**variant_source_id** | **string** | Reference ID to an external object. Should be POSTed as &#x60;source_variant_id&#x60;. | [optional]
**handle** | **string** | The handle of the product. Creating a new product with a handle identical to one of an existing product will cause creating a variant. |
**type** | **string** | The name of the product type associated with the product. | [optional]
**variant_option_one_name** | **string** | The name of the variant option 1. | [optional]
**variant_option_one_value** | **string** | The value of the variant option 1. | [optional]
**variant_option_two_name** | **string** | The name of the variant option 2. | [optional]
**variant_option_two_value** | **string** | The value of the variant option 2. | [optional]
**variant_option_three_name** | **string** | The name of the variant option 3. | [optional]
**variant_option_three_value** | **string** | The value of the variant option 3. | [optional]
**active** | **bool** | Indicates whether the product is currently active. | [optional]
**name** | **string** | The name of the product. Should be posted without any variant related suffixes. |
**description** | **string** | The description of the product. May include HTML. | [optional]
**sku** | **string** | The SKU of the product. Should be unique for new products. |
**tags** | **string** | A comma separated list of tags associated with the product. | [optional]
**brand_id** | **string** | The ID of the brand associated with the product. | [optional]
**supplier_name** | **string** | Product supplier&#39;s name. | [optional]
**supplier_code** | **string** | The code of the supplier for the product. | [optional]
**supply_price** | **double** | The default cost of supply for the product. | [optional]
**account_code_purchase** | **string** | Code used to associate purchase (cost) of the product with a specific account. | [optional]
**account_code_sales** | **string** | Code used to associate sales of the product with a specific account. When POSTing it should be delivered as &#x60;account_code&#x60;. | [optional]
**track_inventory** | **bool** | Indicated whether the system should track inventory count for this product. | [optional]
**button_order** | **int** | A number describing the position of a variant in the UI. | [optional]
**inventory** | [**\Vend09\Model\InventoryRecord[]**](InventoryRecord.md) | A list of inventory records associated with the product. | [optional]
**retail_price** | **double** | Retail price for the product. Tax inclusive or exclusive depending on the store settings. |
**tax_id** | **string** | ID of the tax to be used as the default for this product (for inclusive stores). | [optional]

[[Back to Model list]](../../README.md#models) [[Back to API list]](../../README.md#endpoints) [[Back to README]](../../README.md)
