# Vend09\TaxesApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createTax()**](TaxesApi.md#createTax) | **POST** /taxes | Create a tax
[**getTaxByID()**](TaxesApi.md#getTaxByID) | **GET** /taxes/{tax_id} | Get a single tax by ID
[**listTaxes()**](TaxesApi.md#listTaxes) | **GET** /taxes | List taxes


## `createTax()`

```php
createTax($body): \Vend09\Model\TaxResponse
```

Create a tax

Creates a new tax.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\TaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \Vend09\Model\TaxBase(); // \Vend09\Model\TaxBase | New tax attributes.

try {
    $result = $apiInstance->createTax($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxesApi->createTax: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Vend09\Model\TaxBase**](../Model/TaxBase.md)| New tax attributes. |

### Return type

[**\Vend09\Model\TaxResponse**](../Model/TaxResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getTaxByID()`

```php
getTaxByID($tax_id): \Vend09\Model\TaxResponse
```

Get a single tax by ID

Returns a single tax with the given ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\TaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$tax_id = 'tax_id_example'; // string | An ID of an existing tax object.

try {
    $result = $apiInstance->getTaxByID($tax_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxesApi->getTaxByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **tax_id** | **string**| An ID of an existing tax object. |

### Return type

[**\Vend09\Model\TaxResponse**](../Model/TaxResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listTaxes()`

```php
listTaxes(): \Vend09\Model\TaxCollection
```

List taxes

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a non-paginated list of taxes.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\TaxesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);

try {
    $result = $apiInstance->listTaxes();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling TaxesApi->listTaxes: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

This endpoint does not need any parameter.

### Return type

[**\Vend09\Model\TaxCollection**](../Model/TaxCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
