# Vend09\RegisterSalesApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createUpdateRegisterSale()**](RegisterSalesApi.md#createUpdateRegisterSale) | **POST** /register_sales | Create or update a register sale
[**getRegisterSaleByID()**](RegisterSalesApi.md#getRegisterSaleByID) | **GET** /register_sales/{sale_id} | Get a single register sale by ID
[**listRegisterSales()**](RegisterSalesApi.md#listRegisterSales) | **GET** /register_sales | List register sales


## `createUpdateRegisterSale()`

```php
createUpdateRegisterSale($register_sale): \Vend09\Model\RegisterSaleResponse
```

Create or update a register sale

Returns a single new or updated product object.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\RegisterSalesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$register_sale = new \Vend09\Model\RegisterSaleUpdateBase(); // \Vend09\Model\RegisterSaleUpdateBase | New or updated register sale object.

try {
    $result = $apiInstance->createUpdateRegisterSale($register_sale);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegisterSalesApi->createUpdateRegisterSale: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **register_sale** | [**\Vend09\Model\RegisterSaleUpdateBase**](../Model/RegisterSaleUpdateBase.md)| New or updated register sale object. |

### Return type

[**\Vend09\Model\RegisterSaleResponse**](../Model/RegisterSaleResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getRegisterSaleByID()`

```php
getRegisterSaleByID($sale_id): \Vend09\Model\RegisterSaleCollection
```

Get a single register sale by ID

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a single register sale with the given ID, in an array.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\RegisterSalesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$sale_id = 'sale_id_example'; // string | An ID of an existing sale

try {
    $result = $apiInstance->getRegisterSaleByID($sale_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegisterSalesApi->getRegisterSaleByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sale_id** | **string**| An ID of an existing sale |

### Return type

[**\Vend09\Model\RegisterSaleCollection**](../Model/RegisterSaleCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listRegisterSales()`

```php
listRegisterSales($since, $outlet_id, $status, $page, $page_size): \Vend09\Model\RegisterSaleCollection
```

List register sales

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a paginated list of register sales.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\RegisterSalesApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**.
$outlet_id = 'outlet_id_example'; // string | If included, returns only register sales made for the given outlet, identified by ID.
$status = 'status_example'; // string | If included, returns only register sales in the given state. The status[] parameter may be used more than once; returned sales will be in any of the specified states.
$page = 3.4; // float | The number of the page of results to be returned.
$page_size = 3.4; // float | The size of the page of results to be returned.

try {
    $result = $apiInstance->listRegisterSales($since, $outlet_id, $status, $page, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling RegisterSalesApi->listRegisterSales: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **since** | **\DateTime**| If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. | [optional]
 **outlet_id** | **string**| If included, returns only register sales made for the given outlet, identified by ID. | [optional]
 **status** | **string**| If included, returns only register sales in the given state. The status[] parameter may be used more than once; returned sales will be in any of the specified states. | [optional]
 **page** | **float**| The number of the page of results to be returned. | [optional]
 **page_size** | **float**| The size of the page of results to be returned. | [optional]

### Return type

[**\Vend09\Model\RegisterSaleCollection**](../Model/RegisterSaleCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
