# Vend09\ProductsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createUpdateProduct()**](ProductsApi.md#createUpdateProduct) | **POST** /products | Create or update a product
[**deleteProduct()**](ProductsApi.md#deleteProduct) | **DELETE** /products/{product_id} | Delete a product
[**getProductByID()**](ProductsApi.md#getProductByID) | **GET** /products/{product_id} | Get a single product by ID
[**listProducts()**](ProductsApi.md#listProducts) | **GET** /products | List products


## `createUpdateProduct()`

```php
createUpdateProduct($product): \Vend09\Model\ProductResponse
```

Create or update a product

Returns a single new or updated product object.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product = new \Vend09\Model\ProductUpdateBase(); // \Vend09\Model\ProductUpdateBase | New or updated product object.

try {
    $result = $apiInstance->createUpdateProduct($product);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->createUpdateProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product** | [**\Vend09\Model\ProductUpdateBase**](../Model/ProductUpdateBase.md)| New or updated product object. |

### Return type

[**\Vend09\Model\ProductResponse**](../Model/ProductResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `deleteProduct()`

```php
deleteProduct($product_id)
```

Delete a product

Deleted a product by ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 'product_id_example'; // string | The ID of the product to be deleted.

try {
    $apiInstance->deleteProduct($product_id);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->deleteProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_id** | **string**| The ID of the product to be deleted. |

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getProductByID()`

```php
getProductByID($product_id): \Vend09\Model\ProductCollection
```

Get a single product by ID

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns an array with a single product inside it.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$product_id = 'product_id_example'; // string | An ID of an existing product.

try {
    $result = $apiInstance->getProductByID($product_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->getProductByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **product_id** | **string**| An ID of an existing product. |

### Return type

[**\Vend09\Model\ProductCollection**](../Model/ProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listProducts()`

```php
listProducts($order_by, $order_direction, $since, $active, $sku, $handle, $page, $page_size, $deleted): \Vend09\Model\ProductCollection
```

List products

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a paginated list of products.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$order_by = 'order_by_example'; // string | Defines the attribute by which the query results should be ordered. One of: `id`(recommended), `updated_at`(default), name.
$order_direction = 'order_direction_example'; // string | Selects the order direction of the results returned. On of `ASC`(default), `DESC`.
$since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**.
$active = 'active_example'; // string | If included, only active or inactive products will be returned. One of: '\"0\"' or '\"1\"'.
$sku = 'sku_example'; // string | If included, only the product with given sku will be returned. It may happen that there will be more products with the same sku. In this case all of them will be returned.
$handle = 'handle_example'; // string | If included, only products with given handle will be returned. This is useful for filtering all variants of a product, since all variants share the same handle.
$page = 3.4; // float | The number of the page of results to be returned.
$page_size = 3.4; // float | The size of the page of results to be returned.
$deleted = True; // bool | Indicates whether deleted items should be included in the result.

try {
    $result = $apiInstance->listProducts($order_by, $order_direction, $since, $active, $sku, $handle, $page, $page_size, $deleted);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ProductsApi->listProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **order_by** | **string**| Defines the attribute by which the query results should be ordered. One of: &#x60;id&#x60;(recommended), &#x60;updated_at&#x60;(default), name. | [optional]
 **order_direction** | **string**| Selects the order direction of the results returned. On of &#x60;ASC&#x60;(default), &#x60;DESC&#x60;. | [optional]
 **since** | **\DateTime**| If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. | [optional]
 **active** | **string**| If included, only active or inactive products will be returned. One of: &#39;\&quot;0\&quot;&#39; or &#39;\&quot;1\&quot;&#39;. | [optional]
 **sku** | **string**| If included, only the product with given sku will be returned. It may happen that there will be more products with the same sku. In this case all of them will be returned. | [optional]
 **handle** | **string**| If included, only products with given handle will be returned. This is useful for filtering all variants of a product, since all variants share the same handle. | [optional]
 **page** | **float**| The number of the page of results to be returned. | [optional]
 **page_size** | **float**| The size of the page of results to be returned. | [optional]
 **deleted** | **bool**| Indicates whether deleted items should be included in the result. | [optional]

### Return type

[**\Vend09\Model\ProductCollection**](../Model/ProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
