# Vend09\CustomersApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api.

Method | HTTP request | Description
------------- | ------------- | -------------
[**createUpdateCustomer()**](CustomersApi.md#createUpdateCustomer) | **POST** /customers | Create or update a customer
[**listCustomers()**](CustomersApi.md#listCustomers) | **GET** /customers | List customers


## `createUpdateCustomer()`

```php
createUpdateCustomer($body): \Vend09\Model\CustomerResponse
```

Create or update a customer

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a single new or updated customer object.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \Vend09\Model\CustomerUpdateBase(); // \Vend09\Model\CustomerUpdateBase | New or updated customer attributes

try {
    $result = $apiInstance->createUpdateCustomer($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->createUpdateCustomer: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Vend09\Model\CustomerUpdateBase**](../Model/CustomerUpdateBase.md)| New or updated customer attributes |

### Return type

[**\Vend09\Model\CustomerResponse**](../Model/CustomerResponse.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listCustomers()`

```php
listCustomers($id, $code, $email, $since, $page, $page_size): \Vend09\Model\CustomerCollection
```

List customers

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a paginated list of customers.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\CustomersApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$id = 'id_example'; // string | If included, searches for customers with the given unique ID. The id option cannot be used with the `code` or `email` options.
$code = 'code_example'; // string | If included, searches for customers with the given customer code. The code option cannot be used with id or email options.
$email = 'email_example'; // string | If included, searches for customers with the given email address. This is an exact match search. The email option cannot be used with the id or code options.
$since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**.
$page = 3.4; // float | The number of the page of results to be returned.
$page_size = 3.4; // float | The size of the page of results to be returned.

try {
    $result = $apiInstance->listCustomers($id, $code, $email, $since, $page, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling CustomersApi->listCustomers: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **id** | **string**| If included, searches for customers with the given unique ID. The id option cannot be used with the &#x60;code&#x60; or &#x60;email&#x60; options. | [optional]
 **code** | **string**| If included, searches for customers with the given customer code. The code option cannot be used with id or email options. | [optional]
 **email** | **string**| If included, searches for customers with the given email address. This is an exact match search. The email option cannot be used with the id or code options. | [optional]
 **since** | **\DateTime**| If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. | [optional]
 **page** | **float**| The number of the page of results to be returned. | [optional]
 **page_size** | **float**| The size of the page of results to be returned. | [optional]

### Return type

[**\Vend09\Model\CustomerCollection**](../Model/CustomerCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
