# Vend09\ConsignmentsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConsignment()**](ConsignmentsApi.md#deleteConsignment) | **DELETE** /consignment/{consignment_id} | Delete a consignment
[**getConsignmentByID()**](ConsignmentsApi.md#getConsignmentByID) | **GET** /consignment/{consignment_id} | Get a consignment by ID
[**listConsignments()**](ConsignmentsApi.md#listConsignments) | **GET** /consignment | List consignments
[**newConsignment()**](ConsignmentsApi.md#newConsignment) | **POST** /consignment | Create a consignment
[**updateConsignment()**](ConsignmentsApi.md#updateConsignment) | **PUT** /consignment/{consignment_id} | Update a consignment


## `deleteConsignment()`

```php
deleteConsignment($consignment_id): \Vend09\Model\DeleteConsignment200Response
```

Delete a consignment

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Deletes the consignment with a given ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The ID of the consignment to be deleted

try {
    $result = $apiInstance->deleteConsignment($consignment_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->deleteConsignment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The ID of the consignment to be deleted |

### Return type

[**\Vend09\Model\DeleteConsignment200Response**](../Model/DeleteConsignment200Response.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getConsignmentByID()`

```php
getConsignmentByID($consignment_id): \Vend09\Model\Consignment
```

Get a consignment by ID

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead.\\s\\s \\s\\s Returns a single consignment with a given ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The ID of the consignment to get.

try {
    $result = $apiInstance->getConsignmentByID($consignment_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->getConsignmentByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The ID of the consignment to get. |

### Return type

[**\Vend09\Model\Consignment**](../Model/Consignment.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listConsignments()`

```php
listConsignments($since, $page, $page_size): \Vend09\Model\ConsignmentCollection
```

List consignments

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a paginated list of consignments.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$since = new \DateTime("2013-10-20T19:20:30+01:00"); // \DateTime | If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**.
$page = 3.4; // float | The number of the page of results to be returned.
$page_size = 3.4; // float | The size of the page of results to be returned.

try {
    $result = $apiInstance->listConsignments($since, $page, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->listConsignments: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **since** | **\DateTime**| If included, returns only items modified since the given time. The provided date and time should be in **UTC** and formatted according to **ISO 8601**. | [optional]
 **page** | **float**| The number of the page of results to be returned. | [optional]
 **page_size** | **float**| The size of the page of results to be returned. | [optional]

### Return type

[**\Vend09\Model\ConsignmentCollection**](../Model/ConsignmentCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `newConsignment()`

```php
newConsignment($consignment): \Vend09\Model\Consignment
```

Create a consignment

Creates a new consignment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment = new \Vend09\Model\ConsignmentBase(); // \Vend09\Model\ConsignmentBase | A new consignment object.

try {
    $result = $apiInstance->newConsignment($consignment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->newConsignment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment** | [**\Vend09\Model\ConsignmentBase**](../Model/ConsignmentBase.md)| A new consignment object. |

### Return type

[**\Vend09\Model\Consignment**](../Model/Consignment.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateConsignment()`

```php
updateConsignment($consignment_id, $body): \Vend09\Model\Consignment
```

Update a consignment

Updates a consignment with the given ID.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The ID of the consignment to be updated.
$body = new \Vend09\Model\ConsignmentBase(); // \Vend09\Model\ConsignmentBase | An updated consignment object.

try {
    $result = $apiInstance->updateConsignment($consignment_id, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentsApi->updateConsignment: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The ID of the consignment to be updated. |
 **body** | [**\Vend09\Model\ConsignmentBase**](../Model/ConsignmentBase.md)| An updated consignment object. |

### Return type

[**\Vend09\Model\Consignment**](../Model/Consignment.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
