# Vend09\ConsignmentProductsApi

All URIs are relative to https://domain_prefix.retail.lightspeed.app/api.

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteConsignmentProduct()**](ConsignmentProductsApi.md#deleteConsignmentProduct) | **DELETE** /consignment_product/{consignment_product_id} | Delete a consignment product
[**getConsignmentProductByID()**](ConsignmentProductsApi.md#getConsignmentProductByID) | **GET** /consignment_product/{consignment_product_id} | Get a single consignment product by ID
[**listConsignmentProducts()**](ConsignmentProductsApi.md#listConsignmentProducts) | **GET** /consignment_product | List consignment products
[**newConsignmentProduct()**](ConsignmentProductsApi.md#newConsignmentProduct) | **POST** /consignment_product | Create a consignment product
[**updateConsignmentProduct()**](ConsignmentProductsApi.md#updateConsignmentProduct) | **PUT** /consignment_product/{consignment_product_id} | Update a consignment product


## `deleteConsignmentProduct()`

```php
deleteConsignmentProduct($consignment_product_id)
```

Delete a consignment product

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Deletes an item from the consignment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_product_id = 'consignment_product_id_example'; // string | The ID of the consignment product to be deleted.

try {
    $apiInstance->deleteConsignmentProduct($consignment_product_id);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->deleteConsignmentProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_product_id** | **string**| The ID of the consignment product to be deleted. |

### Return type

void (empty response body)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: Not defined

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `getConsignmentProductByID()`

```php
getConsignmentProductByID($consignment_product_id): \Vend09\Model\Consignment
```

Get a single consignment product by ID

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a single consignment product.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_product_id = 'consignment_product_id_example'; // string | The ID of the consignment to get.

try {
    $result = $apiInstance->getConsignmentProductByID($consignment_product_id);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->getConsignmentProductByID: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_product_id** | **string**| The ID of the consignment to get. |

### Return type

[**\Vend09\Model\Consignment**](../Model/Consignment.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `listConsignmentProducts()`

```php
listConsignmentProducts($consignment_id, $product_id, $page, $page_size): \Vend09\Model\ConsignmentProductCollection
```

List consignment products

**DEPRECATED** This endpoint has a 2.0 equivalent. We recommend using that instead. Returns a paginated list of consignment products.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_id = 'consignment_id_example'; // string | The ID of a consignment to filter the items for. Shouldn't be used together with the `product_id` parameter.
$product_id = 'product_id_example'; // string | The ID of a product to filter the items for. Shouldn't be used together with the `consignment_id` parameter.
$page = 3.4; // float | The number of the page of results to be returned.
$page_size = 3.4; // float | The size of the page of results to be returned.

try {
    $result = $apiInstance->listConsignmentProducts($consignment_id, $product_id, $page, $page_size);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->listConsignmentProducts: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_id** | **string**| The ID of a consignment to filter the items for. Shouldn&#39;t be used together with the &#x60;product_id&#x60; parameter. |
 **product_id** | **string**| The ID of a product to filter the items for. Shouldn&#39;t be used together with the &#x60;consignment_id&#x60; parameter. |
 **page** | **float**| The number of the page of results to be returned. | [optional]
 **page_size** | **float**| The size of the page of results to be returned. | [optional]

### Return type

[**\Vend09\Model\ConsignmentProductCollection**](../Model/ConsignmentProductCollection.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `newConsignmentProduct()`

```php
newConsignmentProduct($body): \Vend09\Model\ConsignmentProduct
```

Create a consignment product

Adds a new product to a consignment.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$body = new \Vend09\Model\ConsignmentProductBase(); // \Vend09\Model\ConsignmentProductBase | New consignment product object.

try {
    $result = $apiInstance->newConsignmentProduct($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->newConsignmentProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\Vend09\Model\ConsignmentProductBase**](../Model/ConsignmentProductBase.md)| New consignment product object. |

### Return type

[**\Vend09\Model\ConsignmentProduct**](../Model/ConsignmentProduct.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)

## `updateConsignmentProduct()`

```php
updateConsignmentProduct($consignment_product_id, $consignment): \Vend09\Model\ConsignmentProduct
```

Update a consignment product

Updates an existing consignment product.

### Example

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');


// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_product_id = 'consignment_product_id_example'; // string | The ID of the consignment to be updated.
$consignment = new \Vend09\Model\ConsignmentProductBase(); // \Vend09\Model\ConsignmentProductBase | A new or updated consignment object.

try {
    $result = $apiInstance->updateConsignmentProduct($consignment_product_id, $consignment);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->updateConsignmentProduct: ', $e->getMessage(), PHP_EOL;
}
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **consignment_product_id** | **string**| The ID of the consignment to be updated. |
 **consignment** | [**\Vend09\Model\ConsignmentProductBase**](../Model/ConsignmentProductBase.md)| A new or updated consignment object. |

### Return type

[**\Vend09\Model\ConsignmentProduct**](../Model/ConsignmentProduct.md)

### Authorization

[personal_token](../../README.md#personal_token)

### HTTP request headers

- **Content-Type**: `application/json`
- **Accept**: `application/json`

[[Back to top]](#) [[Back to API list]](../../README.md#endpoints)
[[Back to Model list]](../../README.md#models)
[[Back to README]](../../README.md)
