# OpenAPIClient-php

The current state of the original Vend API.

For more information, please visit [https://developers.retail.lightspeed.app/](https://developers.retail.lightspeed.app/).

## Installation & Usage

### Requirements

PHP 7.4 and later.
Should also work with PHP 8.0.

### Composer

To install the bindings via [Composer](https://getcomposer.org/), add the following to `composer.json`:

```json
{
  "repositories": [
    {
      "type": "vcs",
      "url": "https://github.com/talisman/vend2.0.git"
    }
  ],
  "require": {
    "talisman/vend2.0": "*@dev"
  }
}
```

Then run `composer install`

### Manual Installation

Download the files and include `autoload.php`:

```php
<?php
require_once('/path/to/OpenAPIClient-php/vendor/autoload.php');
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');



// Configure API key authorization: personal_token
$config = Vend09\Configuration::getDefaultConfiguration()->setApiKey('Authorization', 'YOUR_API_KEY');
// Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
// $config = Vend09\Configuration::getDefaultConfiguration()->setApiKeyPrefix('Authorization', 'Bearer');


$apiInstance = new Vend09\Api\ConsignmentProductsApi(
    // If you want use custom http client, pass your client which implements `GuzzleHttp\ClientInterface`.
    // This is optional, `GuzzleHttp\Client` will be used as default.
    new GuzzleHttp\Client(),
    $config
);
$consignment_product_id = 'consignment_product_id_example'; // string | The ID of the consignment product to be deleted.

try {
    $apiInstance->deleteConsignmentProduct($consignment_product_id);
} catch (Exception $e) {
    echo 'Exception when calling ConsignmentProductsApi->deleteConsignmentProduct: ', $e->getMessage(), PHP_EOL;
}

```

## API Endpoints

All URIs are relative to *https://domain_prefix.retail.lightspeed.app/api*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*ConsignmentProductsApi* | [**deleteConsignmentProduct**](docs/Api/ConsignmentProductsApi.md#deleteconsignmentproduct) | **DELETE** /consignment_product/{consignment_product_id} | Delete a consignment product
*ConsignmentProductsApi* | [**getConsignmentProductByID**](docs/Api/ConsignmentProductsApi.md#getconsignmentproductbyid) | **GET** /consignment_product/{consignment_product_id} | Get a single consignment product by ID
*ConsignmentProductsApi* | [**listConsignmentProducts**](docs/Api/ConsignmentProductsApi.md#listconsignmentproducts) | **GET** /consignment_product | List consignment products
*ConsignmentProductsApi* | [**newConsignmentProduct**](docs/Api/ConsignmentProductsApi.md#newconsignmentproduct) | **POST** /consignment_product | Create a consignment product
*ConsignmentProductsApi* | [**updateConsignmentProduct**](docs/Api/ConsignmentProductsApi.md#updateconsignmentproduct) | **PUT** /consignment_product/{consignment_product_id} | Update a consignment product
*ConsignmentsApi* | [**deleteConsignment**](docs/Api/ConsignmentsApi.md#deleteconsignment) | **DELETE** /consignment/{consignment_id} | Delete a consignment
*ConsignmentsApi* | [**getConsignmentByID**](docs/Api/ConsignmentsApi.md#getconsignmentbyid) | **GET** /consignment/{consignment_id} | Get a consignment by ID
*ConsignmentsApi* | [**listConsignments**](docs/Api/ConsignmentsApi.md#listconsignments) | **GET** /consignment | List consignments
*ConsignmentsApi* | [**newConsignment**](docs/Api/ConsignmentsApi.md#newconsignment) | **POST** /consignment | Create a consignment
*ConsignmentsApi* | [**updateConsignment**](docs/Api/ConsignmentsApi.md#updateconsignment) | **PUT** /consignment/{consignment_id} | Update a consignment
*CustomersApi* | [**createUpdateCustomer**](docs/Api/CustomersApi.md#createupdatecustomer) | **POST** /customers | Create or update a customer
*CustomersApi* | [**listCustomers**](docs/Api/CustomersApi.md#listcustomers) | **GET** /customers | List customers
*OutletsApi* | [**listOutlets**](docs/Api/OutletsApi.md#listoutlets) | **GET** /outlets | List outlets
*PaymentTypesApi* | [**listPaymentTypes**](docs/Api/PaymentTypesApi.md#listpaymenttypes) | **GET** /payment_types | List payment types
*ProductsApi* | [**createUpdateProduct**](docs/Api/ProductsApi.md#createupdateproduct) | **POST** /products | Create or update a product
*ProductsApi* | [**deleteProduct**](docs/Api/ProductsApi.md#deleteproduct) | **DELETE** /products/{product_id} | Delete a product
*ProductsApi* | [**getProductByID**](docs/Api/ProductsApi.md#getproductbyid) | **GET** /products/{product_id} | Get a single product by ID
*ProductsApi* | [**listProducts**](docs/Api/ProductsApi.md#listproducts) | **GET** /products | List products
*RegisterSalesApi* | [**createUpdateRegisterSale**](docs/Api/RegisterSalesApi.md#createupdateregistersale) | **POST** /register_sales | Create or update a register sale
*RegisterSalesApi* | [**getRegisterSaleByID**](docs/Api/RegisterSalesApi.md#getregistersalebyid) | **GET** /register_sales/{sale_id} | Get a single register sale by ID
*RegisterSalesApi* | [**listRegisterSales**](docs/Api/RegisterSalesApi.md#listregistersales) | **GET** /register_sales | List register sales
*RegistersApi* | [**listRegisters**](docs/Api/RegistersApi.md#listregisters) | **GET** /registers | List registers
*SuppliersApi* | [**createUpdateSupplier**](docs/Api/SuppliersApi.md#createupdatesupplier) | **POST** /supplier | Create or update a supplier
*SuppliersApi* | [**deleteSupplier**](docs/Api/SuppliersApi.md#deletesupplier) | **DELETE** /supplier/{supplier_id} | Delete a supplier
*SuppliersApi* | [**getSupplierByID**](docs/Api/SuppliersApi.md#getsupplierbyid) | **GET** /supplier/{supplier_id} | Get a single supplier by ID
*SuppliersApi* | [**listSuppliers**](docs/Api/SuppliersApi.md#listsuppliers) | **GET** /supplier | List suppliers
*TaxesApi* | [**createTax**](docs/Api/TaxesApi.md#createtax) | **POST** /taxes | Create a tax
*TaxesApi* | [**getTaxByID**](docs/Api/TaxesApi.md#gettaxbyid) | **GET** /taxes/{tax_id} | Get a single tax by ID
*TaxesApi* | [**listTaxes**](docs/Api/TaxesApi.md#listtaxes) | **GET** /taxes | List taxes
*UsersApi* | [**listUsers**](docs/Api/UsersApi.md#listusers) | **GET** /users | List users
*WebhooksApi* | [**createWebhook**](docs/Api/WebhooksApi.md#createwebhook) | **POST** /webhooks | Create a webhook
*WebhooksApi* | [**deleteWebhook**](docs/Api/WebhooksApi.md#deletewebhook) | **DELETE** /webhooks/{webhook_id} | Delete a webhook by ID
*WebhooksApi* | [**getWebhookByID**](docs/Api/WebhooksApi.md#getwebhookbyid) | **GET** /webhooks/{webhook_id} | Get a single webhook by ID
*WebhooksApi* | [**listWebhooks**](docs/Api/WebhooksApi.md#listwebhooks) | **GET** /webhooks | List webhooks
*WebhooksApi* | [**updateWebhook**](docs/Api/WebhooksApi.md#updatewebhook) | **PUT** /webhooks/{webhook_id} | Update a webhook by ID

## Models

- [Component](docs/Model/Component.md)
- [Consignment](docs/Model/Consignment.md)
- [ConsignmentBase](docs/Model/ConsignmentBase.md)
- [ConsignmentCollection](docs/Model/ConsignmentCollection.md)
- [ConsignmentProduct](docs/Model/ConsignmentProduct.md)
- [ConsignmentProductBase](docs/Model/ConsignmentProductBase.md)
- [ConsignmentProductCollection](docs/Model/ConsignmentProductCollection.md)
- [Customer](docs/Model/Customer.md)
- [CustomerCollection](docs/Model/CustomerCollection.md)
- [CustomerContact](docs/Model/CustomerContact.md)
- [CustomerResponse](docs/Model/CustomerResponse.md)
- [CustomerUpdateBase](docs/Model/CustomerUpdateBase.md)
- [DeleteConsignment200Response](docs/Model/DeleteConsignment200Response.md)
- [GenericContact](docs/Model/GenericContact.md)
- [InventoryRecord](docs/Model/InventoryRecord.md)
- [Links](docs/Model/Links.md)
- [Outlet](docs/Model/Outlet.md)
- [OutletCollection](docs/Model/OutletCollection.md)
- [Pagination](docs/Model/Pagination.md)
- [PaymentConfig](docs/Model/PaymentConfig.md)
- [PaymentType](docs/Model/PaymentType.md)
- [PaymentTypeCollection](docs/Model/PaymentTypeCollection.md)
- [PriceBookEntry](docs/Model/PriceBookEntry.md)
- [Product](docs/Model/Product.md)
- [ProductCollection](docs/Model/ProductCollection.md)
- [ProductImage](docs/Model/ProductImage.md)
- [ProductResponse](docs/Model/ProductResponse.md)
- [ProductTax](docs/Model/ProductTax.md)
- [ProductUpdateBase](docs/Model/ProductUpdateBase.md)
- [Rate](docs/Model/Rate.md)
- [Register](docs/Model/Register.md)
- [RegisterCollection](docs/Model/RegisterCollection.md)
- [RegisterSale](docs/Model/RegisterSale.md)
- [RegisterSaleCollection](docs/Model/RegisterSaleCollection.md)
- [RegisterSalePayment](docs/Model/RegisterSalePayment.md)
- [RegisterSalePaymentUpdateBase](docs/Model/RegisterSalePaymentUpdateBase.md)
- [RegisterSaleProduct](docs/Model/RegisterSaleProduct.md)
- [RegisterSaleProductAttribute](docs/Model/RegisterSaleProductAttribute.md)
- [RegisterSaleProductUpdateBase](docs/Model/RegisterSaleProductUpdateBase.md)
- [RegisterSaleResponse](docs/Model/RegisterSaleResponse.md)
- [RegisterSaleTax](docs/Model/RegisterSaleTax.md)
- [RegisterSaleTotals](docs/Model/RegisterSaleTotals.md)
- [RegisterSaleUpdateBase](docs/Model/RegisterSaleUpdateBase.md)
- [Supplier](docs/Model/Supplier.md)
- [SupplierCollection](docs/Model/SupplierCollection.md)
- [SupplierUpdateBase](docs/Model/SupplierUpdateBase.md)
- [Tax](docs/Model/Tax.md)
- [TaxBase](docs/Model/TaxBase.md)
- [TaxCollection](docs/Model/TaxCollection.md)
- [TaxResponse](docs/Model/TaxResponse.md)
- [User](docs/Model/User.md)
- [UserCollection](docs/Model/UserCollection.md)
- [UserImage](docs/Model/UserImage.md)
- [Webhook](docs/Model/Webhook.md)
- [WebhookDeleteSuccess](docs/Model/WebhookDeleteSuccess.md)

## Authorization

### personal_token

- **Type**: API key
- **API key parameter name**: Authorization
- **Location**: HTTP header


## Tests

To run the tests, use:

```bash
composer install
vendor/bin/phpunit
```

## Author

api@vendhq.com

## About this package

This PHP package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: `0.9`
    - Package version: `0.9`
- Build package: `org.openapitools.codegen.languages.PhpClientCodegen`
