<?php
/**
 * Copyright Talisman Innovations Ltd. (2019). All rights reserved.
 *
 * Add the relevant headers to the request as specified here  https://apidocs.unleashedsoftware.com/AuthenticationHelp
 *
 *  Content-Type
 *  Accept
 *  api-auth-id
 *  api-auth-signature
 */

namespace Unleashed;

use Psr\Http\Message\RequestInterface;
use Closure;

class HeadersMiddleware
{
    public static function create(string $apiId, string $apiKey, string $contentType = 'application/json'): Closure
    {
        return function (callable $handler) use ($apiId, $apiKey, $contentType)
        {
            return function (RequestInterface $request, array $options) use ($handler, $apiId, $apiKey, $contentType)
            {
                $request = $request->withHeader('Content-Type', $contentType);
                $request = $request->withHeader('Accept', $contentType);
                $request = $request->withHeader('api-auth-id', $apiId);
                $request = $request->withHeader('User-Agent', 'OpenAPI-Generator/1.0/PHP/TIDE');
                $request = $request->withHeader('Client-Type', 'TIDE');

                $query = parse_url($request->getRequestTarget(), PHP_URL_QUERY);
                $query = $query ? urldecode($query) : '';
                $signature = base64_encode(hash_hmac('sha256', $query, $apiKey, true));
                $request = $request->withHeader('api-auth-signature', $signature);

                return $handler($request, $options);
            };
        };
    }

}