<?php
/**
 * TransferDetail
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * TransferDetail Class Doc Comment
 *
 * @category Class
 * @description 
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class TransferDetail implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'transferDetail';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'transfer_order_id' => 'int',
        'line_number' => 'int',
        'source_warehouse_id' => 'int',
        'warehouse_product_id' => 'int',
        'warehouse_location_id' => 'int',
        'destination_warehouse_id' => 'int',
        'destination_warehouse_location_id' => 'int',
        'receipt_fifo_date' => 'string',
        'available_quantity' => 'int',
        'transfer_quantity' => 'int',
        'comments' => 'string',
        'average_landed_price_at_time_of_transfer' => 'object',
        'source_warehouse_stock_on_hand_before_transfer' => 'object',
        'destinate_warehouse_stock_on_hand_before_transfer' => 'object',
        'warehouse_product_code' => 'string',
        'product' => '\Unleashed\Model\Product',
        'created_on' => 'string',
        'created_by' => 'string',
        'last_modified_by' => 'string',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'transfer_order_id' => null,
        'line_number' => null,
        'source_warehouse_id' => null,
        'warehouse_product_id' => null,
        'warehouse_location_id' => null,
        'destination_warehouse_id' => null,
        'destination_warehouse_location_id' => null,
        'receipt_fifo_date' => null,
        'available_quantity' => null,
        'transfer_quantity' => null,
        'comments' => null,
        'average_landed_price_at_time_of_transfer' => null,
        'source_warehouse_stock_on_hand_before_transfer' => null,
        'destinate_warehouse_stock_on_hand_before_transfer' => null,
        'warehouse_product_code' => null,
        'product' => null,
        'created_on' => null,
        'created_by' => null,
        'last_modified_by' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'transfer_order_id' => false,
        'line_number' => false,
        'source_warehouse_id' => false,
        'warehouse_product_id' => false,
        'warehouse_location_id' => false,
        'destination_warehouse_id' => false,
        'destination_warehouse_location_id' => false,
        'receipt_fifo_date' => false,
        'available_quantity' => false,
        'transfer_quantity' => false,
        'comments' => false,
        'average_landed_price_at_time_of_transfer' => true,
        'source_warehouse_stock_on_hand_before_transfer' => true,
        'destinate_warehouse_stock_on_hand_before_transfer' => true,
        'warehouse_product_code' => false,
        'product' => false,
        'created_on' => false,
        'created_by' => false,
        'last_modified_by' => false,
        'guid' => false,
        'last_modified_on' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'transfer_order_id' => 'TransferOrderId',
        'line_number' => 'LineNumber',
        'source_warehouse_id' => 'SourceWarehouseId',
        'warehouse_product_id' => 'WarehouseProductId',
        'warehouse_location_id' => 'WarehouseLocationId',
        'destination_warehouse_id' => 'DestinationWarehouseId',
        'destination_warehouse_location_id' => 'DestinationWarehouseLocationId',
        'receipt_fifo_date' => 'ReceiptFIFODate',
        'available_quantity' => 'AvailableQuantity',
        'transfer_quantity' => 'TransferQuantity',
        'comments' => 'Comments',
        'average_landed_price_at_time_of_transfer' => 'AverageLandedPriceAtTimeOfTransfer',
        'source_warehouse_stock_on_hand_before_transfer' => 'SourceWarehouseStockOnHandBeforeTransfer',
        'destinate_warehouse_stock_on_hand_before_transfer' => 'DestinateWarehouseStockOnHandBeforeTransfer',
        'warehouse_product_code' => 'WarehouseProductCode',
        'product' => 'Product',
        'created_on' => 'CreatedOn',
        'created_by' => 'CreatedBy',
        'last_modified_by' => 'LastModifiedBy',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'transfer_order_id' => 'setTransferOrderId',
        'line_number' => 'setLineNumber',
        'source_warehouse_id' => 'setSourceWarehouseId',
        'warehouse_product_id' => 'setWarehouseProductId',
        'warehouse_location_id' => 'setWarehouseLocationId',
        'destination_warehouse_id' => 'setDestinationWarehouseId',
        'destination_warehouse_location_id' => 'setDestinationWarehouseLocationId',
        'receipt_fifo_date' => 'setReceiptFifoDate',
        'available_quantity' => 'setAvailableQuantity',
        'transfer_quantity' => 'setTransferQuantity',
        'comments' => 'setComments',
        'average_landed_price_at_time_of_transfer' => 'setAverageLandedPriceAtTimeOfTransfer',
        'source_warehouse_stock_on_hand_before_transfer' => 'setSourceWarehouseStockOnHandBeforeTransfer',
        'destinate_warehouse_stock_on_hand_before_transfer' => 'setDestinateWarehouseStockOnHandBeforeTransfer',
        'warehouse_product_code' => 'setWarehouseProductCode',
        'product' => 'setProduct',
        'created_on' => 'setCreatedOn',
        'created_by' => 'setCreatedBy',
        'last_modified_by' => 'setLastModifiedBy',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'transfer_order_id' => 'getTransferOrderId',
        'line_number' => 'getLineNumber',
        'source_warehouse_id' => 'getSourceWarehouseId',
        'warehouse_product_id' => 'getWarehouseProductId',
        'warehouse_location_id' => 'getWarehouseLocationId',
        'destination_warehouse_id' => 'getDestinationWarehouseId',
        'destination_warehouse_location_id' => 'getDestinationWarehouseLocationId',
        'receipt_fifo_date' => 'getReceiptFifoDate',
        'available_quantity' => 'getAvailableQuantity',
        'transfer_quantity' => 'getTransferQuantity',
        'comments' => 'getComments',
        'average_landed_price_at_time_of_transfer' => 'getAverageLandedPriceAtTimeOfTransfer',
        'source_warehouse_stock_on_hand_before_transfer' => 'getSourceWarehouseStockOnHandBeforeTransfer',
        'destinate_warehouse_stock_on_hand_before_transfer' => 'getDestinateWarehouseStockOnHandBeforeTransfer',
        'warehouse_product_code' => 'getWarehouseProductCode',
        'product' => 'getProduct',
        'created_on' => 'getCreatedOn',
        'created_by' => 'getCreatedBy',
        'last_modified_by' => 'getLastModifiedBy',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('transfer_order_id', $data ?? [], null);
        $this->setIfExists('line_number', $data ?? [], null);
        $this->setIfExists('source_warehouse_id', $data ?? [], null);
        $this->setIfExists('warehouse_product_id', $data ?? [], null);
        $this->setIfExists('warehouse_location_id', $data ?? [], null);
        $this->setIfExists('destination_warehouse_id', $data ?? [], null);
        $this->setIfExists('destination_warehouse_location_id', $data ?? [], null);
        $this->setIfExists('receipt_fifo_date', $data ?? [], null);
        $this->setIfExists('available_quantity', $data ?? [], null);
        $this->setIfExists('transfer_quantity', $data ?? [], null);
        $this->setIfExists('comments', $data ?? [], null);
        $this->setIfExists('average_landed_price_at_time_of_transfer', $data ?? [], null);
        $this->setIfExists('source_warehouse_stock_on_hand_before_transfer', $data ?? [], null);
        $this->setIfExists('destinate_warehouse_stock_on_hand_before_transfer', $data ?? [], null);
        $this->setIfExists('warehouse_product_code', $data ?? [], null);
        $this->setIfExists('product', $data ?? [], null);
        $this->setIfExists('created_on', $data ?? [], null);
        $this->setIfExists('created_by', $data ?? [], null);
        $this->setIfExists('last_modified_by', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets transfer_order_id
     *
     * @return int|null
     */
    public function getTransferOrderId()
    {
        return $this->container['transfer_order_id'];
    }

    /**
     * Sets transfer_order_id
     *
     * @param int|null $transfer_order_id transfer_order_id
     *
     * @return self
     */
    public function setTransferOrderId($transfer_order_id)
    {
        if (is_null($transfer_order_id)) {
            throw new \InvalidArgumentException('non-nullable transfer_order_id cannot be null');
        }
        $this->container['transfer_order_id'] = $transfer_order_id;

        return $this;
    }

    /**
     * Gets line_number
     *
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->container['line_number'];
    }

    /**
     * Sets line_number
     *
     * @param int|null $line_number line_number
     *
     * @return self
     */
    public function setLineNumber($line_number)
    {
        if (is_null($line_number)) {
            throw new \InvalidArgumentException('non-nullable line_number cannot be null');
        }
        $this->container['line_number'] = $line_number;

        return $this;
    }

    /**
     * Gets source_warehouse_id
     *
     * @return int|null
     */
    public function getSourceWarehouseId()
    {
        return $this->container['source_warehouse_id'];
    }

    /**
     * Sets source_warehouse_id
     *
     * @param int|null $source_warehouse_id source_warehouse_id
     *
     * @return self
     */
    public function setSourceWarehouseId($source_warehouse_id)
    {
        if (is_null($source_warehouse_id)) {
            throw new \InvalidArgumentException('non-nullable source_warehouse_id cannot be null');
        }
        $this->container['source_warehouse_id'] = $source_warehouse_id;

        return $this;
    }

    /**
     * Gets warehouse_product_id
     *
     * @return int|null
     */
    public function getWarehouseProductId()
    {
        return $this->container['warehouse_product_id'];
    }

    /**
     * Sets warehouse_product_id
     *
     * @param int|null $warehouse_product_id warehouse_product_id
     *
     * @return self
     */
    public function setWarehouseProductId($warehouse_product_id)
    {
        if (is_null($warehouse_product_id)) {
            throw new \InvalidArgumentException('non-nullable warehouse_product_id cannot be null');
        }
        $this->container['warehouse_product_id'] = $warehouse_product_id;

        return $this;
    }

    /**
     * Gets warehouse_location_id
     *
     * @return int|null
     */
    public function getWarehouseLocationId()
    {
        return $this->container['warehouse_location_id'];
    }

    /**
     * Sets warehouse_location_id
     *
     * @param int|null $warehouse_location_id warehouse_location_id
     *
     * @return self
     */
    public function setWarehouseLocationId($warehouse_location_id)
    {
        if (is_null($warehouse_location_id)) {
            throw new \InvalidArgumentException('non-nullable warehouse_location_id cannot be null');
        }
        $this->container['warehouse_location_id'] = $warehouse_location_id;

        return $this;
    }

    /**
     * Gets destination_warehouse_id
     *
     * @return int|null
     */
    public function getDestinationWarehouseId()
    {
        return $this->container['destination_warehouse_id'];
    }

    /**
     * Sets destination_warehouse_id
     *
     * @param int|null $destination_warehouse_id destination_warehouse_id
     *
     * @return self
     */
    public function setDestinationWarehouseId($destination_warehouse_id)
    {
        if (is_null($destination_warehouse_id)) {
            throw new \InvalidArgumentException('non-nullable destination_warehouse_id cannot be null');
        }
        $this->container['destination_warehouse_id'] = $destination_warehouse_id;

        return $this;
    }

    /**
     * Gets destination_warehouse_location_id
     *
     * @return int|null
     */
    public function getDestinationWarehouseLocationId()
    {
        return $this->container['destination_warehouse_location_id'];
    }

    /**
     * Sets destination_warehouse_location_id
     *
     * @param int|null $destination_warehouse_location_id destination_warehouse_location_id
     *
     * @return self
     */
    public function setDestinationWarehouseLocationId($destination_warehouse_location_id)
    {
        if (is_null($destination_warehouse_location_id)) {
            throw new \InvalidArgumentException('non-nullable destination_warehouse_location_id cannot be null');
        }
        $this->container['destination_warehouse_location_id'] = $destination_warehouse_location_id;

        return $this;
    }

    /**
     * Gets receipt_fifo_date
     *
     * @return string|null
     */
    public function getReceiptFifoDate()
    {
        return $this->container['receipt_fifo_date'];
    }

    /**
     * Sets receipt_fifo_date
     *
     * @param string|null $receipt_fifo_date receipt_fifo_date
     *
     * @return self
     */
    public function setReceiptFifoDate($receipt_fifo_date)
    {
        if (is_null($receipt_fifo_date)) {
            throw new \InvalidArgumentException('non-nullable receipt_fifo_date cannot be null');
        }
        $this->container['receipt_fifo_date'] = $receipt_fifo_date;

        return $this;
    }

    /**
     * Gets available_quantity
     *
     * @return int|null
     */
    public function getAvailableQuantity()
    {
        return $this->container['available_quantity'];
    }

    /**
     * Sets available_quantity
     *
     * @param int|null $available_quantity available_quantity
     *
     * @return self
     */
    public function setAvailableQuantity($available_quantity)
    {
        if (is_null($available_quantity)) {
            throw new \InvalidArgumentException('non-nullable available_quantity cannot be null');
        }
        $this->container['available_quantity'] = $available_quantity;

        return $this;
    }

    /**
     * Gets transfer_quantity
     *
     * @return int|null
     */
    public function getTransferQuantity()
    {
        return $this->container['transfer_quantity'];
    }

    /**
     * Sets transfer_quantity
     *
     * @param int|null $transfer_quantity transfer_quantity
     *
     * @return self
     */
    public function setTransferQuantity($transfer_quantity)
    {
        if (is_null($transfer_quantity)) {
            throw new \InvalidArgumentException('non-nullable transfer_quantity cannot be null');
        }
        $this->container['transfer_quantity'] = $transfer_quantity;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        if (is_null($comments)) {
            throw new \InvalidArgumentException('non-nullable comments cannot be null');
        }
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets average_landed_price_at_time_of_transfer
     *
     * @return object|null
     */
    public function getAverageLandedPriceAtTimeOfTransfer()
    {
        return $this->container['average_landed_price_at_time_of_transfer'];
    }

    /**
     * Sets average_landed_price_at_time_of_transfer
     *
     * @param object|null $average_landed_price_at_time_of_transfer average_landed_price_at_time_of_transfer
     *
     * @return self
     */
    public function setAverageLandedPriceAtTimeOfTransfer($average_landed_price_at_time_of_transfer)
    {
        if (is_null($average_landed_price_at_time_of_transfer)) {
            array_push($this->openAPINullablesSetToNull, 'average_landed_price_at_time_of_transfer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('average_landed_price_at_time_of_transfer', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['average_landed_price_at_time_of_transfer'] = $average_landed_price_at_time_of_transfer;

        return $this;
    }

    /**
     * Gets source_warehouse_stock_on_hand_before_transfer
     *
     * @return object|null
     */
    public function getSourceWarehouseStockOnHandBeforeTransfer()
    {
        return $this->container['source_warehouse_stock_on_hand_before_transfer'];
    }

    /**
     * Sets source_warehouse_stock_on_hand_before_transfer
     *
     * @param object|null $source_warehouse_stock_on_hand_before_transfer source_warehouse_stock_on_hand_before_transfer
     *
     * @return self
     */
    public function setSourceWarehouseStockOnHandBeforeTransfer($source_warehouse_stock_on_hand_before_transfer)
    {
        if (is_null($source_warehouse_stock_on_hand_before_transfer)) {
            array_push($this->openAPINullablesSetToNull, 'source_warehouse_stock_on_hand_before_transfer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('source_warehouse_stock_on_hand_before_transfer', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['source_warehouse_stock_on_hand_before_transfer'] = $source_warehouse_stock_on_hand_before_transfer;

        return $this;
    }

    /**
     * Gets destinate_warehouse_stock_on_hand_before_transfer
     *
     * @return object|null
     */
    public function getDestinateWarehouseStockOnHandBeforeTransfer()
    {
        return $this->container['destinate_warehouse_stock_on_hand_before_transfer'];
    }

    /**
     * Sets destinate_warehouse_stock_on_hand_before_transfer
     *
     * @param object|null $destinate_warehouse_stock_on_hand_before_transfer destinate_warehouse_stock_on_hand_before_transfer
     *
     * @return self
     */
    public function setDestinateWarehouseStockOnHandBeforeTransfer($destinate_warehouse_stock_on_hand_before_transfer)
    {
        if (is_null($destinate_warehouse_stock_on_hand_before_transfer)) {
            array_push($this->openAPINullablesSetToNull, 'destinate_warehouse_stock_on_hand_before_transfer');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('destinate_warehouse_stock_on_hand_before_transfer', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['destinate_warehouse_stock_on_hand_before_transfer'] = $destinate_warehouse_stock_on_hand_before_transfer;

        return $this;
    }

    /**
     * Gets warehouse_product_code
     *
     * @return string|null
     */
    public function getWarehouseProductCode()
    {
        return $this->container['warehouse_product_code'];
    }

    /**
     * Sets warehouse_product_code
     *
     * @param string|null $warehouse_product_code warehouse_product_code
     *
     * @return self
     */
    public function setWarehouseProductCode($warehouse_product_code)
    {
        if (is_null($warehouse_product_code)) {
            throw new \InvalidArgumentException('non-nullable warehouse_product_code cannot be null');
        }
        $this->container['warehouse_product_code'] = $warehouse_product_code;

        return $this;
    }

    /**
     * Gets product
     *
     * @return \Unleashed\Model\Product|null
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param \Unleashed\Model\Product|null $product product
     *
     * @return self
     */
    public function setProduct($product)
    {
        if (is_null($product)) {
            throw new \InvalidArgumentException('non-nullable product cannot be null');
        }
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        if (is_null($created_on)) {
            throw new \InvalidArgumentException('non-nullable created_on cannot be null');
        }
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        if (is_null($created_by)) {
            throw new \InvalidArgumentException('non-nullable created_by cannot be null');
        }
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        if (is_null($last_modified_by)) {
            throw new \InvalidArgumentException('non-nullable last_modified_by cannot be null');
        }
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


