<?php
/**
 * SupplierWithProductCode
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * SupplierWithProductCode Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SupplierWithProductCode implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'supplierWithProductCode';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'supplier_product_code' => 'string',
        'supplier_product_description' => 'string',
        'supplier_product_price' => 'float',
        'guid' => 'string',
        'supplier_code' => 'string',
        'supplier_name' => 'string',
        'lead_time_days' => 'int',
        'minimum_order_quantity' => 'float',
        'unit_of_measure' => '\Unleashed\Model\UnitOfMeasure'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'supplier_product_code' => null,
        'supplier_product_description' => null,
        'supplier_product_price' => null,
        'guid' => null,
        'supplier_code' => null,
        'supplier_name' => null,
        'lead_time_days' => null,
        'minimum_order_quantity' => null,
        'unit_of_measure' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'supplier_product_code' => false,
        'supplier_product_description' => false,
        'supplier_product_price' => true,
        'guid' => false,
        'supplier_code' => false,
        'supplier_name' => false,
        'lead_time_days' => true,
        'minimum_order_quantity' => true,
        'unit_of_measure' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'supplier_product_code' => 'SupplierProductCode',
        'supplier_product_description' => 'SupplierProductDescription',
        'supplier_product_price' => 'SupplierProductPrice',
        'guid' => 'Guid',
        'supplier_code' => 'SupplierCode',
        'supplier_name' => 'SupplierName',
        'lead_time_days' => 'LeadTimeDays',
        'minimum_order_quantity' => 'MinimumOrderQuantity',
        'unit_of_measure' => 'UnitOfMeasure'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'supplier_product_code' => 'setSupplierProductCode',
        'supplier_product_description' => 'setSupplierProductDescription',
        'supplier_product_price' => 'setSupplierProductPrice',
        'guid' => 'setGuid',
        'supplier_code' => 'setSupplierCode',
        'supplier_name' => 'setSupplierName',
        'lead_time_days' => 'setLeadTimeDays',
        'minimum_order_quantity' => 'setMinimumOrderQuantity',
        'unit_of_measure' => 'setUnitOfMeasure'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'supplier_product_code' => 'getSupplierProductCode',
        'supplier_product_description' => 'getSupplierProductDescription',
        'supplier_product_price' => 'getSupplierProductPrice',
        'guid' => 'getGuid',
        'supplier_code' => 'getSupplierCode',
        'supplier_name' => 'getSupplierName',
        'lead_time_days' => 'getLeadTimeDays',
        'minimum_order_quantity' => 'getMinimumOrderQuantity',
        'unit_of_measure' => 'getUnitOfMeasure'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('supplier_product_code', $data ?? [], null);
        $this->setIfExists('supplier_product_description', $data ?? [], null);
        $this->setIfExists('supplier_product_price', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('supplier_code', $data ?? [], null);
        $this->setIfExists('supplier_name', $data ?? [], null);
        $this->setIfExists('lead_time_days', $data ?? [], null);
        $this->setIfExists('minimum_order_quantity', $data ?? [], null);
        $this->setIfExists('unit_of_measure', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets supplier_product_code
     *
     * @return string|null
     */
    public function getSupplierProductCode()
    {
        return $this->container['supplier_product_code'];
    }

    /**
     * Sets supplier_product_code
     *
     * @param string|null $supplier_product_code supplier_product_code
     *
     * @return self
     */
    public function setSupplierProductCode($supplier_product_code)
    {
        if (is_null($supplier_product_code)) {
            throw new \InvalidArgumentException('non-nullable supplier_product_code cannot be null');
        }
        $this->container['supplier_product_code'] = $supplier_product_code;

        return $this;
    }

    /**
     * Gets supplier_product_description
     *
     * @return string|null
     */
    public function getSupplierProductDescription()
    {
        return $this->container['supplier_product_description'];
    }

    /**
     * Sets supplier_product_description
     *
     * @param string|null $supplier_product_description supplier_product_description
     *
     * @return self
     */
    public function setSupplierProductDescription($supplier_product_description)
    {
        if (is_null($supplier_product_description)) {
            throw new \InvalidArgumentException('non-nullable supplier_product_description cannot be null');
        }
        $this->container['supplier_product_description'] = $supplier_product_description;

        return $this;
    }

    /**
     * Gets supplier_product_price
     *
     * @return float|null
     */
    public function getSupplierProductPrice()
    {
        return $this->container['supplier_product_price'];
    }

    /**
     * Sets supplier_product_price
     *
     * @param float|null $supplier_product_price supplier_product_price
     *
     * @return self
     */
    public function setSupplierProductPrice($supplier_product_price)
    {
        if (is_null($supplier_product_price)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_product_price');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_product_price', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_product_price'] = $supplier_product_price;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code supplier_code
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        if (is_null($supplier_code)) {
            throw new \InvalidArgumentException('non-nullable supplier_code cannot be null');
        }
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets supplier_name
     *
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->container['supplier_name'];
    }

    /**
     * Sets supplier_name
     *
     * @param string|null $supplier_name supplier_name
     *
     * @return self
     */
    public function setSupplierName($supplier_name)
    {
        if (is_null($supplier_name)) {
            throw new \InvalidArgumentException('non-nullable supplier_name cannot be null');
        }
        $this->container['supplier_name'] = $supplier_name;

        return $this;
    }

    /**
     * Gets lead_time_days
     *
     * @return int|null
     */
    public function getLeadTimeDays()
    {
        return $this->container['lead_time_days'];
    }

    /**
     * Sets lead_time_days
     *
     * @param int|null $lead_time_days lead_time_days
     *
     * @return self
     */
    public function setLeadTimeDays($lead_time_days)
    {
        if (is_null($lead_time_days)) {
            array_push($this->openAPINullablesSetToNull, 'lead_time_days');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('lead_time_days', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['lead_time_days'] = $lead_time_days;

        return $this;
    }

    /**
     * Gets minimum_order_quantity
     *
     * @return float|null
     */
    public function getMinimumOrderQuantity()
    {
        return $this->container['minimum_order_quantity'];
    }

    /**
     * Sets minimum_order_quantity
     *
     * @param float|null $minimum_order_quantity minimum_order_quantity
     *
     * @return self
     */
    public function setMinimumOrderQuantity($minimum_order_quantity)
    {
        if (is_null($minimum_order_quantity)) {
            array_push($this->openAPINullablesSetToNull, 'minimum_order_quantity');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minimum_order_quantity', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minimum_order_quantity'] = $minimum_order_quantity;

        return $this;
    }

    /**
     * Gets unit_of_measure
     *
     * @return \Unleashed\Model\UnitOfMeasure|null
     */
    public function getUnitOfMeasure()
    {
        return $this->container['unit_of_measure'];
    }

    /**
     * Sets unit_of_measure
     *
     * @param \Unleashed\Model\UnitOfMeasure|null $unit_of_measure unit_of_measure
     *
     * @return self
     */
    public function setUnitOfMeasure($unit_of_measure)
    {
        if (is_null($unit_of_measure)) {
            throw new \InvalidArgumentException('non-nullable unit_of_measure cannot be null');
        }
        $this->container['unit_of_measure'] = $unit_of_measure;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


