<?php
/**
 * Supplier
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Supplier Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Supplier implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'supplier';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'bank_account' => 'string',
        'bank_branch' => 'string',
        'bank_name' => 'string',
        'created_by' => 'string',
        'created_on' => 'string',
        'currency' => '\Unleashed\Model\Currency',
        'ddi_number' => 'string',
        'email' => 'string',
        'fax_number' => 'string',
        'gstvat_number' => 'string',
        'guid' => 'string',
        'last_modified_by' => 'string',
        'last_modified_on' => 'string',
        'mobile_number' => 'string',
        'notes' => 'string',
        'phone_number' => 'string',
        'supplier_code' => 'string',
        'supplier_name' => 'string',
        'taxable' => 'bool',
        'toll_free_number' => 'string',
        'website' => 'string',
        'xero_contact_id' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'bank_account' => null,
        'bank_branch' => null,
        'bank_name' => null,
        'created_by' => null,
        'created_on' => null,
        'currency' => null,
        'ddi_number' => null,
        'email' => null,
        'fax_number' => null,
        'gstvat_number' => null,
        'guid' => null,
        'last_modified_by' => null,
        'last_modified_on' => null,
        'mobile_number' => null,
        'notes' => null,
        'phone_number' => null,
        'supplier_code' => null,
        'supplier_name' => null,
        'taxable' => null,
        'toll_free_number' => null,
        'website' => null,
        'xero_contact_id' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'bank_account' => false,
        'bank_branch' => false,
        'bank_name' => false,
        'created_by' => false,
        'created_on' => false,
        'currency' => false,
        'ddi_number' => false,
        'email' => false,
        'fax_number' => false,
        'gstvat_number' => false,
        'guid' => false,
        'last_modified_by' => false,
        'last_modified_on' => false,
        'mobile_number' => false,
        'notes' => false,
        'phone_number' => false,
        'supplier_code' => false,
        'supplier_name' => false,
        'taxable' => false,
        'toll_free_number' => false,
        'website' => false,
        'xero_contact_id' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'bank_account' => 'BankAccount',
        'bank_branch' => 'BankBranch',
        'bank_name' => 'BankName',
        'created_by' => 'CreatedBy',
        'created_on' => 'CreatedOn',
        'currency' => 'Currency',
        'ddi_number' => 'DDINumber',
        'email' => 'Email',
        'fax_number' => 'FaxNumber',
        'gstvat_number' => 'GSTVATNumber',
        'guid' => 'Guid',
        'last_modified_by' => 'LastModifiedBy',
        'last_modified_on' => 'LastModifiedOn',
        'mobile_number' => 'MobileNumber',
        'notes' => 'Notes',
        'phone_number' => 'PhoneNumber',
        'supplier_code' => 'SupplierCode',
        'supplier_name' => 'SupplierName',
        'taxable' => 'Taxable',
        'toll_free_number' => 'TollFreeNumber',
        'website' => 'Website',
        'xero_contact_id' => 'XeroContactId'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'bank_account' => 'setBankAccount',
        'bank_branch' => 'setBankBranch',
        'bank_name' => 'setBankName',
        'created_by' => 'setCreatedBy',
        'created_on' => 'setCreatedOn',
        'currency' => 'setCurrency',
        'ddi_number' => 'setDdiNumber',
        'email' => 'setEmail',
        'fax_number' => 'setFaxNumber',
        'gstvat_number' => 'setGstvatNumber',
        'guid' => 'setGuid',
        'last_modified_by' => 'setLastModifiedBy',
        'last_modified_on' => 'setLastModifiedOn',
        'mobile_number' => 'setMobileNumber',
        'notes' => 'setNotes',
        'phone_number' => 'setPhoneNumber',
        'supplier_code' => 'setSupplierCode',
        'supplier_name' => 'setSupplierName',
        'taxable' => 'setTaxable',
        'toll_free_number' => 'setTollFreeNumber',
        'website' => 'setWebsite',
        'xero_contact_id' => 'setXeroContactId'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'bank_account' => 'getBankAccount',
        'bank_branch' => 'getBankBranch',
        'bank_name' => 'getBankName',
        'created_by' => 'getCreatedBy',
        'created_on' => 'getCreatedOn',
        'currency' => 'getCurrency',
        'ddi_number' => 'getDdiNumber',
        'email' => 'getEmail',
        'fax_number' => 'getFaxNumber',
        'gstvat_number' => 'getGstvatNumber',
        'guid' => 'getGuid',
        'last_modified_by' => 'getLastModifiedBy',
        'last_modified_on' => 'getLastModifiedOn',
        'mobile_number' => 'getMobileNumber',
        'notes' => 'getNotes',
        'phone_number' => 'getPhoneNumber',
        'supplier_code' => 'getSupplierCode',
        'supplier_name' => 'getSupplierName',
        'taxable' => 'getTaxable',
        'toll_free_number' => 'getTollFreeNumber',
        'website' => 'getWebsite',
        'xero_contact_id' => 'getXeroContactId'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('bank_account', $data ?? [], null);
        $this->setIfExists('bank_branch', $data ?? [], null);
        $this->setIfExists('bank_name', $data ?? [], null);
        $this->setIfExists('created_by', $data ?? [], null);
        $this->setIfExists('created_on', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('ddi_number', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('fax_number', $data ?? [], null);
        $this->setIfExists('gstvat_number', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('last_modified_by', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
        $this->setIfExists('mobile_number', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('phone_number', $data ?? [], null);
        $this->setIfExists('supplier_code', $data ?? [], null);
        $this->setIfExists('supplier_name', $data ?? [], null);
        $this->setIfExists('taxable', $data ?? [], null);
        $this->setIfExists('toll_free_number', $data ?? [], null);
        $this->setIfExists('website', $data ?? [], null);
        $this->setIfExists('xero_contact_id', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets bank_account
     *
     * @return string|null
     */
    public function getBankAccount()
    {
        return $this->container['bank_account'];
    }

    /**
     * Sets bank_account
     *
     * @param string|null $bank_account bank_account
     *
     * @return self
     */
    public function setBankAccount($bank_account)
    {
        if (is_null($bank_account)) {
            throw new \InvalidArgumentException('non-nullable bank_account cannot be null');
        }
        $this->container['bank_account'] = $bank_account;

        return $this;
    }

    /**
     * Gets bank_branch
     *
     * @return string|null
     */
    public function getBankBranch()
    {
        return $this->container['bank_branch'];
    }

    /**
     * Sets bank_branch
     *
     * @param string|null $bank_branch bank_branch
     *
     * @return self
     */
    public function setBankBranch($bank_branch)
    {
        if (is_null($bank_branch)) {
            throw new \InvalidArgumentException('non-nullable bank_branch cannot be null');
        }
        $this->container['bank_branch'] = $bank_branch;

        return $this;
    }

    /**
     * Gets bank_name
     *
     * @return string|null
     */
    public function getBankName()
    {
        return $this->container['bank_name'];
    }

    /**
     * Sets bank_name
     *
     * @param string|null $bank_name bank_name
     *
     * @return self
     */
    public function setBankName($bank_name)
    {
        if (is_null($bank_name)) {
            throw new \InvalidArgumentException('non-nullable bank_name cannot be null');
        }
        $this->container['bank_name'] = $bank_name;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        if (is_null($created_by)) {
            throw new \InvalidArgumentException('non-nullable created_by cannot be null');
        }
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        if (is_null($created_on)) {
            throw new \InvalidArgumentException('non-nullable created_on cannot be null');
        }
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Unleashed\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Unleashed\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets ddi_number
     *
     * @return string|null
     */
    public function getDdiNumber()
    {
        return $this->container['ddi_number'];
    }

    /**
     * Sets ddi_number
     *
     * @param string|null $ddi_number ddi_number
     *
     * @return self
     */
    public function setDdiNumber($ddi_number)
    {
        if (is_null($ddi_number)) {
            throw new \InvalidArgumentException('non-nullable ddi_number cannot be null');
        }
        $this->container['ddi_number'] = $ddi_number;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param string|null $fax_number fax_number
     *
     * @return self
     */
    public function setFaxNumber($fax_number)
    {
        if (is_null($fax_number)) {
            throw new \InvalidArgumentException('non-nullable fax_number cannot be null');
        }
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets gstvat_number
     *
     * @return string|null
     */
    public function getGstvatNumber()
    {
        return $this->container['gstvat_number'];
    }

    /**
     * Sets gstvat_number
     *
     * @param string|null $gstvat_number gstvat_number
     *
     * @return self
     */
    public function setGstvatNumber($gstvat_number)
    {
        if (is_null($gstvat_number)) {
            throw new \InvalidArgumentException('non-nullable gstvat_number cannot be null');
        }
        $this->container['gstvat_number'] = $gstvat_number;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        if (is_null($last_modified_by)) {
            throw new \InvalidArgumentException('non-nullable last_modified_by cannot be null');
        }
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets mobile_number
     *
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->container['mobile_number'];
    }

    /**
     * Sets mobile_number
     *
     * @param string|null $mobile_number mobile_number
     *
     * @return self
     */
    public function setMobileNumber($mobile_number)
    {
        if (is_null($mobile_number)) {
            throw new \InvalidArgumentException('non-nullable mobile_number cannot be null');
        }
        $this->container['mobile_number'] = $mobile_number;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets phone_number
     *
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->container['phone_number'];
    }

    /**
     * Sets phone_number
     *
     * @param string|null $phone_number phone_number
     *
     * @return self
     */
    public function setPhoneNumber($phone_number)
    {
        if (is_null($phone_number)) {
            throw new \InvalidArgumentException('non-nullable phone_number cannot be null');
        }
        $this->container['phone_number'] = $phone_number;

        return $this;
    }

    /**
     * Gets supplier_code
     *
     * @return string|null
     */
    public function getSupplierCode()
    {
        return $this->container['supplier_code'];
    }

    /**
     * Sets supplier_code
     *
     * @param string|null $supplier_code supplier_code
     *
     * @return self
     */
    public function setSupplierCode($supplier_code)
    {
        if (is_null($supplier_code)) {
            throw new \InvalidArgumentException('non-nullable supplier_code cannot be null');
        }
        $this->container['supplier_code'] = $supplier_code;

        return $this;
    }

    /**
     * Gets supplier_name
     *
     * @return string|null
     */
    public function getSupplierName()
    {
        return $this->container['supplier_name'];
    }

    /**
     * Sets supplier_name
     *
     * @param string|null $supplier_name supplier_name
     *
     * @return self
     */
    public function setSupplierName($supplier_name)
    {
        if (is_null($supplier_name)) {
            throw new \InvalidArgumentException('non-nullable supplier_name cannot be null');
        }
        $this->container['supplier_name'] = $supplier_name;

        return $this;
    }

    /**
     * Gets taxable
     *
     * @return bool|null
     */
    public function getTaxable()
    {
        return $this->container['taxable'];
    }

    /**
     * Sets taxable
     *
     * @param bool|null $taxable taxable
     *
     * @return self
     */
    public function setTaxable($taxable)
    {
        if (is_null($taxable)) {
            throw new \InvalidArgumentException('non-nullable taxable cannot be null');
        }
        $this->container['taxable'] = $taxable;

        return $this;
    }

    /**
     * Gets toll_free_number
     *
     * @return string|null
     */
    public function getTollFreeNumber()
    {
        return $this->container['toll_free_number'];
    }

    /**
     * Sets toll_free_number
     *
     * @param string|null $toll_free_number toll_free_number
     *
     * @return self
     */
    public function setTollFreeNumber($toll_free_number)
    {
        if (is_null($toll_free_number)) {
            throw new \InvalidArgumentException('non-nullable toll_free_number cannot be null');
        }
        $this->container['toll_free_number'] = $toll_free_number;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string|null $website website
     *
     * @return self
     */
    public function setWebsite($website)
    {
        if (is_null($website)) {
            throw new \InvalidArgumentException('non-nullable website cannot be null');
        }
        $this->container['website'] = $website;

        return $this;
    }

    /**
     * Gets xero_contact_id
     *
     * @return string|null
     */
    public function getXeroContactId()
    {
        return $this->container['xero_contact_id'];
    }

    /**
     * Sets xero_contact_id
     *
     * @param string|null $xero_contact_id xero_contact_id
     *
     * @return self
     */
    public function setXeroContactId($xero_contact_id)
    {
        if (is_null($xero_contact_id)) {
            throw new \InvalidArgumentException('non-nullable xero_contact_id cannot be null');
        }
        $this->container['xero_contact_id'] = $xero_contact_id;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


