<?php
/**
 * Stockonhand
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Stockonhand Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Stockonhand implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'stockonhand';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'product_code' => 'string',
        'product_description' => 'string',
        'product_guid' => 'string',
        'product_source_id' => 'string',
        'product_group_name' => 'string',
        'warehouse_id' => 'string',
        'warehouse' => 'string',
        'warehouse_code' => 'string',
        'days_since_last_sale' => 'int',
        'on_purchase' => 'int',
        'allocated_qty' => 'int',
        'available_qty' => 'int',
        'qty_on_hand' => 'int',
        'avg_cost' => 'int',
        'total_cost' => 'int',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'product_code' => null,
        'product_description' => null,
        'product_guid' => null,
        'product_source_id' => null,
        'product_group_name' => null,
        'warehouse_id' => null,
        'warehouse' => null,
        'warehouse_code' => null,
        'days_since_last_sale' => null,
        'on_purchase' => null,
        'allocated_qty' => null,
        'available_qty' => null,
        'qty_on_hand' => null,
        'avg_cost' => null,
        'total_cost' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'product_code' => false,
        'product_description' => false,
        'product_guid' => false,
        'product_source_id' => false,
        'product_group_name' => false,
        'warehouse_id' => false,
        'warehouse' => false,
        'warehouse_code' => false,
        'days_since_last_sale' => false,
        'on_purchase' => false,
        'allocated_qty' => false,
        'available_qty' => false,
        'qty_on_hand' => false,
        'avg_cost' => false,
        'total_cost' => false,
        'guid' => false,
        'last_modified_on' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'product_code' => 'ProductCode',
        'product_description' => 'ProductDescription',
        'product_guid' => 'ProductGuid',
        'product_source_id' => 'ProductSourceId',
        'product_group_name' => 'ProductGroupName',
        'warehouse_id' => 'WarehouseId',
        'warehouse' => 'Warehouse',
        'warehouse_code' => 'WarehouseCode',
        'days_since_last_sale' => 'DaysSinceLastSale',
        'on_purchase' => 'OnPurchase',
        'allocated_qty' => 'AllocatedQty',
        'available_qty' => 'AvailableQty',
        'qty_on_hand' => 'QtyOnHand',
        'avg_cost' => 'AvgCost',
        'total_cost' => 'TotalCost',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'product_code' => 'setProductCode',
        'product_description' => 'setProductDescription',
        'product_guid' => 'setProductGuid',
        'product_source_id' => 'setProductSourceId',
        'product_group_name' => 'setProductGroupName',
        'warehouse_id' => 'setWarehouseId',
        'warehouse' => 'setWarehouse',
        'warehouse_code' => 'setWarehouseCode',
        'days_since_last_sale' => 'setDaysSinceLastSale',
        'on_purchase' => 'setOnPurchase',
        'allocated_qty' => 'setAllocatedQty',
        'available_qty' => 'setAvailableQty',
        'qty_on_hand' => 'setQtyOnHand',
        'avg_cost' => 'setAvgCost',
        'total_cost' => 'setTotalCost',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'product_code' => 'getProductCode',
        'product_description' => 'getProductDescription',
        'product_guid' => 'getProductGuid',
        'product_source_id' => 'getProductSourceId',
        'product_group_name' => 'getProductGroupName',
        'warehouse_id' => 'getWarehouseId',
        'warehouse' => 'getWarehouse',
        'warehouse_code' => 'getWarehouseCode',
        'days_since_last_sale' => 'getDaysSinceLastSale',
        'on_purchase' => 'getOnPurchase',
        'allocated_qty' => 'getAllocatedQty',
        'available_qty' => 'getAvailableQty',
        'qty_on_hand' => 'getQtyOnHand',
        'avg_cost' => 'getAvgCost',
        'total_cost' => 'getTotalCost',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('product_code', $data ?? [], null);
        $this->setIfExists('product_description', $data ?? [], null);
        $this->setIfExists('product_guid', $data ?? [], null);
        $this->setIfExists('product_source_id', $data ?? [], null);
        $this->setIfExists('product_group_name', $data ?? [], null);
        $this->setIfExists('warehouse_id', $data ?? [], null);
        $this->setIfExists('warehouse', $data ?? [], null);
        $this->setIfExists('warehouse_code', $data ?? [], null);
        $this->setIfExists('days_since_last_sale', $data ?? [], null);
        $this->setIfExists('on_purchase', $data ?? [], null);
        $this->setIfExists('allocated_qty', $data ?? [], null);
        $this->setIfExists('available_qty', $data ?? [], null);
        $this->setIfExists('qty_on_hand', $data ?? [], null);
        $this->setIfExists('avg_cost', $data ?? [], null);
        $this->setIfExists('total_cost', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets product_code
     *
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->container['product_code'];
    }

    /**
     * Sets product_code
     *
     * @param string|null $product_code product_code
     *
     * @return self
     */
    public function setProductCode($product_code)
    {
        if (is_null($product_code)) {
            throw new \InvalidArgumentException('non-nullable product_code cannot be null');
        }
        $this->container['product_code'] = $product_code;

        return $this;
    }

    /**
     * Gets product_description
     *
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->container['product_description'];
    }

    /**
     * Sets product_description
     *
     * @param string|null $product_description product_description
     *
     * @return self
     */
    public function setProductDescription($product_description)
    {
        if (is_null($product_description)) {
            throw new \InvalidArgumentException('non-nullable product_description cannot be null');
        }
        $this->container['product_description'] = $product_description;

        return $this;
    }

    /**
     * Gets product_guid
     *
     * @return string|null
     */
    public function getProductGuid()
    {
        return $this->container['product_guid'];
    }

    /**
     * Sets product_guid
     *
     * @param string|null $product_guid product_guid
     *
     * @return self
     */
    public function setProductGuid($product_guid)
    {
        if (is_null($product_guid)) {
            throw new \InvalidArgumentException('non-nullable product_guid cannot be null');
        }
        $this->container['product_guid'] = $product_guid;

        return $this;
    }

    /**
     * Gets product_source_id
     *
     * @return string|null
     */
    public function getProductSourceId()
    {
        return $this->container['product_source_id'];
    }

    /**
     * Sets product_source_id
     *
     * @param string|null $product_source_id product_source_id
     *
     * @return self
     */
    public function setProductSourceId($product_source_id)
    {
        if (is_null($product_source_id)) {
            throw new \InvalidArgumentException('non-nullable product_source_id cannot be null');
        }
        $this->container['product_source_id'] = $product_source_id;

        return $this;
    }

    /**
     * Gets product_group_name
     *
     * @return string|null
     */
    public function getProductGroupName()
    {
        return $this->container['product_group_name'];
    }

    /**
     * Sets product_group_name
     *
     * @param string|null $product_group_name product_group_name
     *
     * @return self
     */
    public function setProductGroupName($product_group_name)
    {
        if (is_null($product_group_name)) {
            throw new \InvalidArgumentException('non-nullable product_group_name cannot be null');
        }
        $this->container['product_group_name'] = $product_group_name;

        return $this;
    }

    /**
     * Gets warehouse_id
     *
     * @return string|null
     */
    public function getWarehouseId()
    {
        return $this->container['warehouse_id'];
    }

    /**
     * Sets warehouse_id
     *
     * @param string|null $warehouse_id warehouse_id
     *
     * @return self
     */
    public function setWarehouseId($warehouse_id)
    {
        if (is_null($warehouse_id)) {
            throw new \InvalidArgumentException('non-nullable warehouse_id cannot be null');
        }
        $this->container['warehouse_id'] = $warehouse_id;

        return $this;
    }

    /**
     * Gets warehouse
     *
     * @return string|null
     */
    public function getWarehouse()
    {
        return $this->container['warehouse'];
    }

    /**
     * Sets warehouse
     *
     * @param string|null $warehouse warehouse
     *
     * @return self
     */
    public function setWarehouse($warehouse)
    {
        if (is_null($warehouse)) {
            throw new \InvalidArgumentException('non-nullable warehouse cannot be null');
        }
        $this->container['warehouse'] = $warehouse;

        return $this;
    }

    /**
     * Gets warehouse_code
     *
     * @return string|null
     */
    public function getWarehouseCode()
    {
        return $this->container['warehouse_code'];
    }

    /**
     * Sets warehouse_code
     *
     * @param string|null $warehouse_code warehouse_code
     *
     * @return self
     */
    public function setWarehouseCode($warehouse_code)
    {
        if (is_null($warehouse_code)) {
            throw new \InvalidArgumentException('non-nullable warehouse_code cannot be null');
        }
        $this->container['warehouse_code'] = $warehouse_code;

        return $this;
    }

    /**
     * Gets days_since_last_sale
     *
     * @return int|null
     */
    public function getDaysSinceLastSale()
    {
        return $this->container['days_since_last_sale'];
    }

    /**
     * Sets days_since_last_sale
     *
     * @param int|null $days_since_last_sale days_since_last_sale
     *
     * @return self
     */
    public function setDaysSinceLastSale($days_since_last_sale)
    {
        if (is_null($days_since_last_sale)) {
            throw new \InvalidArgumentException('non-nullable days_since_last_sale cannot be null');
        }
        $this->container['days_since_last_sale'] = $days_since_last_sale;

        return $this;
    }

    /**
     * Gets on_purchase
     *
     * @return int|null
     */
    public function getOnPurchase()
    {
        return $this->container['on_purchase'];
    }

    /**
     * Sets on_purchase
     *
     * @param int|null $on_purchase on_purchase
     *
     * @return self
     */
    public function setOnPurchase($on_purchase)
    {
        if (is_null($on_purchase)) {
            throw new \InvalidArgumentException('non-nullable on_purchase cannot be null');
        }
        $this->container['on_purchase'] = $on_purchase;

        return $this;
    }

    /**
     * Gets allocated_qty
     *
     * @return int|null
     */
    public function getAllocatedQty()
    {
        return $this->container['allocated_qty'];
    }

    /**
     * Sets allocated_qty
     *
     * @param int|null $allocated_qty allocated_qty
     *
     * @return self
     */
    public function setAllocatedQty($allocated_qty)
    {
        if (is_null($allocated_qty)) {
            throw new \InvalidArgumentException('non-nullable allocated_qty cannot be null');
        }
        $this->container['allocated_qty'] = $allocated_qty;

        return $this;
    }

    /**
     * Gets available_qty
     *
     * @return int|null
     */
    public function getAvailableQty()
    {
        return $this->container['available_qty'];
    }

    /**
     * Sets available_qty
     *
     * @param int|null $available_qty available_qty
     *
     * @return self
     */
    public function setAvailableQty($available_qty)
    {
        if (is_null($available_qty)) {
            throw new \InvalidArgumentException('non-nullable available_qty cannot be null');
        }
        $this->container['available_qty'] = $available_qty;

        return $this;
    }

    /**
     * Gets qty_on_hand
     *
     * @return int|null
     */
    public function getQtyOnHand()
    {
        return $this->container['qty_on_hand'];
    }

    /**
     * Sets qty_on_hand
     *
     * @param int|null $qty_on_hand qty_on_hand
     *
     * @return self
     */
    public function setQtyOnHand($qty_on_hand)
    {
        if (is_null($qty_on_hand)) {
            throw new \InvalidArgumentException('non-nullable qty_on_hand cannot be null');
        }
        $this->container['qty_on_hand'] = $qty_on_hand;

        return $this;
    }

    /**
     * Gets avg_cost
     *
     * @return int|null
     */
    public function getAvgCost()
    {
        return $this->container['avg_cost'];
    }

    /**
     * Sets avg_cost
     *
     * @param int|null $avg_cost avg_cost
     *
     * @return self
     */
    public function setAvgCost($avg_cost)
    {
        if (is_null($avg_cost)) {
            throw new \InvalidArgumentException('non-nullable avg_cost cannot be null');
        }
        $this->container['avg_cost'] = $avg_cost;

        return $this;
    }

    /**
     * Gets total_cost
     *
     * @return int|null
     */
    public function getTotalCost()
    {
        return $this->container['total_cost'];
    }

    /**
     * Sets total_cost
     *
     * @param int|null $total_cost total_cost
     *
     * @return self
     */
    public function setTotalCost($total_cost)
    {
        if (is_null($total_cost)) {
            throw new \InvalidArgumentException('non-nullable total_cost cannot be null');
        }
        $this->container['total_cost'] = $total_cost;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


