<?php
/**
 * SalesOrderLine
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * SalesOrderLine Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class SalesOrderLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'salesOrderLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'line_number' => 'int',
        'line_type' => 'string',
        'product' => '\Unleashed\Model\SalesOrderLineProduct',
        'due_date' => 'string',
        'order_quantity' => 'float',
        'unit_price' => 'float',
        'discount_rate' => 'float',
        'line_total' => 'float',
        'volume' => 'float',
        'weight' => 'float',
        'comments' => 'string',
        'average_landed_price_at_time_of_sale' => 'int',
        'tax_rate' => 'float',
        'line_tax' => 'float',
        'xero_tax_code' => 'string',
        'bc_unit_price' => 'float',
        'bc_line_total' => 'float',
        'bc_line_tax' => 'float',
        'line_tax_code' => 'string',
        'xero_sales_account' => 'string',
        'serial_numbers' => '\Unleashed\Model\SerialNumber[]',
        'batch_numbers' => '\Unleashed\Model\BatchNumber[]',
        'assembly' => '\Unleashed\Model\Assembly',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'line_number' => null,
        'line_type' => null,
        'product' => null,
        'due_date' => null,
        'order_quantity' => null,
        'unit_price' => null,
        'discount_rate' => null,
        'line_total' => null,
        'volume' => null,
        'weight' => null,
        'comments' => null,
        'average_landed_price_at_time_of_sale' => null,
        'tax_rate' => null,
        'line_tax' => null,
        'xero_tax_code' => null,
        'bc_unit_price' => null,
        'bc_line_total' => null,
        'bc_line_tax' => null,
        'line_tax_code' => null,
        'xero_sales_account' => null,
        'serial_numbers' => null,
        'batch_numbers' => null,
        'assembly' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'line_number' => false,
        'line_type' => false,
        'product' => false,
        'due_date' => false,
        'order_quantity' => false,
        'unit_price' => false,
        'discount_rate' => false,
        'line_total' => false,
        'volume' => false,
        'weight' => false,
        'comments' => false,
        'average_landed_price_at_time_of_sale' => false,
        'tax_rate' => false,
        'line_tax' => false,
        'xero_tax_code' => false,
        'bc_unit_price' => false,
        'bc_line_total' => false,
        'bc_line_tax' => false,
        'line_tax_code' => false,
        'xero_sales_account' => false,
        'serial_numbers' => false,
        'batch_numbers' => false,
        'assembly' => false,
        'guid' => false,
        'last_modified_on' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'line_number' => 'LineNumber',
        'line_type' => 'LineType',
        'product' => 'Product',
        'due_date' => 'DueDate',
        'order_quantity' => 'OrderQuantity',
        'unit_price' => 'UnitPrice',
        'discount_rate' => 'DiscountRate',
        'line_total' => 'LineTotal',
        'volume' => 'Volume',
        'weight' => 'Weight',
        'comments' => 'Comments',
        'average_landed_price_at_time_of_sale' => 'AverageLandedPriceAtTimeOfSale',
        'tax_rate' => 'TaxRate',
        'line_tax' => 'LineTax',
        'xero_tax_code' => 'XeroTaxCode',
        'bc_unit_price' => 'BCUnitPrice',
        'bc_line_total' => 'BCLineTotal',
        'bc_line_tax' => 'BCLineTax',
        'line_tax_code' => 'LineTaxCode',
        'xero_sales_account' => 'XeroSalesAccount',
        'serial_numbers' => 'SerialNumbers',
        'batch_numbers' => 'BatchNumbers',
        'assembly' => 'Assembly',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'line_number' => 'setLineNumber',
        'line_type' => 'setLineType',
        'product' => 'setProduct',
        'due_date' => 'setDueDate',
        'order_quantity' => 'setOrderQuantity',
        'unit_price' => 'setUnitPrice',
        'discount_rate' => 'setDiscountRate',
        'line_total' => 'setLineTotal',
        'volume' => 'setVolume',
        'weight' => 'setWeight',
        'comments' => 'setComments',
        'average_landed_price_at_time_of_sale' => 'setAverageLandedPriceAtTimeOfSale',
        'tax_rate' => 'setTaxRate',
        'line_tax' => 'setLineTax',
        'xero_tax_code' => 'setXeroTaxCode',
        'bc_unit_price' => 'setBcUnitPrice',
        'bc_line_total' => 'setBcLineTotal',
        'bc_line_tax' => 'setBcLineTax',
        'line_tax_code' => 'setLineTaxCode',
        'xero_sales_account' => 'setXeroSalesAccount',
        'serial_numbers' => 'setSerialNumbers',
        'batch_numbers' => 'setBatchNumbers',
        'assembly' => 'setAssembly',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'line_number' => 'getLineNumber',
        'line_type' => 'getLineType',
        'product' => 'getProduct',
        'due_date' => 'getDueDate',
        'order_quantity' => 'getOrderQuantity',
        'unit_price' => 'getUnitPrice',
        'discount_rate' => 'getDiscountRate',
        'line_total' => 'getLineTotal',
        'volume' => 'getVolume',
        'weight' => 'getWeight',
        'comments' => 'getComments',
        'average_landed_price_at_time_of_sale' => 'getAverageLandedPriceAtTimeOfSale',
        'tax_rate' => 'getTaxRate',
        'line_tax' => 'getLineTax',
        'xero_tax_code' => 'getXeroTaxCode',
        'bc_unit_price' => 'getBcUnitPrice',
        'bc_line_total' => 'getBcLineTotal',
        'bc_line_tax' => 'getBcLineTax',
        'line_tax_code' => 'getLineTaxCode',
        'xero_sales_account' => 'getXeroSalesAccount',
        'serial_numbers' => 'getSerialNumbers',
        'batch_numbers' => 'getBatchNumbers',
        'assembly' => 'getAssembly',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('line_number', $data ?? [], null);
        $this->setIfExists('line_type', $data ?? [], null);
        $this->setIfExists('product', $data ?? [], null);
        $this->setIfExists('due_date', $data ?? [], null);
        $this->setIfExists('order_quantity', $data ?? [], null);
        $this->setIfExists('unit_price', $data ?? [], null);
        $this->setIfExists('discount_rate', $data ?? [], null);
        $this->setIfExists('line_total', $data ?? [], null);
        $this->setIfExists('volume', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('comments', $data ?? [], null);
        $this->setIfExists('average_landed_price_at_time_of_sale', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('line_tax', $data ?? [], null);
        $this->setIfExists('xero_tax_code', $data ?? [], null);
        $this->setIfExists('bc_unit_price', $data ?? [], null);
        $this->setIfExists('bc_line_total', $data ?? [], null);
        $this->setIfExists('bc_line_tax', $data ?? [], null);
        $this->setIfExists('line_tax_code', $data ?? [], null);
        $this->setIfExists('xero_sales_account', $data ?? [], null);
        $this->setIfExists('serial_numbers', $data ?? [], null);
        $this->setIfExists('batch_numbers', $data ?? [], null);
        $this->setIfExists('assembly', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets line_number
     *
     * @return int|null
     */
    public function getLineNumber()
    {
        return $this->container['line_number'];
    }

    /**
     * Sets line_number
     *
     * @param int|null $line_number line_number
     *
     * @return self
     */
    public function setLineNumber($line_number)
    {
        if (is_null($line_number)) {
            throw new \InvalidArgumentException('non-nullable line_number cannot be null');
        }
        $this->container['line_number'] = $line_number;

        return $this;
    }

    /**
     * Gets line_type
     *
     * @return string|null
     */
    public function getLineType()
    {
        return $this->container['line_type'];
    }

    /**
     * Sets line_type
     *
     * @param string|null $line_type line_type
     *
     * @return self
     */
    public function setLineType($line_type)
    {
        if (is_null($line_type)) {
            throw new \InvalidArgumentException('non-nullable line_type cannot be null');
        }
        $this->container['line_type'] = $line_type;

        return $this;
    }

    /**
     * Gets product
     *
     * @return \Unleashed\Model\SalesOrderLineProduct|null
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param \Unleashed\Model\SalesOrderLineProduct|null $product product
     *
     * @return self
     */
    public function setProduct($product)
    {
        if (is_null($product)) {
            throw new \InvalidArgumentException('non-nullable product cannot be null');
        }
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets due_date
     *
     * @return string|null
     */
    public function getDueDate()
    {
        return $this->container['due_date'];
    }

    /**
     * Sets due_date
     *
     * @param string|null $due_date due_date
     *
     * @return self
     */
    public function setDueDate($due_date)
    {
        if (is_null($due_date)) {
            throw new \InvalidArgumentException('non-nullable due_date cannot be null');
        }
        $this->container['due_date'] = $due_date;

        return $this;
    }

    /**
     * Gets order_quantity
     *
     * @return float|null
     */
    public function getOrderQuantity()
    {
        return $this->container['order_quantity'];
    }

    /**
     * Sets order_quantity
     *
     * @param float|null $order_quantity order_quantity
     *
     * @return self
     */
    public function setOrderQuantity($order_quantity)
    {
        if (is_null($order_quantity)) {
            throw new \InvalidArgumentException('non-nullable order_quantity cannot be null');
        }
        $this->container['order_quantity'] = $order_quantity;

        return $this;
    }

    /**
     * Gets unit_price
     *
     * @return float|null
     */
    public function getUnitPrice()
    {
        return $this->container['unit_price'];
    }

    /**
     * Sets unit_price
     *
     * @param float|null $unit_price unit_price
     *
     * @return self
     */
    public function setUnitPrice($unit_price)
    {
        if (is_null($unit_price)) {
            throw new \InvalidArgumentException('non-nullable unit_price cannot be null');
        }
        $this->container['unit_price'] = $unit_price;

        return $this;
    }

    /**
     * Gets discount_rate
     *
     * @return float|null
     */
    public function getDiscountRate()
    {
        return $this->container['discount_rate'];
    }

    /**
     * Sets discount_rate
     *
     * @param float|null $discount_rate discount_rate
     *
     * @return self
     */
    public function setDiscountRate($discount_rate)
    {
        if (is_null($discount_rate)) {
            throw new \InvalidArgumentException('non-nullable discount_rate cannot be null');
        }
        $this->container['discount_rate'] = $discount_rate;

        return $this;
    }

    /**
     * Gets line_total
     *
     * @return float|null
     */
    public function getLineTotal()
    {
        return $this->container['line_total'];
    }

    /**
     * Sets line_total
     *
     * @param float|null $line_total line_total
     *
     * @return self
     */
    public function setLineTotal($line_total)
    {
        if (is_null($line_total)) {
            throw new \InvalidArgumentException('non-nullable line_total cannot be null');
        }
        $this->container['line_total'] = $line_total;

        return $this;
    }

    /**
     * Gets volume
     *
     * @return float|null
     */
    public function getVolume()
    {
        return $this->container['volume'];
    }

    /**
     * Sets volume
     *
     * @param float|null $volume volume
     *
     * @return self
     */
    public function setVolume($volume)
    {
        if (is_null($volume)) {
            throw new \InvalidArgumentException('non-nullable volume cannot be null');
        }
        $this->container['volume'] = $volume;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            throw new \InvalidArgumentException('non-nullable weight cannot be null');
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        if (is_null($comments)) {
            throw new \InvalidArgumentException('non-nullable comments cannot be null');
        }
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets average_landed_price_at_time_of_sale
     *
     * @return int|null
     */
    public function getAverageLandedPriceAtTimeOfSale()
    {
        return $this->container['average_landed_price_at_time_of_sale'];
    }

    /**
     * Sets average_landed_price_at_time_of_sale
     *
     * @param int|null $average_landed_price_at_time_of_sale average_landed_price_at_time_of_sale
     *
     * @return self
     */
    public function setAverageLandedPriceAtTimeOfSale($average_landed_price_at_time_of_sale)
    {
        if (is_null($average_landed_price_at_time_of_sale)) {
            throw new \InvalidArgumentException('non-nullable average_landed_price_at_time_of_sale cannot be null');
        }
        $this->container['average_landed_price_at_time_of_sale'] = $average_landed_price_at_time_of_sale;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets line_tax
     *
     * @return float|null
     */
    public function getLineTax()
    {
        return $this->container['line_tax'];
    }

    /**
     * Sets line_tax
     *
     * @param float|null $line_tax line_tax
     *
     * @return self
     */
    public function setLineTax($line_tax)
    {
        if (is_null($line_tax)) {
            throw new \InvalidArgumentException('non-nullable line_tax cannot be null');
        }
        $this->container['line_tax'] = $line_tax;

        return $this;
    }

    /**
     * Gets xero_tax_code
     *
     * @return string|null
     */
    public function getXeroTaxCode()
    {
        return $this->container['xero_tax_code'];
    }

    /**
     * Sets xero_tax_code
     *
     * @param string|null $xero_tax_code xero_tax_code
     *
     * @return self
     */
    public function setXeroTaxCode($xero_tax_code)
    {
        if (is_null($xero_tax_code)) {
            throw new \InvalidArgumentException('non-nullable xero_tax_code cannot be null');
        }
        $this->container['xero_tax_code'] = $xero_tax_code;

        return $this;
    }

    /**
     * Gets bc_unit_price
     *
     * @return float|null
     */
    public function getBcUnitPrice()
    {
        return $this->container['bc_unit_price'];
    }

    /**
     * Sets bc_unit_price
     *
     * @param float|null $bc_unit_price bc_unit_price
     *
     * @return self
     */
    public function setBcUnitPrice($bc_unit_price)
    {
        if (is_null($bc_unit_price)) {
            throw new \InvalidArgumentException('non-nullable bc_unit_price cannot be null');
        }
        $this->container['bc_unit_price'] = $bc_unit_price;

        return $this;
    }

    /**
     * Gets bc_line_total
     *
     * @return float|null
     */
    public function getBcLineTotal()
    {
        return $this->container['bc_line_total'];
    }

    /**
     * Sets bc_line_total
     *
     * @param float|null $bc_line_total bc_line_total
     *
     * @return self
     */
    public function setBcLineTotal($bc_line_total)
    {
        if (is_null($bc_line_total)) {
            throw new \InvalidArgumentException('non-nullable bc_line_total cannot be null');
        }
        $this->container['bc_line_total'] = $bc_line_total;

        return $this;
    }

    /**
     * Gets bc_line_tax
     *
     * @return float|null
     */
    public function getBcLineTax()
    {
        return $this->container['bc_line_tax'];
    }

    /**
     * Sets bc_line_tax
     *
     * @param float|null $bc_line_tax bc_line_tax
     *
     * @return self
     */
    public function setBcLineTax($bc_line_tax)
    {
        if (is_null($bc_line_tax)) {
            throw new \InvalidArgumentException('non-nullable bc_line_tax cannot be null');
        }
        $this->container['bc_line_tax'] = $bc_line_tax;

        return $this;
    }

    /**
     * Gets line_tax_code
     *
     * @return string|null
     */
    public function getLineTaxCode()
    {
        return $this->container['line_tax_code'];
    }

    /**
     * Sets line_tax_code
     *
     * @param string|null $line_tax_code line_tax_code
     *
     * @return self
     */
    public function setLineTaxCode($line_tax_code)
    {
        if (is_null($line_tax_code)) {
            throw new \InvalidArgumentException('non-nullable line_tax_code cannot be null');
        }
        $this->container['line_tax_code'] = $line_tax_code;

        return $this;
    }

    /**
     * Gets xero_sales_account
     *
     * @return string|null
     */
    public function getXeroSalesAccount()
    {
        return $this->container['xero_sales_account'];
    }

    /**
     * Sets xero_sales_account
     *
     * @param string|null $xero_sales_account xero_sales_account
     *
     * @return self
     */
    public function setXeroSalesAccount($xero_sales_account)
    {
        if (is_null($xero_sales_account)) {
            throw new \InvalidArgumentException('non-nullable xero_sales_account cannot be null');
        }
        $this->container['xero_sales_account'] = $xero_sales_account;

        return $this;
    }

    /**
     * Gets serial_numbers
     *
     * @return \Unleashed\Model\SerialNumber[]|null
     */
    public function getSerialNumbers()
    {
        return $this->container['serial_numbers'];
    }

    /**
     * Sets serial_numbers
     *
     * @param \Unleashed\Model\SerialNumber[]|null $serial_numbers serial_numbers
     *
     * @return self
     */
    public function setSerialNumbers($serial_numbers)
    {
        if (is_null($serial_numbers)) {
            throw new \InvalidArgumentException('non-nullable serial_numbers cannot be null');
        }
        $this->container['serial_numbers'] = $serial_numbers;

        return $this;
    }

    /**
     * Gets batch_numbers
     *
     * @return \Unleashed\Model\BatchNumber[]|null
     */
    public function getBatchNumbers()
    {
        return $this->container['batch_numbers'];
    }

    /**
     * Sets batch_numbers
     *
     * @param \Unleashed\Model\BatchNumber[]|null $batch_numbers batch_numbers
     *
     * @return self
     */
    public function setBatchNumbers($batch_numbers)
    {
        if (is_null($batch_numbers)) {
            throw new \InvalidArgumentException('non-nullable batch_numbers cannot be null');
        }
        $this->container['batch_numbers'] = $batch_numbers;

        return $this;
    }

    /**
     * Gets assembly
     *
     * @return \Unleashed\Model\Assembly|null
     */
    public function getAssembly()
    {
        return $this->container['assembly'];
    }

    /**
     * Sets assembly
     *
     * @param \Unleashed\Model\Assembly|null $assembly assembly
     *
     * @return self
     */
    public function setAssembly($assembly)
    {
        if (is_null($assembly)) {
            throw new \InvalidArgumentException('non-nullable assembly cannot be null');
        }
        $this->container['assembly'] = $assembly;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


