<?php
/**
 * PurchaseOrderCosts
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * PurchaseOrderCosts Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PurchaseOrderCosts implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'purchaseOrderCosts';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'applied_distribution_method' => 'string',
        'distribution_method' => 'string',
        'cost' => 'float',
        'tax_cost' => 'float',
        'total_cost' => 'float',
        'bc_cost' => 'float',
        'bc_tax_cost' => 'float',
        'bc_total_cost' => 'float',
        'cost_date' => '\DateTime',
        'cost_exchange_rate' => 'float',
        'order_exchange_rate' => 'float',
        'currency' => 'string',
        'reference' => 'string',
        'tax_code' => 'string',
        'tax_rate' => 'float',
        'receipted' => 'bool',
        'supplier' => '\Unleashed\Model\Supplier'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'applied_distribution_method' => null,
        'distribution_method' => null,
        'cost' => null,
        'tax_cost' => null,
        'total_cost' => null,
        'bc_cost' => null,
        'bc_tax_cost' => null,
        'bc_total_cost' => null,
        'cost_date' => 'date-time',
        'cost_exchange_rate' => null,
        'order_exchange_rate' => null,
        'currency' => null,
        'reference' => null,
        'tax_code' => null,
        'tax_rate' => null,
        'receipted' => null,
        'supplier' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'applied_distribution_method' => false,
        'distribution_method' => false,
        'cost' => false,
        'tax_cost' => false,
        'total_cost' => true,
        'bc_cost' => true,
        'bc_tax_cost' => true,
        'bc_total_cost' => true,
        'cost_date' => true,
        'cost_exchange_rate' => true,
        'order_exchange_rate' => true,
        'currency' => false,
        'reference' => false,
        'tax_code' => false,
        'tax_rate' => true,
        'receipted' => false,
        'supplier' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'applied_distribution_method' => 'AppliedDistributionMethod',
        'distribution_method' => 'DistributionMethod',
        'cost' => 'Cost',
        'tax_cost' => 'TaxCost',
        'total_cost' => 'TotalCost',
        'bc_cost' => 'BCCost',
        'bc_tax_cost' => 'BCTaxCost',
        'bc_total_cost' => 'BCTotalCost',
        'cost_date' => 'CostDate',
        'cost_exchange_rate' => 'CostExchangeRate',
        'order_exchange_rate' => 'OrderExchangeRate',
        'currency' => 'Currency',
        'reference' => 'Reference',
        'tax_code' => 'TaxCode',
        'tax_rate' => 'TaxRate',
        'receipted' => 'Receipted',
        'supplier' => 'Supplier'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'applied_distribution_method' => 'setAppliedDistributionMethod',
        'distribution_method' => 'setDistributionMethod',
        'cost' => 'setCost',
        'tax_cost' => 'setTaxCost',
        'total_cost' => 'setTotalCost',
        'bc_cost' => 'setBcCost',
        'bc_tax_cost' => 'setBcTaxCost',
        'bc_total_cost' => 'setBcTotalCost',
        'cost_date' => 'setCostDate',
        'cost_exchange_rate' => 'setCostExchangeRate',
        'order_exchange_rate' => 'setOrderExchangeRate',
        'currency' => 'setCurrency',
        'reference' => 'setReference',
        'tax_code' => 'setTaxCode',
        'tax_rate' => 'setTaxRate',
        'receipted' => 'setReceipted',
        'supplier' => 'setSupplier'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'applied_distribution_method' => 'getAppliedDistributionMethod',
        'distribution_method' => 'getDistributionMethod',
        'cost' => 'getCost',
        'tax_cost' => 'getTaxCost',
        'total_cost' => 'getTotalCost',
        'bc_cost' => 'getBcCost',
        'bc_tax_cost' => 'getBcTaxCost',
        'bc_total_cost' => 'getBcTotalCost',
        'cost_date' => 'getCostDate',
        'cost_exchange_rate' => 'getCostExchangeRate',
        'order_exchange_rate' => 'getOrderExchangeRate',
        'currency' => 'getCurrency',
        'reference' => 'getReference',
        'tax_code' => 'getTaxCode',
        'tax_rate' => 'getTaxRate',
        'receipted' => 'getReceipted',
        'supplier' => 'getSupplier'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('applied_distribution_method', $data ?? [], null);
        $this->setIfExists('distribution_method', $data ?? [], null);
        $this->setIfExists('cost', $data ?? [], null);
        $this->setIfExists('tax_cost', $data ?? [], null);
        $this->setIfExists('total_cost', $data ?? [], null);
        $this->setIfExists('bc_cost', $data ?? [], null);
        $this->setIfExists('bc_tax_cost', $data ?? [], null);
        $this->setIfExists('bc_total_cost', $data ?? [], null);
        $this->setIfExists('cost_date', $data ?? [], null);
        $this->setIfExists('cost_exchange_rate', $data ?? [], null);
        $this->setIfExists('order_exchange_rate', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('reference', $data ?? [], null);
        $this->setIfExists('tax_code', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('receipted', $data ?? [], null);
        $this->setIfExists('supplier', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        if (!is_null($this->container['applied_distribution_method']) && (mb_strlen($this->container['applied_distribution_method']) > 15)) {
            $invalidProperties[] = "invalid value for 'applied_distribution_method', the character length must be smaller than or equal to 15.";
        }

        if (!is_null($this->container['distribution_method']) && (mb_strlen($this->container['distribution_method']) > 15)) {
            $invalidProperties[] = "invalid value for 'distribution_method', the character length must be smaller than or equal to 15.";
        }

        if (!is_null($this->container['currency']) && (mb_strlen($this->container['currency']) > 3)) {
            $invalidProperties[] = "invalid value for 'currency', the character length must be smaller than or equal to 3.";
        }

        if (!is_null($this->container['reference']) && (mb_strlen($this->container['reference']) > 200)) {
            $invalidProperties[] = "invalid value for 'reference', the character length must be smaller than or equal to 200.";
        }

        if (!is_null($this->container['tax_code']) && (mb_strlen($this->container['tax_code']) > 50)) {
            $invalidProperties[] = "invalid value for 'tax_code', the character length must be smaller than or equal to 50.";
        }

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets applied_distribution_method
     *
     * @return string|null
     */
    public function getAppliedDistributionMethod()
    {
        return $this->container['applied_distribution_method'];
    }

    /**
     * Sets applied_distribution_method
     *
     * @param string|null $applied_distribution_method Method used to distribute costs
     *
     * @return self
     */
    public function setAppliedDistributionMethod($applied_distribution_method)
    {
        if (is_null($applied_distribution_method)) {
            throw new \InvalidArgumentException('non-nullable applied_distribution_method cannot be null');
        }
        if ((mb_strlen($applied_distribution_method) > 15)) {
            throw new \InvalidArgumentException('invalid length for $applied_distribution_method when calling PurchaseOrderCosts., must be smaller than or equal to 15.');
        }

        $this->container['applied_distribution_method'] = $applied_distribution_method;

        return $this;
    }

    /**
     * Gets distribution_method
     *
     * @return string|null
     */
    public function getDistributionMethod()
    {
        return $this->container['distribution_method'];
    }

    /**
     * Sets distribution_method
     *
     * @param string|null $distribution_method Distribution method
     *
     * @return self
     */
    public function setDistributionMethod($distribution_method)
    {
        if (is_null($distribution_method)) {
            throw new \InvalidArgumentException('non-nullable distribution_method cannot be null');
        }
        if ((mb_strlen($distribution_method) > 15)) {
            throw new \InvalidArgumentException('invalid length for $distribution_method when calling PurchaseOrderCosts., must be smaller than or equal to 15.');
        }

        $this->container['distribution_method'] = $distribution_method;

        return $this;
    }

    /**
     * Gets cost
     *
     * @return float|null
     */
    public function getCost()
    {
        return $this->container['cost'];
    }

    /**
     * Sets cost
     *
     * @param float|null $cost Cost amount
     *
     * @return self
     */
    public function setCost($cost)
    {
        if (is_null($cost)) {
            throw new \InvalidArgumentException('non-nullable cost cannot be null');
        }
        $this->container['cost'] = $cost;

        return $this;
    }

    /**
     * Gets tax_cost
     *
     * @return float|null
     */
    public function getTaxCost()
    {
        return $this->container['tax_cost'];
    }

    /**
     * Sets tax_cost
     *
     * @param float|null $tax_cost Tax on cost
     *
     * @return self
     */
    public function setTaxCost($tax_cost)
    {
        if (is_null($tax_cost)) {
            throw new \InvalidArgumentException('non-nullable tax_cost cannot be null');
        }
        $this->container['tax_cost'] = $tax_cost;

        return $this;
    }

    /**
     * Gets total_cost
     *
     * @return float|null
     */
    public function getTotalCost()
    {
        return $this->container['total_cost'];
    }

    /**
     * Sets total_cost
     *
     * @param float|null $total_cost Total cost amount
     *
     * @return self
     */
    public function setTotalCost($total_cost)
    {
        if (is_null($total_cost)) {
            array_push($this->openAPINullablesSetToNull, 'total_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('total_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['total_cost'] = $total_cost;

        return $this;
    }

    /**
     * Gets bc_cost
     *
     * @return float|null
     */
    public function getBcCost()
    {
        return $this->container['bc_cost'];
    }

    /**
     * Sets bc_cost
     *
     * @param float|null $bc_cost Base currency cost
     *
     * @return self
     */
    public function setBcCost($bc_cost)
    {
        if (is_null($bc_cost)) {
            array_push($this->openAPINullablesSetToNull, 'bc_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bc_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bc_cost'] = $bc_cost;

        return $this;
    }

    /**
     * Gets bc_tax_cost
     *
     * @return float|null
     */
    public function getBcTaxCost()
    {
        return $this->container['bc_tax_cost'];
    }

    /**
     * Sets bc_tax_cost
     *
     * @param float|null $bc_tax_cost Base currency tax cost
     *
     * @return self
     */
    public function setBcTaxCost($bc_tax_cost)
    {
        if (is_null($bc_tax_cost)) {
            array_push($this->openAPINullablesSetToNull, 'bc_tax_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bc_tax_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bc_tax_cost'] = $bc_tax_cost;

        return $this;
    }

    /**
     * Gets bc_total_cost
     *
     * @return float|null
     */
    public function getBcTotalCost()
    {
        return $this->container['bc_total_cost'];
    }

    /**
     * Sets bc_total_cost
     *
     * @param float|null $bc_total_cost Base currency total cost
     *
     * @return self
     */
    public function setBcTotalCost($bc_total_cost)
    {
        if (is_null($bc_total_cost)) {
            array_push($this->openAPINullablesSetToNull, 'bc_total_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('bc_total_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['bc_total_cost'] = $bc_total_cost;

        return $this;
    }

    /**
     * Gets cost_date
     *
     * @return \DateTime|null
     */
    public function getCostDate()
    {
        return $this->container['cost_date'];
    }

    /**
     * Sets cost_date
     *
     * @param \DateTime|null $cost_date Date of cost
     *
     * @return self
     */
    public function setCostDate($cost_date)
    {
        if (is_null($cost_date)) {
            array_push($this->openAPINullablesSetToNull, 'cost_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cost_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cost_date'] = $cost_date;

        return $this;
    }

    /**
     * Gets cost_exchange_rate
     *
     * @return float|null
     */
    public function getCostExchangeRate()
    {
        return $this->container['cost_exchange_rate'];
    }

    /**
     * Sets cost_exchange_rate
     *
     * @param float|null $cost_exchange_rate Exchange rate for cost
     *
     * @return self
     */
    public function setCostExchangeRate($cost_exchange_rate)
    {
        if (is_null($cost_exchange_rate)) {
            array_push($this->openAPINullablesSetToNull, 'cost_exchange_rate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('cost_exchange_rate', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['cost_exchange_rate'] = $cost_exchange_rate;

        return $this;
    }

    /**
     * Gets order_exchange_rate
     *
     * @return float|null
     */
    public function getOrderExchangeRate()
    {
        return $this->container['order_exchange_rate'];
    }

    /**
     * Sets order_exchange_rate
     *
     * @param float|null $order_exchange_rate Order exchange rate
     *
     * @return self
     */
    public function setOrderExchangeRate($order_exchange_rate)
    {
        if (is_null($order_exchange_rate)) {
            array_push($this->openAPINullablesSetToNull, 'order_exchange_rate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('order_exchange_rate', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['order_exchange_rate'] = $order_exchange_rate;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param string|null $currency Currency code
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        if ((mb_strlen($currency) > 3)) {
            throw new \InvalidArgumentException('invalid length for $currency when calling PurchaseOrderCosts., must be smaller than or equal to 3.');
        }

        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets reference
     *
     * @return string|null
     */
    public function getReference()
    {
        return $this->container['reference'];
    }

    /**
     * Sets reference
     *
     * @param string|null $reference Cost reference
     *
     * @return self
     */
    public function setReference($reference)
    {
        if (is_null($reference)) {
            throw new \InvalidArgumentException('non-nullable reference cannot be null');
        }
        if ((mb_strlen($reference) > 200)) {
            throw new \InvalidArgumentException('invalid length for $reference when calling PurchaseOrderCosts., must be smaller than or equal to 200.');
        }

        $this->container['reference'] = $reference;

        return $this;
    }

    /**
     * Gets tax_code
     *
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->container['tax_code'];
    }

    /**
     * Sets tax_code
     *
     * @param string|null $tax_code Tax code
     *
     * @return self
     */
    public function setTaxCode($tax_code)
    {
        if (is_null($tax_code)) {
            throw new \InvalidArgumentException('non-nullable tax_code cannot be null');
        }
        if ((mb_strlen($tax_code) > 50)) {
            throw new \InvalidArgumentException('invalid length for $tax_code when calling PurchaseOrderCosts., must be smaller than or equal to 50.');
        }

        $this->container['tax_code'] = $tax_code;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate Tax rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            array_push($this->openAPINullablesSetToNull, 'tax_rate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('tax_rate', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets receipted
     *
     * @return bool|null
     */
    public function getReceipted()
    {
        return $this->container['receipted'];
    }

    /**
     * Sets receipted
     *
     * @param bool|null $receipted Whether cost has been receipted
     *
     * @return self
     */
    public function setReceipted($receipted)
    {
        if (is_null($receipted)) {
            throw new \InvalidArgumentException('non-nullable receipted cannot be null');
        }
        $this->container['receipted'] = $receipted;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return \Unleashed\Model\Supplier|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param \Unleashed\Model\Supplier|null $supplier supplier
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        if (is_null($supplier)) {
            throw new \InvalidArgumentException('non-nullable supplier cannot be null');
        }
        $this->container['supplier'] = $supplier;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


