<?php
/**
 * PurchaseOrder
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * PurchaseOrder Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class PurchaseOrder implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'purchaseOrder';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'order_number' => 'string',
        'order_date' => 'string',
        'delivery_date' => 'string',
        'completed_date' => 'string',
        'supplier' => '\Unleashed\Model\Supplier',
        'supplier_ref' => 'string',
        'supplier_eori' => 'string',
        'comments' => 'string',
        'printed' => 'bool',
        'order_status' => 'string',
        'custom_order_status' => 'string',
        'received_date' => 'string',
        'delivery_name' => 'string',
        'delivery_street_address' => 'string',
        'delivery_street_address2' => 'string',
        'delivery_suburb' => 'string',
        'delivery_region' => 'string',
        'delivery_city' => 'string',
        'delivery_country' => 'string',
        'delivery_post_code' => 'string',
        'currency' => '\Unleashed\Model\Currency',
        'exchange_rate' => 'int',
        'tax' => '\Unleashed\Model\Tax',
        'tax_rate' => 'float',
        'xero_tax_code' => 'string',
        'tax_code' => 'string',
        'sub_total' => 'float',
        'tax_total' => 'float',
        'total' => 'float',
        'total_volume' => 'float',
        'total_weight' => 'float',
        'supplier_invoice_date' => 'string',
        'bc_sub_total' => 'float',
        'bc_tax_total' => 'float',
        'bc_total' => 'float',
        'purchase_order_lines' => '\Unleashed\Model\PurchaseOrderPurchaseOrderLinesInner[]',
        'warehouse' => '\Unleashed\Model\Warehouse',
        'discount_rate' => 'float',
        'sales_orders' => '\Unleashed\Model\SalesOrder',
        'created_on' => 'string',
        'created_by' => 'string',
        'last_modified_by' => 'string',
        'guid' => 'string',
        'last_modified_on' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'order_number' => null,
        'order_date' => null,
        'delivery_date' => null,
        'completed_date' => null,
        'supplier' => null,
        'supplier_ref' => null,
        'supplier_eori' => null,
        'comments' => null,
        'printed' => null,
        'order_status' => null,
        'custom_order_status' => null,
        'received_date' => null,
        'delivery_name' => null,
        'delivery_street_address' => null,
        'delivery_street_address2' => null,
        'delivery_suburb' => null,
        'delivery_region' => null,
        'delivery_city' => null,
        'delivery_country' => null,
        'delivery_post_code' => null,
        'currency' => null,
        'exchange_rate' => null,
        'tax' => null,
        'tax_rate' => null,
        'xero_tax_code' => null,
        'tax_code' => null,
        'sub_total' => null,
        'tax_total' => null,
        'total' => null,
        'total_volume' => null,
        'total_weight' => null,
        'supplier_invoice_date' => null,
        'bc_sub_total' => null,
        'bc_tax_total' => null,
        'bc_total' => null,
        'purchase_order_lines' => null,
        'warehouse' => null,
        'discount_rate' => null,
        'sales_orders' => null,
        'created_on' => null,
        'created_by' => null,
        'last_modified_by' => null,
        'guid' => null,
        'last_modified_on' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'order_number' => false,
        'order_date' => false,
        'delivery_date' => false,
        'completed_date' => false,
        'supplier' => false,
        'supplier_ref' => false,
        'supplier_eori' => false,
        'comments' => false,
        'printed' => true,
        'order_status' => false,
        'custom_order_status' => false,
        'received_date' => true,
        'delivery_name' => false,
        'delivery_street_address' => false,
        'delivery_street_address2' => false,
        'delivery_suburb' => false,
        'delivery_region' => false,
        'delivery_city' => false,
        'delivery_country' => false,
        'delivery_post_code' => false,
        'currency' => false,
        'exchange_rate' => false,
        'tax' => false,
        'tax_rate' => false,
        'xero_tax_code' => false,
        'tax_code' => false,
        'sub_total' => false,
        'tax_total' => false,
        'total' => false,
        'total_volume' => false,
        'total_weight' => false,
        'supplier_invoice_date' => true,
        'bc_sub_total' => false,
        'bc_tax_total' => false,
        'bc_total' => false,
        'purchase_order_lines' => false,
        'warehouse' => false,
        'discount_rate' => false,
        'sales_orders' => false,
        'created_on' => false,
        'created_by' => false,
        'last_modified_by' => false,
        'guid' => false,
        'last_modified_on' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'order_number' => 'OrderNumber',
        'order_date' => 'OrderDate',
        'delivery_date' => 'DeliveryDate',
        'completed_date' => 'CompletedDate',
        'supplier' => 'Supplier',
        'supplier_ref' => 'SupplierRef',
        'supplier_eori' => 'SupplierEORI',
        'comments' => 'Comments',
        'printed' => 'Printed',
        'order_status' => 'OrderStatus',
        'custom_order_status' => 'CustomOrderStatus',
        'received_date' => 'ReceivedDate',
        'delivery_name' => 'DeliveryName',
        'delivery_street_address' => 'DeliveryStreetAddress',
        'delivery_street_address2' => 'DeliveryStreetAddress2',
        'delivery_suburb' => 'DeliverySuburb',
        'delivery_region' => 'DeliveryRegion',
        'delivery_city' => 'DeliveryCity',
        'delivery_country' => 'DeliveryCountry',
        'delivery_post_code' => 'DeliveryPostCode',
        'currency' => 'Currency',
        'exchange_rate' => 'ExchangeRate',
        'tax' => 'Tax',
        'tax_rate' => 'TaxRate',
        'xero_tax_code' => 'XeroTaxCode',
        'tax_code' => 'TaxCode',
        'sub_total' => 'SubTotal',
        'tax_total' => 'TaxTotal',
        'total' => 'Total',
        'total_volume' => 'TotalVolume',
        'total_weight' => 'TotalWeight',
        'supplier_invoice_date' => 'SupplierInvoiceDate',
        'bc_sub_total' => 'BCSubTotal',
        'bc_tax_total' => 'BCTaxTotal',
        'bc_total' => 'BCTotal',
        'purchase_order_lines' => 'PurchaseOrderLines',
        'warehouse' => 'Warehouse',
        'discount_rate' => 'DiscountRate',
        'sales_orders' => 'SalesOrders',
        'created_on' => 'CreatedOn',
        'created_by' => 'CreatedBy',
        'last_modified_by' => 'LastModifiedBy',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'order_number' => 'setOrderNumber',
        'order_date' => 'setOrderDate',
        'delivery_date' => 'setDeliveryDate',
        'completed_date' => 'setCompletedDate',
        'supplier' => 'setSupplier',
        'supplier_ref' => 'setSupplierRef',
        'supplier_eori' => 'setSupplierEori',
        'comments' => 'setComments',
        'printed' => 'setPrinted',
        'order_status' => 'setOrderStatus',
        'custom_order_status' => 'setCustomOrderStatus',
        'received_date' => 'setReceivedDate',
        'delivery_name' => 'setDeliveryName',
        'delivery_street_address' => 'setDeliveryStreetAddress',
        'delivery_street_address2' => 'setDeliveryStreetAddress2',
        'delivery_suburb' => 'setDeliverySuburb',
        'delivery_region' => 'setDeliveryRegion',
        'delivery_city' => 'setDeliveryCity',
        'delivery_country' => 'setDeliveryCountry',
        'delivery_post_code' => 'setDeliveryPostCode',
        'currency' => 'setCurrency',
        'exchange_rate' => 'setExchangeRate',
        'tax' => 'setTax',
        'tax_rate' => 'setTaxRate',
        'xero_tax_code' => 'setXeroTaxCode',
        'tax_code' => 'setTaxCode',
        'sub_total' => 'setSubTotal',
        'tax_total' => 'setTaxTotal',
        'total' => 'setTotal',
        'total_volume' => 'setTotalVolume',
        'total_weight' => 'setTotalWeight',
        'supplier_invoice_date' => 'setSupplierInvoiceDate',
        'bc_sub_total' => 'setBcSubTotal',
        'bc_tax_total' => 'setBcTaxTotal',
        'bc_total' => 'setBcTotal',
        'purchase_order_lines' => 'setPurchaseOrderLines',
        'warehouse' => 'setWarehouse',
        'discount_rate' => 'setDiscountRate',
        'sales_orders' => 'setSalesOrders',
        'created_on' => 'setCreatedOn',
        'created_by' => 'setCreatedBy',
        'last_modified_by' => 'setLastModifiedBy',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'order_number' => 'getOrderNumber',
        'order_date' => 'getOrderDate',
        'delivery_date' => 'getDeliveryDate',
        'completed_date' => 'getCompletedDate',
        'supplier' => 'getSupplier',
        'supplier_ref' => 'getSupplierRef',
        'supplier_eori' => 'getSupplierEori',
        'comments' => 'getComments',
        'printed' => 'getPrinted',
        'order_status' => 'getOrderStatus',
        'custom_order_status' => 'getCustomOrderStatus',
        'received_date' => 'getReceivedDate',
        'delivery_name' => 'getDeliveryName',
        'delivery_street_address' => 'getDeliveryStreetAddress',
        'delivery_street_address2' => 'getDeliveryStreetAddress2',
        'delivery_suburb' => 'getDeliverySuburb',
        'delivery_region' => 'getDeliveryRegion',
        'delivery_city' => 'getDeliveryCity',
        'delivery_country' => 'getDeliveryCountry',
        'delivery_post_code' => 'getDeliveryPostCode',
        'currency' => 'getCurrency',
        'exchange_rate' => 'getExchangeRate',
        'tax' => 'getTax',
        'tax_rate' => 'getTaxRate',
        'xero_tax_code' => 'getXeroTaxCode',
        'tax_code' => 'getTaxCode',
        'sub_total' => 'getSubTotal',
        'tax_total' => 'getTaxTotal',
        'total' => 'getTotal',
        'total_volume' => 'getTotalVolume',
        'total_weight' => 'getTotalWeight',
        'supplier_invoice_date' => 'getSupplierInvoiceDate',
        'bc_sub_total' => 'getBcSubTotal',
        'bc_tax_total' => 'getBcTaxTotal',
        'bc_total' => 'getBcTotal',
        'purchase_order_lines' => 'getPurchaseOrderLines',
        'warehouse' => 'getWarehouse',
        'discount_rate' => 'getDiscountRate',
        'sales_orders' => 'getSalesOrders',
        'created_on' => 'getCreatedOn',
        'created_by' => 'getCreatedBy',
        'last_modified_by' => 'getLastModifiedBy',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('order_number', $data ?? [], null);
        $this->setIfExists('order_date', $data ?? [], null);
        $this->setIfExists('delivery_date', $data ?? [], null);
        $this->setIfExists('completed_date', $data ?? [], null);
        $this->setIfExists('supplier', $data ?? [], null);
        $this->setIfExists('supplier_ref', $data ?? [], null);
        $this->setIfExists('supplier_eori', $data ?? [], null);
        $this->setIfExists('comments', $data ?? [], null);
        $this->setIfExists('printed', $data ?? [], null);
        $this->setIfExists('order_status', $data ?? [], null);
        $this->setIfExists('custom_order_status', $data ?? [], null);
        $this->setIfExists('received_date', $data ?? [], null);
        $this->setIfExists('delivery_name', $data ?? [], null);
        $this->setIfExists('delivery_street_address', $data ?? [], null);
        $this->setIfExists('delivery_street_address2', $data ?? [], null);
        $this->setIfExists('delivery_suburb', $data ?? [], null);
        $this->setIfExists('delivery_region', $data ?? [], null);
        $this->setIfExists('delivery_city', $data ?? [], null);
        $this->setIfExists('delivery_country', $data ?? [], null);
        $this->setIfExists('delivery_post_code', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('exchange_rate', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('xero_tax_code', $data ?? [], null);
        $this->setIfExists('tax_code', $data ?? [], null);
        $this->setIfExists('sub_total', $data ?? [], null);
        $this->setIfExists('tax_total', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('total_volume', $data ?? [], null);
        $this->setIfExists('total_weight', $data ?? [], null);
        $this->setIfExists('supplier_invoice_date', $data ?? [], null);
        $this->setIfExists('bc_sub_total', $data ?? [], null);
        $this->setIfExists('bc_tax_total', $data ?? [], null);
        $this->setIfExists('bc_total', $data ?? [], null);
        $this->setIfExists('purchase_order_lines', $data ?? [], null);
        $this->setIfExists('warehouse', $data ?? [], null);
        $this->setIfExists('discount_rate', $data ?? [], null);
        $this->setIfExists('sales_orders', $data ?? [], null);
        $this->setIfExists('created_on', $data ?? [], null);
        $this->setIfExists('created_by', $data ?? [], null);
        $this->setIfExists('last_modified_by', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets order_number
     *
     * @return string|null
     */
    public function getOrderNumber()
    {
        return $this->container['order_number'];
    }

    /**
     * Sets order_number
     *
     * @param string|null $order_number order_number
     *
     * @return self
     */
    public function setOrderNumber($order_number)
    {
        if (is_null($order_number)) {
            throw new \InvalidArgumentException('non-nullable order_number cannot be null');
        }
        $this->container['order_number'] = $order_number;

        return $this;
    }

    /**
     * Gets order_date
     *
     * @return string|null
     */
    public function getOrderDate()
    {
        return $this->container['order_date'];
    }

    /**
     * Sets order_date
     *
     * @param string|null $order_date order_date
     *
     * @return self
     */
    public function setOrderDate($order_date)
    {
        if (is_null($order_date)) {
            throw new \InvalidArgumentException('non-nullable order_date cannot be null');
        }
        $this->container['order_date'] = $order_date;

        return $this;
    }

    /**
     * Gets delivery_date
     *
     * @return string|null
     */
    public function getDeliveryDate()
    {
        return $this->container['delivery_date'];
    }

    /**
     * Sets delivery_date
     *
     * @param string|null $delivery_date delivery_date
     *
     * @return self
     */
    public function setDeliveryDate($delivery_date)
    {
        if (is_null($delivery_date)) {
            throw new \InvalidArgumentException('non-nullable delivery_date cannot be null');
        }
        $this->container['delivery_date'] = $delivery_date;

        return $this;
    }

    /**
     * Gets completed_date
     *
     * @return string|null
     */
    public function getCompletedDate()
    {
        return $this->container['completed_date'];
    }

    /**
     * Sets completed_date
     *
     * @param string|null $completed_date completed_date
     *
     * @return self
     */
    public function setCompletedDate($completed_date)
    {
        if (is_null($completed_date)) {
            throw new \InvalidArgumentException('non-nullable completed_date cannot be null');
        }
        $this->container['completed_date'] = $completed_date;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return \Unleashed\Model\Supplier|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param \Unleashed\Model\Supplier|null $supplier supplier
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        if (is_null($supplier)) {
            throw new \InvalidArgumentException('non-nullable supplier cannot be null');
        }
        $this->container['supplier'] = $supplier;

        return $this;
    }

    /**
     * Gets supplier_ref
     *
     * @return string|null
     */
    public function getSupplierRef()
    {
        return $this->container['supplier_ref'];
    }

    /**
     * Sets supplier_ref
     *
     * @param string|null $supplier_ref supplier_ref
     *
     * @return self
     */
    public function setSupplierRef($supplier_ref)
    {
        if (is_null($supplier_ref)) {
            throw new \InvalidArgumentException('non-nullable supplier_ref cannot be null');
        }
        $this->container['supplier_ref'] = $supplier_ref;

        return $this;
    }

    /**
     * Gets supplier_eori
     *
     * @return string|null
     */
    public function getSupplierEori()
    {
        return $this->container['supplier_eori'];
    }

    /**
     * Sets supplier_eori
     *
     * @param string|null $supplier_eori supplier_eori
     *
     * @return self
     */
    public function setSupplierEori($supplier_eori)
    {
        if (is_null($supplier_eori)) {
            throw new \InvalidArgumentException('non-nullable supplier_eori cannot be null');
        }
        $this->container['supplier_eori'] = $supplier_eori;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        if (is_null($comments)) {
            throw new \InvalidArgumentException('non-nullable comments cannot be null');
        }
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets printed
     *
     * @return bool|null
     */
    public function getPrinted()
    {
        return $this->container['printed'];
    }

    /**
     * Sets printed
     *
     * @param bool|null $printed printed
     *
     * @return self
     */
    public function setPrinted($printed)
    {
        if (is_null($printed)) {
            array_push($this->openAPINullablesSetToNull, 'printed');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('printed', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['printed'] = $printed;

        return $this;
    }

    /**
     * Gets order_status
     *
     * @return string|null
     */
    public function getOrderStatus()
    {
        return $this->container['order_status'];
    }

    /**
     * Sets order_status
     *
     * @param string|null $order_status order_status
     *
     * @return self
     */
    public function setOrderStatus($order_status)
    {
        if (is_null($order_status)) {
            throw new \InvalidArgumentException('non-nullable order_status cannot be null');
        }
        $this->container['order_status'] = $order_status;

        return $this;
    }

    /**
     * Gets custom_order_status
     *
     * @return string|null
     */
    public function getCustomOrderStatus()
    {
        return $this->container['custom_order_status'];
    }

    /**
     * Sets custom_order_status
     *
     * @param string|null $custom_order_status custom_order_status
     *
     * @return self
     */
    public function setCustomOrderStatus($custom_order_status)
    {
        if (is_null($custom_order_status)) {
            throw new \InvalidArgumentException('non-nullable custom_order_status cannot be null');
        }
        $this->container['custom_order_status'] = $custom_order_status;

        return $this;
    }

    /**
     * Gets received_date
     *
     * @return string|null
     */
    public function getReceivedDate()
    {
        return $this->container['received_date'];
    }

    /**
     * Sets received_date
     *
     * @param string|null $received_date received_date
     *
     * @return self
     */
    public function setReceivedDate($received_date)
    {
        if (is_null($received_date)) {
            array_push($this->openAPINullablesSetToNull, 'received_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('received_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['received_date'] = $received_date;

        return $this;
    }

    /**
     * Gets delivery_name
     *
     * @return string|null
     */
    public function getDeliveryName()
    {
        return $this->container['delivery_name'];
    }

    /**
     * Sets delivery_name
     *
     * @param string|null $delivery_name delivery_name
     *
     * @return self
     */
    public function setDeliveryName($delivery_name)
    {
        if (is_null($delivery_name)) {
            throw new \InvalidArgumentException('non-nullable delivery_name cannot be null');
        }
        $this->container['delivery_name'] = $delivery_name;

        return $this;
    }

    /**
     * Gets delivery_street_address
     *
     * @return string|null
     */
    public function getDeliveryStreetAddress()
    {
        return $this->container['delivery_street_address'];
    }

    /**
     * Sets delivery_street_address
     *
     * @param string|null $delivery_street_address delivery_street_address
     *
     * @return self
     */
    public function setDeliveryStreetAddress($delivery_street_address)
    {
        if (is_null($delivery_street_address)) {
            throw new \InvalidArgumentException('non-nullable delivery_street_address cannot be null');
        }
        $this->container['delivery_street_address'] = $delivery_street_address;

        return $this;
    }

    /**
     * Gets delivery_street_address2
     *
     * @return string|null
     */
    public function getDeliveryStreetAddress2()
    {
        return $this->container['delivery_street_address2'];
    }

    /**
     * Sets delivery_street_address2
     *
     * @param string|null $delivery_street_address2 delivery_street_address2
     *
     * @return self
     */
    public function setDeliveryStreetAddress2($delivery_street_address2)
    {
        if (is_null($delivery_street_address2)) {
            throw new \InvalidArgumentException('non-nullable delivery_street_address2 cannot be null');
        }
        $this->container['delivery_street_address2'] = $delivery_street_address2;

        return $this;
    }

    /**
     * Gets delivery_suburb
     *
     * @return string|null
     */
    public function getDeliverySuburb()
    {
        return $this->container['delivery_suburb'];
    }

    /**
     * Sets delivery_suburb
     *
     * @param string|null $delivery_suburb delivery_suburb
     *
     * @return self
     */
    public function setDeliverySuburb($delivery_suburb)
    {
        if (is_null($delivery_suburb)) {
            throw new \InvalidArgumentException('non-nullable delivery_suburb cannot be null');
        }
        $this->container['delivery_suburb'] = $delivery_suburb;

        return $this;
    }

    /**
     * Gets delivery_region
     *
     * @return string|null
     */
    public function getDeliveryRegion()
    {
        return $this->container['delivery_region'];
    }

    /**
     * Sets delivery_region
     *
     * @param string|null $delivery_region delivery_region
     *
     * @return self
     */
    public function setDeliveryRegion($delivery_region)
    {
        if (is_null($delivery_region)) {
            throw new \InvalidArgumentException('non-nullable delivery_region cannot be null');
        }
        $this->container['delivery_region'] = $delivery_region;

        return $this;
    }

    /**
     * Gets delivery_city
     *
     * @return string|null
     */
    public function getDeliveryCity()
    {
        return $this->container['delivery_city'];
    }

    /**
     * Sets delivery_city
     *
     * @param string|null $delivery_city delivery_city
     *
     * @return self
     */
    public function setDeliveryCity($delivery_city)
    {
        if (is_null($delivery_city)) {
            throw new \InvalidArgumentException('non-nullable delivery_city cannot be null');
        }
        $this->container['delivery_city'] = $delivery_city;

        return $this;
    }

    /**
     * Gets delivery_country
     *
     * @return string|null
     */
    public function getDeliveryCountry()
    {
        return $this->container['delivery_country'];
    }

    /**
     * Sets delivery_country
     *
     * @param string|null $delivery_country delivery_country
     *
     * @return self
     */
    public function setDeliveryCountry($delivery_country)
    {
        if (is_null($delivery_country)) {
            throw new \InvalidArgumentException('non-nullable delivery_country cannot be null');
        }
        $this->container['delivery_country'] = $delivery_country;

        return $this;
    }

    /**
     * Gets delivery_post_code
     *
     * @return string|null
     */
    public function getDeliveryPostCode()
    {
        return $this->container['delivery_post_code'];
    }

    /**
     * Sets delivery_post_code
     *
     * @param string|null $delivery_post_code delivery_post_code
     *
     * @return self
     */
    public function setDeliveryPostCode($delivery_post_code)
    {
        if (is_null($delivery_post_code)) {
            throw new \InvalidArgumentException('non-nullable delivery_post_code cannot be null');
        }
        $this->container['delivery_post_code'] = $delivery_post_code;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Unleashed\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Unleashed\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets exchange_rate
     *
     * @return int|null
     */
    public function getExchangeRate()
    {
        return $this->container['exchange_rate'];
    }

    /**
     * Sets exchange_rate
     *
     * @param int|null $exchange_rate exchange_rate
     *
     * @return self
     */
    public function setExchangeRate($exchange_rate)
    {
        if (is_null($exchange_rate)) {
            throw new \InvalidArgumentException('non-nullable exchange_rate cannot be null');
        }
        $this->container['exchange_rate'] = $exchange_rate;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return \Unleashed\Model\Tax|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param \Unleashed\Model\Tax|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets xero_tax_code
     *
     * @return string|null
     */
    public function getXeroTaxCode()
    {
        return $this->container['xero_tax_code'];
    }

    /**
     * Sets xero_tax_code
     *
     * @param string|null $xero_tax_code xero_tax_code
     *
     * @return self
     */
    public function setXeroTaxCode($xero_tax_code)
    {
        if (is_null($xero_tax_code)) {
            throw new \InvalidArgumentException('non-nullable xero_tax_code cannot be null');
        }
        $this->container['xero_tax_code'] = $xero_tax_code;

        return $this;
    }

    /**
     * Gets tax_code
     *
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->container['tax_code'];
    }

    /**
     * Sets tax_code
     *
     * @param string|null $tax_code tax_code
     *
     * @return self
     */
    public function setTaxCode($tax_code)
    {
        if (is_null($tax_code)) {
            throw new \InvalidArgumentException('non-nullable tax_code cannot be null');
        }
        $this->container['tax_code'] = $tax_code;

        return $this;
    }

    /**
     * Gets sub_total
     *
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param float|null $sub_total sub_total
     *
     * @return self
     */
    public function setSubTotal($sub_total)
    {
        if (is_null($sub_total)) {
            throw new \InvalidArgumentException('non-nullable sub_total cannot be null');
        }
        $this->container['sub_total'] = $sub_total;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param float|null $tax_total tax_total
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        if (is_null($tax_total)) {
            throw new \InvalidArgumentException('non-nullable tax_total cannot be null');
        }
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets total
     *
     * @return float|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param float|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets total_volume
     *
     * @return float|null
     */
    public function getTotalVolume()
    {
        return $this->container['total_volume'];
    }

    /**
     * Sets total_volume
     *
     * @param float|null $total_volume total_volume
     *
     * @return self
     */
    public function setTotalVolume($total_volume)
    {
        if (is_null($total_volume)) {
            throw new \InvalidArgumentException('non-nullable total_volume cannot be null');
        }
        $this->container['total_volume'] = $total_volume;

        return $this;
    }

    /**
     * Gets total_weight
     *
     * @return float|null
     */
    public function getTotalWeight()
    {
        return $this->container['total_weight'];
    }

    /**
     * Sets total_weight
     *
     * @param float|null $total_weight total_weight
     *
     * @return self
     */
    public function setTotalWeight($total_weight)
    {
        if (is_null($total_weight)) {
            throw new \InvalidArgumentException('non-nullable total_weight cannot be null');
        }
        $this->container['total_weight'] = $total_weight;

        return $this;
    }

    /**
     * Gets supplier_invoice_date
     *
     * @return string|null
     */
    public function getSupplierInvoiceDate()
    {
        return $this->container['supplier_invoice_date'];
    }

    /**
     * Sets supplier_invoice_date
     *
     * @param string|null $supplier_invoice_date supplier_invoice_date
     *
     * @return self
     */
    public function setSupplierInvoiceDate($supplier_invoice_date)
    {
        if (is_null($supplier_invoice_date)) {
            array_push($this->openAPINullablesSetToNull, 'supplier_invoice_date');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('supplier_invoice_date', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['supplier_invoice_date'] = $supplier_invoice_date;

        return $this;
    }

    /**
     * Gets bc_sub_total
     *
     * @return float|null
     */
    public function getBcSubTotal()
    {
        return $this->container['bc_sub_total'];
    }

    /**
     * Sets bc_sub_total
     *
     * @param float|null $bc_sub_total bc_sub_total
     *
     * @return self
     */
    public function setBcSubTotal($bc_sub_total)
    {
        if (is_null($bc_sub_total)) {
            throw new \InvalidArgumentException('non-nullable bc_sub_total cannot be null');
        }
        $this->container['bc_sub_total'] = $bc_sub_total;

        return $this;
    }

    /**
     * Gets bc_tax_total
     *
     * @return float|null
     */
    public function getBcTaxTotal()
    {
        return $this->container['bc_tax_total'];
    }

    /**
     * Sets bc_tax_total
     *
     * @param float|null $bc_tax_total bc_tax_total
     *
     * @return self
     */
    public function setBcTaxTotal($bc_tax_total)
    {
        if (is_null($bc_tax_total)) {
            throw new \InvalidArgumentException('non-nullable bc_tax_total cannot be null');
        }
        $this->container['bc_tax_total'] = $bc_tax_total;

        return $this;
    }

    /**
     * Gets bc_total
     *
     * @return float|null
     */
    public function getBcTotal()
    {
        return $this->container['bc_total'];
    }

    /**
     * Sets bc_total
     *
     * @param float|null $bc_total bc_total
     *
     * @return self
     */
    public function setBcTotal($bc_total)
    {
        if (is_null($bc_total)) {
            throw new \InvalidArgumentException('non-nullable bc_total cannot be null');
        }
        $this->container['bc_total'] = $bc_total;

        return $this;
    }

    /**
     * Gets purchase_order_lines
     *
     * @return \Unleashed\Model\PurchaseOrderPurchaseOrderLinesInner[]|null
     */
    public function getPurchaseOrderLines()
    {
        return $this->container['purchase_order_lines'];
    }

    /**
     * Sets purchase_order_lines
     *
     * @param \Unleashed\Model\PurchaseOrderPurchaseOrderLinesInner[]|null $purchase_order_lines purchase_order_lines
     *
     * @return self
     */
    public function setPurchaseOrderLines($purchase_order_lines)
    {
        if (is_null($purchase_order_lines)) {
            throw new \InvalidArgumentException('non-nullable purchase_order_lines cannot be null');
        }
        $this->container['purchase_order_lines'] = $purchase_order_lines;

        return $this;
    }

    /**
     * Gets warehouse
     *
     * @return \Unleashed\Model\Warehouse|null
     */
    public function getWarehouse()
    {
        return $this->container['warehouse'];
    }

    /**
     * Sets warehouse
     *
     * @param \Unleashed\Model\Warehouse|null $warehouse warehouse
     *
     * @return self
     */
    public function setWarehouse($warehouse)
    {
        if (is_null($warehouse)) {
            throw new \InvalidArgumentException('non-nullable warehouse cannot be null');
        }
        $this->container['warehouse'] = $warehouse;

        return $this;
    }

    /**
     * Gets discount_rate
     *
     * @return float|null
     */
    public function getDiscountRate()
    {
        return $this->container['discount_rate'];
    }

    /**
     * Sets discount_rate
     *
     * @param float|null $discount_rate discount_rate
     *
     * @return self
     */
    public function setDiscountRate($discount_rate)
    {
        if (is_null($discount_rate)) {
            throw new \InvalidArgumentException('non-nullable discount_rate cannot be null');
        }
        $this->container['discount_rate'] = $discount_rate;

        return $this;
    }

    /**
     * Gets sales_orders
     *
     * @return \Unleashed\Model\SalesOrder|null
     */
    public function getSalesOrders()
    {
        return $this->container['sales_orders'];
    }

    /**
     * Sets sales_orders
     *
     * @param \Unleashed\Model\SalesOrder|null $sales_orders sales_orders
     *
     * @return self
     */
    public function setSalesOrders($sales_orders)
    {
        if (is_null($sales_orders)) {
            throw new \InvalidArgumentException('non-nullable sales_orders cannot be null');
        }
        $this->container['sales_orders'] = $sales_orders;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        if (is_null($created_on)) {
            throw new \InvalidArgumentException('non-nullable created_on cannot be null');
        }
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        if (is_null($created_by)) {
            throw new \InvalidArgumentException('non-nullable created_by cannot be null');
        }
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        if (is_null($last_modified_by)) {
            throw new \InvalidArgumentException('non-nullable last_modified_by cannot be null');
        }
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


