<?php
/**
 * Product
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Product Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Product implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'product';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'product_code' => 'string',
        'product_description' => 'string',
        'barcode' => 'string',
        'pack_size' => 'float',
        'width' => 'float',
        'height' => 'float',
        'depth' => 'float',
        'weight' => 'float',
        'min_stock_alert_level' => 'float',
        'max_stock_alert_level' => 'float',
        're_order_point' => 'float',
        'unit_of_measure' => '\Unleashed\Model\UnitOfMeasure',
        'never_diminishing' => 'bool',
        'last_cost' => 'float',
        'default_purchase_price' => 'float',
        'default_sell_price' => 'float',
        'customer_sell_price' => 'float',
        'average_land_price' => 'float',
        'obsolete' => 'bool',
        'notes' => 'string',
        'image_url' => 'string',
        'sell_price_tier1' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier2' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier3' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier4' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier5' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier6' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier7' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier8' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier9' => '\Unleashed\Model\SellPriceTier',
        'sell_price_tier10' => '\Unleashed\Model\SellPriceTier',
        'xero_tax_code' => 'string',
        'xero_tax_rate' => 'float',
        'taxable_purchase' => 'bool',
        'taxable_sales' => 'bool',
        'xero_sales_tax_code' => 'string',
        'xero_sales_tax_rate' => 'float',
        'is_component' => 'bool',
        'is_assembled_product' => 'bool',
        'product_group' => '\Unleashed\Model\ProductGroup',
        'xero_sales_account' => 'string',
        'xero_cost_of_goods_account' => 'string',
        'purchase_account' => 'string',
        'bin_location' => 'string',
        'supplier' => '\Unleashed\Model\SupplierWithProductCode',
        'attribute_set' => '\Unleashed\Model\AttributeSet',
        'source_id' => 'string',
        'source_variant_parent_id' => 'string',
        'is_serialized' => 'bool',
        'is_batch_tracked' => 'bool',
        'is_sellable' => 'bool',
        'minimum_sell_price' => 'float',
        'minimum_sale_quantity' => 'float',
        'minimum_order_quantity' => 'float',
        'created_by' => 'string',
        'created_on' => 'string',
        'last_modified_by' => 'string',
        'guid' => 'string',
        'last_modified_on' => 'string',
        'images' => '\Unleashed\Model\Image[]',
        'product_brand' => '\Unleashed\Model\ProductBrand',
        'product_sub_group' => '\Unleashed\Model\ProductGroup',
        'comments' => 'string',
        'copy_comments_for_sales' => 'bool',
        'copy_comments_for_purchases' => 'bool',
        'alternate_units_of_measure' => '\Unleashed\Model\AlternateUnitOfMeasure[]',
        'automatic_charge_cost' => 'float',
        'commerce_code' => 'string',
        'customs_description' => 'string',
        'default_purchases_unit_of_measure' => '\Unleashed\Model\UnitOfMeasure',
        'icc_country_code' => 'string',
        'icc_country_name' => 'string',
        'is_purchasable' => 'bool',
        'nominal_cost' => 'float',
        'reminder' => 'string',
        'inventory_details' => '\Unleashed\Model\InventoryDetail[]',
        'supplementary_classification_abbreviation' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'product_code' => null,
        'product_description' => null,
        'barcode' => null,
        'pack_size' => null,
        'width' => null,
        'height' => null,
        'depth' => null,
        'weight' => null,
        'min_stock_alert_level' => null,
        'max_stock_alert_level' => null,
        're_order_point' => null,
        'unit_of_measure' => null,
        'never_diminishing' => null,
        'last_cost' => null,
        'default_purchase_price' => null,
        'default_sell_price' => null,
        'customer_sell_price' => null,
        'average_land_price' => null,
        'obsolete' => null,
        'notes' => null,
        'image_url' => null,
        'sell_price_tier1' => null,
        'sell_price_tier2' => null,
        'sell_price_tier3' => null,
        'sell_price_tier4' => null,
        'sell_price_tier5' => null,
        'sell_price_tier6' => null,
        'sell_price_tier7' => null,
        'sell_price_tier8' => null,
        'sell_price_tier9' => null,
        'sell_price_tier10' => null,
        'xero_tax_code' => null,
        'xero_tax_rate' => null,
        'taxable_purchase' => null,
        'taxable_sales' => null,
        'xero_sales_tax_code' => null,
        'xero_sales_tax_rate' => null,
        'is_component' => null,
        'is_assembled_product' => null,
        'product_group' => null,
        'xero_sales_account' => null,
        'xero_cost_of_goods_account' => null,
        'purchase_account' => null,
        'bin_location' => null,
        'supplier' => null,
        'attribute_set' => null,
        'source_id' => null,
        'source_variant_parent_id' => null,
        'is_serialized' => null,
        'is_batch_tracked' => null,
        'is_sellable' => null,
        'minimum_sell_price' => null,
        'minimum_sale_quantity' => null,
        'minimum_order_quantity' => null,
        'created_by' => null,
        'created_on' => null,
        'last_modified_by' => null,
        'guid' => null,
        'last_modified_on' => null,
        'images' => null,
        'product_brand' => null,
        'product_sub_group' => null,
        'comments' => null,
        'copy_comments_for_sales' => null,
        'copy_comments_for_purchases' => null,
        'alternate_units_of_measure' => null,
        'automatic_charge_cost' => null,
        'commerce_code' => null,
        'customs_description' => null,
        'default_purchases_unit_of_measure' => null,
        'icc_country_code' => null,
        'icc_country_name' => null,
        'is_purchasable' => null,
        'nominal_cost' => null,
        'reminder' => null,
        'inventory_details' => null,
        'supplementary_classification_abbreviation' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'product_code' => false,
        'product_description' => false,
        'barcode' => false,
        'pack_size' => true,
        'width' => true,
        'height' => true,
        'depth' => true,
        'weight' => true,
        'min_stock_alert_level' => true,
        'max_stock_alert_level' => true,
        're_order_point' => true,
        'unit_of_measure' => false,
        'never_diminishing' => true,
        'last_cost' => false,
        'default_purchase_price' => true,
        'default_sell_price' => true,
        'customer_sell_price' => true,
        'average_land_price' => true,
        'obsolete' => false,
        'notes' => false,
        'image_url' => false,
        'sell_price_tier1' => false,
        'sell_price_tier2' => false,
        'sell_price_tier3' => false,
        'sell_price_tier4' => false,
        'sell_price_tier5' => false,
        'sell_price_tier6' => false,
        'sell_price_tier7' => false,
        'sell_price_tier8' => false,
        'sell_price_tier9' => false,
        'sell_price_tier10' => false,
        'xero_tax_code' => false,
        'xero_tax_rate' => true,
        'taxable_purchase' => true,
        'taxable_sales' => true,
        'xero_sales_tax_code' => false,
        'xero_sales_tax_rate' => true,
        'is_component' => false,
        'is_assembled_product' => false,
        'product_group' => false,
        'xero_sales_account' => false,
        'xero_cost_of_goods_account' => false,
        'purchase_account' => false,
        'bin_location' => false,
        'supplier' => false,
        'attribute_set' => false,
        'source_id' => false,
        'source_variant_parent_id' => false,
        'is_serialized' => false,
        'is_batch_tracked' => false,
        'is_sellable' => false,
        'minimum_sell_price' => true,
        'minimum_sale_quantity' => true,
        'minimum_order_quantity' => true,
        'created_by' => false,
        'created_on' => true,
        'last_modified_by' => true,
        'guid' => false,
        'last_modified_on' => false,
        'images' => false,
        'product_brand' => false,
        'product_sub_group' => false,
        'comments' => false,
        'copy_comments_for_sales' => false,
        'copy_comments_for_purchases' => false,
        'alternate_units_of_measure' => false,
        'automatic_charge_cost' => true,
        'commerce_code' => false,
        'customs_description' => false,
        'default_purchases_unit_of_measure' => false,
        'icc_country_code' => false,
        'icc_country_name' => false,
        'is_purchasable' => false,
        'nominal_cost' => true,
        'reminder' => false,
        'inventory_details' => false,
        'supplementary_classification_abbreviation' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'product_code' => 'ProductCode',
        'product_description' => 'ProductDescription',
        'barcode' => 'Barcode',
        'pack_size' => 'PackSize',
        'width' => 'Width',
        'height' => 'Height',
        'depth' => 'Depth',
        'weight' => 'Weight',
        'min_stock_alert_level' => 'MinStockAlertLevel',
        'max_stock_alert_level' => 'MaxStockAlertLevel',
        're_order_point' => 'ReOrderPoint',
        'unit_of_measure' => 'UnitOfMeasure',
        'never_diminishing' => 'NeverDiminishing',
        'last_cost' => 'LastCost',
        'default_purchase_price' => 'DefaultPurchasePrice',
        'default_sell_price' => 'DefaultSellPrice',
        'customer_sell_price' => 'CustomerSellPrice',
        'average_land_price' => 'AverageLandPrice',
        'obsolete' => 'Obsolete',
        'notes' => 'Notes',
        'image_url' => 'ImageUrl',
        'sell_price_tier1' => 'SellPriceTier1',
        'sell_price_tier2' => 'SellPriceTier2',
        'sell_price_tier3' => 'SellPriceTier3',
        'sell_price_tier4' => 'SellPriceTier4',
        'sell_price_tier5' => 'SellPriceTier5',
        'sell_price_tier6' => 'SellPriceTier6',
        'sell_price_tier7' => 'SellPriceTier7',
        'sell_price_tier8' => 'SellPriceTier8',
        'sell_price_tier9' => 'SellPriceTier9',
        'sell_price_tier10' => 'SellPriceTier10',
        'xero_tax_code' => 'XeroTaxCode',
        'xero_tax_rate' => 'XeroTaxRate',
        'taxable_purchase' => 'TaxablePurchase',
        'taxable_sales' => 'TaxableSales',
        'xero_sales_tax_code' => 'XeroSalesTaxCode',
        'xero_sales_tax_rate' => 'XeroSalesTaxRate',
        'is_component' => 'IsComponent',
        'is_assembled_product' => 'IsAssembledProduct',
        'product_group' => 'ProductGroup',
        'xero_sales_account' => 'XeroSalesAccount',
        'xero_cost_of_goods_account' => 'XeroCostOfGoodsAccount',
        'purchase_account' => 'PurchaseAccount',
        'bin_location' => 'BinLocation',
        'supplier' => 'Supplier',
        'attribute_set' => 'AttributeSet',
        'source_id' => 'SourceId',
        'source_variant_parent_id' => 'SourceVariantParentId',
        'is_serialized' => 'IsSerialized',
        'is_batch_tracked' => 'IsBatchTracked',
        'is_sellable' => 'IsSellable',
        'minimum_sell_price' => 'MinimumSellPrice',
        'minimum_sale_quantity' => 'MinimumSaleQuantity',
        'minimum_order_quantity' => 'MinimumOrderQuantity',
        'created_by' => 'CreatedBy',
        'created_on' => 'CreatedOn',
        'last_modified_by' => 'LastModifiedBy',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn',
        'images' => 'Images',
        'product_brand' => 'ProductBrand',
        'product_sub_group' => 'ProductSubGroup',
        'comments' => 'Comments',
        'copy_comments_for_sales' => 'CopyCommentsForSales',
        'copy_comments_for_purchases' => 'CopyCommentsForPurchases',
        'alternate_units_of_measure' => 'AlternateUnitsOfMeasure',
        'automatic_charge_cost' => 'AutomaticChargeCost',
        'commerce_code' => 'CommerceCode',
        'customs_description' => 'CustomsDescription',
        'default_purchases_unit_of_measure' => 'DefaultPurchasesUnitOfMeasure',
        'icc_country_code' => 'ICCCountryCode',
        'icc_country_name' => 'ICCCountryName',
        'is_purchasable' => 'IsPurchasable',
        'nominal_cost' => 'NominalCost',
        'reminder' => 'Reminder',
        'inventory_details' => 'InventoryDetails',
        'supplementary_classification_abbreviation' => 'SupplementaryClassificationAbbreviation'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'product_code' => 'setProductCode',
        'product_description' => 'setProductDescription',
        'barcode' => 'setBarcode',
        'pack_size' => 'setPackSize',
        'width' => 'setWidth',
        'height' => 'setHeight',
        'depth' => 'setDepth',
        'weight' => 'setWeight',
        'min_stock_alert_level' => 'setMinStockAlertLevel',
        'max_stock_alert_level' => 'setMaxStockAlertLevel',
        're_order_point' => 'setReOrderPoint',
        'unit_of_measure' => 'setUnitOfMeasure',
        'never_diminishing' => 'setNeverDiminishing',
        'last_cost' => 'setLastCost',
        'default_purchase_price' => 'setDefaultPurchasePrice',
        'default_sell_price' => 'setDefaultSellPrice',
        'customer_sell_price' => 'setCustomerSellPrice',
        'average_land_price' => 'setAverageLandPrice',
        'obsolete' => 'setObsolete',
        'notes' => 'setNotes',
        'image_url' => 'setImageUrl',
        'sell_price_tier1' => 'setSellPriceTier1',
        'sell_price_tier2' => 'setSellPriceTier2',
        'sell_price_tier3' => 'setSellPriceTier3',
        'sell_price_tier4' => 'setSellPriceTier4',
        'sell_price_tier5' => 'setSellPriceTier5',
        'sell_price_tier6' => 'setSellPriceTier6',
        'sell_price_tier7' => 'setSellPriceTier7',
        'sell_price_tier8' => 'setSellPriceTier8',
        'sell_price_tier9' => 'setSellPriceTier9',
        'sell_price_tier10' => 'setSellPriceTier10',
        'xero_tax_code' => 'setXeroTaxCode',
        'xero_tax_rate' => 'setXeroTaxRate',
        'taxable_purchase' => 'setTaxablePurchase',
        'taxable_sales' => 'setTaxableSales',
        'xero_sales_tax_code' => 'setXeroSalesTaxCode',
        'xero_sales_tax_rate' => 'setXeroSalesTaxRate',
        'is_component' => 'setIsComponent',
        'is_assembled_product' => 'setIsAssembledProduct',
        'product_group' => 'setProductGroup',
        'xero_sales_account' => 'setXeroSalesAccount',
        'xero_cost_of_goods_account' => 'setXeroCostOfGoodsAccount',
        'purchase_account' => 'setPurchaseAccount',
        'bin_location' => 'setBinLocation',
        'supplier' => 'setSupplier',
        'attribute_set' => 'setAttributeSet',
        'source_id' => 'setSourceId',
        'source_variant_parent_id' => 'setSourceVariantParentId',
        'is_serialized' => 'setIsSerialized',
        'is_batch_tracked' => 'setIsBatchTracked',
        'is_sellable' => 'setIsSellable',
        'minimum_sell_price' => 'setMinimumSellPrice',
        'minimum_sale_quantity' => 'setMinimumSaleQuantity',
        'minimum_order_quantity' => 'setMinimumOrderQuantity',
        'created_by' => 'setCreatedBy',
        'created_on' => 'setCreatedOn',
        'last_modified_by' => 'setLastModifiedBy',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn',
        'images' => 'setImages',
        'product_brand' => 'setProductBrand',
        'product_sub_group' => 'setProductSubGroup',
        'comments' => 'setComments',
        'copy_comments_for_sales' => 'setCopyCommentsForSales',
        'copy_comments_for_purchases' => 'setCopyCommentsForPurchases',
        'alternate_units_of_measure' => 'setAlternateUnitsOfMeasure',
        'automatic_charge_cost' => 'setAutomaticChargeCost',
        'commerce_code' => 'setCommerceCode',
        'customs_description' => 'setCustomsDescription',
        'default_purchases_unit_of_measure' => 'setDefaultPurchasesUnitOfMeasure',
        'icc_country_code' => 'setIccCountryCode',
        'icc_country_name' => 'setIccCountryName',
        'is_purchasable' => 'setIsPurchasable',
        'nominal_cost' => 'setNominalCost',
        'reminder' => 'setReminder',
        'inventory_details' => 'setInventoryDetails',
        'supplementary_classification_abbreviation' => 'setSupplementaryClassificationAbbreviation'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'product_code' => 'getProductCode',
        'product_description' => 'getProductDescription',
        'barcode' => 'getBarcode',
        'pack_size' => 'getPackSize',
        'width' => 'getWidth',
        'height' => 'getHeight',
        'depth' => 'getDepth',
        'weight' => 'getWeight',
        'min_stock_alert_level' => 'getMinStockAlertLevel',
        'max_stock_alert_level' => 'getMaxStockAlertLevel',
        're_order_point' => 'getReOrderPoint',
        'unit_of_measure' => 'getUnitOfMeasure',
        'never_diminishing' => 'getNeverDiminishing',
        'last_cost' => 'getLastCost',
        'default_purchase_price' => 'getDefaultPurchasePrice',
        'default_sell_price' => 'getDefaultSellPrice',
        'customer_sell_price' => 'getCustomerSellPrice',
        'average_land_price' => 'getAverageLandPrice',
        'obsolete' => 'getObsolete',
        'notes' => 'getNotes',
        'image_url' => 'getImageUrl',
        'sell_price_tier1' => 'getSellPriceTier1',
        'sell_price_tier2' => 'getSellPriceTier2',
        'sell_price_tier3' => 'getSellPriceTier3',
        'sell_price_tier4' => 'getSellPriceTier4',
        'sell_price_tier5' => 'getSellPriceTier5',
        'sell_price_tier6' => 'getSellPriceTier6',
        'sell_price_tier7' => 'getSellPriceTier7',
        'sell_price_tier8' => 'getSellPriceTier8',
        'sell_price_tier9' => 'getSellPriceTier9',
        'sell_price_tier10' => 'getSellPriceTier10',
        'xero_tax_code' => 'getXeroTaxCode',
        'xero_tax_rate' => 'getXeroTaxRate',
        'taxable_purchase' => 'getTaxablePurchase',
        'taxable_sales' => 'getTaxableSales',
        'xero_sales_tax_code' => 'getXeroSalesTaxCode',
        'xero_sales_tax_rate' => 'getXeroSalesTaxRate',
        'is_component' => 'getIsComponent',
        'is_assembled_product' => 'getIsAssembledProduct',
        'product_group' => 'getProductGroup',
        'xero_sales_account' => 'getXeroSalesAccount',
        'xero_cost_of_goods_account' => 'getXeroCostOfGoodsAccount',
        'purchase_account' => 'getPurchaseAccount',
        'bin_location' => 'getBinLocation',
        'supplier' => 'getSupplier',
        'attribute_set' => 'getAttributeSet',
        'source_id' => 'getSourceId',
        'source_variant_parent_id' => 'getSourceVariantParentId',
        'is_serialized' => 'getIsSerialized',
        'is_batch_tracked' => 'getIsBatchTracked',
        'is_sellable' => 'getIsSellable',
        'minimum_sell_price' => 'getMinimumSellPrice',
        'minimum_sale_quantity' => 'getMinimumSaleQuantity',
        'minimum_order_quantity' => 'getMinimumOrderQuantity',
        'created_by' => 'getCreatedBy',
        'created_on' => 'getCreatedOn',
        'last_modified_by' => 'getLastModifiedBy',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn',
        'images' => 'getImages',
        'product_brand' => 'getProductBrand',
        'product_sub_group' => 'getProductSubGroup',
        'comments' => 'getComments',
        'copy_comments_for_sales' => 'getCopyCommentsForSales',
        'copy_comments_for_purchases' => 'getCopyCommentsForPurchases',
        'alternate_units_of_measure' => 'getAlternateUnitsOfMeasure',
        'automatic_charge_cost' => 'getAutomaticChargeCost',
        'commerce_code' => 'getCommerceCode',
        'customs_description' => 'getCustomsDescription',
        'default_purchases_unit_of_measure' => 'getDefaultPurchasesUnitOfMeasure',
        'icc_country_code' => 'getIccCountryCode',
        'icc_country_name' => 'getIccCountryName',
        'is_purchasable' => 'getIsPurchasable',
        'nominal_cost' => 'getNominalCost',
        'reminder' => 'getReminder',
        'inventory_details' => 'getInventoryDetails',
        'supplementary_classification_abbreviation' => 'getSupplementaryClassificationAbbreviation'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('product_code', $data ?? [], null);
        $this->setIfExists('product_description', $data ?? [], null);
        $this->setIfExists('barcode', $data ?? [], null);
        $this->setIfExists('pack_size', $data ?? [], null);
        $this->setIfExists('width', $data ?? [], null);
        $this->setIfExists('height', $data ?? [], null);
        $this->setIfExists('depth', $data ?? [], null);
        $this->setIfExists('weight', $data ?? [], null);
        $this->setIfExists('min_stock_alert_level', $data ?? [], null);
        $this->setIfExists('max_stock_alert_level', $data ?? [], null);
        $this->setIfExists('re_order_point', $data ?? [], null);
        $this->setIfExists('unit_of_measure', $data ?? [], null);
        $this->setIfExists('never_diminishing', $data ?? [], null);
        $this->setIfExists('last_cost', $data ?? [], null);
        $this->setIfExists('default_purchase_price', $data ?? [], null);
        $this->setIfExists('default_sell_price', $data ?? [], null);
        $this->setIfExists('customer_sell_price', $data ?? [], null);
        $this->setIfExists('average_land_price', $data ?? [], null);
        $this->setIfExists('obsolete', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('image_url', $data ?? [], null);
        $this->setIfExists('sell_price_tier1', $data ?? [], null);
        $this->setIfExists('sell_price_tier2', $data ?? [], null);
        $this->setIfExists('sell_price_tier3', $data ?? [], null);
        $this->setIfExists('sell_price_tier4', $data ?? [], null);
        $this->setIfExists('sell_price_tier5', $data ?? [], null);
        $this->setIfExists('sell_price_tier6', $data ?? [], null);
        $this->setIfExists('sell_price_tier7', $data ?? [], null);
        $this->setIfExists('sell_price_tier8', $data ?? [], null);
        $this->setIfExists('sell_price_tier9', $data ?? [], null);
        $this->setIfExists('sell_price_tier10', $data ?? [], null);
        $this->setIfExists('xero_tax_code', $data ?? [], null);
        $this->setIfExists('xero_tax_rate', $data ?? [], null);
        $this->setIfExists('taxable_purchase', $data ?? [], null);
        $this->setIfExists('taxable_sales', $data ?? [], null);
        $this->setIfExists('xero_sales_tax_code', $data ?? [], null);
        $this->setIfExists('xero_sales_tax_rate', $data ?? [], null);
        $this->setIfExists('is_component', $data ?? [], null);
        $this->setIfExists('is_assembled_product', $data ?? [], null);
        $this->setIfExists('product_group', $data ?? [], null);
        $this->setIfExists('xero_sales_account', $data ?? [], null);
        $this->setIfExists('xero_cost_of_goods_account', $data ?? [], null);
        $this->setIfExists('purchase_account', $data ?? [], null);
        $this->setIfExists('bin_location', $data ?? [], null);
        $this->setIfExists('supplier', $data ?? [], null);
        $this->setIfExists('attribute_set', $data ?? [], null);
        $this->setIfExists('source_id', $data ?? [], null);
        $this->setIfExists('source_variant_parent_id', $data ?? [], null);
        $this->setIfExists('is_serialized', $data ?? [], null);
        $this->setIfExists('is_batch_tracked', $data ?? [], null);
        $this->setIfExists('is_sellable', $data ?? [], null);
        $this->setIfExists('minimum_sell_price', $data ?? [], null);
        $this->setIfExists('minimum_sale_quantity', $data ?? [], null);
        $this->setIfExists('minimum_order_quantity', $data ?? [], null);
        $this->setIfExists('created_by', $data ?? [], null);
        $this->setIfExists('created_on', $data ?? [], null);
        $this->setIfExists('last_modified_by', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
        $this->setIfExists('images', $data ?? [], null);
        $this->setIfExists('product_brand', $data ?? [], null);
        $this->setIfExists('product_sub_group', $data ?? [], null);
        $this->setIfExists('comments', $data ?? [], null);
        $this->setIfExists('copy_comments_for_sales', $data ?? [], null);
        $this->setIfExists('copy_comments_for_purchases', $data ?? [], null);
        $this->setIfExists('alternate_units_of_measure', $data ?? [], null);
        $this->setIfExists('automatic_charge_cost', $data ?? [], null);
        $this->setIfExists('commerce_code', $data ?? [], null);
        $this->setIfExists('customs_description', $data ?? [], null);
        $this->setIfExists('default_purchases_unit_of_measure', $data ?? [], null);
        $this->setIfExists('icc_country_code', $data ?? [], null);
        $this->setIfExists('icc_country_name', $data ?? [], null);
        $this->setIfExists('is_purchasable', $data ?? [], null);
        $this->setIfExists('nominal_cost', $data ?? [], null);
        $this->setIfExists('reminder', $data ?? [], null);
        $this->setIfExists('inventory_details', $data ?? [], null);
        $this->setIfExists('supplementary_classification_abbreviation', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets product_code
     *
     * @return string|null
     */
    public function getProductCode()
    {
        return $this->container['product_code'];
    }

    /**
     * Sets product_code
     *
     * @param string|null $product_code product_code
     *
     * @return self
     */
    public function setProductCode($product_code)
    {
        if (is_null($product_code)) {
            throw new \InvalidArgumentException('non-nullable product_code cannot be null');
        }
        $this->container['product_code'] = $product_code;

        return $this;
    }

    /**
     * Gets product_description
     *
     * @return string|null
     */
    public function getProductDescription()
    {
        return $this->container['product_description'];
    }

    /**
     * Sets product_description
     *
     * @param string|null $product_description product_description
     *
     * @return self
     */
    public function setProductDescription($product_description)
    {
        if (is_null($product_description)) {
            throw new \InvalidArgumentException('non-nullable product_description cannot be null');
        }
        $this->container['product_description'] = $product_description;

        return $this;
    }

    /**
     * Gets barcode
     *
     * @return string|null
     */
    public function getBarcode()
    {
        return $this->container['barcode'];
    }

    /**
     * Sets barcode
     *
     * @param string|null $barcode barcode
     *
     * @return self
     */
    public function setBarcode($barcode)
    {
        if (is_null($barcode)) {
            throw new \InvalidArgumentException('non-nullable barcode cannot be null');
        }
        $this->container['barcode'] = $barcode;

        return $this;
    }

    /**
     * Gets pack_size
     *
     * @return float|null
     */
    public function getPackSize()
    {
        return $this->container['pack_size'];
    }

    /**
     * Sets pack_size
     *
     * @param float|null $pack_size pack_size
     *
     * @return self
     */
    public function setPackSize($pack_size)
    {
        if (is_null($pack_size)) {
            array_push($this->openAPINullablesSetToNull, 'pack_size');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('pack_size', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['pack_size'] = $pack_size;

        return $this;
    }

    /**
     * Gets width
     *
     * @return float|null
     */
    public function getWidth()
    {
        return $this->container['width'];
    }

    /**
     * Sets width
     *
     * @param float|null $width width
     *
     * @return self
     */
    public function setWidth($width)
    {
        if (is_null($width)) {
            array_push($this->openAPINullablesSetToNull, 'width');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('width', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['width'] = $width;

        return $this;
    }

    /**
     * Gets height
     *
     * @return float|null
     */
    public function getHeight()
    {
        return $this->container['height'];
    }

    /**
     * Sets height
     *
     * @param float|null $height height
     *
     * @return self
     */
    public function setHeight($height)
    {
        if (is_null($height)) {
            array_push($this->openAPINullablesSetToNull, 'height');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('height', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['height'] = $height;

        return $this;
    }

    /**
     * Gets depth
     *
     * @return float|null
     */
    public function getDepth()
    {
        return $this->container['depth'];
    }

    /**
     * Sets depth
     *
     * @param float|null $depth depth
     *
     * @return self
     */
    public function setDepth($depth)
    {
        if (is_null($depth)) {
            array_push($this->openAPINullablesSetToNull, 'depth');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('depth', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['depth'] = $depth;

        return $this;
    }

    /**
     * Gets weight
     *
     * @return float|null
     */
    public function getWeight()
    {
        return $this->container['weight'];
    }

    /**
     * Sets weight
     *
     * @param float|null $weight weight
     *
     * @return self
     */
    public function setWeight($weight)
    {
        if (is_null($weight)) {
            array_push($this->openAPINullablesSetToNull, 'weight');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('weight', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['weight'] = $weight;

        return $this;
    }

    /**
     * Gets min_stock_alert_level
     *
     * @return float|null
     */
    public function getMinStockAlertLevel()
    {
        return $this->container['min_stock_alert_level'];
    }

    /**
     * Sets min_stock_alert_level
     *
     * @param float|null $min_stock_alert_level min_stock_alert_level
     *
     * @return self
     */
    public function setMinStockAlertLevel($min_stock_alert_level)
    {
        if (is_null($min_stock_alert_level)) {
            array_push($this->openAPINullablesSetToNull, 'min_stock_alert_level');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('min_stock_alert_level', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['min_stock_alert_level'] = $min_stock_alert_level;

        return $this;
    }

    /**
     * Gets max_stock_alert_level
     *
     * @return float|null
     */
    public function getMaxStockAlertLevel()
    {
        return $this->container['max_stock_alert_level'];
    }

    /**
     * Sets max_stock_alert_level
     *
     * @param float|null $max_stock_alert_level max_stock_alert_level
     *
     * @return self
     */
    public function setMaxStockAlertLevel($max_stock_alert_level)
    {
        if (is_null($max_stock_alert_level)) {
            array_push($this->openAPINullablesSetToNull, 'max_stock_alert_level');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('max_stock_alert_level', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['max_stock_alert_level'] = $max_stock_alert_level;

        return $this;
    }

    /**
     * Gets re_order_point
     *
     * @return float|null
     */
    public function getReOrderPoint()
    {
        return $this->container['re_order_point'];
    }

    /**
     * Sets re_order_point
     *
     * @param float|null $re_order_point re_order_point
     *
     * @return self
     */
    public function setReOrderPoint($re_order_point)
    {
        if (is_null($re_order_point)) {
            array_push($this->openAPINullablesSetToNull, 're_order_point');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('re_order_point', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['re_order_point'] = $re_order_point;

        return $this;
    }

    /**
     * Gets unit_of_measure
     *
     * @return \Unleashed\Model\UnitOfMeasure|null
     */
    public function getUnitOfMeasure()
    {
        return $this->container['unit_of_measure'];
    }

    /**
     * Sets unit_of_measure
     *
     * @param \Unleashed\Model\UnitOfMeasure|null $unit_of_measure unit_of_measure
     *
     * @return self
     */
    public function setUnitOfMeasure($unit_of_measure)
    {
        if (is_null($unit_of_measure)) {
            throw new \InvalidArgumentException('non-nullable unit_of_measure cannot be null');
        }
        $this->container['unit_of_measure'] = $unit_of_measure;

        return $this;
    }

    /**
     * Gets never_diminishing
     *
     * @return bool|null
     */
    public function getNeverDiminishing()
    {
        return $this->container['never_diminishing'];
    }

    /**
     * Sets never_diminishing
     *
     * @param bool|null $never_diminishing never_diminishing
     *
     * @return self
     */
    public function setNeverDiminishing($never_diminishing)
    {
        if (is_null($never_diminishing)) {
            array_push($this->openAPINullablesSetToNull, 'never_diminishing');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('never_diminishing', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['never_diminishing'] = $never_diminishing;

        return $this;
    }

    /**
     * Gets last_cost
     *
     * @return float|null
     */
    public function getLastCost()
    {
        return $this->container['last_cost'];
    }

    /**
     * Sets last_cost
     *
     * @param float|null $last_cost last_cost
     *
     * @return self
     */
    public function setLastCost($last_cost)
    {
        if (is_null($last_cost)) {
            throw new \InvalidArgumentException('non-nullable last_cost cannot be null');
        }
        $this->container['last_cost'] = $last_cost;

        return $this;
    }

    /**
     * Gets default_purchase_price
     *
     * @return float|null
     */
    public function getDefaultPurchasePrice()
    {
        return $this->container['default_purchase_price'];
    }

    /**
     * Sets default_purchase_price
     *
     * @param float|null $default_purchase_price default_purchase_price
     *
     * @return self
     */
    public function setDefaultPurchasePrice($default_purchase_price)
    {
        if (is_null($default_purchase_price)) {
            array_push($this->openAPINullablesSetToNull, 'default_purchase_price');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('default_purchase_price', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['default_purchase_price'] = $default_purchase_price;

        return $this;
    }

    /**
     * Gets default_sell_price
     *
     * @return float|null
     */
    public function getDefaultSellPrice()
    {
        return $this->container['default_sell_price'];
    }

    /**
     * Sets default_sell_price
     *
     * @param float|null $default_sell_price default_sell_price
     *
     * @return self
     */
    public function setDefaultSellPrice($default_sell_price)
    {
        if (is_null($default_sell_price)) {
            array_push($this->openAPINullablesSetToNull, 'default_sell_price');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('default_sell_price', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['default_sell_price'] = $default_sell_price;

        return $this;
    }

    /**
     * Gets customer_sell_price
     *
     * @return float|null
     */
    public function getCustomerSellPrice()
    {
        return $this->container['customer_sell_price'];
    }

    /**
     * Sets customer_sell_price
     *
     * @param float|null $customer_sell_price customer_sell_price
     *
     * @return self
     */
    public function setCustomerSellPrice($customer_sell_price)
    {
        if (is_null($customer_sell_price)) {
            array_push($this->openAPINullablesSetToNull, 'customer_sell_price');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('customer_sell_price', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['customer_sell_price'] = $customer_sell_price;

        return $this;
    }

    /**
     * Gets average_land_price
     *
     * @return float|null
     */
    public function getAverageLandPrice()
    {
        return $this->container['average_land_price'];
    }

    /**
     * Sets average_land_price
     *
     * @param float|null $average_land_price average_land_price
     *
     * @return self
     */
    public function setAverageLandPrice($average_land_price)
    {
        if (is_null($average_land_price)) {
            array_push($this->openAPINullablesSetToNull, 'average_land_price');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('average_land_price', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['average_land_price'] = $average_land_price;

        return $this;
    }

    /**
     * Gets obsolete
     *
     * @return bool|null
     */
    public function getObsolete()
    {
        return $this->container['obsolete'];
    }

    /**
     * Sets obsolete
     *
     * @param bool|null $obsolete obsolete
     *
     * @return self
     */
    public function setObsolete($obsolete)
    {
        if (is_null($obsolete)) {
            throw new \InvalidArgumentException('non-nullable obsolete cannot be null');
        }
        $this->container['obsolete'] = $obsolete;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets image_url
     *
     * @return string|null
     */
    public function getImageUrl()
    {
        return $this->container['image_url'];
    }

    /**
     * Sets image_url
     *
     * @param string|null $image_url image_url
     *
     * @return self
     */
    public function setImageUrl($image_url)
    {
        if (is_null($image_url)) {
            throw new \InvalidArgumentException('non-nullable image_url cannot be null');
        }
        $this->container['image_url'] = $image_url;

        return $this;
    }

    /**
     * Gets sell_price_tier1
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier1()
    {
        return $this->container['sell_price_tier1'];
    }

    /**
     * Sets sell_price_tier1
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier1 sell_price_tier1
     *
     * @return self
     */
    public function setSellPriceTier1($sell_price_tier1)
    {
        if (is_null($sell_price_tier1)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier1 cannot be null');
        }
        $this->container['sell_price_tier1'] = $sell_price_tier1;

        return $this;
    }

    /**
     * Gets sell_price_tier2
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier2()
    {
        return $this->container['sell_price_tier2'];
    }

    /**
     * Sets sell_price_tier2
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier2 sell_price_tier2
     *
     * @return self
     */
    public function setSellPriceTier2($sell_price_tier2)
    {
        if (is_null($sell_price_tier2)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier2 cannot be null');
        }
        $this->container['sell_price_tier2'] = $sell_price_tier2;

        return $this;
    }

    /**
     * Gets sell_price_tier3
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier3()
    {
        return $this->container['sell_price_tier3'];
    }

    /**
     * Sets sell_price_tier3
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier3 sell_price_tier3
     *
     * @return self
     */
    public function setSellPriceTier3($sell_price_tier3)
    {
        if (is_null($sell_price_tier3)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier3 cannot be null');
        }
        $this->container['sell_price_tier3'] = $sell_price_tier3;

        return $this;
    }

    /**
     * Gets sell_price_tier4
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier4()
    {
        return $this->container['sell_price_tier4'];
    }

    /**
     * Sets sell_price_tier4
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier4 sell_price_tier4
     *
     * @return self
     */
    public function setSellPriceTier4($sell_price_tier4)
    {
        if (is_null($sell_price_tier4)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier4 cannot be null');
        }
        $this->container['sell_price_tier4'] = $sell_price_tier4;

        return $this;
    }

    /**
     * Gets sell_price_tier5
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier5()
    {
        return $this->container['sell_price_tier5'];
    }

    /**
     * Sets sell_price_tier5
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier5 sell_price_tier5
     *
     * @return self
     */
    public function setSellPriceTier5($sell_price_tier5)
    {
        if (is_null($sell_price_tier5)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier5 cannot be null');
        }
        $this->container['sell_price_tier5'] = $sell_price_tier5;

        return $this;
    }

    /**
     * Gets sell_price_tier6
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier6()
    {
        return $this->container['sell_price_tier6'];
    }

    /**
     * Sets sell_price_tier6
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier6 sell_price_tier6
     *
     * @return self
     */
    public function setSellPriceTier6($sell_price_tier6)
    {
        if (is_null($sell_price_tier6)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier6 cannot be null');
        }
        $this->container['sell_price_tier6'] = $sell_price_tier6;

        return $this;
    }

    /**
     * Gets sell_price_tier7
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier7()
    {
        return $this->container['sell_price_tier7'];
    }

    /**
     * Sets sell_price_tier7
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier7 sell_price_tier7
     *
     * @return self
     */
    public function setSellPriceTier7($sell_price_tier7)
    {
        if (is_null($sell_price_tier7)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier7 cannot be null');
        }
        $this->container['sell_price_tier7'] = $sell_price_tier7;

        return $this;
    }

    /**
     * Gets sell_price_tier8
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier8()
    {
        return $this->container['sell_price_tier8'];
    }

    /**
     * Sets sell_price_tier8
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier8 sell_price_tier8
     *
     * @return self
     */
    public function setSellPriceTier8($sell_price_tier8)
    {
        if (is_null($sell_price_tier8)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier8 cannot be null');
        }
        $this->container['sell_price_tier8'] = $sell_price_tier8;

        return $this;
    }

    /**
     * Gets sell_price_tier9
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier9()
    {
        return $this->container['sell_price_tier9'];
    }

    /**
     * Sets sell_price_tier9
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier9 sell_price_tier9
     *
     * @return self
     */
    public function setSellPriceTier9($sell_price_tier9)
    {
        if (is_null($sell_price_tier9)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier9 cannot be null');
        }
        $this->container['sell_price_tier9'] = $sell_price_tier9;

        return $this;
    }

    /**
     * Gets sell_price_tier10
     *
     * @return \Unleashed\Model\SellPriceTier|null
     */
    public function getSellPriceTier10()
    {
        return $this->container['sell_price_tier10'];
    }

    /**
     * Sets sell_price_tier10
     *
     * @param \Unleashed\Model\SellPriceTier|null $sell_price_tier10 sell_price_tier10
     *
     * @return self
     */
    public function setSellPriceTier10($sell_price_tier10)
    {
        if (is_null($sell_price_tier10)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier10 cannot be null');
        }
        $this->container['sell_price_tier10'] = $sell_price_tier10;

        return $this;
    }

    /**
     * Gets xero_tax_code
     *
     * @return string|null
     */
    public function getXeroTaxCode()
    {
        return $this->container['xero_tax_code'];
    }

    /**
     * Sets xero_tax_code
     *
     * @param string|null $xero_tax_code xero_tax_code
     *
     * @return self
     */
    public function setXeroTaxCode($xero_tax_code)
    {
        if (is_null($xero_tax_code)) {
            throw new \InvalidArgumentException('non-nullable xero_tax_code cannot be null');
        }
        $this->container['xero_tax_code'] = $xero_tax_code;

        return $this;
    }

    /**
     * Gets xero_tax_rate
     *
     * @return float|null
     */
    public function getXeroTaxRate()
    {
        return $this->container['xero_tax_rate'];
    }

    /**
     * Sets xero_tax_rate
     *
     * @param float|null $xero_tax_rate xero_tax_rate
     *
     * @return self
     */
    public function setXeroTaxRate($xero_tax_rate)
    {
        if (is_null($xero_tax_rate)) {
            array_push($this->openAPINullablesSetToNull, 'xero_tax_rate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('xero_tax_rate', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['xero_tax_rate'] = $xero_tax_rate;

        return $this;
    }

    /**
     * Gets taxable_purchase
     *
     * @return bool|null
     */
    public function getTaxablePurchase()
    {
        return $this->container['taxable_purchase'];
    }

    /**
     * Sets taxable_purchase
     *
     * @param bool|null $taxable_purchase taxable_purchase
     *
     * @return self
     */
    public function setTaxablePurchase($taxable_purchase)
    {
        if (is_null($taxable_purchase)) {
            array_push($this->openAPINullablesSetToNull, 'taxable_purchase');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('taxable_purchase', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['taxable_purchase'] = $taxable_purchase;

        return $this;
    }

    /**
     * Gets taxable_sales
     *
     * @return bool|null
     */
    public function getTaxableSales()
    {
        return $this->container['taxable_sales'];
    }

    /**
     * Sets taxable_sales
     *
     * @param bool|null $taxable_sales taxable_sales
     *
     * @return self
     */
    public function setTaxableSales($taxable_sales)
    {
        if (is_null($taxable_sales)) {
            array_push($this->openAPINullablesSetToNull, 'taxable_sales');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('taxable_sales', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['taxable_sales'] = $taxable_sales;

        return $this;
    }

    /**
     * Gets xero_sales_tax_code
     *
     * @return string|null
     */
    public function getXeroSalesTaxCode()
    {
        return $this->container['xero_sales_tax_code'];
    }

    /**
     * Sets xero_sales_tax_code
     *
     * @param string|null $xero_sales_tax_code xero_sales_tax_code
     *
     * @return self
     */
    public function setXeroSalesTaxCode($xero_sales_tax_code)
    {
        if (is_null($xero_sales_tax_code)) {
            throw new \InvalidArgumentException('non-nullable xero_sales_tax_code cannot be null');
        }
        $this->container['xero_sales_tax_code'] = $xero_sales_tax_code;

        return $this;
    }

    /**
     * Gets xero_sales_tax_rate
     *
     * @return float|null
     */
    public function getXeroSalesTaxRate()
    {
        return $this->container['xero_sales_tax_rate'];
    }

    /**
     * Sets xero_sales_tax_rate
     *
     * @param float|null $xero_sales_tax_rate xero_sales_tax_rate
     *
     * @return self
     */
    public function setXeroSalesTaxRate($xero_sales_tax_rate)
    {
        if (is_null($xero_sales_tax_rate)) {
            array_push($this->openAPINullablesSetToNull, 'xero_sales_tax_rate');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('xero_sales_tax_rate', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['xero_sales_tax_rate'] = $xero_sales_tax_rate;

        return $this;
    }

    /**
     * Gets is_component
     *
     * @return bool|null
     */
    public function getIsComponent()
    {
        return $this->container['is_component'];
    }

    /**
     * Sets is_component
     *
     * @param bool|null $is_component is_component
     *
     * @return self
     */
    public function setIsComponent($is_component)
    {
        if (is_null($is_component)) {
            throw new \InvalidArgumentException('non-nullable is_component cannot be null');
        }
        $this->container['is_component'] = $is_component;

        return $this;
    }

    /**
     * Gets is_assembled_product
     *
     * @return bool|null
     */
    public function getIsAssembledProduct()
    {
        return $this->container['is_assembled_product'];
    }

    /**
     * Sets is_assembled_product
     *
     * @param bool|null $is_assembled_product is_assembled_product
     *
     * @return self
     */
    public function setIsAssembledProduct($is_assembled_product)
    {
        if (is_null($is_assembled_product)) {
            throw new \InvalidArgumentException('non-nullable is_assembled_product cannot be null');
        }
        $this->container['is_assembled_product'] = $is_assembled_product;

        return $this;
    }

    /**
     * Gets product_group
     *
     * @return \Unleashed\Model\ProductGroup|null
     */
    public function getProductGroup()
    {
        return $this->container['product_group'];
    }

    /**
     * Sets product_group
     *
     * @param \Unleashed\Model\ProductGroup|null $product_group product_group
     *
     * @return self
     */
    public function setProductGroup($product_group)
    {
        if (is_null($product_group)) {
            throw new \InvalidArgumentException('non-nullable product_group cannot be null');
        }
        $this->container['product_group'] = $product_group;

        return $this;
    }

    /**
     * Gets xero_sales_account
     *
     * @return string|null
     */
    public function getXeroSalesAccount()
    {
        return $this->container['xero_sales_account'];
    }

    /**
     * Sets xero_sales_account
     *
     * @param string|null $xero_sales_account xero_sales_account
     *
     * @return self
     */
    public function setXeroSalesAccount($xero_sales_account)
    {
        if (is_null($xero_sales_account)) {
            throw new \InvalidArgumentException('non-nullable xero_sales_account cannot be null');
        }
        $this->container['xero_sales_account'] = $xero_sales_account;

        return $this;
    }

    /**
     * Gets xero_cost_of_goods_account
     *
     * @return string|null
     */
    public function getXeroCostOfGoodsAccount()
    {
        return $this->container['xero_cost_of_goods_account'];
    }

    /**
     * Sets xero_cost_of_goods_account
     *
     * @param string|null $xero_cost_of_goods_account xero_cost_of_goods_account
     *
     * @return self
     */
    public function setXeroCostOfGoodsAccount($xero_cost_of_goods_account)
    {
        if (is_null($xero_cost_of_goods_account)) {
            throw new \InvalidArgumentException('non-nullable xero_cost_of_goods_account cannot be null');
        }
        $this->container['xero_cost_of_goods_account'] = $xero_cost_of_goods_account;

        return $this;
    }

    /**
     * Gets purchase_account
     *
     * @return string|null
     */
    public function getPurchaseAccount()
    {
        return $this->container['purchase_account'];
    }

    /**
     * Sets purchase_account
     *
     * @param string|null $purchase_account purchase_account
     *
     * @return self
     */
    public function setPurchaseAccount($purchase_account)
    {
        if (is_null($purchase_account)) {
            throw new \InvalidArgumentException('non-nullable purchase_account cannot be null');
        }
        $this->container['purchase_account'] = $purchase_account;

        return $this;
    }

    /**
     * Gets bin_location
     *
     * @return string|null
     */
    public function getBinLocation()
    {
        return $this->container['bin_location'];
    }

    /**
     * Sets bin_location
     *
     * @param string|null $bin_location bin_location
     *
     * @return self
     */
    public function setBinLocation($bin_location)
    {
        if (is_null($bin_location)) {
            throw new \InvalidArgumentException('non-nullable bin_location cannot be null');
        }
        $this->container['bin_location'] = $bin_location;

        return $this;
    }

    /**
     * Gets supplier
     *
     * @return \Unleashed\Model\SupplierWithProductCode|null
     */
    public function getSupplier()
    {
        return $this->container['supplier'];
    }

    /**
     * Sets supplier
     *
     * @param \Unleashed\Model\SupplierWithProductCode|null $supplier supplier
     *
     * @return self
     */
    public function setSupplier($supplier)
    {
        if (is_null($supplier)) {
            throw new \InvalidArgumentException('non-nullable supplier cannot be null');
        }
        $this->container['supplier'] = $supplier;

        return $this;
    }

    /**
     * Gets attribute_set
     *
     * @return \Unleashed\Model\AttributeSet|null
     */
    public function getAttributeSet()
    {
        return $this->container['attribute_set'];
    }

    /**
     * Sets attribute_set
     *
     * @param \Unleashed\Model\AttributeSet|null $attribute_set attribute_set
     *
     * @return self
     */
    public function setAttributeSet($attribute_set)
    {
        if (is_null($attribute_set)) {
            throw new \InvalidArgumentException('non-nullable attribute_set cannot be null');
        }
        $this->container['attribute_set'] = $attribute_set;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id source_id
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        if (is_null($source_id)) {
            throw new \InvalidArgumentException('non-nullable source_id cannot be null');
        }
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets source_variant_parent_id
     *
     * @return string|null
     */
    public function getSourceVariantParentId()
    {
        return $this->container['source_variant_parent_id'];
    }

    /**
     * Sets source_variant_parent_id
     *
     * @param string|null $source_variant_parent_id source_variant_parent_id
     *
     * @return self
     */
    public function setSourceVariantParentId($source_variant_parent_id)
    {
        if (is_null($source_variant_parent_id)) {
            throw new \InvalidArgumentException('non-nullable source_variant_parent_id cannot be null');
        }
        $this->container['source_variant_parent_id'] = $source_variant_parent_id;

        return $this;
    }

    /**
     * Gets is_serialized
     *
     * @return bool|null
     */
    public function getIsSerialized()
    {
        return $this->container['is_serialized'];
    }

    /**
     * Sets is_serialized
     *
     * @param bool|null $is_serialized is_serialized
     *
     * @return self
     */
    public function setIsSerialized($is_serialized)
    {
        if (is_null($is_serialized)) {
            throw new \InvalidArgumentException('non-nullable is_serialized cannot be null');
        }
        $this->container['is_serialized'] = $is_serialized;

        return $this;
    }

    /**
     * Gets is_batch_tracked
     *
     * @return bool|null
     */
    public function getIsBatchTracked()
    {
        return $this->container['is_batch_tracked'];
    }

    /**
     * Sets is_batch_tracked
     *
     * @param bool|null $is_batch_tracked is_batch_tracked
     *
     * @return self
     */
    public function setIsBatchTracked($is_batch_tracked)
    {
        if (is_null($is_batch_tracked)) {
            throw new \InvalidArgumentException('non-nullable is_batch_tracked cannot be null');
        }
        $this->container['is_batch_tracked'] = $is_batch_tracked;

        return $this;
    }

    /**
     * Gets is_sellable
     *
     * @return bool|null
     */
    public function getIsSellable()
    {
        return $this->container['is_sellable'];
    }

    /**
     * Sets is_sellable
     *
     * @param bool|null $is_sellable is_sellable
     *
     * @return self
     */
    public function setIsSellable($is_sellable)
    {
        if (is_null($is_sellable)) {
            throw new \InvalidArgumentException('non-nullable is_sellable cannot be null');
        }
        $this->container['is_sellable'] = $is_sellable;

        return $this;
    }

    /**
     * Gets minimum_sell_price
     *
     * @return float|null
     */
    public function getMinimumSellPrice()
    {
        return $this->container['minimum_sell_price'];
    }

    /**
     * Sets minimum_sell_price
     *
     * @param float|null $minimum_sell_price minimum_sell_price
     *
     * @return self
     */
    public function setMinimumSellPrice($minimum_sell_price)
    {
        if (is_null($minimum_sell_price)) {
            array_push($this->openAPINullablesSetToNull, 'minimum_sell_price');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minimum_sell_price', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minimum_sell_price'] = $minimum_sell_price;

        return $this;
    }

    /**
     * Gets minimum_sale_quantity
     *
     * @return float|null
     */
    public function getMinimumSaleQuantity()
    {
        return $this->container['minimum_sale_quantity'];
    }

    /**
     * Sets minimum_sale_quantity
     *
     * @param float|null $minimum_sale_quantity minimum_sale_quantity
     *
     * @return self
     */
    public function setMinimumSaleQuantity($minimum_sale_quantity)
    {
        if (is_null($minimum_sale_quantity)) {
            array_push($this->openAPINullablesSetToNull, 'minimum_sale_quantity');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minimum_sale_quantity', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minimum_sale_quantity'] = $minimum_sale_quantity;

        return $this;
    }

    /**
     * Gets minimum_order_quantity
     *
     * @return float|null
     */
    public function getMinimumOrderQuantity()
    {
        return $this->container['minimum_order_quantity'];
    }

    /**
     * Sets minimum_order_quantity
     *
     * @param float|null $minimum_order_quantity minimum_order_quantity
     *
     * @return self
     */
    public function setMinimumOrderQuantity($minimum_order_quantity)
    {
        if (is_null($minimum_order_quantity)) {
            array_push($this->openAPINullablesSetToNull, 'minimum_order_quantity');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('minimum_order_quantity', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['minimum_order_quantity'] = $minimum_order_quantity;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        if (is_null($created_by)) {
            throw new \InvalidArgumentException('non-nullable created_by cannot be null');
        }
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        if (is_null($created_on)) {
            array_push($this->openAPINullablesSetToNull, 'created_on');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('created_on', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        if (is_null($last_modified_by)) {
            array_push($this->openAPINullablesSetToNull, 'last_modified_by');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('last_modified_by', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets images
     *
     * @return \Unleashed\Model\Image[]|null
     */
    public function getImages()
    {
        return $this->container['images'];
    }

    /**
     * Sets images
     *
     * @param \Unleashed\Model\Image[]|null $images images
     *
     * @return self
     */
    public function setImages($images)
    {
        if (is_null($images)) {
            throw new \InvalidArgumentException('non-nullable images cannot be null');
        }
        $this->container['images'] = $images;

        return $this;
    }

    /**
     * Gets product_brand
     *
     * @return \Unleashed\Model\ProductBrand|null
     */
    public function getProductBrand()
    {
        return $this->container['product_brand'];
    }

    /**
     * Sets product_brand
     *
     * @param \Unleashed\Model\ProductBrand|null $product_brand product_brand
     *
     * @return self
     */
    public function setProductBrand($product_brand)
    {
        if (is_null($product_brand)) {
            throw new \InvalidArgumentException('non-nullable product_brand cannot be null');
        }
        $this->container['product_brand'] = $product_brand;

        return $this;
    }

    /**
     * Gets product_sub_group
     *
     * @return \Unleashed\Model\ProductGroup|null
     */
    public function getProductSubGroup()
    {
        return $this->container['product_sub_group'];
    }

    /**
     * Sets product_sub_group
     *
     * @param \Unleashed\Model\ProductGroup|null $product_sub_group product_sub_group
     *
     * @return self
     */
    public function setProductSubGroup($product_sub_group)
    {
        if (is_null($product_sub_group)) {
            throw new \InvalidArgumentException('non-nullable product_sub_group cannot be null');
        }
        $this->container['product_sub_group'] = $product_sub_group;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        if (is_null($comments)) {
            throw new \InvalidArgumentException('non-nullable comments cannot be null');
        }
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets copy_comments_for_sales
     *
     * @return bool|null
     */
    public function getCopyCommentsForSales()
    {
        return $this->container['copy_comments_for_sales'];
    }

    /**
     * Sets copy_comments_for_sales
     *
     * @param bool|null $copy_comments_for_sales copy_comments_for_sales
     *
     * @return self
     */
    public function setCopyCommentsForSales($copy_comments_for_sales)
    {
        if (is_null($copy_comments_for_sales)) {
            throw new \InvalidArgumentException('non-nullable copy_comments_for_sales cannot be null');
        }
        $this->container['copy_comments_for_sales'] = $copy_comments_for_sales;

        return $this;
    }

    /**
     * Gets copy_comments_for_purchases
     *
     * @return bool|null
     */
    public function getCopyCommentsForPurchases()
    {
        return $this->container['copy_comments_for_purchases'];
    }

    /**
     * Sets copy_comments_for_purchases
     *
     * @param bool|null $copy_comments_for_purchases copy_comments_for_purchases
     *
     * @return self
     */
    public function setCopyCommentsForPurchases($copy_comments_for_purchases)
    {
        if (is_null($copy_comments_for_purchases)) {
            throw new \InvalidArgumentException('non-nullable copy_comments_for_purchases cannot be null');
        }
        $this->container['copy_comments_for_purchases'] = $copy_comments_for_purchases;

        return $this;
    }

    /**
     * Gets alternate_units_of_measure
     *
     * @return \Unleashed\Model\AlternateUnitOfMeasure[]|null
     */
    public function getAlternateUnitsOfMeasure()
    {
        return $this->container['alternate_units_of_measure'];
    }

    /**
     * Sets alternate_units_of_measure
     *
     * @param \Unleashed\Model\AlternateUnitOfMeasure[]|null $alternate_units_of_measure alternate_units_of_measure
     *
     * @return self
     */
    public function setAlternateUnitsOfMeasure($alternate_units_of_measure)
    {
        if (is_null($alternate_units_of_measure)) {
            throw new \InvalidArgumentException('non-nullable alternate_units_of_measure cannot be null');
        }
        $this->container['alternate_units_of_measure'] = $alternate_units_of_measure;

        return $this;
    }

    /**
     * Gets automatic_charge_cost
     *
     * @return float|null
     */
    public function getAutomaticChargeCost()
    {
        return $this->container['automatic_charge_cost'];
    }

    /**
     * Sets automatic_charge_cost
     *
     * @param float|null $automatic_charge_cost automatic_charge_cost
     *
     * @return self
     */
    public function setAutomaticChargeCost($automatic_charge_cost)
    {
        if (is_null($automatic_charge_cost)) {
            array_push($this->openAPINullablesSetToNull, 'automatic_charge_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('automatic_charge_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['automatic_charge_cost'] = $automatic_charge_cost;

        return $this;
    }

    /**
     * Gets commerce_code
     *
     * @return string|null
     */
    public function getCommerceCode()
    {
        return $this->container['commerce_code'];
    }

    /**
     * Sets commerce_code
     *
     * @param string|null $commerce_code commerce_code
     *
     * @return self
     */
    public function setCommerceCode($commerce_code)
    {
        if (is_null($commerce_code)) {
            throw new \InvalidArgumentException('non-nullable commerce_code cannot be null');
        }
        $this->container['commerce_code'] = $commerce_code;

        return $this;
    }

    /**
     * Gets customs_description
     *
     * @return string|null
     */
    public function getCustomsDescription()
    {
        return $this->container['customs_description'];
    }

    /**
     * Sets customs_description
     *
     * @param string|null $customs_description customs_description
     *
     * @return self
     */
    public function setCustomsDescription($customs_description)
    {
        if (is_null($customs_description)) {
            throw new \InvalidArgumentException('non-nullable customs_description cannot be null');
        }
        $this->container['customs_description'] = $customs_description;

        return $this;
    }

    /**
     * Gets default_purchases_unit_of_measure
     *
     * @return \Unleashed\Model\UnitOfMeasure|null
     */
    public function getDefaultPurchasesUnitOfMeasure()
    {
        return $this->container['default_purchases_unit_of_measure'];
    }

    /**
     * Sets default_purchases_unit_of_measure
     *
     * @param \Unleashed\Model\UnitOfMeasure|null $default_purchases_unit_of_measure default_purchases_unit_of_measure
     *
     * @return self
     */
    public function setDefaultPurchasesUnitOfMeasure($default_purchases_unit_of_measure)
    {
        if (is_null($default_purchases_unit_of_measure)) {
            throw new \InvalidArgumentException('non-nullable default_purchases_unit_of_measure cannot be null');
        }
        $this->container['default_purchases_unit_of_measure'] = $default_purchases_unit_of_measure;

        return $this;
    }

    /**
     * Gets icc_country_code
     *
     * @return string|null
     */
    public function getIccCountryCode()
    {
        return $this->container['icc_country_code'];
    }

    /**
     * Sets icc_country_code
     *
     * @param string|null $icc_country_code icc_country_code
     *
     * @return self
     */
    public function setIccCountryCode($icc_country_code)
    {
        if (is_null($icc_country_code)) {
            throw new \InvalidArgumentException('non-nullable icc_country_code cannot be null');
        }
        $this->container['icc_country_code'] = $icc_country_code;

        return $this;
    }

    /**
     * Gets icc_country_name
     *
     * @return string|null
     */
    public function getIccCountryName()
    {
        return $this->container['icc_country_name'];
    }

    /**
     * Sets icc_country_name
     *
     * @param string|null $icc_country_name icc_country_name
     *
     * @return self
     */
    public function setIccCountryName($icc_country_name)
    {
        if (is_null($icc_country_name)) {
            throw new \InvalidArgumentException('non-nullable icc_country_name cannot be null');
        }
        $this->container['icc_country_name'] = $icc_country_name;

        return $this;
    }

    /**
     * Gets is_purchasable
     *
     * @return bool|null
     */
    public function getIsPurchasable()
    {
        return $this->container['is_purchasable'];
    }

    /**
     * Sets is_purchasable
     *
     * @param bool|null $is_purchasable is_purchasable
     *
     * @return self
     */
    public function setIsPurchasable($is_purchasable)
    {
        if (is_null($is_purchasable)) {
            throw new \InvalidArgumentException('non-nullable is_purchasable cannot be null');
        }
        $this->container['is_purchasable'] = $is_purchasable;

        return $this;
    }

    /**
     * Gets nominal_cost
     *
     * @return float|null
     */
    public function getNominalCost()
    {
        return $this->container['nominal_cost'];
    }

    /**
     * Sets nominal_cost
     *
     * @param float|null $nominal_cost nominal_cost
     *
     * @return self
     */
    public function setNominalCost($nominal_cost)
    {
        if (is_null($nominal_cost)) {
            array_push($this->openAPINullablesSetToNull, 'nominal_cost');
        } else {
            $nullablesSetToNull = $this->getOpenAPINullablesSetToNull();
            $index = array_search('nominal_cost', $nullablesSetToNull);
            if ($index !== FALSE) {
                unset($nullablesSetToNull[$index]);
                $this->setOpenAPINullablesSetToNull($nullablesSetToNull);
            }
        }
        $this->container['nominal_cost'] = $nominal_cost;

        return $this;
    }

    /**
     * Gets reminder
     *
     * @return string|null
     */
    public function getReminder()
    {
        return $this->container['reminder'];
    }

    /**
     * Sets reminder
     *
     * @param string|null $reminder reminder
     *
     * @return self
     */
    public function setReminder($reminder)
    {
        if (is_null($reminder)) {
            throw new \InvalidArgumentException('non-nullable reminder cannot be null');
        }
        $this->container['reminder'] = $reminder;

        return $this;
    }

    /**
     * Gets inventory_details
     *
     * @return \Unleashed\Model\InventoryDetail[]|null
     */
    public function getInventoryDetails()
    {
        return $this->container['inventory_details'];
    }

    /**
     * Sets inventory_details
     *
     * @param \Unleashed\Model\InventoryDetail[]|null $inventory_details inventory_details
     *
     * @return self
     */
    public function setInventoryDetails($inventory_details)
    {
        if (is_null($inventory_details)) {
            throw new \InvalidArgumentException('non-nullable inventory_details cannot be null');
        }
        $this->container['inventory_details'] = $inventory_details;

        return $this;
    }

    /**
     * Gets supplementary_classification_abbreviation
     *
     * @return string|null
     */
    public function getSupplementaryClassificationAbbreviation()
    {
        return $this->container['supplementary_classification_abbreviation'];
    }

    /**
     * Sets supplementary_classification_abbreviation
     *
     * @param string|null $supplementary_classification_abbreviation supplementary_classification_abbreviation
     *
     * @return self
     */
    public function setSupplementaryClassificationAbbreviation($supplementary_classification_abbreviation)
    {
        if (is_null($supplementary_classification_abbreviation)) {
            throw new \InvalidArgumentException('non-nullable supplementary_classification_abbreviation cannot be null');
        }
        $this->container['supplementary_classification_abbreviation'] = $supplementary_classification_abbreviation;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


