<?php
/**
 * Customer
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Customer Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Customer implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'customer';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'addresses' => '\Unleashed\Model\Address[]',
        'customer_code' => 'string',
        'customer_name' => 'string',
        'gstvat_number' => 'string',
        'bank_name' => 'string',
        'bank_branch' => 'string',
        'bank_account' => 'string',
        'website' => 'string',
        'phone_number' => 'string',
        'fax_number' => 'string',
        'mobile_number' => 'string',
        'ddi_number' => 'string',
        'toll_free_number' => 'string',
        'email' => 'string',
        'email_cc' => 'string',
        'currency' => '\Unleashed\Model\Currency',
        'notes' => 'string',
        'taxable' => 'bool',
        'xero_contact_id' => 'string',
        'sales_person' => '\Unleashed\Model\SalesPerson',
        'discount_rate' => 'float',
        'print_packing_slip_instead_of_invoice' => 'bool',
        'print_invoice' => 'bool',
        'stop_credit' => 'bool',
        'obsolete' => 'bool',
        'xero_sales_account' => 'string',
        'xero_cost_of_goods_account' => 'string',
        'sell_price_tier' => 'string',
        'customer_type' => 'string',
        'payment_term' => 'string',
        'contact_first_name' => 'string',
        'contact_last_name' => 'string',
        'source_id' => 'string',
        'created_by' => 'string',
        'guid' => 'string',
        'last_modified_on' => 'string',
        'contacts' => '\Unleashed\Model\Contact[]',
        'tax_code' => 'string',
        'tax_rate' => 'float',
        'created_on' => 'string',
        'eori_number' => 'string',
        'credit_limit' => 'string',
        'default_warehouse' => '\Unleashed\Model\Warehouse',
        'delivery_instruction' => 'string',
        'delivery_method' => 'string',
        'has_credit_limit' => 'bool',
        'reminder' => 'string',
        'sales_order_group' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'addresses' => null,
        'customer_code' => null,
        'customer_name' => null,
        'gstvat_number' => null,
        'bank_name' => null,
        'bank_branch' => null,
        'bank_account' => null,
        'website' => null,
        'phone_number' => null,
        'fax_number' => null,
        'mobile_number' => null,
        'ddi_number' => null,
        'toll_free_number' => null,
        'email' => null,
        'email_cc' => null,
        'currency' => null,
        'notes' => null,
        'taxable' => null,
        'xero_contact_id' => null,
        'sales_person' => null,
        'discount_rate' => null,
        'print_packing_slip_instead_of_invoice' => null,
        'print_invoice' => null,
        'stop_credit' => null,
        'obsolete' => null,
        'xero_sales_account' => null,
        'xero_cost_of_goods_account' => null,
        'sell_price_tier' => null,
        'customer_type' => null,
        'payment_term' => null,
        'contact_first_name' => null,
        'contact_last_name' => null,
        'source_id' => null,
        'created_by' => null,
        'guid' => null,
        'last_modified_on' => null,
        'contacts' => null,
        'tax_code' => null,
        'tax_rate' => null,
        'created_on' => null,
        'eori_number' => null,
        'credit_limit' => null,
        'default_warehouse' => null,
        'delivery_instruction' => null,
        'delivery_method' => null,
        'has_credit_limit' => null,
        'reminder' => null,
        'sales_order_group' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'addresses' => false,
        'customer_code' => false,
        'customer_name' => false,
        'gstvat_number' => false,
        'bank_name' => false,
        'bank_branch' => false,
        'bank_account' => false,
        'website' => false,
        'phone_number' => false,
        'fax_number' => false,
        'mobile_number' => false,
        'ddi_number' => false,
        'toll_free_number' => false,
        'email' => false,
        'email_cc' => false,
        'currency' => false,
        'notes' => false,
        'taxable' => false,
        'xero_contact_id' => false,
        'sales_person' => false,
        'discount_rate' => false,
        'print_packing_slip_instead_of_invoice' => false,
        'print_invoice' => false,
        'stop_credit' => false,
        'obsolete' => false,
        'xero_sales_account' => false,
        'xero_cost_of_goods_account' => false,
        'sell_price_tier' => false,
        'customer_type' => false,
        'payment_term' => false,
        'contact_first_name' => false,
        'contact_last_name' => false,
        'source_id' => false,
        'created_by' => false,
        'guid' => false,
        'last_modified_on' => false,
        'contacts' => false,
        'tax_code' => false,
        'tax_rate' => false,
        'created_on' => false,
        'eori_number' => false,
        'credit_limit' => false,
        'default_warehouse' => false,
        'delivery_instruction' => false,
        'delivery_method' => false,
        'has_credit_limit' => false,
        'reminder' => false,
        'sales_order_group' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'addresses' => 'Addresses',
        'customer_code' => 'CustomerCode',
        'customer_name' => 'CustomerName',
        'gstvat_number' => 'GSTVATNumber',
        'bank_name' => 'BankName',
        'bank_branch' => 'BankBranch',
        'bank_account' => 'BankAccount',
        'website' => 'Website',
        'phone_number' => 'PhoneNumber',
        'fax_number' => 'FaxNumber',
        'mobile_number' => 'MobileNumber',
        'ddi_number' => 'DDINumber',
        'toll_free_number' => 'TollFreeNumber',
        'email' => 'Email',
        'email_cc' => 'EmailCC',
        'currency' => 'Currency',
        'notes' => 'Notes',
        'taxable' => 'Taxable',
        'xero_contact_id' => 'XeroContactId',
        'sales_person' => 'SalesPerson',
        'discount_rate' => 'DiscountRate',
        'print_packing_slip_instead_of_invoice' => 'PrintPackingSlipInsteadOfInvoice',
        'print_invoice' => 'PrintInvoice',
        'stop_credit' => 'StopCredit',
        'obsolete' => 'Obsolete',
        'xero_sales_account' => 'XeroSalesAccount',
        'xero_cost_of_goods_account' => 'XeroCostOfGoodsAccount',
        'sell_price_tier' => 'SellPriceTier',
        'customer_type' => 'CustomerType',
        'payment_term' => 'PaymentTerm',
        'contact_first_name' => 'ContactFirstName',
        'contact_last_name' => 'ContactLastName',
        'source_id' => 'SourceId',
        'created_by' => 'CreatedBy',
        'guid' => 'Guid',
        'last_modified_on' => 'LastModifiedOn',
        'contacts' => 'Contacts',
        'tax_code' => 'TaxCode',
        'tax_rate' => 'TaxRate',
        'created_on' => 'CreatedOn',
        'eori_number' => 'EORINumber',
        'credit_limit' => 'CreditLimit',
        'default_warehouse' => 'DefaultWarehouse',
        'delivery_instruction' => 'DeliveryInstruction',
        'delivery_method' => 'DeliveryMethod',
        'has_credit_limit' => 'HasCreditLimit',
        'reminder' => 'Reminder',
        'sales_order_group' => 'SalesOrderGroup'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'addresses' => 'setAddresses',
        'customer_code' => 'setCustomerCode',
        'customer_name' => 'setCustomerName',
        'gstvat_number' => 'setGstvatNumber',
        'bank_name' => 'setBankName',
        'bank_branch' => 'setBankBranch',
        'bank_account' => 'setBankAccount',
        'website' => 'setWebsite',
        'phone_number' => 'setPhoneNumber',
        'fax_number' => 'setFaxNumber',
        'mobile_number' => 'setMobileNumber',
        'ddi_number' => 'setDdiNumber',
        'toll_free_number' => 'setTollFreeNumber',
        'email' => 'setEmail',
        'email_cc' => 'setEmailCc',
        'currency' => 'setCurrency',
        'notes' => 'setNotes',
        'taxable' => 'setTaxable',
        'xero_contact_id' => 'setXeroContactId',
        'sales_person' => 'setSalesPerson',
        'discount_rate' => 'setDiscountRate',
        'print_packing_slip_instead_of_invoice' => 'setPrintPackingSlipInsteadOfInvoice',
        'print_invoice' => 'setPrintInvoice',
        'stop_credit' => 'setStopCredit',
        'obsolete' => 'setObsolete',
        'xero_sales_account' => 'setXeroSalesAccount',
        'xero_cost_of_goods_account' => 'setXeroCostOfGoodsAccount',
        'sell_price_tier' => 'setSellPriceTier',
        'customer_type' => 'setCustomerType',
        'payment_term' => 'setPaymentTerm',
        'contact_first_name' => 'setContactFirstName',
        'contact_last_name' => 'setContactLastName',
        'source_id' => 'setSourceId',
        'created_by' => 'setCreatedBy',
        'guid' => 'setGuid',
        'last_modified_on' => 'setLastModifiedOn',
        'contacts' => 'setContacts',
        'tax_code' => 'setTaxCode',
        'tax_rate' => 'setTaxRate',
        'created_on' => 'setCreatedOn',
        'eori_number' => 'setEoriNumber',
        'credit_limit' => 'setCreditLimit',
        'default_warehouse' => 'setDefaultWarehouse',
        'delivery_instruction' => 'setDeliveryInstruction',
        'delivery_method' => 'setDeliveryMethod',
        'has_credit_limit' => 'setHasCreditLimit',
        'reminder' => 'setReminder',
        'sales_order_group' => 'setSalesOrderGroup'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'addresses' => 'getAddresses',
        'customer_code' => 'getCustomerCode',
        'customer_name' => 'getCustomerName',
        'gstvat_number' => 'getGstvatNumber',
        'bank_name' => 'getBankName',
        'bank_branch' => 'getBankBranch',
        'bank_account' => 'getBankAccount',
        'website' => 'getWebsite',
        'phone_number' => 'getPhoneNumber',
        'fax_number' => 'getFaxNumber',
        'mobile_number' => 'getMobileNumber',
        'ddi_number' => 'getDdiNumber',
        'toll_free_number' => 'getTollFreeNumber',
        'email' => 'getEmail',
        'email_cc' => 'getEmailCc',
        'currency' => 'getCurrency',
        'notes' => 'getNotes',
        'taxable' => 'getTaxable',
        'xero_contact_id' => 'getXeroContactId',
        'sales_person' => 'getSalesPerson',
        'discount_rate' => 'getDiscountRate',
        'print_packing_slip_instead_of_invoice' => 'getPrintPackingSlipInsteadOfInvoice',
        'print_invoice' => 'getPrintInvoice',
        'stop_credit' => 'getStopCredit',
        'obsolete' => 'getObsolete',
        'xero_sales_account' => 'getXeroSalesAccount',
        'xero_cost_of_goods_account' => 'getXeroCostOfGoodsAccount',
        'sell_price_tier' => 'getSellPriceTier',
        'customer_type' => 'getCustomerType',
        'payment_term' => 'getPaymentTerm',
        'contact_first_name' => 'getContactFirstName',
        'contact_last_name' => 'getContactLastName',
        'source_id' => 'getSourceId',
        'created_by' => 'getCreatedBy',
        'guid' => 'getGuid',
        'last_modified_on' => 'getLastModifiedOn',
        'contacts' => 'getContacts',
        'tax_code' => 'getTaxCode',
        'tax_rate' => 'getTaxRate',
        'created_on' => 'getCreatedOn',
        'eori_number' => 'getEoriNumber',
        'credit_limit' => 'getCreditLimit',
        'default_warehouse' => 'getDefaultWarehouse',
        'delivery_instruction' => 'getDeliveryInstruction',
        'delivery_method' => 'getDeliveryMethod',
        'has_credit_limit' => 'getHasCreditLimit',
        'reminder' => 'getReminder',
        'sales_order_group' => 'getSalesOrderGroup'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('addresses', $data ?? [], null);
        $this->setIfExists('customer_code', $data ?? [], null);
        $this->setIfExists('customer_name', $data ?? [], null);
        $this->setIfExists('gstvat_number', $data ?? [], null);
        $this->setIfExists('bank_name', $data ?? [], null);
        $this->setIfExists('bank_branch', $data ?? [], null);
        $this->setIfExists('bank_account', $data ?? [], null);
        $this->setIfExists('website', $data ?? [], null);
        $this->setIfExists('phone_number', $data ?? [], null);
        $this->setIfExists('fax_number', $data ?? [], null);
        $this->setIfExists('mobile_number', $data ?? [], null);
        $this->setIfExists('ddi_number', $data ?? [], null);
        $this->setIfExists('toll_free_number', $data ?? [], null);
        $this->setIfExists('email', $data ?? [], null);
        $this->setIfExists('email_cc', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('taxable', $data ?? [], null);
        $this->setIfExists('xero_contact_id', $data ?? [], null);
        $this->setIfExists('sales_person', $data ?? [], null);
        $this->setIfExists('discount_rate', $data ?? [], null);
        $this->setIfExists('print_packing_slip_instead_of_invoice', $data ?? [], null);
        $this->setIfExists('print_invoice', $data ?? [], null);
        $this->setIfExists('stop_credit', $data ?? [], null);
        $this->setIfExists('obsolete', $data ?? [], null);
        $this->setIfExists('xero_sales_account', $data ?? [], null);
        $this->setIfExists('xero_cost_of_goods_account', $data ?? [], null);
        $this->setIfExists('sell_price_tier', $data ?? [], null);
        $this->setIfExists('customer_type', $data ?? [], null);
        $this->setIfExists('payment_term', $data ?? [], null);
        $this->setIfExists('contact_first_name', $data ?? [], null);
        $this->setIfExists('contact_last_name', $data ?? [], null);
        $this->setIfExists('source_id', $data ?? [], null);
        $this->setIfExists('created_by', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
        $this->setIfExists('contacts', $data ?? [], null);
        $this->setIfExists('tax_code', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('created_on', $data ?? [], null);
        $this->setIfExists('eori_number', $data ?? [], null);
        $this->setIfExists('credit_limit', $data ?? [], null);
        $this->setIfExists('default_warehouse', $data ?? [], null);
        $this->setIfExists('delivery_instruction', $data ?? [], null);
        $this->setIfExists('delivery_method', $data ?? [], null);
        $this->setIfExists('has_credit_limit', $data ?? [], null);
        $this->setIfExists('reminder', $data ?? [], null);
        $this->setIfExists('sales_order_group', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets addresses
     *
     * @return \Unleashed\Model\Address[]|null
     */
    public function getAddresses()
    {
        return $this->container['addresses'];
    }

    /**
     * Sets addresses
     *
     * @param \Unleashed\Model\Address[]|null $addresses addresses
     *
     * @return self
     */
    public function setAddresses($addresses)
    {
        if (is_null($addresses)) {
            throw new \InvalidArgumentException('non-nullable addresses cannot be null');
        }
        $this->container['addresses'] = $addresses;

        return $this;
    }

    /**
     * Gets customer_code
     *
     * @return string|null
     */
    public function getCustomerCode()
    {
        return $this->container['customer_code'];
    }

    /**
     * Sets customer_code
     *
     * @param string|null $customer_code customer_code
     *
     * @return self
     */
    public function setCustomerCode($customer_code)
    {
        if (is_null($customer_code)) {
            throw new \InvalidArgumentException('non-nullable customer_code cannot be null');
        }
        $this->container['customer_code'] = $customer_code;

        return $this;
    }

    /**
     * Gets customer_name
     *
     * @return string|null
     */
    public function getCustomerName()
    {
        return $this->container['customer_name'];
    }

    /**
     * Sets customer_name
     *
     * @param string|null $customer_name customer_name
     *
     * @return self
     */
    public function setCustomerName($customer_name)
    {
        if (is_null($customer_name)) {
            throw new \InvalidArgumentException('non-nullable customer_name cannot be null');
        }
        $this->container['customer_name'] = $customer_name;

        return $this;
    }

    /**
     * Gets gstvat_number
     *
     * @return string|null
     */
    public function getGstvatNumber()
    {
        return $this->container['gstvat_number'];
    }

    /**
     * Sets gstvat_number
     *
     * @param string|null $gstvat_number gstvat_number
     *
     * @return self
     */
    public function setGstvatNumber($gstvat_number)
    {
        if (is_null($gstvat_number)) {
            throw new \InvalidArgumentException('non-nullable gstvat_number cannot be null');
        }
        $this->container['gstvat_number'] = $gstvat_number;

        return $this;
    }

    /**
     * Gets bank_name
     *
     * @return string|null
     */
    public function getBankName()
    {
        return $this->container['bank_name'];
    }

    /**
     * Sets bank_name
     *
     * @param string|null $bank_name bank_name
     *
     * @return self
     */
    public function setBankName($bank_name)
    {
        if (is_null($bank_name)) {
            throw new \InvalidArgumentException('non-nullable bank_name cannot be null');
        }
        $this->container['bank_name'] = $bank_name;

        return $this;
    }

    /**
     * Gets bank_branch
     *
     * @return string|null
     */
    public function getBankBranch()
    {
        return $this->container['bank_branch'];
    }

    /**
     * Sets bank_branch
     *
     * @param string|null $bank_branch bank_branch
     *
     * @return self
     */
    public function setBankBranch($bank_branch)
    {
        if (is_null($bank_branch)) {
            throw new \InvalidArgumentException('non-nullable bank_branch cannot be null');
        }
        $this->container['bank_branch'] = $bank_branch;

        return $this;
    }

    /**
     * Gets bank_account
     *
     * @return string|null
     */
    public function getBankAccount()
    {
        return $this->container['bank_account'];
    }

    /**
     * Sets bank_account
     *
     * @param string|null $bank_account bank_account
     *
     * @return self
     */
    public function setBankAccount($bank_account)
    {
        if (is_null($bank_account)) {
            throw new \InvalidArgumentException('non-nullable bank_account cannot be null');
        }
        $this->container['bank_account'] = $bank_account;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string|null $website website
     *
     * @return self
     */
    public function setWebsite($website)
    {
        if (is_null($website)) {
            throw new \InvalidArgumentException('non-nullable website cannot be null');
        }
        $this->container['website'] = $website;

        return $this;
    }

    /**
     * Gets phone_number
     *
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->container['phone_number'];
    }

    /**
     * Sets phone_number
     *
     * @param string|null $phone_number phone_number
     *
     * @return self
     */
    public function setPhoneNumber($phone_number)
    {
        if (is_null($phone_number)) {
            throw new \InvalidArgumentException('non-nullable phone_number cannot be null');
        }
        $this->container['phone_number'] = $phone_number;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param string|null $fax_number fax_number
     *
     * @return self
     */
    public function setFaxNumber($fax_number)
    {
        if (is_null($fax_number)) {
            throw new \InvalidArgumentException('non-nullable fax_number cannot be null');
        }
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets mobile_number
     *
     * @return string|null
     */
    public function getMobileNumber()
    {
        return $this->container['mobile_number'];
    }

    /**
     * Sets mobile_number
     *
     * @param string|null $mobile_number mobile_number
     *
     * @return self
     */
    public function setMobileNumber($mobile_number)
    {
        if (is_null($mobile_number)) {
            throw new \InvalidArgumentException('non-nullable mobile_number cannot be null');
        }
        $this->container['mobile_number'] = $mobile_number;

        return $this;
    }

    /**
     * Gets ddi_number
     *
     * @return string|null
     */
    public function getDdiNumber()
    {
        return $this->container['ddi_number'];
    }

    /**
     * Sets ddi_number
     *
     * @param string|null $ddi_number ddi_number
     *
     * @return self
     */
    public function setDdiNumber($ddi_number)
    {
        if (is_null($ddi_number)) {
            throw new \InvalidArgumentException('non-nullable ddi_number cannot be null');
        }
        $this->container['ddi_number'] = $ddi_number;

        return $this;
    }

    /**
     * Gets toll_free_number
     *
     * @return string|null
     */
    public function getTollFreeNumber()
    {
        return $this->container['toll_free_number'];
    }

    /**
     * Sets toll_free_number
     *
     * @param string|null $toll_free_number toll_free_number
     *
     * @return self
     */
    public function setTollFreeNumber($toll_free_number)
    {
        if (is_null($toll_free_number)) {
            throw new \InvalidArgumentException('non-nullable toll_free_number cannot be null');
        }
        $this->container['toll_free_number'] = $toll_free_number;

        return $this;
    }

    /**
     * Gets email
     *
     * @return string|null
     */
    public function getEmail()
    {
        return $this->container['email'];
    }

    /**
     * Sets email
     *
     * @param string|null $email email
     *
     * @return self
     */
    public function setEmail($email)
    {
        if (is_null($email)) {
            throw new \InvalidArgumentException('non-nullable email cannot be null');
        }
        $this->container['email'] = $email;

        return $this;
    }

    /**
     * Gets email_cc
     *
     * @return string|null
     */
    public function getEmailCc()
    {
        return $this->container['email_cc'];
    }

    /**
     * Sets email_cc
     *
     * @param string|null $email_cc email_cc
     *
     * @return self
     */
    public function setEmailCc($email_cc)
    {
        if (is_null($email_cc)) {
            throw new \InvalidArgumentException('non-nullable email_cc cannot be null');
        }
        $this->container['email_cc'] = $email_cc;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Unleashed\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Unleashed\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets taxable
     *
     * @return bool|null
     */
    public function getTaxable()
    {
        return $this->container['taxable'];
    }

    /**
     * Sets taxable
     *
     * @param bool|null $taxable taxable
     *
     * @return self
     */
    public function setTaxable($taxable)
    {
        if (is_null($taxable)) {
            throw new \InvalidArgumentException('non-nullable taxable cannot be null');
        }
        $this->container['taxable'] = $taxable;

        return $this;
    }

    /**
     * Gets xero_contact_id
     *
     * @return string|null
     */
    public function getXeroContactId()
    {
        return $this->container['xero_contact_id'];
    }

    /**
     * Sets xero_contact_id
     *
     * @param string|null $xero_contact_id xero_contact_id
     *
     * @return self
     */
    public function setXeroContactId($xero_contact_id)
    {
        if (is_null($xero_contact_id)) {
            throw new \InvalidArgumentException('non-nullable xero_contact_id cannot be null');
        }
        $this->container['xero_contact_id'] = $xero_contact_id;

        return $this;
    }

    /**
     * Gets sales_person
     *
     * @return \Unleashed\Model\SalesPerson|null
     */
    public function getSalesPerson()
    {
        return $this->container['sales_person'];
    }

    /**
     * Sets sales_person
     *
     * @param \Unleashed\Model\SalesPerson|null $sales_person sales_person
     *
     * @return self
     */
    public function setSalesPerson($sales_person)
    {
        if (is_null($sales_person)) {
            throw new \InvalidArgumentException('non-nullable sales_person cannot be null');
        }
        $this->container['sales_person'] = $sales_person;

        return $this;
    }

    /**
     * Gets discount_rate
     *
     * @return float|null
     */
    public function getDiscountRate()
    {
        return $this->container['discount_rate'];
    }

    /**
     * Sets discount_rate
     *
     * @param float|null $discount_rate discount_rate
     *
     * @return self
     */
    public function setDiscountRate($discount_rate)
    {
        if (is_null($discount_rate)) {
            throw new \InvalidArgumentException('non-nullable discount_rate cannot be null');
        }
        $this->container['discount_rate'] = $discount_rate;

        return $this;
    }

    /**
     * Gets print_packing_slip_instead_of_invoice
     *
     * @return bool|null
     */
    public function getPrintPackingSlipInsteadOfInvoice()
    {
        return $this->container['print_packing_slip_instead_of_invoice'];
    }

    /**
     * Sets print_packing_slip_instead_of_invoice
     *
     * @param bool|null $print_packing_slip_instead_of_invoice print_packing_slip_instead_of_invoice
     *
     * @return self
     */
    public function setPrintPackingSlipInsteadOfInvoice($print_packing_slip_instead_of_invoice)
    {
        if (is_null($print_packing_slip_instead_of_invoice)) {
            throw new \InvalidArgumentException('non-nullable print_packing_slip_instead_of_invoice cannot be null');
        }
        $this->container['print_packing_slip_instead_of_invoice'] = $print_packing_slip_instead_of_invoice;

        return $this;
    }

    /**
     * Gets print_invoice
     *
     * @return bool|null
     */
    public function getPrintInvoice()
    {
        return $this->container['print_invoice'];
    }

    /**
     * Sets print_invoice
     *
     * @param bool|null $print_invoice print_invoice
     *
     * @return self
     */
    public function setPrintInvoice($print_invoice)
    {
        if (is_null($print_invoice)) {
            throw new \InvalidArgumentException('non-nullable print_invoice cannot be null');
        }
        $this->container['print_invoice'] = $print_invoice;

        return $this;
    }

    /**
     * Gets stop_credit
     *
     * @return bool|null
     */
    public function getStopCredit()
    {
        return $this->container['stop_credit'];
    }

    /**
     * Sets stop_credit
     *
     * @param bool|null $stop_credit stop_credit
     *
     * @return self
     */
    public function setStopCredit($stop_credit)
    {
        if (is_null($stop_credit)) {
            throw new \InvalidArgumentException('non-nullable stop_credit cannot be null');
        }
        $this->container['stop_credit'] = $stop_credit;

        return $this;
    }

    /**
     * Gets obsolete
     *
     * @return bool|null
     */
    public function getObsolete()
    {
        return $this->container['obsolete'];
    }

    /**
     * Sets obsolete
     *
     * @param bool|null $obsolete obsolete
     *
     * @return self
     */
    public function setObsolete($obsolete)
    {
        if (is_null($obsolete)) {
            throw new \InvalidArgumentException('non-nullable obsolete cannot be null');
        }
        $this->container['obsolete'] = $obsolete;

        return $this;
    }

    /**
     * Gets xero_sales_account
     *
     * @return string|null
     */
    public function getXeroSalesAccount()
    {
        return $this->container['xero_sales_account'];
    }

    /**
     * Sets xero_sales_account
     *
     * @param string|null $xero_sales_account xero_sales_account
     *
     * @return self
     */
    public function setXeroSalesAccount($xero_sales_account)
    {
        if (is_null($xero_sales_account)) {
            throw new \InvalidArgumentException('non-nullable xero_sales_account cannot be null');
        }
        $this->container['xero_sales_account'] = $xero_sales_account;

        return $this;
    }

    /**
     * Gets xero_cost_of_goods_account
     *
     * @return string|null
     */
    public function getXeroCostOfGoodsAccount()
    {
        return $this->container['xero_cost_of_goods_account'];
    }

    /**
     * Sets xero_cost_of_goods_account
     *
     * @param string|null $xero_cost_of_goods_account xero_cost_of_goods_account
     *
     * @return self
     */
    public function setXeroCostOfGoodsAccount($xero_cost_of_goods_account)
    {
        if (is_null($xero_cost_of_goods_account)) {
            throw new \InvalidArgumentException('non-nullable xero_cost_of_goods_account cannot be null');
        }
        $this->container['xero_cost_of_goods_account'] = $xero_cost_of_goods_account;

        return $this;
    }

    /**
     * Gets sell_price_tier
     *
     * @return string|null
     */
    public function getSellPriceTier()
    {
        return $this->container['sell_price_tier'];
    }

    /**
     * Sets sell_price_tier
     *
     * @param string|null $sell_price_tier sell_price_tier
     *
     * @return self
     */
    public function setSellPriceTier($sell_price_tier)
    {
        if (is_null($sell_price_tier)) {
            throw new \InvalidArgumentException('non-nullable sell_price_tier cannot be null');
        }
        $this->container['sell_price_tier'] = $sell_price_tier;

        return $this;
    }

    /**
     * Gets customer_type
     *
     * @return string|null
     */
    public function getCustomerType()
    {
        return $this->container['customer_type'];
    }

    /**
     * Sets customer_type
     *
     * @param string|null $customer_type customer_type
     *
     * @return self
     */
    public function setCustomerType($customer_type)
    {
        if (is_null($customer_type)) {
            throw new \InvalidArgumentException('non-nullable customer_type cannot be null');
        }
        $this->container['customer_type'] = $customer_type;

        return $this;
    }

    /**
     * Gets payment_term
     *
     * @return string|null
     */
    public function getPaymentTerm()
    {
        return $this->container['payment_term'];
    }

    /**
     * Sets payment_term
     *
     * @param string|null $payment_term payment_term
     *
     * @return self
     */
    public function setPaymentTerm($payment_term)
    {
        if (is_null($payment_term)) {
            throw new \InvalidArgumentException('non-nullable payment_term cannot be null');
        }
        $this->container['payment_term'] = $payment_term;

        return $this;
    }

    /**
     * Gets contact_first_name
     *
     * @return string|null
     */
    public function getContactFirstName()
    {
        return $this->container['contact_first_name'];
    }

    /**
     * Sets contact_first_name
     *
     * @param string|null $contact_first_name contact_first_name
     *
     * @return self
     */
    public function setContactFirstName($contact_first_name)
    {
        if (is_null($contact_first_name)) {
            throw new \InvalidArgumentException('non-nullable contact_first_name cannot be null');
        }
        $this->container['contact_first_name'] = $contact_first_name;

        return $this;
    }

    /**
     * Gets contact_last_name
     *
     * @return string|null
     */
    public function getContactLastName()
    {
        return $this->container['contact_last_name'];
    }

    /**
     * Sets contact_last_name
     *
     * @param string|null $contact_last_name contact_last_name
     *
     * @return self
     */
    public function setContactLastName($contact_last_name)
    {
        if (is_null($contact_last_name)) {
            throw new \InvalidArgumentException('non-nullable contact_last_name cannot be null');
        }
        $this->container['contact_last_name'] = $contact_last_name;

        return $this;
    }

    /**
     * Gets source_id
     *
     * @return string|null
     */
    public function getSourceId()
    {
        return $this->container['source_id'];
    }

    /**
     * Sets source_id
     *
     * @param string|null $source_id source_id
     *
     * @return self
     */
    public function setSourceId($source_id)
    {
        if (is_null($source_id)) {
            throw new \InvalidArgumentException('non-nullable source_id cannot be null');
        }
        $this->container['source_id'] = $source_id;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        if (is_null($created_by)) {
            throw new \InvalidArgumentException('non-nullable created_by cannot be null');
        }
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets contacts
     *
     * @return \Unleashed\Model\Contact[]|null
     */
    public function getContacts()
    {
        return $this->container['contacts'];
    }

    /**
     * Sets contacts
     *
     * @param \Unleashed\Model\Contact[]|null $contacts contacts
     *
     * @return self
     */
    public function setContacts($contacts)
    {
        if (is_null($contacts)) {
            throw new \InvalidArgumentException('non-nullable contacts cannot be null');
        }
        $this->container['contacts'] = $contacts;

        return $this;
    }

    /**
     * Gets tax_code
     *
     * @return string|null
     */
    public function getTaxCode()
    {
        return $this->container['tax_code'];
    }

    /**
     * Sets tax_code
     *
     * @param string|null $tax_code tax_code
     *
     * @return self
     */
    public function setTaxCode($tax_code)
    {
        if (is_null($tax_code)) {
            throw new \InvalidArgumentException('non-nullable tax_code cannot be null');
        }
        $this->container['tax_code'] = $tax_code;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        if (is_null($created_on)) {
            throw new \InvalidArgumentException('non-nullable created_on cannot be null');
        }
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets eori_number
     *
     * @return string|null
     */
    public function getEoriNumber()
    {
        return $this->container['eori_number'];
    }

    /**
     * Sets eori_number
     *
     * @param string|null $eori_number eori_number
     *
     * @return self
     */
    public function setEoriNumber($eori_number)
    {
        if (is_null($eori_number)) {
            throw new \InvalidArgumentException('non-nullable eori_number cannot be null');
        }
        $this->container['eori_number'] = $eori_number;

        return $this;
    }

    /**
     * Gets credit_limit
     *
     * @return string|null
     */
    public function getCreditLimit()
    {
        return $this->container['credit_limit'];
    }

    /**
     * Sets credit_limit
     *
     * @param string|null $credit_limit credit_limit
     *
     * @return self
     */
    public function setCreditLimit($credit_limit)
    {
        if (is_null($credit_limit)) {
            throw new \InvalidArgumentException('non-nullable credit_limit cannot be null');
        }
        $this->container['credit_limit'] = $credit_limit;

        return $this;
    }

    /**
     * Gets default_warehouse
     *
     * @return \Unleashed\Model\Warehouse|null
     */
    public function getDefaultWarehouse()
    {
        return $this->container['default_warehouse'];
    }

    /**
     * Sets default_warehouse
     *
     * @param \Unleashed\Model\Warehouse|null $default_warehouse default_warehouse
     *
     * @return self
     */
    public function setDefaultWarehouse($default_warehouse)
    {
        if (is_null($default_warehouse)) {
            throw new \InvalidArgumentException('non-nullable default_warehouse cannot be null');
        }
        $this->container['default_warehouse'] = $default_warehouse;

        return $this;
    }

    /**
     * Gets delivery_instruction
     *
     * @return string|null
     */
    public function getDeliveryInstruction()
    {
        return $this->container['delivery_instruction'];
    }

    /**
     * Sets delivery_instruction
     *
     * @param string|null $delivery_instruction delivery_instruction
     *
     * @return self
     */
    public function setDeliveryInstruction($delivery_instruction)
    {
        if (is_null($delivery_instruction)) {
            throw new \InvalidArgumentException('non-nullable delivery_instruction cannot be null');
        }
        $this->container['delivery_instruction'] = $delivery_instruction;

        return $this;
    }

    /**
     * Gets delivery_method
     *
     * @return string|null
     */
    public function getDeliveryMethod()
    {
        return $this->container['delivery_method'];
    }

    /**
     * Sets delivery_method
     *
     * @param string|null $delivery_method delivery_method
     *
     * @return self
     */
    public function setDeliveryMethod($delivery_method)
    {
        if (is_null($delivery_method)) {
            throw new \InvalidArgumentException('non-nullable delivery_method cannot be null');
        }
        $this->container['delivery_method'] = $delivery_method;

        return $this;
    }

    /**
     * Gets has_credit_limit
     *
     * @return bool|null
     */
    public function getHasCreditLimit()
    {
        return $this->container['has_credit_limit'];
    }

    /**
     * Sets has_credit_limit
     *
     * @param bool|null $has_credit_limit has_credit_limit
     *
     * @return self
     */
    public function setHasCreditLimit($has_credit_limit)
    {
        if (is_null($has_credit_limit)) {
            throw new \InvalidArgumentException('non-nullable has_credit_limit cannot be null');
        }
        $this->container['has_credit_limit'] = $has_credit_limit;

        return $this;
    }

    /**
     * Gets reminder
     *
     * @return string|null
     */
    public function getReminder()
    {
        return $this->container['reminder'];
    }

    /**
     * Sets reminder
     *
     * @param string|null $reminder reminder
     *
     * @return self
     */
    public function setReminder($reminder)
    {
        if (is_null($reminder)) {
            throw new \InvalidArgumentException('non-nullable reminder cannot be null');
        }
        $this->container['reminder'] = $reminder;

        return $this;
    }

    /**
     * Gets sales_order_group
     *
     * @return string|null
     */
    public function getSalesOrderGroup()
    {
        return $this->container['sales_order_group'];
    }

    /**
     * Sets sales_order_group
     *
     * @param string|null $sales_order_group sales_order_group
     *
     * @return self
     */
    public function setSalesOrderGroup($sales_order_group)
    {
        if (is_null($sales_order_group)) {
            throw new \InvalidArgumentException('non-nullable sales_order_group cannot be null');
        }
        $this->container['sales_order_group'] = $sales_order_group;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


