<?php
/**
 * CreditNote
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * CreditNote Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class CreditNote implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'creditNote';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'credit_note_number' => 'string',
        'credit_date' => 'string',
        'sales_invoice_date' => 'string',
        'required_delivery_date' => 'string',
        'warehouse' => '\Unleashed\Model\Warehouse',
        'customer' => '\Unleashed\Model\Customer',
        'credit_status' => 'string',
        'currency' => '\Unleashed\Model\Currency',
        'total' => 'float',
        'invoice_number' => 'string',
        'reference_number' => 'string',
        'credit_note_lines' => '\Unleashed\Model\CreditNoteLine[]',
        'comments' => 'string',
        'tax_rate' => 'float',
        'xero_tax_code' => 'string',
        'tax_total' => 'float',
        'sub_total' => 'float',
        'tax' => '\Unleashed\Model\Tax',
        'last_modified_by' => 'string',
        'last_modified_on' => 'string',
        'created_by' => 'string',
        'created_on' => 'string',
        'guid' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'credit_note_number' => null,
        'credit_date' => null,
        'sales_invoice_date' => null,
        'required_delivery_date' => null,
        'warehouse' => null,
        'customer' => null,
        'credit_status' => null,
        'currency' => null,
        'total' => null,
        'invoice_number' => null,
        'reference_number' => null,
        'credit_note_lines' => null,
        'comments' => null,
        'tax_rate' => null,
        'xero_tax_code' => null,
        'tax_total' => null,
        'sub_total' => null,
        'tax' => null,
        'last_modified_by' => null,
        'last_modified_on' => null,
        'created_by' => null,
        'created_on' => null,
        'guid' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'credit_note_number' => false,
        'credit_date' => false,
        'sales_invoice_date' => false,
        'required_delivery_date' => false,
        'warehouse' => false,
        'customer' => false,
        'credit_status' => false,
        'currency' => false,
        'total' => false,
        'invoice_number' => false,
        'reference_number' => false,
        'credit_note_lines' => false,
        'comments' => false,
        'tax_rate' => false,
        'xero_tax_code' => false,
        'tax_total' => false,
        'sub_total' => false,
        'tax' => false,
        'last_modified_by' => false,
        'last_modified_on' => false,
        'created_by' => false,
        'created_on' => false,
        'guid' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'credit_note_number' => 'CreditNoteNumber',
        'credit_date' => 'CreditDate',
        'sales_invoice_date' => 'SalesInvoiceDate',
        'required_delivery_date' => 'RequiredDeliveryDate',
        'warehouse' => 'Warehouse',
        'customer' => 'Customer',
        'credit_status' => 'CreditStatus',
        'currency' => 'Currency',
        'total' => 'Total',
        'invoice_number' => 'InvoiceNumber',
        'reference_number' => 'ReferenceNumber',
        'credit_note_lines' => 'CreditNoteLines',
        'comments' => 'Comments',
        'tax_rate' => 'TaxRate',
        'xero_tax_code' => 'XeroTaxCode',
        'tax_total' => 'TaxTotal',
        'sub_total' => 'SubTotal',
        'tax' => 'Tax',
        'last_modified_by' => 'LastModifiedBy',
        'last_modified_on' => 'LastModifiedOn',
        'created_by' => 'CreatedBy',
        'created_on' => 'CreatedOn',
        'guid' => 'Guid'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'credit_note_number' => 'setCreditNoteNumber',
        'credit_date' => 'setCreditDate',
        'sales_invoice_date' => 'setSalesInvoiceDate',
        'required_delivery_date' => 'setRequiredDeliveryDate',
        'warehouse' => 'setWarehouse',
        'customer' => 'setCustomer',
        'credit_status' => 'setCreditStatus',
        'currency' => 'setCurrency',
        'total' => 'setTotal',
        'invoice_number' => 'setInvoiceNumber',
        'reference_number' => 'setReferenceNumber',
        'credit_note_lines' => 'setCreditNoteLines',
        'comments' => 'setComments',
        'tax_rate' => 'setTaxRate',
        'xero_tax_code' => 'setXeroTaxCode',
        'tax_total' => 'setTaxTotal',
        'sub_total' => 'setSubTotal',
        'tax' => 'setTax',
        'last_modified_by' => 'setLastModifiedBy',
        'last_modified_on' => 'setLastModifiedOn',
        'created_by' => 'setCreatedBy',
        'created_on' => 'setCreatedOn',
        'guid' => 'setGuid'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'credit_note_number' => 'getCreditNoteNumber',
        'credit_date' => 'getCreditDate',
        'sales_invoice_date' => 'getSalesInvoiceDate',
        'required_delivery_date' => 'getRequiredDeliveryDate',
        'warehouse' => 'getWarehouse',
        'customer' => 'getCustomer',
        'credit_status' => 'getCreditStatus',
        'currency' => 'getCurrency',
        'total' => 'getTotal',
        'invoice_number' => 'getInvoiceNumber',
        'reference_number' => 'getReferenceNumber',
        'credit_note_lines' => 'getCreditNoteLines',
        'comments' => 'getComments',
        'tax_rate' => 'getTaxRate',
        'xero_tax_code' => 'getXeroTaxCode',
        'tax_total' => 'getTaxTotal',
        'sub_total' => 'getSubTotal',
        'tax' => 'getTax',
        'last_modified_by' => 'getLastModifiedBy',
        'last_modified_on' => 'getLastModifiedOn',
        'created_by' => 'getCreatedBy',
        'created_on' => 'getCreatedOn',
        'guid' => 'getGuid'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('credit_note_number', $data ?? [], null);
        $this->setIfExists('credit_date', $data ?? [], null);
        $this->setIfExists('sales_invoice_date', $data ?? [], null);
        $this->setIfExists('required_delivery_date', $data ?? [], null);
        $this->setIfExists('warehouse', $data ?? [], null);
        $this->setIfExists('customer', $data ?? [], null);
        $this->setIfExists('credit_status', $data ?? [], null);
        $this->setIfExists('currency', $data ?? [], null);
        $this->setIfExists('total', $data ?? [], null);
        $this->setIfExists('invoice_number', $data ?? [], null);
        $this->setIfExists('reference_number', $data ?? [], null);
        $this->setIfExists('credit_note_lines', $data ?? [], null);
        $this->setIfExists('comments', $data ?? [], null);
        $this->setIfExists('tax_rate', $data ?? [], null);
        $this->setIfExists('xero_tax_code', $data ?? [], null);
        $this->setIfExists('tax_total', $data ?? [], null);
        $this->setIfExists('sub_total', $data ?? [], null);
        $this->setIfExists('tax', $data ?? [], null);
        $this->setIfExists('last_modified_by', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
        $this->setIfExists('created_by', $data ?? [], null);
        $this->setIfExists('created_on', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets credit_note_number
     *
     * @return string|null
     */
    public function getCreditNoteNumber()
    {
        return $this->container['credit_note_number'];
    }

    /**
     * Sets credit_note_number
     *
     * @param string|null $credit_note_number credit_note_number
     *
     * @return self
     */
    public function setCreditNoteNumber($credit_note_number)
    {
        if (is_null($credit_note_number)) {
            throw new \InvalidArgumentException('non-nullable credit_note_number cannot be null');
        }
        $this->container['credit_note_number'] = $credit_note_number;

        return $this;
    }

    /**
     * Gets credit_date
     *
     * @return string|null
     */
    public function getCreditDate()
    {
        return $this->container['credit_date'];
    }

    /**
     * Sets credit_date
     *
     * @param string|null $credit_date credit_date
     *
     * @return self
     */
    public function setCreditDate($credit_date)
    {
        if (is_null($credit_date)) {
            throw new \InvalidArgumentException('non-nullable credit_date cannot be null');
        }
        $this->container['credit_date'] = $credit_date;

        return $this;
    }

    /**
     * Gets sales_invoice_date
     *
     * @return string|null
     */
    public function getSalesInvoiceDate()
    {
        return $this->container['sales_invoice_date'];
    }

    /**
     * Sets sales_invoice_date
     *
     * @param string|null $sales_invoice_date sales_invoice_date
     *
     * @return self
     */
    public function setSalesInvoiceDate($sales_invoice_date)
    {
        if (is_null($sales_invoice_date)) {
            throw new \InvalidArgumentException('non-nullable sales_invoice_date cannot be null');
        }
        $this->container['sales_invoice_date'] = $sales_invoice_date;

        return $this;
    }

    /**
     * Gets required_delivery_date
     *
     * @return string|null
     */
    public function getRequiredDeliveryDate()
    {
        return $this->container['required_delivery_date'];
    }

    /**
     * Sets required_delivery_date
     *
     * @param string|null $required_delivery_date required_delivery_date
     *
     * @return self
     */
    public function setRequiredDeliveryDate($required_delivery_date)
    {
        if (is_null($required_delivery_date)) {
            throw new \InvalidArgumentException('non-nullable required_delivery_date cannot be null');
        }
        $this->container['required_delivery_date'] = $required_delivery_date;

        return $this;
    }

    /**
     * Gets warehouse
     *
     * @return \Unleashed\Model\Warehouse|null
     */
    public function getWarehouse()
    {
        return $this->container['warehouse'];
    }

    /**
     * Sets warehouse
     *
     * @param \Unleashed\Model\Warehouse|null $warehouse warehouse
     *
     * @return self
     */
    public function setWarehouse($warehouse)
    {
        if (is_null($warehouse)) {
            throw new \InvalidArgumentException('non-nullable warehouse cannot be null');
        }
        $this->container['warehouse'] = $warehouse;

        return $this;
    }

    /**
     * Gets customer
     *
     * @return \Unleashed\Model\Customer|null
     */
    public function getCustomer()
    {
        return $this->container['customer'];
    }

    /**
     * Sets customer
     *
     * @param \Unleashed\Model\Customer|null $customer customer
     *
     * @return self
     */
    public function setCustomer($customer)
    {
        if (is_null($customer)) {
            throw new \InvalidArgumentException('non-nullable customer cannot be null');
        }
        $this->container['customer'] = $customer;

        return $this;
    }

    /**
     * Gets credit_status
     *
     * @return string|null
     */
    public function getCreditStatus()
    {
        return $this->container['credit_status'];
    }

    /**
     * Sets credit_status
     *
     * @param string|null $credit_status credit_status
     *
     * @return self
     */
    public function setCreditStatus($credit_status)
    {
        if (is_null($credit_status)) {
            throw new \InvalidArgumentException('non-nullable credit_status cannot be null');
        }
        $this->container['credit_status'] = $credit_status;

        return $this;
    }

    /**
     * Gets currency
     *
     * @return \Unleashed\Model\Currency|null
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     *
     * @param \Unleashed\Model\Currency|null $currency currency
     *
     * @return self
     */
    public function setCurrency($currency)
    {
        if (is_null($currency)) {
            throw new \InvalidArgumentException('non-nullable currency cannot be null');
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets total
     *
     * @return float|null
     */
    public function getTotal()
    {
        return $this->container['total'];
    }

    /**
     * Sets total
     *
     * @param float|null $total total
     *
     * @return self
     */
    public function setTotal($total)
    {
        if (is_null($total)) {
            throw new \InvalidArgumentException('non-nullable total cannot be null');
        }
        $this->container['total'] = $total;

        return $this;
    }

    /**
     * Gets invoice_number
     *
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return $this->container['invoice_number'];
    }

    /**
     * Sets invoice_number
     *
     * @param string|null $invoice_number invoice_number
     *
     * @return self
     */
    public function setInvoiceNumber($invoice_number)
    {
        if (is_null($invoice_number)) {
            throw new \InvalidArgumentException('non-nullable invoice_number cannot be null');
        }
        $this->container['invoice_number'] = $invoice_number;

        return $this;
    }

    /**
     * Gets reference_number
     *
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return $this->container['reference_number'];
    }

    /**
     * Sets reference_number
     *
     * @param string|null $reference_number reference_number
     *
     * @return self
     */
    public function setReferenceNumber($reference_number)
    {
        if (is_null($reference_number)) {
            throw new \InvalidArgumentException('non-nullable reference_number cannot be null');
        }
        $this->container['reference_number'] = $reference_number;

        return $this;
    }

    /**
     * Gets credit_note_lines
     *
     * @return \Unleashed\Model\CreditNoteLine[]|null
     */
    public function getCreditNoteLines()
    {
        return $this->container['credit_note_lines'];
    }

    /**
     * Sets credit_note_lines
     *
     * @param \Unleashed\Model\CreditNoteLine[]|null $credit_note_lines credit_note_lines
     *
     * @return self
     */
    public function setCreditNoteLines($credit_note_lines)
    {
        if (is_null($credit_note_lines)) {
            throw new \InvalidArgumentException('non-nullable credit_note_lines cannot be null');
        }
        $this->container['credit_note_lines'] = $credit_note_lines;

        return $this;
    }

    /**
     * Gets comments
     *
     * @return string|null
     */
    public function getComments()
    {
        return $this->container['comments'];
    }

    /**
     * Sets comments
     *
     * @param string|null $comments comments
     *
     * @return self
     */
    public function setComments($comments)
    {
        if (is_null($comments)) {
            throw new \InvalidArgumentException('non-nullable comments cannot be null');
        }
        $this->container['comments'] = $comments;

        return $this;
    }

    /**
     * Gets tax_rate
     *
     * @return float|null
     */
    public function getTaxRate()
    {
        return $this->container['tax_rate'];
    }

    /**
     * Sets tax_rate
     *
     * @param float|null $tax_rate tax_rate
     *
     * @return self
     */
    public function setTaxRate($tax_rate)
    {
        if (is_null($tax_rate)) {
            throw new \InvalidArgumentException('non-nullable tax_rate cannot be null');
        }
        $this->container['tax_rate'] = $tax_rate;

        return $this;
    }

    /**
     * Gets xero_tax_code
     *
     * @return string|null
     */
    public function getXeroTaxCode()
    {
        return $this->container['xero_tax_code'];
    }

    /**
     * Sets xero_tax_code
     *
     * @param string|null $xero_tax_code xero_tax_code
     *
     * @return self
     */
    public function setXeroTaxCode($xero_tax_code)
    {
        if (is_null($xero_tax_code)) {
            throw new \InvalidArgumentException('non-nullable xero_tax_code cannot be null');
        }
        $this->container['xero_tax_code'] = $xero_tax_code;

        return $this;
    }

    /**
     * Gets tax_total
     *
     * @return float|null
     */
    public function getTaxTotal()
    {
        return $this->container['tax_total'];
    }

    /**
     * Sets tax_total
     *
     * @param float|null $tax_total tax_total
     *
     * @return self
     */
    public function setTaxTotal($tax_total)
    {
        if (is_null($tax_total)) {
            throw new \InvalidArgumentException('non-nullable tax_total cannot be null');
        }
        $this->container['tax_total'] = $tax_total;

        return $this;
    }

    /**
     * Gets sub_total
     *
     * @return float|null
     */
    public function getSubTotal()
    {
        return $this->container['sub_total'];
    }

    /**
     * Sets sub_total
     *
     * @param float|null $sub_total sub_total
     *
     * @return self
     */
    public function setSubTotal($sub_total)
    {
        if (is_null($sub_total)) {
            throw new \InvalidArgumentException('non-nullable sub_total cannot be null');
        }
        $this->container['sub_total'] = $sub_total;

        return $this;
    }

    /**
     * Gets tax
     *
     * @return \Unleashed\Model\Tax|null
     */
    public function getTax()
    {
        return $this->container['tax'];
    }

    /**
     * Sets tax
     *
     * @param \Unleashed\Model\Tax|null $tax tax
     *
     * @return self
     */
    public function setTax($tax)
    {
        if (is_null($tax)) {
            throw new \InvalidArgumentException('non-nullable tax cannot be null');
        }
        $this->container['tax'] = $tax;

        return $this;
    }

    /**
     * Gets last_modified_by
     *
     * @return string|null
     */
    public function getLastModifiedBy()
    {
        return $this->container['last_modified_by'];
    }

    /**
     * Sets last_modified_by
     *
     * @param string|null $last_modified_by last_modified_by
     *
     * @return self
     */
    public function setLastModifiedBy($last_modified_by)
    {
        if (is_null($last_modified_by)) {
            throw new \InvalidArgumentException('non-nullable last_modified_by cannot be null');
        }
        $this->container['last_modified_by'] = $last_modified_by;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets created_by
     *
     * @return string|null
     */
    public function getCreatedBy()
    {
        return $this->container['created_by'];
    }

    /**
     * Sets created_by
     *
     * @param string|null $created_by created_by
     *
     * @return self
     */
    public function setCreatedBy($created_by)
    {
        if (is_null($created_by)) {
            throw new \InvalidArgumentException('non-nullable created_by cannot be null');
        }
        $this->container['created_by'] = $created_by;

        return $this;
    }

    /**
     * Gets created_on
     *
     * @return string|null
     */
    public function getCreatedOn()
    {
        return $this->container['created_on'];
    }

    /**
     * Sets created_on
     *
     * @param string|null $created_on created_on
     *
     * @return self
     */
    public function setCreatedOn($created_on)
    {
        if (is_null($created_on)) {
            throw new \InvalidArgumentException('non-nullable created_on cannot be null');
        }
        $this->container['created_on'] = $created_on;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


