<?php
/**
 * Contact
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * Contact Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class Contact implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'contact';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'for_invoicing' => 'bool',
        'for_shipping' => 'bool',
        'for_ordering' => 'bool',
        'is_default' => 'bool',
        'ddi_number' => 'string',
        'email_address' => 'string',
        'fax_number' => 'string',
        'first_name' => 'string',
        'last_name' => 'string',
        'mobile_phone' => 'string',
        'notes' => 'string',
        'office_phone' => 'string',
        'phone_number' => 'string',
        'toll_free_number' => 'string',
        'website' => 'string',
        'guid' => 'string',
        'delivery_address' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'for_invoicing' => null,
        'for_shipping' => null,
        'for_ordering' => null,
        'is_default' => null,
        'ddi_number' => null,
        'email_address' => null,
        'fax_number' => null,
        'first_name' => null,
        'last_name' => null,
        'mobile_phone' => null,
        'notes' => null,
        'office_phone' => null,
        'phone_number' => null,
        'toll_free_number' => null,
        'website' => null,
        'guid' => null,
        'delivery_address' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'for_invoicing' => false,
        'for_shipping' => false,
        'for_ordering' => false,
        'is_default' => false,
        'ddi_number' => false,
        'email_address' => false,
        'fax_number' => false,
        'first_name' => false,
        'last_name' => false,
        'mobile_phone' => false,
        'notes' => false,
        'office_phone' => false,
        'phone_number' => false,
        'toll_free_number' => false,
        'website' => false,
        'guid' => false,
        'delivery_address' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'for_invoicing' => 'ForInvoicing',
        'for_shipping' => 'ForShipping',
        'for_ordering' => 'ForOrdering',
        'is_default' => 'IsDefault',
        'ddi_number' => 'DDINumber',
        'email_address' => 'EmailAddress',
        'fax_number' => 'FaxNumber',
        'first_name' => 'FirstName',
        'last_name' => 'LastName',
        'mobile_phone' => 'MobilePhone',
        'notes' => 'Notes',
        'office_phone' => 'OfficePhone',
        'phone_number' => 'PhoneNumber',
        'toll_free_number' => 'TollFreeNumber',
        'website' => 'Website',
        'guid' => 'Guid',
        'delivery_address' => 'DeliveryAddress'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'for_invoicing' => 'setForInvoicing',
        'for_shipping' => 'setForShipping',
        'for_ordering' => 'setForOrdering',
        'is_default' => 'setIsDefault',
        'ddi_number' => 'setDdiNumber',
        'email_address' => 'setEmailAddress',
        'fax_number' => 'setFaxNumber',
        'first_name' => 'setFirstName',
        'last_name' => 'setLastName',
        'mobile_phone' => 'setMobilePhone',
        'notes' => 'setNotes',
        'office_phone' => 'setOfficePhone',
        'phone_number' => 'setPhoneNumber',
        'toll_free_number' => 'setTollFreeNumber',
        'website' => 'setWebsite',
        'guid' => 'setGuid',
        'delivery_address' => 'setDeliveryAddress'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'for_invoicing' => 'getForInvoicing',
        'for_shipping' => 'getForShipping',
        'for_ordering' => 'getForOrdering',
        'is_default' => 'getIsDefault',
        'ddi_number' => 'getDdiNumber',
        'email_address' => 'getEmailAddress',
        'fax_number' => 'getFaxNumber',
        'first_name' => 'getFirstName',
        'last_name' => 'getLastName',
        'mobile_phone' => 'getMobilePhone',
        'notes' => 'getNotes',
        'office_phone' => 'getOfficePhone',
        'phone_number' => 'getPhoneNumber',
        'toll_free_number' => 'getTollFreeNumber',
        'website' => 'getWebsite',
        'guid' => 'getGuid',
        'delivery_address' => 'getDeliveryAddress'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('for_invoicing', $data ?? [], null);
        $this->setIfExists('for_shipping', $data ?? [], null);
        $this->setIfExists('for_ordering', $data ?? [], null);
        $this->setIfExists('is_default', $data ?? [], null);
        $this->setIfExists('ddi_number', $data ?? [], null);
        $this->setIfExists('email_address', $data ?? [], null);
        $this->setIfExists('fax_number', $data ?? [], null);
        $this->setIfExists('first_name', $data ?? [], null);
        $this->setIfExists('last_name', $data ?? [], null);
        $this->setIfExists('mobile_phone', $data ?? [], null);
        $this->setIfExists('notes', $data ?? [], null);
        $this->setIfExists('office_phone', $data ?? [], null);
        $this->setIfExists('phone_number', $data ?? [], null);
        $this->setIfExists('toll_free_number', $data ?? [], null);
        $this->setIfExists('website', $data ?? [], null);
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('delivery_address', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets for_invoicing
     *
     * @return bool|null
     */
    public function getForInvoicing()
    {
        return $this->container['for_invoicing'];
    }

    /**
     * Sets for_invoicing
     *
     * @param bool|null $for_invoicing for_invoicing
     *
     * @return self
     */
    public function setForInvoicing($for_invoicing)
    {
        if (is_null($for_invoicing)) {
            throw new \InvalidArgumentException('non-nullable for_invoicing cannot be null');
        }
        $this->container['for_invoicing'] = $for_invoicing;

        return $this;
    }

    /**
     * Gets for_shipping
     *
     * @return bool|null
     */
    public function getForShipping()
    {
        return $this->container['for_shipping'];
    }

    /**
     * Sets for_shipping
     *
     * @param bool|null $for_shipping for_shipping
     *
     * @return self
     */
    public function setForShipping($for_shipping)
    {
        if (is_null($for_shipping)) {
            throw new \InvalidArgumentException('non-nullable for_shipping cannot be null');
        }
        $this->container['for_shipping'] = $for_shipping;

        return $this;
    }

    /**
     * Gets for_ordering
     *
     * @return bool|null
     */
    public function getForOrdering()
    {
        return $this->container['for_ordering'];
    }

    /**
     * Sets for_ordering
     *
     * @param bool|null $for_ordering for_ordering
     *
     * @return self
     */
    public function setForOrdering($for_ordering)
    {
        if (is_null($for_ordering)) {
            throw new \InvalidArgumentException('non-nullable for_ordering cannot be null');
        }
        $this->container['for_ordering'] = $for_ordering;

        return $this;
    }

    /**
     * Gets is_default
     *
     * @return bool|null
     */
    public function getIsDefault()
    {
        return $this->container['is_default'];
    }

    /**
     * Sets is_default
     *
     * @param bool|null $is_default is_default
     *
     * @return self
     */
    public function setIsDefault($is_default)
    {
        if (is_null($is_default)) {
            throw new \InvalidArgumentException('non-nullable is_default cannot be null');
        }
        $this->container['is_default'] = $is_default;

        return $this;
    }

    /**
     * Gets ddi_number
     *
     * @return string|null
     */
    public function getDdiNumber()
    {
        return $this->container['ddi_number'];
    }

    /**
     * Sets ddi_number
     *
     * @param string|null $ddi_number ddi_number
     *
     * @return self
     */
    public function setDdiNumber($ddi_number)
    {
        if (is_null($ddi_number)) {
            throw new \InvalidArgumentException('non-nullable ddi_number cannot be null');
        }
        $this->container['ddi_number'] = $ddi_number;

        return $this;
    }

    /**
     * Gets email_address
     *
     * @return string|null
     */
    public function getEmailAddress()
    {
        return $this->container['email_address'];
    }

    /**
     * Sets email_address
     *
     * @param string|null $email_address email_address
     *
     * @return self
     */
    public function setEmailAddress($email_address)
    {
        if (is_null($email_address)) {
            throw new \InvalidArgumentException('non-nullable email_address cannot be null');
        }
        $this->container['email_address'] = $email_address;

        return $this;
    }

    /**
     * Gets fax_number
     *
     * @return string|null
     */
    public function getFaxNumber()
    {
        return $this->container['fax_number'];
    }

    /**
     * Sets fax_number
     *
     * @param string|null $fax_number fax_number
     *
     * @return self
     */
    public function setFaxNumber($fax_number)
    {
        if (is_null($fax_number)) {
            throw new \InvalidArgumentException('non-nullable fax_number cannot be null');
        }
        $this->container['fax_number'] = $fax_number;

        return $this;
    }

    /**
     * Gets first_name
     *
     * @return string|null
     */
    public function getFirstName()
    {
        return $this->container['first_name'];
    }

    /**
     * Sets first_name
     *
     * @param string|null $first_name first_name
     *
     * @return self
     */
    public function setFirstName($first_name)
    {
        if (is_null($first_name)) {
            throw new \InvalidArgumentException('non-nullable first_name cannot be null');
        }
        $this->container['first_name'] = $first_name;

        return $this;
    }

    /**
     * Gets last_name
     *
     * @return string|null
     */
    public function getLastName()
    {
        return $this->container['last_name'];
    }

    /**
     * Sets last_name
     *
     * @param string|null $last_name last_name
     *
     * @return self
     */
    public function setLastName($last_name)
    {
        if (is_null($last_name)) {
            throw new \InvalidArgumentException('non-nullable last_name cannot be null');
        }
        $this->container['last_name'] = $last_name;

        return $this;
    }

    /**
     * Gets mobile_phone
     *
     * @return string|null
     */
    public function getMobilePhone()
    {
        return $this->container['mobile_phone'];
    }

    /**
     * Sets mobile_phone
     *
     * @param string|null $mobile_phone mobile_phone
     *
     * @return self
     */
    public function setMobilePhone($mobile_phone)
    {
        if (is_null($mobile_phone)) {
            throw new \InvalidArgumentException('non-nullable mobile_phone cannot be null');
        }
        $this->container['mobile_phone'] = $mobile_phone;

        return $this;
    }

    /**
     * Gets notes
     *
     * @return string|null
     */
    public function getNotes()
    {
        return $this->container['notes'];
    }

    /**
     * Sets notes
     *
     * @param string|null $notes notes
     *
     * @return self
     */
    public function setNotes($notes)
    {
        if (is_null($notes)) {
            throw new \InvalidArgumentException('non-nullable notes cannot be null');
        }
        $this->container['notes'] = $notes;

        return $this;
    }

    /**
     * Gets office_phone
     *
     * @return string|null
     */
    public function getOfficePhone()
    {
        return $this->container['office_phone'];
    }

    /**
     * Sets office_phone
     *
     * @param string|null $office_phone office_phone
     *
     * @return self
     */
    public function setOfficePhone($office_phone)
    {
        if (is_null($office_phone)) {
            throw new \InvalidArgumentException('non-nullable office_phone cannot be null');
        }
        $this->container['office_phone'] = $office_phone;

        return $this;
    }

    /**
     * Gets phone_number
     *
     * @return string|null
     */
    public function getPhoneNumber()
    {
        return $this->container['phone_number'];
    }

    /**
     * Sets phone_number
     *
     * @param string|null $phone_number phone_number
     *
     * @return self
     */
    public function setPhoneNumber($phone_number)
    {
        if (is_null($phone_number)) {
            throw new \InvalidArgumentException('non-nullable phone_number cannot be null');
        }
        $this->container['phone_number'] = $phone_number;

        return $this;
    }

    /**
     * Gets toll_free_number
     *
     * @return string|null
     */
    public function getTollFreeNumber()
    {
        return $this->container['toll_free_number'];
    }

    /**
     * Sets toll_free_number
     *
     * @param string|null $toll_free_number toll_free_number
     *
     * @return self
     */
    public function setTollFreeNumber($toll_free_number)
    {
        if (is_null($toll_free_number)) {
            throw new \InvalidArgumentException('non-nullable toll_free_number cannot be null');
        }
        $this->container['toll_free_number'] = $toll_free_number;

        return $this;
    }

    /**
     * Gets website
     *
     * @return string|null
     */
    public function getWebsite()
    {
        return $this->container['website'];
    }

    /**
     * Sets website
     *
     * @param string|null $website website
     *
     * @return self
     */
    public function setWebsite($website)
    {
        if (is_null($website)) {
            throw new \InvalidArgumentException('non-nullable website cannot be null');
        }
        $this->container['website'] = $website;

        return $this;
    }

    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets delivery_address
     *
     * @return string|null
     */
    public function getDeliveryAddress()
    {
        return $this->container['delivery_address'];
    }

    /**
     * Sets delivery_address
     *
     * @param string|null $delivery_address delivery_address
     *
     * @return self
     */
    public function setDeliveryAddress($delivery_address)
    {
        if (is_null($delivery_address)) {
            throw new \InvalidArgumentException('non-nullable delivery_address cannot be null');
        }
        $this->container['delivery_address'] = $delivery_address;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


