<?php
/**
 * AssemblyLine
 *
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Model;

use \ArrayAccess;
use \Unleashed\ObjectSerializer;

/**
 * AssemblyLine Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 * @implements \ArrayAccess<string, mixed>
 */
class AssemblyLine implements ModelInterface, ArrayAccess, \JsonSerializable
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'assemblyLine';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'guid' => 'string',
        'product' => '\Unleashed\Model\Product',
        'batch_numbers' => 'object[]',
        'serial_numbers' => 'object[]',
        'quantity' => 'int',
        'disassemble_cost' => 'float',
        'wastage_quantity' => 'int',
        'unit_cost' => 'float',
        'total_cost' => 'float',
        'last_modified_on' => 'string',
        'sub_assembly_guid' => 'string'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'guid' => null,
        'product' => null,
        'batch_numbers' => null,
        'serial_numbers' => null,
        'quantity' => null,
        'disassemble_cost' => null,
        'wastage_quantity' => null,
        'unit_cost' => null,
        'total_cost' => null,
        'last_modified_on' => null,
        'sub_assembly_guid' => null
    ];

    /**
      * Array of nullable properties. Used for (de)serialization
      *
      * @var boolean[]
      */
    protected static array $openAPINullables = [
        'guid' => false,
        'product' => false,
        'batch_numbers' => false,
        'serial_numbers' => false,
        'quantity' => false,
        'disassemble_cost' => false,
        'wastage_quantity' => false,
        'unit_cost' => false,
        'total_cost' => false,
        'last_modified_on' => false,
        'sub_assembly_guid' => false
    ];

    /**
      * If a nullable field gets set to null, insert it here
      *
      * @var boolean[]
      */
    protected array $openAPINullablesSetToNull = [];

    /**
     * Array of property to type mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPITypes()
    {
        return self::$openAPITypes;
    }

    /**
     * Array of property to format mappings. Used for (de)serialization
     *
     * @return array
     */
    public static function openAPIFormats()
    {
        return self::$openAPIFormats;
    }

    /**
     * Array of nullable properties
     *
     * @return array
     */
    protected static function openAPINullables(): array
    {
        return self::$openAPINullables;
    }

    /**
     * Array of nullable field names deliberately set to null
     *
     * @return boolean[]
     */
    private function getOpenAPINullablesSetToNull(): array
    {
        return $this->openAPINullablesSetToNull;
    }

    /**
     * Setter - Array of nullable field names deliberately set to null
     *
     * @param boolean[] $openAPINullablesSetToNull
     */
    private function setOpenAPINullablesSetToNull(array $openAPINullablesSetToNull): void
    {
        $this->openAPINullablesSetToNull = $openAPINullablesSetToNull;
    }

    /**
     * Checks if a property is nullable
     *
     * @param string $property
     * @return bool
     */
    public static function isNullable(string $property): bool
    {
        return self::openAPINullables()[$property] ?? false;
    }

    /**
     * Checks if a nullable property is set to null.
     *
     * @param string $property
     * @return bool
     */
    public function isNullableSetToNull(string $property): bool
    {
        return in_array($property, $this->getOpenAPINullablesSetToNull(), true);
    }

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'guid' => 'Guid',
        'product' => 'Product',
        'batch_numbers' => 'BatchNumbers',
        'serial_numbers' => 'SerialNumbers',
        'quantity' => 'Quantity',
        'disassemble_cost' => 'DisassembleCost',
        'wastage_quantity' => 'WastageQuantity',
        'unit_cost' => 'UnitCost',
        'total_cost' => 'TotalCost',
        'last_modified_on' => 'LastModifiedOn',
        'sub_assembly_guid' => 'SubAssemblyGuid'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'guid' => 'setGuid',
        'product' => 'setProduct',
        'batch_numbers' => 'setBatchNumbers',
        'serial_numbers' => 'setSerialNumbers',
        'quantity' => 'setQuantity',
        'disassemble_cost' => 'setDisassembleCost',
        'wastage_quantity' => 'setWastageQuantity',
        'unit_cost' => 'setUnitCost',
        'total_cost' => 'setTotalCost',
        'last_modified_on' => 'setLastModifiedOn',
        'sub_assembly_guid' => 'setSubAssemblyGuid'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'guid' => 'getGuid',
        'product' => 'getProduct',
        'batch_numbers' => 'getBatchNumbers',
        'serial_numbers' => 'getSerialNumbers',
        'quantity' => 'getQuantity',
        'disassemble_cost' => 'getDisassembleCost',
        'wastage_quantity' => 'getWastageQuantity',
        'unit_cost' => 'getUnitCost',
        'total_cost' => 'getTotalCost',
        'last_modified_on' => 'getLastModifiedOn',
        'sub_assembly_guid' => 'getSubAssemblyGuid'
    ];

    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @return array
     */
    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @return array
     */
    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @return array
     */
    public static function getters()
    {
        return self::$getters;
    }

    /**
     * The original name of the model.
     *
     * @return string
     */
    public function getModelName()
    {
        return self::$openAPIModelName;
    }


    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[]|null $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(?array $data = null)
    {
        $this->setIfExists('guid', $data ?? [], null);
        $this->setIfExists('product', $data ?? [], null);
        $this->setIfExists('batch_numbers', $data ?? [], null);
        $this->setIfExists('serial_numbers', $data ?? [], null);
        $this->setIfExists('quantity', $data ?? [], null);
        $this->setIfExists('disassemble_cost', $data ?? [], null);
        $this->setIfExists('wastage_quantity', $data ?? [], null);
        $this->setIfExists('unit_cost', $data ?? [], null);
        $this->setIfExists('total_cost', $data ?? [], null);
        $this->setIfExists('last_modified_on', $data ?? [], null);
        $this->setIfExists('sub_assembly_guid', $data ?? [], null);
    }

    /**
    * Sets $this->container[$variableName] to the given data or to the given default Value; if $variableName
    * is nullable and its value is set to null in the $fields array, then mark it as "set to null" in the
    * $this->openAPINullablesSetToNull array
    *
    * @param string $variableName
    * @param array  $fields
    * @param mixed  $defaultValue
    */
    private function setIfExists(string $variableName, array $fields, $defaultValue): void
    {
        if (self::isNullable($variableName) && array_key_exists($variableName, $fields) && is_null($fields[$variableName])) {
            $this->openAPINullablesSetToNull[] = $variableName;
        }

        $this->container[$variableName] = $fields[$variableName] ?? $defaultValue;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];

        return $invalidProperties;
    }

    /**
     * Validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properties are valid
     */
    public function valid()
    {
        return count($this->listInvalidProperties()) === 0;
    }


    /**
     * Gets guid
     *
     * @return string|null
     */
    public function getGuid()
    {
        return $this->container['guid'];
    }

    /**
     * Sets guid
     *
     * @param string|null $guid guid
     *
     * @return self
     */
    public function setGuid($guid)
    {
        if (is_null($guid)) {
            throw new \InvalidArgumentException('non-nullable guid cannot be null');
        }
        $this->container['guid'] = $guid;

        return $this;
    }

    /**
     * Gets product
     *
     * @return \Unleashed\Model\Product|null
     */
    public function getProduct()
    {
        return $this->container['product'];
    }

    /**
     * Sets product
     *
     * @param \Unleashed\Model\Product|null $product product
     *
     * @return self
     */
    public function setProduct($product)
    {
        if (is_null($product)) {
            throw new \InvalidArgumentException('non-nullable product cannot be null');
        }
        $this->container['product'] = $product;

        return $this;
    }

    /**
     * Gets batch_numbers
     *
     * @return object[]|null
     */
    public function getBatchNumbers()
    {
        return $this->container['batch_numbers'];
    }

    /**
     * Sets batch_numbers
     *
     * @param object[]|null $batch_numbers batch_numbers
     *
     * @return self
     */
    public function setBatchNumbers($batch_numbers)
    {
        if (is_null($batch_numbers)) {
            throw new \InvalidArgumentException('non-nullable batch_numbers cannot be null');
        }
        $this->container['batch_numbers'] = $batch_numbers;

        return $this;
    }

    /**
     * Gets serial_numbers
     *
     * @return object[]|null
     */
    public function getSerialNumbers()
    {
        return $this->container['serial_numbers'];
    }

    /**
     * Sets serial_numbers
     *
     * @param object[]|null $serial_numbers serial_numbers
     *
     * @return self
     */
    public function setSerialNumbers($serial_numbers)
    {
        if (is_null($serial_numbers)) {
            throw new \InvalidArgumentException('non-nullable serial_numbers cannot be null');
        }
        $this->container['serial_numbers'] = $serial_numbers;

        return $this;
    }

    /**
     * Gets quantity
     *
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->container['quantity'];
    }

    /**
     * Sets quantity
     *
     * @param int|null $quantity quantity
     *
     * @return self
     */
    public function setQuantity($quantity)
    {
        if (is_null($quantity)) {
            throw new \InvalidArgumentException('non-nullable quantity cannot be null');
        }
        $this->container['quantity'] = $quantity;

        return $this;
    }

    /**
     * Gets disassemble_cost
     *
     * @return float|null
     */
    public function getDisassembleCost()
    {
        return $this->container['disassemble_cost'];
    }

    /**
     * Sets disassemble_cost
     *
     * @param float|null $disassemble_cost disassemble_cost
     *
     * @return self
     */
    public function setDisassembleCost($disassemble_cost)
    {
        if (is_null($disassemble_cost)) {
            throw new \InvalidArgumentException('non-nullable disassemble_cost cannot be null');
        }
        $this->container['disassemble_cost'] = $disassemble_cost;

        return $this;
    }

    /**
     * Gets wastage_quantity
     *
     * @return int|null
     */
    public function getWastageQuantity()
    {
        return $this->container['wastage_quantity'];
    }

    /**
     * Sets wastage_quantity
     *
     * @param int|null $wastage_quantity wastage_quantity
     *
     * @return self
     */
    public function setWastageQuantity($wastage_quantity)
    {
        if (is_null($wastage_quantity)) {
            throw new \InvalidArgumentException('non-nullable wastage_quantity cannot be null');
        }
        $this->container['wastage_quantity'] = $wastage_quantity;

        return $this;
    }

    /**
     * Gets unit_cost
     *
     * @return float|null
     */
    public function getUnitCost()
    {
        return $this->container['unit_cost'];
    }

    /**
     * Sets unit_cost
     *
     * @param float|null $unit_cost unit_cost
     *
     * @return self
     */
    public function setUnitCost($unit_cost)
    {
        if (is_null($unit_cost)) {
            throw new \InvalidArgumentException('non-nullable unit_cost cannot be null');
        }
        $this->container['unit_cost'] = $unit_cost;

        return $this;
    }

    /**
     * Gets total_cost
     *
     * @return float|null
     */
    public function getTotalCost()
    {
        return $this->container['total_cost'];
    }

    /**
     * Sets total_cost
     *
     * @param float|null $total_cost total_cost
     *
     * @return self
     */
    public function setTotalCost($total_cost)
    {
        if (is_null($total_cost)) {
            throw new \InvalidArgumentException('non-nullable total_cost cannot be null');
        }
        $this->container['total_cost'] = $total_cost;

        return $this;
    }

    /**
     * Gets last_modified_on
     *
     * @return string|null
     */
    public function getLastModifiedOn()
    {
        return $this->container['last_modified_on'];
    }

    /**
     * Sets last_modified_on
     *
     * @param string|null $last_modified_on last_modified_on
     *
     * @return self
     */
    public function setLastModifiedOn($last_modified_on)
    {
        if (is_null($last_modified_on)) {
            throw new \InvalidArgumentException('non-nullable last_modified_on cannot be null');
        }
        $this->container['last_modified_on'] = $last_modified_on;

        return $this;
    }

    /**
     * Gets sub_assembly_guid
     *
     * @return string|null
     */
    public function getSubAssemblyGuid()
    {
        return $this->container['sub_assembly_guid'];
    }

    /**
     * Sets sub_assembly_guid
     *
     * @param string|null $sub_assembly_guid sub_assembly_guid
     *
     * @return self
     */
    public function setSubAssemblyGuid($sub_assembly_guid)
    {
        if (is_null($sub_assembly_guid)) {
            throw new \InvalidArgumentException('non-nullable sub_assembly_guid cannot be null');
        }
        $this->container['sub_assembly_guid'] = $sub_assembly_guid;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     *
     * @param integer $offset Offset
     *
     * @return boolean
     */
    public function offsetExists($offset): bool
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     *
     * @param integer $offset Offset
     *
     * @return mixed|null
     */
    #[\ReturnTypeWillChange]
    public function offsetGet($offset)
    {
        return $this->container[$offset] ?? null;
    }

    /**
     * Sets value based on offset.
     *
     * @param int|null $offset Offset
     * @param mixed    $value  Value to be set
     *
     * @return void
     */
    public function offsetSet($offset, $value): void
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     *
     * @param integer $offset Offset
     *
     * @return void
     */
    public function offsetUnset($offset): void
    {
        unset($this->container[$offset]);
    }

    /**
     * Serializes the object to a value that can be serialized natively by json_encode().
     * @link https://www.php.net/manual/en/jsonserializable.jsonserialize.php
     *
     * @return mixed Returns data which can be serialized by json_encode(), which is a value
     * of any type other than a resource.
     */
    #[\ReturnTypeWillChange]
    public function jsonSerialize()
    {
       return ObjectSerializer::sanitizeForSerialization($this);
    }

    /**
     * Gets the string presentation of the object
     *
     * @return string
     */
    public function __toString()
    {
        return json_encode(
            ObjectSerializer::sanitizeForSerialization($this),
            JSON_PRETTY_PRINT
        );
    }

    /**
     * Gets a header-safe presentation of the object
     *
     * @return string
     */
    public function toHeaderValue()
    {
        return json_encode(ObjectSerializer::sanitizeForSerialization($this));
    }
}


