<?php
/**
 * SalesShipmentsApi
 * PHP version 8.1
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */

/**
 * Unleashed API
 *
 * The Unleashed API is linked to the Unleashed web application: https://go.unleashedsoftware.com/v2.  Date format must be yyyy-MM-ddTHH:mm:ss.fff
 *
 * The version of the OpenAPI document: 1
 * Contact: steven.brookes@talisman-innovations.com
 * Generated by: https://openapi-generator.tech
 * Generator version: 7.13.0
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace Unleashed\Api;

use GuzzleHttp\Client;
use GuzzleHttp\ClientInterface;
use GuzzleHttp\Exception\ConnectException;
use GuzzleHttp\Exception\RequestException;
use GuzzleHttp\Psr7\MultipartStream;
use GuzzleHttp\Psr7\Request;
use GuzzleHttp\RequestOptions;
use Psr\Http\Message\RequestInterface;
use Psr\Http\Message\ResponseInterface;
use Unleashed\ApiException;
use Unleashed\Configuration;
use Unleashed\FormDataProcessor;
use Unleashed\HeaderSelector;
use Unleashed\ObjectSerializer;

/**
 * SalesShipmentsApi Class Doc Comment
 *
 * @category Class
 * @package  Unleashed
 * @author   OpenAPI Generator team
 * @link     https://openapi-generator.tech
 */
class SalesShipmentsApi
{
    /**
     * @var ClientInterface
     */
    protected $client;

    /**
     * @var Configuration
     */
    protected $config;

    /**
     * @var HeaderSelector
     */
    protected $headerSelector;

    /**
     * @var int Host index
     */
    protected $hostIndex;

    /** @var string[] $contentTypes **/
    public const contentTypes = [
        'createSalesShipment' => [
            'application/json',
            'application/xml',
        ],
        'deleteSalesShipment' => [
            'application/json',
        ],
        'deleteSalesShipmentLine' => [
            'application/json',
        ],
        'getSalesShipment' => [
            'application/json',
        ],
        'getSalesShipments' => [
            'application/json',
        ],
        'updateSalesShipment' => [
            'application/json',
            'application/xml',
        ],
    ];

    /**
     * @param ClientInterface $client
     * @param Configuration   $config
     * @param HeaderSelector  $selector
     * @param int             $hostIndex (Optional) host index to select the list of hosts if defined in the OpenAPI spec
     */
    public function __construct(
        ?ClientInterface $client = null,
        ?Configuration $config = null,
        ?HeaderSelector $selector = null,
        int $hostIndex = 0
    ) {
        $this->client = $client ?: new Client();
        $this->config = $config ?: Configuration::getDefaultConfiguration();
        $this->headerSelector = $selector ?: new HeaderSelector();
        $this->hostIndex = $hostIndex;
    }

    /**
     * Set the host index
     *
     * @param int $hostIndex Host index (required)
     */
    public function setHostIndex($hostIndex): void
    {
        $this->hostIndex = $hostIndex;
    }

    /**
     * Get the host index
     *
     * @return int Host index
     */
    public function getHostIndex()
    {
        return $this->hostIndex;
    }

    /**
     * @return Configuration
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * Operation createSalesShipment
     *
     * @param  bool|null $serial_batch serial_batch (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesShipment'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\SalesShipment
     */
    public function createSalesShipment($serial_batch = null, $body = null, string $contentType = self::contentTypes['createSalesShipment'][0])
    {
        list($response) = $this->createSalesShipmentWithHttpInfo($serial_batch, $body, $contentType);
        return $response;
    }

    /**
     * Operation createSalesShipmentWithHttpInfo
     *
     * @param  bool|null $serial_batch (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesShipment'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\SalesShipment, HTTP status code, HTTP response headers (array of strings)
     */
    public function createSalesShipmentWithHttpInfo($serial_batch = null, $body = null, string $contentType = self::contentTypes['createSalesShipment'][0])
    {
        $request = $this->createSalesShipmentRequest($serial_batch, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\SalesShipment',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\SalesShipment',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\SalesShipment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation createSalesShipmentAsync
     *
     * @param  bool|null $serial_batch (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSalesShipmentAsync($serial_batch = null, $body = null, string $contentType = self::contentTypes['createSalesShipment'][0])
    {
        return $this->createSalesShipmentAsyncWithHttpInfo($serial_batch, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation createSalesShipmentAsyncWithHttpInfo
     *
     * @param  bool|null $serial_batch (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function createSalesShipmentAsyncWithHttpInfo($serial_batch = null, $body = null, string $contentType = self::contentTypes['createSalesShipment'][0])
    {
        $returnType = '\Unleashed\Model\SalesShipment';
        $request = $this->createSalesShipmentRequest($serial_batch, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'createSalesShipment'
     *
     * @param  bool|null $serial_batch (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['createSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function createSalesShipmentRequest($serial_batch = null, $body = null, string $contentType = self::contentTypes['createSalesShipment'][0])
    {




        $resourcePath = '/SalesShipments';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $serial_batch,
            'serialBatch', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);




        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'POST',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSalesShipment
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipment'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\SalesShipment
     */
    public function deleteSalesShipment($id, string $contentType = self::contentTypes['deleteSalesShipment'][0])
    {
        list($response) = $this->deleteSalesShipmentWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation deleteSalesShipmentWithHttpInfo
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipment'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\SalesShipment, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSalesShipmentWithHttpInfo($id, string $contentType = self::contentTypes['deleteSalesShipment'][0])
    {
        $request = $this->deleteSalesShipmentRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\SalesShipment',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\SalesShipment',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\SalesShipment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSalesShipmentAsync
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesShipmentAsync($id, string $contentType = self::contentTypes['deleteSalesShipment'][0])
    {
        return $this->deleteSalesShipmentAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSalesShipmentAsyncWithHttpInfo
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesShipmentAsyncWithHttpInfo($id, string $contentType = self::contentTypes['deleteSalesShipment'][0])
    {
        $returnType = '\Unleashed\Model\SalesShipment';
        $request = $this->deleteSalesShipmentRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSalesShipment'
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSalesShipmentRequest($id, string $contentType = self::contentTypes['deleteSalesShipment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deleteSalesShipment'
            );
        }


        $resourcePath = '/SalesShipments/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation deleteSalesShipmentLine
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipmentLine'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return object
     */
    public function deleteSalesShipmentLine($id, string $contentType = self::contentTypes['deleteSalesShipmentLine'][0])
    {
        list($response) = $this->deleteSalesShipmentLineWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation deleteSalesShipmentLineWithHttpInfo
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipmentLine'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of object, HTTP status code, HTTP response headers (array of strings)
     */
    public function deleteSalesShipmentLineWithHttpInfo($id, string $contentType = self::contentTypes['deleteSalesShipmentLine'][0])
    {
        $request = $this->deleteSalesShipmentLineRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        'object',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                'object',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        'object',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation deleteSalesShipmentLineAsync
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipmentLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesShipmentLineAsync($id, string $contentType = self::contentTypes['deleteSalesShipmentLine'][0])
    {
        return $this->deleteSalesShipmentLineAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation deleteSalesShipmentLineAsyncWithHttpInfo
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipmentLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function deleteSalesShipmentLineAsyncWithHttpInfo($id, string $contentType = self::contentTypes['deleteSalesShipmentLine'][0])
    {
        $returnType = 'object';
        $request = $this->deleteSalesShipmentLineRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'deleteSalesShipmentLine'
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['deleteSalesShipmentLine'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function deleteSalesShipmentLineRequest($id, string $contentType = self::contentTypes['deleteSalesShipmentLine'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling deleteSalesShipmentLine'
            );
        }


        $resourcePath = '/SalesShipments/Lines/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'DELETE',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesShipment
     *
     * @param  string $id id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipment'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\SalesShipment
     */
    public function getSalesShipment($id, string $contentType = self::contentTypes['getSalesShipment'][0])
    {
        list($response) = $this->getSalesShipmentWithHttpInfo($id, $contentType);
        return $response;
    }

    /**
     * Operation getSalesShipmentWithHttpInfo
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipment'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\SalesShipment, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesShipmentWithHttpInfo($id, string $contentType = self::contentTypes['getSalesShipment'][0])
    {
        $request = $this->getSalesShipmentRequest($id, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\SalesShipment',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\SalesShipment',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\SalesShipment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSalesShipmentAsync
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesShipmentAsync($id, string $contentType = self::contentTypes['getSalesShipment'][0])
    {
        return $this->getSalesShipmentAsyncWithHttpInfo($id, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesShipmentAsyncWithHttpInfo
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesShipmentAsyncWithHttpInfo($id, string $contentType = self::contentTypes['getSalesShipment'][0])
    {
        $returnType = '\Unleashed\Model\SalesShipment';
        $request = $this->getSalesShipmentRequest($id, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesShipment'
     *
     * @param  string $id (required)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesShipmentRequest($id, string $contentType = self::contentTypes['getSalesShipment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling getSalesShipment'
            );
        }


        $resourcePath = '/SalesShipments/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;



        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['*/*', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation getSalesShipments
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size page_size (optional)
     * @param  string|null $shipment_status shipment_status (optional)
     * @param  string|null $start_date start_date (optional)
     * @param  string|null $end_date end_date (optional)
     * @param  string|null $modified_since modified_since (optional)
     * @param  string|null $order_number order_number (optional)
     * @param  bool|null $serial_batch serial_batch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipments'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\PagedSalesShipment
     */
    public function getSalesShipments($page_number, $page_size = null, $shipment_status = null, $start_date = null, $end_date = null, $modified_since = null, $order_number = null, $serial_batch = null, string $contentType = self::contentTypes['getSalesShipments'][0])
    {
        list($response) = $this->getSalesShipmentsWithHttpInfo($page_number, $page_size, $shipment_status, $start_date, $end_date, $modified_since, $order_number, $serial_batch, $contentType);
        return $response;
    }

    /**
     * Operation getSalesShipmentsWithHttpInfo
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size (optional)
     * @param  string|null $shipment_status (optional)
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string|null $modified_since (optional)
     * @param  string|null $order_number (optional)
     * @param  bool|null $serial_batch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipments'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\PagedSalesShipment, HTTP status code, HTTP response headers (array of strings)
     */
    public function getSalesShipmentsWithHttpInfo($page_number, $page_size = null, $shipment_status = null, $start_date = null, $end_date = null, $modified_since = null, $order_number = null, $serial_batch = null, string $contentType = self::contentTypes['getSalesShipments'][0])
    {
        $request = $this->getSalesShipmentsRequest($page_number, $page_size, $shipment_status, $start_date, $end_date, $modified_since, $order_number, $serial_batch, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\PagedSalesShipment',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\PagedSalesShipment',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\PagedSalesShipment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation getSalesShipmentsAsync
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size (optional)
     * @param  string|null $shipment_status (optional)
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string|null $modified_since (optional)
     * @param  string|null $order_number (optional)
     * @param  bool|null $serial_batch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesShipmentsAsync($page_number, $page_size = null, $shipment_status = null, $start_date = null, $end_date = null, $modified_since = null, $order_number = null, $serial_batch = null, string $contentType = self::contentTypes['getSalesShipments'][0])
    {
        return $this->getSalesShipmentsAsyncWithHttpInfo($page_number, $page_size, $shipment_status, $start_date, $end_date, $modified_since, $order_number, $serial_batch, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation getSalesShipmentsAsyncWithHttpInfo
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size (optional)
     * @param  string|null $shipment_status (optional)
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string|null $modified_since (optional)
     * @param  string|null $order_number (optional)
     * @param  bool|null $serial_batch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function getSalesShipmentsAsyncWithHttpInfo($page_number, $page_size = null, $shipment_status = null, $start_date = null, $end_date = null, $modified_since = null, $order_number = null, $serial_batch = null, string $contentType = self::contentTypes['getSalesShipments'][0])
    {
        $returnType = '\Unleashed\Model\PagedSalesShipment';
        $request = $this->getSalesShipmentsRequest($page_number, $page_size, $shipment_status, $start_date, $end_date, $modified_since, $order_number, $serial_batch, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'getSalesShipments'
     *
     * @param  int $page_number Pages are requested by putting the page number into the URL: https://api.unleashedsoftware.com/{endpoint}/{pagenumber}, where {endpoint} and {pagenumber} are placeholders (required)
     * @param  int|null $page_size (optional)
     * @param  string|null $shipment_status (optional)
     * @param  string|null $start_date (optional)
     * @param  string|null $end_date (optional)
     * @param  string|null $modified_since (optional)
     * @param  string|null $order_number (optional)
     * @param  bool|null $serial_batch (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['getSalesShipments'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function getSalesShipmentsRequest($page_number, $page_size = null, $shipment_status = null, $start_date = null, $end_date = null, $modified_since = null, $order_number = null, $serial_batch = null, string $contentType = self::contentTypes['getSalesShipments'][0])
    {

        // verify the required parameter 'page_number' is set
        if ($page_number === null || (is_array($page_number) && count($page_number) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $page_number when calling getSalesShipments'
            );
        }









        $resourcePath = '/SalesShipments/Page/{pageNumber}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $page_size,
            'pageSize', // param base name
            'integer', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $shipment_status,
            'shipmentStatus', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $start_date,
            'startDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $end_date,
            'endDate', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $modified_since,
            'modifiedSince', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $order_number,
            'orderNumber', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);
        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $serial_batch,
            'serialBatch', // param base name
            'boolean', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($page_number !== null) {
            $resourcePath = str_replace(
                '{' . 'pageNumber' . '}',
                ObjectSerializer::toPathValue($page_number),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'GET',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Operation updateSalesShipment
     *
     * @param  string $id id (required)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSalesShipment'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return \Unleashed\Model\SalesShipment
     */
    public function updateSalesShipment($id, $serial_batch = null, $body = null, string $contentType = self::contentTypes['updateSalesShipment'][0])
    {
        list($response) = $this->updateSalesShipmentWithHttpInfo($id, $serial_batch, $body, $contentType);
        return $response;
    }

    /**
     * Operation updateSalesShipmentWithHttpInfo
     *
     * @param  string $id (required)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSalesShipment'] to see the possible values for this operation
     *
     * @throws \Unleashed\ApiException on non-2xx response or if the response body is not in the expected format
     * @throws \InvalidArgumentException
     * @return array of \Unleashed\Model\SalesShipment, HTTP status code, HTTP response headers (array of strings)
     */
    public function updateSalesShipmentWithHttpInfo($id, $serial_batch = null, $body = null, string $contentType = self::contentTypes['updateSalesShipment'][0])
    {
        $request = $this->updateSalesShipmentRequest($id, $serial_batch, $body, $contentType);

        try {
            $options = $this->createHttpClientOption();
            try {
                $response = $this->client->send($request, $options);
            } catch (RequestException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    $e->getResponse() ? $e->getResponse()->getHeaders() : null,
                    $e->getResponse() ? (string) $e->getResponse()->getBody() : null
                );
            } catch (ConnectException $e) {
                throw new ApiException(
                    "[{$e->getCode()}] {$e->getMessage()}",
                    (int) $e->getCode(),
                    null,
                    null
                );
            }

            $statusCode = $response->getStatusCode();


            switch($statusCode) {
                case 200:
                    return $this->handleResponseWithDataType(
                        '\Unleashed\Model\SalesShipment',
                        $request,
                        $response,
                    );
            }

            

            if ($statusCode < 200 || $statusCode > 299) {
                throw new ApiException(
                    sprintf(
                        '[%d] Error connecting to the API (%s)',
                        $statusCode,
                        (string) $request->getUri()
                    ),
                    $statusCode,
                    $response->getHeaders(),
                    (string) $response->getBody()
                );
            }

            return $this->handleResponseWithDataType(
                '\Unleashed\Model\SalesShipment',
                $request,
                $response,
            );
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = ObjectSerializer::deserialize(
                        $e->getResponseBody(),
                        '\Unleashed\Model\SalesShipment',
                        $e->getResponseHeaders()
                    );
                    $e->setResponseObject($data);
                    throw $e;
            }
        

            throw $e;
        }
    }

    /**
     * Operation updateSalesShipmentAsync
     *
     * @param  string $id (required)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSalesShipmentAsync($id, $serial_batch = null, $body = null, string $contentType = self::contentTypes['updateSalesShipment'][0])
    {
        return $this->updateSalesShipmentAsyncWithHttpInfo($id, $serial_batch, $body, $contentType)
            ->then(
                function ($response) {
                    return $response[0];
                }
            );
    }

    /**
     * Operation updateSalesShipmentAsyncWithHttpInfo
     *
     * @param  string $id (required)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Promise\PromiseInterface
     */
    public function updateSalesShipmentAsyncWithHttpInfo($id, $serial_batch = null, $body = null, string $contentType = self::contentTypes['updateSalesShipment'][0])
    {
        $returnType = '\Unleashed\Model\SalesShipment';
        $request = $this->updateSalesShipmentRequest($id, $serial_batch, $body, $contentType);

        return $this->client
            ->sendAsync($request, $this->createHttpClientOption())
            ->then(
                function ($response) use ($returnType) {
                    if ($returnType === '\SplFileObject') {
                        $content = $response->getBody(); //stream goes to serializer
                    } else {
                        $content = (string) $response->getBody();
                        if ($returnType !== 'string') {
                            $content = json_decode($content);
                        }
                    }

                    return [
                        ObjectSerializer::deserialize($content, $returnType, []),
                        $response->getStatusCode(),
                        $response->getHeaders()
                    ];
                },
                function ($exception) {
                    $response = $exception->getResponse();
                    $statusCode = $response->getStatusCode();
                    throw new ApiException(
                        sprintf(
                            '[%d] Error connecting to the API (%s)',
                            $statusCode,
                            $exception->getRequest()->getUri()
                        ),
                        $statusCode,
                        $response->getHeaders(),
                        (string) $response->getBody()
                    );
                }
            );
    }

    /**
     * Create request for operation 'updateSalesShipment'
     *
     * @param  string $id (required)
     * @param  string|null $serial_batch If set to true then the attributes SerialNumbers and BatchNumbers are auto-assigned. (optional)
     * @param  \Unleashed\Model\SalesShipment|null $body (optional)
     * @param  string $contentType The value for the Content-Type header. Check self::contentTypes['updateSalesShipment'] to see the possible values for this operation
     *
     * @throws \InvalidArgumentException
     * @return \GuzzleHttp\Psr7\Request
     */
    public function updateSalesShipmentRequest($id, $serial_batch = null, $body = null, string $contentType = self::contentTypes['updateSalesShipment'][0])
    {

        // verify the required parameter 'id' is set
        if ($id === null || (is_array($id) && count($id) === 0)) {
            throw new \InvalidArgumentException(
                'Missing the required parameter $id when calling updateSalesShipment'
            );
        }




        $resourcePath = '/SalesShipments/{id}';
        $formParams = [];
        $queryParams = [];
        $headerParams = [];
        $httpBody = '';
        $multipart = false;

        // query params
        $queryParams = array_merge($queryParams, ObjectSerializer::toQueryValue(
            $serial_batch,
            'serialBatch', // param base name
            'string', // openApiType
            '', // style
            false, // explode
            false // required
        ) ?? []);


        // path params
        if ($id !== null) {
            $resourcePath = str_replace(
                '{' . 'id' . '}',
                ObjectSerializer::toPathValue($id),
                $resourcePath
            );
        }


        $headers = $this->headerSelector->selectHeaders(
            ['application/json', 'application/xml', ],
            $contentType,
            $multipart
        );

        // for model (json/xml)
        if (isset($body)) {
            if (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the body
                $httpBody = \GuzzleHttp\Utils::jsonEncode(ObjectSerializer::sanitizeForSerialization($body));
            } else {
                $httpBody = $body;
            }
        } elseif (count($formParams) > 0) {
            if ($multipart) {
                $multipartContents = [];
                foreach ($formParams as $formParamName => $formParamValue) {
                    $formParamValueItems = is_array($formParamValue) ? $formParamValue : [$formParamValue];
                    foreach ($formParamValueItems as $formParamValueItem) {
                        $multipartContents[] = [
                            'name' => $formParamName,
                            'contents' => $formParamValueItem
                        ];
                    }
                }
                // for HTTP post (form)
                $httpBody = new MultipartStream($multipartContents);

            } elseif (stripos($headers['Content-Type'], 'application/json') !== false) {
                # if Content-Type contains "application/json", json_encode the form parameters
                $httpBody = \GuzzleHttp\Utils::jsonEncode($formParams);
            } else {
                // for HTTP post (form)
                $httpBody = ObjectSerializer::buildQuery($formParams);
            }
        }


        $defaultHeaders = [];
        if ($this->config->getUserAgent()) {
            $defaultHeaders['User-Agent'] = $this->config->getUserAgent();
        }

        $headers = array_merge(
            $defaultHeaders,
            $headerParams,
            $headers
        );

        $operationHost = $this->config->getHost();
        $query = ObjectSerializer::buildQuery($queryParams);
        return new Request(
            'PUT',
            $operationHost . $resourcePath . ($query ? "?{$query}" : ''),
            $headers,
            $httpBody
        );
    }

    /**
     * Create http client option
     *
     * @throws \RuntimeException on file opening failure
     * @return array of http client options
     */
    protected function createHttpClientOption()
    {
        $options = [];
        if ($this->config->getDebug()) {
            $options[RequestOptions::DEBUG] = fopen($this->config->getDebugFile(), 'a');
            if (!$options[RequestOptions::DEBUG]) {
                throw new \RuntimeException('Failed to open the debug file: ' . $this->config->getDebugFile());
            }
        }

        return $options;
    }

    private function handleResponseWithDataType(
        string $dataType,
        RequestInterface $request,
        ResponseInterface $response
    ): array {
        if ($dataType === '\SplFileObject') {
            $content = $response->getBody(); //stream goes to serializer
        } else {
            $content = (string) $response->getBody();
            if ($dataType !== 'string') {
                try {
                    $content = json_decode($content, false, 512, JSON_THROW_ON_ERROR);
                } catch (\JsonException $exception) {
                    throw new ApiException(
                        sprintf(
                            'Error JSON decoding server response (%s)',
                            $request->getUri()
                        ),
                        $response->getStatusCode(),
                        $response->getHeaders(),
                        $content
                    );
                }
            }
        }

        return [
            ObjectSerializer::deserialize($content, $dataType, []),
            $response->getStatusCode(),
            $response->getHeaders()
        ];
    }

    private function responseWithinRangeCode(
        string $rangeCode,
        int $statusCode
    ): bool {
        $left = (int) ($rangeCode[0].'00');
        $right = (int) ($rangeCode[0].'99');

        return $statusCode >= $left && $statusCode <= $right;
    }
}
